/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.ss.formula.ptg;

import org.zkoss.poi.ss.formula.FormulaRenderingWorkbook;
import org.zkoss.poi.ss.formula.ptg.Area3DPtg;
import org.zkoss.poi.util.LittleEndianOutput;

public class TablePtg
extends Area3DPtg {
    private static final long serialVersionUID = -4648300991532829249L;
    private String _tableName;
    private Item[] _items;
    private String[] _columns;
    private final boolean _inTable;

    public TablePtg(int extIdx, int firstRow, int lastRow, int firstColumn, int lastColumn, String tableName, Item[] items, String[] columns, boolean inTable) {
        super(firstRow, lastRow, firstColumn, lastColumn, false, false, false, false, extIdx);
        this._tableName = tableName;
        this._items = items;
        this._columns = columns;
        this._inTable = inTable;
    }

    public String getTableName() {
        return this._tableName;
    }

    public void setTableName(String tableName) {
        this._tableName = tableName;
    }

    public Item getItem1() {
        return this._items.length > 0 ? this._items[0] : null;
    }

    public Item getItem2() {
        return this._items.length > 1 ? this._items[1] : null;
    }

    public String getColumn1() {
        return this._columns.length > 0 ? this._columns[0] : null;
    }

    public void setColumn1(String column) {
        if (this._columns.length > 0) {
            this._columns[0] = column;
        }
    }

    public String getColumn2() {
        return this._columns.length > 1 ? this._columns[1] : null;
    }

    public void setColumn2(String column) {
        if (this._columns.length > 1) {
            this._columns[1] = column;
        }
    }

    @Override
    public void write(LittleEndianOutput out) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getSize() {
        return 0;
    }

    public static String formatAsFormulaString(String tableName, Item item1, Item item2, String column1, String column2, boolean inTable) {
        return TablePtg.formatAsFormulaString0(tableName, item1, item2, column1, column2, inTable, false);
    }

    private static String formatAsFormulaString0(String tableName, Item item1, Item item2, String column1, String column2, boolean inTable, boolean internal) {
        StringBuilder sb = new StringBuilder();
        int count = 0;
        if (item1 != null) {
            ++count;
            if (item2 != null) {
                ++count;
            }
        }
        if (column1 != null) {
            ++count;
            if (column2 != null) {
                ++count;
            }
        }
        if (item1 != null) {
            if (count > 1) {
                sb.append('[');
            }
            sb.append(item1.getName());
        }
        if (item2 != null) {
            sb.append("],[").append(item2.getName());
        }
        if (column1 != null) {
            if (sb.length() > 0) {
                sb.append("],[");
            } else if (count > 1 || column1.startsWith(" ")) {
                sb.append("[");
            }
            sb.append(column1);
        }
        if (column2 != null) {
            sb.append("]:[").append(column2);
        }
        if (count > 1 || column1 != null && column1.startsWith(" ")) {
            sb.append(']');
        }
        return (inTable ? "" : tableName) + (sb.length() == 0 && !internal ? "" : '[' + sb.toString() + ']');
    }

    @Override
    public String toFormulaString(FormulaRenderingWorkbook book) {
        return this.toFormulaString(this._inTable);
    }

    private String toFormulaString(boolean inTable) {
        Item item1 = this._items.length > 0 ? this._items[0] : null;
        Item item2 = this._items.length > 1 ? this._items[1] : null;
        String column1 = this._columns.length > 0 ? this._columns[0] : null;
        String column2 = this._columns.length > 1 ? this._columns[1] : null;
        return TablePtg.formatAsFormulaString(this._tableName, item1, item2, column1, column2, inTable);
    }

    @Override
    public String toInternalFormulaString(FormulaRenderingWorkbook book) {
        Item item1 = this._items.length > 0 ? this._items[0] : null;
        Item item2 = this._items.length > 1 ? this._items[1] : null;
        String column1 = this._columns.length > 0 ? this._columns[0] : null;
        String column2 = this._columns.length > 1 ? this._columns[1] : null;
        return TablePtg.formatAsFormulaString0(this._tableName, item1, item2, column1, column2, this._inTable, true);
    }

    @Override
    public byte getDefaultOperandClass() {
        return 0;
    }

    @Override
    public final String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getName());
        sb.append(" [");
        sb.append(this.toFormulaString(false));
        sb.append(" ");
        sb.append(this.formatReferenceAsString());
        sb.append("]");
        return sb.toString();
    }

    public String toCopyFormulaString() {
        Item item1 = this._items.length > 0 ? this._items[0] : null;
        Item item2 = this._items.length > 1 ? this._items[1] : null;
        String column1 = this._columns.length > 0 ? this._columns[0] : null;
        String column2 = this._columns.length > 1 ? this._columns[1] : null;
        return TablePtg.formatAsFormulaString0(this._tableName, item1, item2, column1, column2, false, false);
    }

    public static enum Item {
        ALL("#All"),
        HEADERS("#Headers"),
        DATA("#Data"),
        TOTALS("#Totals"),
        THIS_ROW("#This Row");

        private String _name;

        private Item(String name) {
            this._name = name;
        }

        public String getName() {
            return this._name;
        }

        public static Item valueOfName(String name) {
            if ("#All".equalsIgnoreCase(name)) {
                return ALL;
            }
            if ("#Data".equalsIgnoreCase(name)) {
                return DATA;
            }
            if ("#Headers".equalsIgnoreCase(name)) {
                return HEADERS;
            }
            if ("#Totals".equalsIgnoreCase(name)) {
                return TOTALS;
            }
            if ("#This Row".equalsIgnoreCase(name)) {
                return THIS_ROW;
            }
            return null;
        }
    }
}

