/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.hssf.record;

import org.zkoss.poi.hssf.record.RecordInputStream;
import org.zkoss.poi.hssf.record.StandardRecord;
import org.zkoss.poi.hssf.record.common.FtrHeader;
import org.zkoss.poi.util.BitField;
import org.zkoss.poi.util.BitFieldFactory;
import org.zkoss.poi.util.LittleEndianOutput;

public class BookExtRecord
extends StandardRecord {
    private static final BitField fDontAutoRecover = BitFieldFactory.getInstance(1);
    private static final BitField fHidePivotList = BitFieldFactory.getInstance(2);
    private static final BitField fFilterPrivacy = BitFieldFactory.getInstance(4);
    private static final BitField fEmbedFactoids = BitFieldFactory.getInstance(8);
    private static final BitField mdFactoidDisplay = BitFieldFactory.getInstance(48);
    private static final BitField fSavedDuringRecovery = BitFieldFactory.getInstance(64);
    private static final BitField fCreatedViaDataRecovery = BitFieldFactory.getInstance(128);
    private static final BitField fOpenedViaDataRecovery = BitFieldFactory.getInstance(256);
    private static final BitField fOpenedViaSafeLoad = BitFieldFactory.getInstance(512);
    private static final BitField fBuggedUserAboutSolution = BitFieldFactory.getInstance(1);
    private static final BitField fShowInkAnnotation = BitFieldFactory.getInstance(2);
    private static final BitField fPublishedBookItems = BitFieldFactory.getInstance(2);
    private static final BitField fShowPivotChartFilter = BitFieldFactory.getInstance(4);
    public static final short sid = 2147;
    private FtrHeader futureHeader;
    private int bits;
    private int cb;
    private byte grbit1;
    private byte grbit2;

    public BookExtRecord() {
        this.futureHeader = new FtrHeader();
        this.futureHeader.setRecordType((short)2147);
        this.cb = 22;
    }

    public BookExtRecord(RecordInputStream in) {
        this.futureHeader = new FtrHeader(in);
        this.cb = in.readInt();
        this.bits = in.readInt();
        if (this.cb > 20) {
            this.grbit1 = in.readByte();
            if (this.cb > 21) {
                this.grbit2 = in.readByte();
            }
        }
    }

    @Override
    public short getSid() {
        return 2147;
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[BOOKEXT]\n");
        buffer.append(this.futureHeader.toString());
        buffer.append("    .cb         = ").append(Integer.toString(this.cb)).append("\n");
        buffer.append("    .bits       = ").append(Integer.toHexString(this.bits)).append("\n");
        buffer.append("       .fDontAutoRecover         = ").append(this.isDontAutoRecover()).append("\n");
        buffer.append("       .fHidePivotList           = ").append(this.isHidePivotList()).append("\n");
        buffer.append("       .fFilterPrivacy           = ").append(this.isFilterPrivacy()).append("\n");
        buffer.append("       .fEmbedFactoids           = ").append(this.isEmbedFactoids()).append("\n");
        buffer.append("       .mdFactoidDisplay         = ").append(this.getFactoidDisplay()).append("\n");
        buffer.append("       .fSavedDuringRecovery     = ").append(this.isSavedDuringRecovery()).append("\n");
        buffer.append("       .fCreatedViaDataRecovery  = ").append(this.isCreatedViaDataRecovery()).append("\n");
        buffer.append("       .fOpenedViaDataRecovery   = ").append(this.isOpenedViaDataRecovery()).append("\n");
        buffer.append("       .fOpenedViaSafeLoad       = ").append(this.isOpenedViaSafeLoad()).append("\n");
        if (this.cb > 20) {
            buffer.append("    .grbit1     = ").append(Integer.toHexString(this.grbit1)).append("\n");
            buffer.append("       .fBuggedUserAboutSolution = ").append(this.isBuggedUserAboutSolution()).append("\n");
            buffer.append("       .fShowInkAnnotation       = ").append(this.isShowInkAnnotation()).append("\n");
            if (this.cb > 21) {
                buffer.append("    .grbit2     = ").append(Integer.toHexString(this.grbit2)).append("\n");
                buffer.append("       .fPublishedBookItems      = ").append(this.isPublishOnlySelectedBookItems()).append("\n");
                buffer.append("       .fShowPivotChartFilter    = ").append(this.isShowPivotChartFilter()).append("\n");
            } else {
                buffer.append("    .grbit2     = (n/a)").append("\n");
            }
        } else {
            buffer.append("    .grbit1     = (n/a)").append("\n");
            buffer.append("    .grbit2     = (n/a)").append("\n");
        }
        buffer.append("[/BOOKEXT]\n");
        return buffer.toString();
    }

    public boolean isDontAutoRecover() {
        return fDontAutoRecover.isSet(this.bits);
    }

    public void setDontAutoRecover(boolean flag) {
        this.bits = fDontAutoRecover.setBoolean(this.bits, flag);
    }

    public boolean isHidePivotList() {
        return fHidePivotList.isSet(this.bits);
    }

    public void setHidePivotList(boolean flag) {
        this.bits = fHidePivotList.setBoolean(this.bits, flag);
    }

    public boolean isFilterPrivacy() {
        return fFilterPrivacy.isSet(this.bits);
    }

    public void setFilterPrivacy(boolean flag) {
        this.bits = fFilterPrivacy.setBoolean(this.bits, flag);
    }

    public boolean isEmbedFactoids() {
        return fEmbedFactoids.isSet(this.bits);
    }

    public void setEmbedFactoids(boolean flag) {
        this.bits = fEmbedFactoids.setBoolean(this.bits, flag);
    }

    public int getFactoidDisplay() {
        return mdFactoidDisplay.getValue(this.bits);
    }

    public void setFactoidDisplay(int value) {
        if (value < 0 || value > 2) {
            value = 2;
        }
        mdFactoidDisplay.setValue(this.bits, value);
    }

    public boolean isSavedDuringRecovery() {
        return fSavedDuringRecovery.isSet(this.bits);
    }

    public void setSavedDuringRecovery(boolean flag) {
        this.bits = fSavedDuringRecovery.setBoolean(this.bits, flag);
    }

    public boolean isCreatedViaDataRecovery() {
        return fCreatedViaDataRecovery.isSet(this.bits);
    }

    public void setCreatedViaDataRecovery(boolean flag) {
        this.bits = fCreatedViaDataRecovery.setBoolean(this.bits, flag);
    }

    public boolean isOpenedViaDataRecovery() {
        return fOpenedViaDataRecovery.isSet(this.bits);
    }

    public void setOpenedViaDataRecovery(boolean flag) {
        this.bits = fOpenedViaDataRecovery.setBoolean(this.bits, flag);
    }

    public boolean isOpenedViaSafeLoad() {
        return fOpenedViaSafeLoad.isSet(this.bits);
    }

    public void setOpenedViaSafeLoad(boolean flag) {
        this.bits = fOpenedViaSafeLoad.setBoolean(this.bits, flag);
    }

    public boolean isBuggedUserAboutSolution() {
        return fBuggedUserAboutSolution.isSet(this.grbit1);
    }

    public void setBuggedUserAboutSolution(boolean flag) {
        this.grbit1 = (byte)fBuggedUserAboutSolution.setBoolean(this.grbit1, flag);
    }

    public boolean isShowInkAnnotation() {
        return fShowInkAnnotation.isSet(this.grbit1);
    }

    public void setShowInkAnnotation(boolean flag) {
        this.grbit1 = (byte)fShowInkAnnotation.setBoolean(this.grbit1, flag);
    }

    public boolean isPublishOnlySelectedBookItems() {
        return fPublishedBookItems.isSet(this.grbit2);
    }

    public void setPublishOnlySelectedBookItems(boolean flag) {
        this.grbit2 = (byte)fPublishedBookItems.setBoolean(this.grbit2, flag);
    }

    public boolean isShowPivotChartFilter() {
        return fShowPivotChartFilter.isSet(this.grbit2);
    }

    public void setShowPivotChartFilter(boolean flag) {
        this.grbit2 = (byte)fShowPivotChartFilter.setBoolean(this.grbit2, flag);
    }

    @Override
    public void serialize(LittleEndianOutput out) {
        this.futureHeader.serialize(out);
        out.writeInt(this.cb);
        out.writeInt(this.bits);
        out.writeByte(this.grbit1);
        out.writeByte(this.grbit2);
    }

    @Override
    public Object clone() {
        return this.cloneViaReserialise();
    }

    @Override
    protected int getDataSize() {
        return 22;
    }
}

