/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.hdgf.chunks;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.StringTokenizer;
import org.zkoss.poi.hdgf.chunks.Chunk;
import org.zkoss.poi.hdgf.chunks.ChunkHeader;
import org.zkoss.poi.hdgf.chunks.ChunkSeparator;
import org.zkoss.poi.hdgf.chunks.ChunkTrailer;
import org.zkoss.poi.util.POILogFactory;
import org.zkoss.poi.util.POILogger;

public final class ChunkFactory {
    private int version;
    private Hashtable<Integer, CommandDefinition[]> chunkCommandDefinitions = new Hashtable();
    private static String chunkTableName = "/org/apache/poi/hdgf/chunks_parse_cmds.tbl";
    private static POILogger logger = POILogFactory.getLogger(ChunkFactory.class);

    public ChunkFactory(int version) throws IOException {
        this.version = version;
        this.processChunkParseCommands();
    }

    private void processChunkParseCommands() throws IOException {
        String line;
        InputStream cpd = ChunkFactory.class.getResourceAsStream(chunkTableName);
        if (cpd == null) {
            throw new IllegalStateException("Unable to find HDGF chunk definition on the classpath - " + chunkTableName);
        }
        BufferedReader inp = new BufferedReader(new InputStreamReader(cpd));
        while ((line = inp.readLine()) != null) {
            if (line.startsWith("#") || line.startsWith(" ") || line.startsWith("\t") || line.length() == 0) continue;
            if (!line.startsWith("start")) {
                throw new IllegalStateException("Expecting start xxx, found " + line);
            }
            int chunkType = Integer.parseInt(line.substring(6));
            ArrayList<CommandDefinition> defsL = new ArrayList<CommandDefinition>();
            while (!(line = inp.readLine()).startsWith("end")) {
                StringTokenizer st = new StringTokenizer(line, " ");
                int defType = Integer.parseInt(st.nextToken());
                int offset = Integer.parseInt(st.nextToken());
                String name = st.nextToken("\uffff").substring(1);
                CommandDefinition def = new CommandDefinition(defType, offset, name);
                defsL.add(def);
            }
            CommandDefinition[] defs = defsL.toArray(new CommandDefinition[defsL.size()]);
            this.chunkCommandDefinitions.put(chunkType, defs);
        }
        inp.close();
        cpd.close();
    }

    public int getVersion() {
        return this.version;
    }

    public Chunk createChunk(byte[] data, int offset) {
        ChunkHeader header = ChunkHeader.createChunkHeader(this.version, data, offset);
        if (header.length < 0) {
            throw new IllegalArgumentException("Found a chunk with a negative length, which isn't allowed");
        }
        int endOfDataPos = offset + header.getLength() + header.getSizeInBytes();
        if (endOfDataPos > data.length) {
            logger.log(5, "Header called for " + header.getLength() + " bytes, but that would take us passed the end of the data!");
            endOfDataPos = data.length;
            header.length = data.length - offset - header.getSizeInBytes();
            if (header.hasTrailer()) {
                header.length -= 8;
                endOfDataPos -= 8;
            }
            if (header.hasSeparator()) {
                header.length -= 4;
                endOfDataPos -= 4;
            }
        }
        ChunkTrailer trailer = null;
        ChunkSeparator separator = null;
        if (header.hasTrailer()) {
            if (endOfDataPos <= data.length - 8) {
                trailer = new ChunkTrailer(data, endOfDataPos);
                endOfDataPos += 8;
            } else {
                logger.log(7, "Header claims a length to " + endOfDataPos + " there's then no space for the trailer in the data (" + data.length + ")");
            }
        }
        if (header.hasSeparator()) {
            if (endOfDataPos <= data.length - 4) {
                separator = new ChunkSeparator(data, endOfDataPos);
            } else {
                logger.log(7, "Header claims a length to " + endOfDataPos + " there's then no space for the separator in the data (" + data.length + ")");
            }
        }
        byte[] contents = new byte[header.getLength()];
        System.arraycopy(data, offset + header.getSizeInBytes(), contents, 0, contents.length);
        Chunk chunk = new Chunk(header, trailer, separator, contents);
        CommandDefinition[] defs = this.chunkCommandDefinitions.get(header.getType());
        if (defs == null) {
            defs = new CommandDefinition[]{};
        }
        chunk.commandDefinitions = defs;
        chunk.processCommands();
        return chunk;
    }

    public class CommandDefinition {
        private int type;
        private int offset;
        private String name;

        public CommandDefinition(int type, int offset, String name) {
            this.type = type;
            this.offset = offset;
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public int getOffset() {
            return this.offset;
        }

        public int getType() {
            return this.type;
        }
    }
}

