/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.adwindow.validator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.adempiere.util.Callback;
import org.adempiere.webui.adwindow.ADWindow;
import org.adempiere.webui.adwindow.validator.WindowValidator;
import org.adempiere.webui.adwindow.validator.WindowValidatorEvent;
import org.compiere.util.Util;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class WindowValidatorManager
implements BundleActivator,
ServiceTrackerCustomizer<WindowValidator, WindowValidator> {
    private static WindowValidatorManager instance = null;
    private BundleContext context;
    private Map<String, List<WindowValidatorEntry>> validatorMap = new HashMap<String, List<WindowValidatorEntry>>();
    private List<WindowValidatorEntry> globalValidators = new ArrayList<WindowValidatorEntry>();
    private ServiceTracker<WindowValidator, WindowValidator> serviceTracker;

    public WindowValidator addingService(ServiceReference<WindowValidator> reference) {
        WindowValidator service = (WindowValidator)this.context.getService(reference);
        Object obj = reference.getProperty("AD_Window_UU");
        if (obj instanceof String) {
            String uuid = (String)reference.getProperty("AD_Window_UU");
            String events = (String)reference.getProperty("events");
            if (uuid == null || "*".equals(uuid)) {
                String[] validatorEvents = null;
                if (!Util.isEmpty((String)events, (boolean)true) && !"*".equals(events.trim())) {
                    validatorEvents = events.split("[,]");
                }
                WindowValidatorEntry entry = new WindowValidatorEntry(service, validatorEvents);
                this.globalValidators.add(entry);
                return service;
            }
            this.addService(service, uuid, events);
        } else if (obj instanceof String[]) {
            String[] uuids = (String[])reference.getProperty("AD_Window_UU");
            String events = (String)reference.getProperty("events");
            String[] stringArray = uuids;
            int n = uuids.length;
            int n2 = 0;
            while (n2 < n) {
                String uuid = stringArray[n2];
                this.addService(service, uuid, events);
                ++n2;
            }
        }
        return service;
    }

    protected void addService(WindowValidator service, String uuid, String events) {
        List<WindowValidatorEntry> list = this.validatorMap.get(uuid);
        if (list == null) {
            list = new ArrayList<WindowValidatorEntry>();
            this.validatorMap.put(uuid, list);
        }
        String[] validatorEvents = null;
        if (!Util.isEmpty((String)events, (boolean)true) && !"*".equals(events.trim())) {
            validatorEvents = events.split("[,]");
        }
        WindowValidatorEntry entry = new WindowValidatorEntry(service, validatorEvents);
        list.add(entry);
    }

    public void modifiedService(ServiceReference<WindowValidator> reference, WindowValidator service) {
    }

    public void removedService(ServiceReference<WindowValidator> reference, WindowValidator service) {
        Object obj = reference.getProperty("AD_Window_UU");
        if (obj instanceof String) {
            String uuid = (String)reference.getProperty("AD_Window_UU");
            if (uuid == null || "*".equals(uuid)) {
                this.globalValidators.removeIf(i -> i.validator.equals(service));
            } else {
                this.removeService(service, uuid);
            }
        } else if (obj instanceof String[]) {
            String[] uuids;
            String[] stringArray = uuids = (String[])reference.getProperty("AD_Window_UU");
            int n = uuids.length;
            int n2 = 0;
            while (n2 < n) {
                String uuid = stringArray[n2];
                this.removeService(service, uuid);
                ++n2;
            }
        }
    }

    protected void removeService(WindowValidator service, String uuid) {
        List<WindowValidatorEntry> list = this.validatorMap.get(uuid);
        if (list != null) {
            list.removeIf(i -> i.validator.equals(service));
        }
    }

    public void start(BundleContext context) throws Exception {
        this.context = context;
        this.serviceTracker = new ServiceTracker(context, WindowValidator.class.getName(), (ServiceTrackerCustomizer)this);
        this.serviceTracker.open();
        instance = this;
    }

    public void stop(BundleContext context) throws Exception {
        this.serviceTracker.close();
        this.context = null;
        instance = null;
    }

    public static WindowValidatorManager getInstance() {
        return instance;
    }

    public void fireWindowValidatorEvent(WindowValidatorEvent event, Callback<Boolean> callback) {
        String e;
        int n;
        int n2;
        String[] stringArray;
        ADWindow window = event.getWindow();
        String uuid = window.getAD_Window_UU();
        List<WindowValidatorEntry> list = this.validatorMap.get(uuid);
        int listSize = list != null ? list.size() : 0;
        ArrayList<WindowValidator> validators = new ArrayList<WindowValidator>();
        if (listSize > 0) {
            block0: for (WindowValidatorEntry validatorEntry : list) {
                if (validatorEntry.events == null || validatorEntry.events.length == 0) {
                    validators.add(validatorEntry.validator);
                    continue;
                }
                stringArray = validatorEntry.events;
                n2 = validatorEntry.events.length;
                n = 0;
                while (n < n2) {
                    e = stringArray[n];
                    if (e.trim().equalsIgnoreCase(event.getName())) {
                        validators.add(validatorEntry.validator);
                        continue block0;
                    }
                    ++n;
                }
            }
        }
        block2: for (WindowValidatorEntry validatorEntry : this.globalValidators) {
            if (validatorEntry.events == null || validatorEntry.events.length == 0) {
                validators.add(validatorEntry.validator);
                continue;
            }
            stringArray = validatorEntry.events;
            n2 = validatorEntry.events.length;
            n = 0;
            while (n < n2) {
                e = stringArray[n];
                if (e.trim().equalsIgnoreCase(event.getName())) {
                    validators.add(validatorEntry.validator);
                    continue block2;
                }
                ++n;
            }
        }
        ChainCallback chain = new ChainCallback(event, validators.toArray(new WindowValidator[0]), callback);
        chain.start();
    }

    private static class ChainCallback
    implements Callback<Boolean> {
        private Callback<Boolean> callback;
        private WindowValidator[] validators;
        private WindowValidatorEvent event;
        private int index = -1;

        public ChainCallback(WindowValidatorEvent event, WindowValidator[] validators, Callback<Boolean> callback) {
            this.event = event;
            this.validators = validators;
            this.callback = callback;
        }

        public void start() {
            this.index = 0;
            if (this.index < this.validators.length) {
                this.validators[this.index].onWindowEvent(this.event, this);
            } else if (this.callback != null) {
                this.callback.onCallback((Object)true);
            }
        }

        public void onCallback(Boolean result) {
            if (result.booleanValue()) {
                if (this.index < this.validators.length - 1) {
                    ++this.index;
                    this.validators[this.index].onWindowEvent(this.event, this);
                } else if (this.callback != null) {
                    this.callback.onCallback((Object)result);
                }
            } else if (this.callback != null) {
                this.callback.onCallback((Object)result);
            }
        }
    }

    private static class WindowValidatorEntry {
        private WindowValidator validator;
        private String[] events;

        private WindowValidatorEntry(WindowValidator validator, String[] events) {
            this.validator = validator;
            this.events = events;
        }
    }
}

