/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.html;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.ThreadSafe;
import org.owasp.html.AttributePolicy;
import org.owasp.html.ElementAndAttributePolicies;
import org.owasp.html.ElementAndAttributePolicyBasedSanitizerPolicy;
import org.owasp.html.Handler;
import org.owasp.html.HtmlChangeListener;
import org.owasp.html.HtmlChangeReporter;
import org.owasp.html.HtmlSanitizer;
import org.owasp.html.HtmlStreamEventProcessor;
import org.owasp.html.HtmlStreamEventReceiver;
import org.owasp.html.HtmlStreamRenderer;
import org.owasp.html.TCB;

@ThreadSafe
@Immutable
@TCB
public final class PolicyFactory
implements Function<HtmlStreamEventReceiver, HtmlSanitizer.Policy> {
    private final ImmutableMap<String, ElementAndAttributePolicies> policies;
    private final ImmutableMap<String, AttributePolicy> globalAttrPolicies;
    private final ImmutableSet<String> textContainers;
    private final HtmlStreamEventProcessor preprocessor;
    private final HtmlStreamEventProcessor postprocessor;

    PolicyFactory(ImmutableMap<String, ElementAndAttributePolicies> policies, ImmutableSet<String> textContainers, ImmutableMap<String, AttributePolicy> globalAttrPolicies, HtmlStreamEventProcessor preprocessor, HtmlStreamEventProcessor postprocessor) {
        this.policies = policies;
        this.textContainers = textContainers;
        this.globalAttrPolicies = globalAttrPolicies;
        this.preprocessor = preprocessor;
        this.postprocessor = postprocessor;
    }

    public HtmlSanitizer.Policy apply(@Nonnull HtmlStreamEventReceiver out) {
        return new ElementAndAttributePolicyBasedSanitizerPolicy(this.postprocessor.wrap(out), this.policies, this.textContainers);
    }

    public <CTX> HtmlSanitizer.Policy apply(HtmlStreamEventReceiver out, @Nullable HtmlChangeListener<CTX> listener, @Nullable CTX context) {
        if (listener == null) {
            return this.apply(out);
        }
        HtmlChangeReporter<CTX> r = new HtmlChangeReporter<CTX>(out, listener, context);
        r.setPolicy(this.apply(r.getWrappedRenderer()));
        return r.getWrappedPolicy();
    }

    public String sanitize(@Nullable String html) {
        return this.sanitize(html, null, null);
    }

    public <CTX> String sanitize(@Nullable String html, @Nullable HtmlChangeListener<CTX> listener, @Nullable CTX context) {
        if (html == null) {
            return "";
        }
        StringBuilder out = new StringBuilder(html.length());
        HtmlSanitizer.sanitize(html, this.apply(HtmlStreamRenderer.create(out, Handler.DO_NOTHING), listener, context), this.preprocessor);
        return out.toString();
    }

    public PolicyFactory and(PolicyFactory f) {
        ImmutableMap allGlobalAttrPolicies;
        ElementAndAttributePolicies p;
        String elName;
        ImmutableMap.Builder b = ImmutableMap.builder();
        for (Map.Entry e : this.policies.entrySet()) {
            elName = (String)e.getKey();
            p = (ElementAndAttributePolicies)e.getValue();
            ElementAndAttributePolicies q = (ElementAndAttributePolicies)f.policies.get((Object)elName);
            p = q != null ? p.and(q) : p.andGlobals((Map<String, AttributePolicy>)f.globalAttrPolicies);
            b.put((Object)elName, (Object)p);
        }
        for (Map.Entry e : f.policies.entrySet()) {
            elName = (String)e.getKey();
            if (this.policies.containsKey((Object)elName)) continue;
            p = (ElementAndAttributePolicies)e.getValue();
            p = p.andGlobals((Map<String, AttributePolicy>)this.globalAttrPolicies);
            b.put((Object)elName, (Object)p);
        }
        Object allTextContainers = this.textContainers.containsAll(f.textContainers) ? this.textContainers : (f.textContainers.containsAll(this.textContainers) ? f.textContainers : ImmutableSet.builder().addAll(this.textContainers).addAll(f.textContainers).build());
        if (f.globalAttrPolicies.isEmpty()) {
            allGlobalAttrPolicies = this.globalAttrPolicies;
        } else if (this.globalAttrPolicies.isEmpty()) {
            allGlobalAttrPolicies = f.globalAttrPolicies;
        } else {
            String attrName;
            ImmutableMap.Builder ab = ImmutableMap.builder();
            for (Map.Entry e : this.globalAttrPolicies.entrySet()) {
                attrName = (String)e.getKey();
                ab.put((Object)attrName, (Object)AttributePolicy.Util.join((AttributePolicy)e.getValue(), (AttributePolicy)f.globalAttrPolicies.get((Object)attrName)));
            }
            for (Map.Entry e : f.globalAttrPolicies.entrySet()) {
                attrName = (String)e.getKey();
                if (this.globalAttrPolicies.containsKey((Object)attrName)) continue;
                ab.put((Object)attrName, e.getValue());
            }
            allGlobalAttrPolicies = ab.build();
        }
        HtmlStreamEventProcessor compositionOfPreprocessors = HtmlStreamEventProcessor.Processors.compose(this.preprocessor, f.preprocessor);
        HtmlStreamEventProcessor compositionOfPostprocessors = HtmlStreamEventProcessor.Processors.compose(this.postprocessor, f.postprocessor);
        return new PolicyFactory((ImmutableMap<String, ElementAndAttributePolicies>)b.build(), (ImmutableSet<String>)allTextContainers, allGlobalAttrPolicies, compositionOfPreprocessors, compositionOfPostprocessors);
    }
}

