/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.sso.filter;

import java.io.IOException;
import java.util.logging.Level;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.adempiere.base.sso.ISSOPrincipalService;
import org.adempiere.base.sso.SSOUtils;
import org.compiere.model.MSysConfig;
import org.compiere.util.CLogger;
import org.compiere.util.Util;

public class SSOWebUIFilter
implements Filter {
    protected static CLogger log = CLogger.getCLogger(SSOWebUIFilter.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        block14: {
            boolean isSSOEnable = MSysConfig.getBooleanValue((String)"ENABLE_SSO", (boolean)false);
            if (isSSOEnable && request instanceof HttpServletRequest) {
                HttpServletRequest httpRequest = (HttpServletRequest)request;
                HttpServletResponse httpResponse = (HttpServletResponse)response;
                String ping = httpRequest.getHeader("X-PING");
                if (!Util.isEmpty((String)ping, (boolean)true)) {
                    chain.doFilter(request, response);
                    return;
                }
                if (SSOUtils.isResourceRequest((HttpServletRequest)httpRequest, (boolean)true)) {
                    chain.doFilter(request, response);
                    return;
                }
                boolean isAdminResRequest = false;
                if (httpRequest.getSession().getAttribute("sso.admin.login") != null) {
                    isAdminResRequest = (Boolean)httpRequest.getSession().getAttribute("sso.admin.login");
                }
                boolean bl = isAdminResRequest = isAdminResRequest || httpRequest.getServletPath().toLowerCase().startsWith("/admin");
                if (httpRequest.getServletPath().toLowerCase().startsWith("/index") || httpRequest.getServletPath().equalsIgnoreCase("/")) {
                    isAdminResRequest = false;
                }
                httpRequest.getSession().setAttribute("sso.admin.login", (Object)isAdminResRequest);
                if (isAdminResRequest && httpRequest.getServletPath().toLowerCase().endsWith("admin")) {
                    httpResponse.sendRedirect("/webui/admin.zul");
                    return;
                }
                ISSOPrincipalService m_SSOPrincipal = null;
                try {
                    m_SSOPrincipal = SSOUtils.getSSOPrincipalService();
                    if (m_SSOPrincipal == null || isAdminResRequest) break block14;
                    if (m_SSOPrincipal.hasAuthenticationCode(httpRequest, httpResponse)) {
                        Object currentUri = httpRequest.getRequestURL().toString();
                        m_SSOPrincipal.getAuthenticationToken(httpRequest, httpResponse, "SSO_MODE_WEBUI");
                        if (!httpResponse.isCommitted()) {
                            Object queryString = httpRequest.getSession().getAttribute("sso.query.string");
                            if (queryString != null && queryString instanceof String && !Util.isEmpty((String)((String)queryString))) {
                                currentUri = (String)currentUri + "?" + (String)queryString;
                            }
                            httpRequest.getSession().removeAttribute("sso.query.string");
                            httpResponse.sendRedirect((String)currentUri);
                        }
                        break block14;
                    }
                    if (!m_SSOPrincipal.isAuthenticated(httpRequest, httpResponse)) {
                        httpRequest.getSession().setAttribute("sso.query.string", (Object)httpRequest.getQueryString());
                        m_SSOPrincipal.redirectForAuthentication(httpRequest, httpResponse, "SSO_MODE_WEBUI");
                        return;
                    }
                    break block14;
                }
                catch (Throwable exc) {
                    log.log(Level.SEVERE, "Exception while authenticating: ", exc);
                    if (m_SSOPrincipal != null) {
                        m_SSOPrincipal.removePrincipalFromSession(httpRequest);
                    }
                    httpResponse.setStatus(500);
                    response.setContentType("text/html");
                    response.getWriter().append(SSOUtils.getCreateErrorResponce((String)exc.getLocalizedMessage()));
                    return;
                }
            }
            if (request instanceof HttpServletRequest && ((HttpServletRequest)request).getServletPath().startsWith("/admin")) {
                ((HttpServletResponse)response).setStatus(404);
                return;
            }
        }
        chain.doFilter(request, response);
    }

    public void destroy() {
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }
}

