/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.report;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.webui.apps.AEnv;
import org.adempiere.webui.theme.ThemeManager;
import org.apache.ecs.ConcreteElement;
import org.apache.ecs.xhtml.a;
import org.apache.ecs.xhtml.body;
import org.compiere.model.MSysConfig;
import org.compiere.print.IHTMLExtension;
import org.compiere.print.PrintData;
import org.compiere.print.PrintDataElement;
import org.compiere.util.Env;
import org.compiere.util.Language;
import org.compiere.util.Msg;
import org.zkoss.zk.ui.Executions;

public class HTMLExtension
implements IHTMLExtension {
    private String classPrefix;
    private String componentId;
    private String scriptURL;
    private String styleURL;
    private String contextPath;
    private String processID;

    public HTMLExtension(String contextPath, String classPrefix, String componentId) {
        this(contextPath, classPrefix, componentId, "");
    }

    public HTMLExtension(String contextPath, String classPrefix, String componentId, String processID) {
        Object theme = MSysConfig.getValue((String)"HTML_REPORT_THEME", (String)"/", (int)Env.getAD_Client_ID((Properties)Env.getCtx()));
        if (!((String)theme).startsWith("/") && !((String)theme).startsWith("~./")) {
            theme = "/" + (String)theme;
        }
        if (!((String)theme).endsWith("/")) {
            theme = (String)theme + "/";
        }
        this.classPrefix = classPrefix;
        this.componentId = componentId;
        if (((String)theme).startsWith("~./")) {
            if (Executions.getCurrent() != null) {
                this.styleURL = Executions.encodeURL((String)((String)theme + "css/report.css"));
            }
        } else {
            this.styleURL = contextPath + (String)theme + "css/report.css";
        }
        this.contextPath = contextPath;
        this.processID = processID;
    }

    public String getWebFontLinks() {
        StringBuilder builder = new StringBuilder();
        builder.append("<link rel=\"stylesheet\" href=\"").append(this.contextPath).append("/css/font-awesome.css.dsp").append("\">");
        return builder.toString();
    }

    public void extendIDColumn(int row, ConcreteElement columnElement, a href, PrintDataElement dataElement) {
        href.addAttribute("onclick", "parent.idempiere.showColumnMenu(document, event, '" + dataElement.getColumnName() + "', " + row + ", " + ThemeManager.isUseFontIconForImage() + ", " + this.processID + ")");
        href.addAttribute("componentId", this.componentId);
        href.addAttribute("foreignColumnName", dataElement.getForeignColumnName());
        href.addAttribute("value", dataElement.getValueAsString());
        href.addAttribute("displayValue", dataElement.getValueDisplay(Env.getLanguage((Properties)Env.getCtx())));
    }

    public void extendRowElement(ConcreteElement row, PrintData printData) {
        PrintDataElement pkey = printData.getPKey();
        if (pkey != null) {
            row.addAttribute("ondblclick", "parent.idempiere.drillAcross('" + this.componentId + "', '" + pkey.getColumnName() + "', '" + pkey.getValueAsString() + "')");
        }
    }

    public String getClassPrefix() {
        return this.classPrefix;
    }

    public String getScriptURL() {
        return this.scriptURL;
    }

    public String getStyleURL() {
        return this.styleURL;
    }

    public void setWebAttribute(body reportBody) {
        StringBuilder windowIconAttr = new StringBuilder();
        if (ThemeManager.isUseFontIconForImage()) {
            windowIconAttr.append("z-icon-Window");
        } else {
            String windowIco = ThemeManager.getThemeResource("images/mWindow.png");
            if (windowIco.startsWith("~./")) {
                if (Executions.getCurrent() != null) {
                    windowIconAttr.append(Executions.encodeURL((String)windowIco));
                }
            } else {
                windowIconAttr.append(this.contextPath);
                if (!windowIco.startsWith("/") && !this.contextPath.endsWith("/")) {
                    windowIconAttr.append("/");
                }
                windowIconAttr.append(windowIco);
            }
        }
        StringBuilder reportIconAttr = new StringBuilder();
        if (ThemeManager.isUseFontIconForImage()) {
            reportIconAttr.append("z-icon-Report");
        } else {
            String reportIco = ThemeManager.getThemeResource("images/mReport.png");
            if (reportIco.startsWith("~./")) {
                if (Executions.getCurrent() != null) {
                    reportIconAttr.append(Executions.encodeURL((String)reportIco));
                }
            } else {
                reportIconAttr.append(this.contextPath);
                if (!reportIco.startsWith("/") && !this.contextPath.endsWith("/")) {
                    reportIconAttr.append("/");
                }
                reportIconAttr.append(reportIco);
            }
        }
        StringBuilder drillAssistantIconAttr = new StringBuilder();
        if (ThemeManager.isUseFontIconForImage()) {
            drillAssistantIconAttr.append("z-icon-Zoom");
        } else {
            String drillAssistantIco = ThemeManager.getThemeResource("images/Zoom16.png");
            if (drillAssistantIco.startsWith("~./")) {
                if (Executions.getCurrent() != null) {
                    drillAssistantIconAttr.append(Executions.encodeURL((String)drillAssistantIco));
                }
            } else {
                drillAssistantIconAttr.append(this.contextPath);
                if (!drillAssistantIco.startsWith("/") && !this.contextPath.endsWith("/")) {
                    drillAssistantIconAttr.append("/");
                }
                drillAssistantIconAttr.append(drillAssistantIco);
            }
        }
        reportBody.addAttribute("windowIco", windowIconAttr.toString());
        reportBody.addAttribute("reportIco", reportIconAttr.toString());
        reportBody.addAttribute("reportLabel", Msg.getMsg((Language)AEnv.getLanguage(Env.getCtx()), (String)"Report").replace("&", ""));
        reportBody.addAttribute("windowLabel", Msg.getMsg((Language)AEnv.getLanguage(Env.getCtx()), (String)"Window"));
        reportBody.addAttribute("drillAssistantIco", drillAssistantIconAttr.toString());
        reportBody.addAttribute("drillAssistantLabel", Msg.getMsg((Language)AEnv.getLanguage(Env.getCtx()), (String)"DrillAssistant").replace("&", ""));
    }

    public String getFullPathStyle() {
        URL urlFile;
        Object theme = MSysConfig.getValue((String)"HTML_REPORT_THEME", (String)"/", (int)Env.getAD_Client_ID((Properties)Env.getCtx()));
        if (!((String)theme).startsWith("/") && !((String)theme).startsWith("~./")) {
            theme = "/" + (String)theme;
        }
        if (!((String)theme).endsWith("/")) {
            theme = (String)theme + "/";
        }
        Object resFile = (String)theme + "css/report.css";
        if (((String)theme).startsWith("~./")) {
            resFile = ThemeManager.toClassPathResourcePath((String)resFile);
        }
        if ((urlFile = this.getClass().getResource((String)resFile)) == null) {
            resFile = "/css/report.css";
            urlFile = this.getClass().getResource((String)resFile);
        }
        if (urlFile != null) {
            FileOutputStream cssStream = null;
            File cssFile = null;
            InputStream stream = null;
            try {
                try {
                    int read;
                    stream = urlFile.openStream();
                    cssFile = File.createTempFile("report", ".css");
                    cssStream = new FileOutputStream(cssFile);
                    byte[] buffer = new byte[1024];
                    while ((read = stream.read(buffer)) != -1) {
                        cssStream.write(buffer, 0, read);
                    }
                }
                catch (IOException e) {
                    throw new AdempiereException((Throwable)e);
                }
            }
            catch (Throwable throwable) {
                if (cssStream != null) {
                    try {
                        cssStream.close();
                    }
                    catch (Exception exception) {}
                }
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                throw throwable;
            }
            if (cssStream != null) {
                try {
                    cssStream.close();
                }
                catch (Exception exception) {}
            }
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            return cssFile.getAbsolutePath();
        }
        return null;
    }
}

