/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.dashboard;

import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.base.Core;
import org.adempiere.base.event.AbstractEventHandler;
import org.adempiere.base.event.EventManager;
import org.adempiere.webui.ClientInfo;
import org.adempiere.webui.component.Tabpanel;
import org.adempiere.webui.dashboard.ADCalendarEvent;
import org.adempiere.webui.dashboard.CalendarWindow;
import org.adempiere.webui.dashboard.DashboardPanel;
import org.adempiere.webui.dashboard.EventWindow;
import org.adempiere.webui.dashboard.RequestWindow;
import org.adempiere.webui.session.SessionManager;
import org.adempiere.webui.theme.ThemeManager;
import org.adempiere.webui.util.ServerPushTemplate;
import org.compiere.model.I_R_Request;
import org.compiere.model.MSysConfig;
import org.compiere.model.PO;
import org.compiere.model.X_R_RequestType;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Trx;
import org.compiere.util.TrxEventListener;
import org.idempiere.distributed.IMessageService;
import org.idempiere.distributed.ITopic;
import org.idempiere.distributed.ITopicSubscriber;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.zkoss.calendar.Calendars;
import org.zkoss.calendar.api.CalendarEvent;
import org.zkoss.calendar.api.CalendarModel;
import org.zkoss.calendar.event.CalendarsEvent;
import org.zkoss.calendar.impl.SimpleCalendarModel;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.util.Callback;
import org.zkoss.zk.ui.util.DesktopCleanup;
import org.zkoss.zul.Label;
import org.zkoss.zul.impl.LabelImageElement;

public class DPCalendar
extends DashboardPanel
implements EventListener<org.zkoss.zk.ui.event.Event>,
EventHandler {
    private static final long serialVersionUID = -224914882522997787L;
    private static final String ON_MOBILE_SET_SELECTED_TAB_ECHO = "onMobileSetSelectedTabEcho";
    private static final String ON_EVENT_EDIT_EVENT = "onEventEdit";
    private static final String ON_EVENT_CREATE_EVENT = "onEventCreate";
    private static final String ON_MOVE_DATE_EVENT = "onMoveDate";
    private static final String ON_REQUEST_CHANGED_TOPIC = "onRequestChanged";
    private Calendars calendars;
    private SimpleCalendarModel scm;
    private LabelImageElement btnCal;
    private LabelImageElement btnRefresh;
    private LabelImageElement btnCurrentDate;
    private Label lblDate;
    private Component divArrowLeft;
    private Component divArrowRight;
    private EventWindow eventWin;
    private WeakReference<Desktop> desktop;
    private ArrayList<ADCalendarEvent> events;
    private DesktopCleanup listener;
    private static RequestEventHandler eventHandler;
    private static TopicSubscriber subscriber;
    private static final CLogger log;

    static {
        log = CLogger.getCLogger(DPCalendar.class);
    }

    public DPCalendar() {
        Component component = Executions.createComponents((String)ThemeManager.getThemeResource("zul/calendar/calendar_mini.zul"), (Component)this, null);
        this.calendars = (Calendars)component.getFellow("cal");
        this.btnCal = (LabelImageElement)component.getFellow("btnCal");
        this.btnCal.addEventListener("onClick", (EventListener)this);
        this.btnRefresh = (LabelImageElement)component.getFellow("btnRefresh");
        this.btnRefresh.addEventListener("onClick", (EventListener)this);
        this.btnCurrentDate = (LabelImageElement)component.getFellow("btnCurrentDate");
        this.btnCurrentDate.addEventListener("onClick", (EventListener)this);
        this.lblDate = (Label)component.getFellow("lblDate");
        this.lblDate.addEventListener("onCreate", (EventListener)this);
        this.divArrowLeft = component.getFellow("divArrowLeft");
        this.divArrowLeft.addEventListener(ON_MOVE_DATE_EVENT, (EventListener)this);
        this.divArrowRight = component.getFellow("divArrowRight");
        this.divArrowRight.addEventListener(ON_MOVE_DATE_EVENT, (EventListener)this);
        this.appendChild(component);
        this.calendars.addEventListener(ON_EVENT_CREATE_EVENT, (EventListener)this);
        this.calendars.addEventListener(ON_EVENT_EDIT_EVENT, (EventListener)this);
        this.createStaticListeners();
        this.listener = new DesktopCleanup(){

            public void cleanup(Desktop desktop) throws Exception {
                DPCalendar.this.cleanup();
            }
        };
        if (ClientInfo.isMobile()) {
            this.addCallback("afterPageAttached", (Callback & Serializable)t -> this.afterPageAttached());
            this.addEventListener(ON_MOBILE_SET_SELECTED_TAB_ECHO, evt -> this.calendars.invalidate());
        }
    }

    private void afterPageAttached() {
        Component p = this.getParent();
        while (p != null) {
            if (p instanceof Tabpanel) {
                p.addEventListener("onMobileSetSelectedTab", evt -> this.onMobileSelected());
                break;
            }
            p = p.getParent();
        }
    }

    private void onMobileSelected() {
        Events.echoEvent((String)ON_MOBILE_SET_SELECTED_TAB_ECHO, (Component)this, null);
    }

    private synchronized void createStaticListeners() {
        if (eventHandler == null) {
            eventHandler = new RequestEventHandler();
            eventHandler.bindEventManager(EventManager.getInstance());
        }
        if (subscriber == null) {
            subscriber = new TopicSubscriber();
            IMessageService service = Core.getMessageService();
            if (service != null) {
                ITopic topic = service.getTopic(ON_REQUEST_CHANGED_TOPIC);
                topic.subscribe((ITopicSubscriber)subscriber);
            }
        }
    }

    public void onEvent(org.zkoss.zk.ui.event.Event e) throws Exception {
        CalendarsEvent calendarsEvent;
        CalendarEvent calendarEvent;
        String type = e.getName();
        if (type.equals("onClick")) {
            if (e.getTarget() == this.btnCal) {
                new CalendarWindow(this.scm);
            } else if (e.getTarget() == this.btnRefresh) {
                this.btnRefreshClicked();
            } else if (e.getTarget() == this.btnCurrentDate) {
                this.btnCurrentDateClicked();
            }
        } else if (type.equals("onCreate")) {
            if (e.getTarget() == this.lblDate) {
                this.updateDateLabel();
            }
        } else if (type.equals(ON_MOVE_DATE_EVENT)) {
            if (e.getTarget() == this.divArrowLeft) {
                this.divArrowClicked(false);
            } else if (e.getTarget() == this.divArrowRight) {
                this.divArrowClicked(true);
            }
        } else if (type.equals(ON_EVENT_CREATE_EVENT)) {
            if (e instanceof CalendarsEvent) {
                CalendarsEvent calendarsEvent2 = (CalendarsEvent)e;
                RequestWindow requestWin = new RequestWindow(calendarsEvent2, this);
                SessionManager.getAppDesktop().showWindow(requestWin);
            }
        } else if (type.equals(ON_EVENT_EDIT_EVENT) && e instanceof CalendarsEvent && (calendarEvent = (calendarsEvent = (CalendarsEvent)e).getCalendarEvent()) instanceof ADCalendarEvent) {
            ADCalendarEvent ce = (ADCalendarEvent)calendarEvent;
            if (this.eventWin == null) {
                this.eventWin = new EventWindow();
            }
            this.eventWin.setData(ce);
            SessionManager.getAppDesktop().showWindow(this.eventWin);
        }
    }

    public static ArrayList<ADCalendarEvent> getEvents(int RequestTypeID, Properties ctx) {
        ArrayList<ADCalendarEvent> events;
        block21: {
            String mode = MSysConfig.getValue((String)"ZK_DASHBOARD_CALENDAR_REQUEST_DISPLAY_MODE", (String)"CSU", (int)Env.getAD_Client_ID((Properties)ctx));
            Object modeCondition = "";
            if (mode.indexOf(67) >= 0) {
                modeCondition = (String)modeCondition + "r.CreatedBy = ?";
            }
            if (mode.indexOf(83) >= 0) {
                if (((String)modeCondition).length() > 0) {
                    modeCondition = (String)modeCondition + " OR ";
                }
                modeCondition = (String)modeCondition + "r.SalesRep_ID = ?";
            }
            if (mode.indexOf(85) >= 0) {
                if (((String)modeCondition).length() > 0) {
                    modeCondition = (String)modeCondition + " OR ";
                }
                modeCondition = (String)modeCondition + "r.AD_User_ID = ?";
            }
            events = new ArrayList<ADCalendarEvent>();
            String sql = "SELECT DISTINCT r.R_Request_ID, r.DateNextAction, r.DateStartPlan, r.DateCompletePlan, r.StartTime, r.EndTime, r.Summary, rt.HeaderColor, rt.ContentColor, rt.R_RequestType_ID FROM R_Request r, R_RequestType rt WHERE r.R_RequestType_ID = rt.R_RequestType_ID AND (" + (String)modeCondition + ") AND r.AD_Client_ID = ? AND r.IsActive = 'Y' AND (r.R_Status_ID IS NULL OR r.R_Status_ID IN (SELECT R_Status_ID FROM R_Status WHERE IsClosed='N')) ";
            if (RequestTypeID > 0) {
                sql = sql + "AND rt.R_RequestType_ID = ? ";
            }
            CPreparedStatement ps = null;
            ResultSet rs = null;
            int count = 1;
            try {
                try {
                    ps = DB.prepareStatement((String)sql, null);
                    if (mode.indexOf(67) >= 0) {
                        ps.setInt(count++, Env.getAD_User_ID((Properties)ctx));
                    }
                    if (mode.indexOf(83) >= 0) {
                        ps.setInt(count++, Env.getAD_User_ID((Properties)ctx));
                    }
                    if (mode.indexOf(85) >= 0) {
                        ps.setInt(count++, Env.getAD_User_ID((Properties)ctx));
                    }
                    ps.setInt(count++, Env.getAD_Client_ID((Properties)ctx));
                    if (RequestTypeID > 0) {
                        ps.setInt(count++, RequestTypeID);
                    }
                    rs = ps.executeQuery();
                    while (rs.next()) {
                        int R_Request_ID = rs.getInt("R_Request_ID");
                        Date dateNextAction = rs.getDate("DateNextAction");
                        Date dateStartPlan = rs.getDate("DateStartPlan");
                        Date dateCompletePlan = rs.getDate("DateCompletePlan");
                        Timestamp startTime = rs.getTimestamp("StartTime");
                        Timestamp endTime = rs.getTimestamp("EndTime");
                        String summary = rs.getString("Summary");
                        String headerColor = rs.getString("HeaderColor");
                        String contentColor = rs.getString("ContentColor");
                        int R_RequestType_ID = rs.getInt("R_RequestType_ID");
                        if (dateNextAction != null) {
                            Calendar cal = Calendar.getInstance();
                            cal.setTime(dateNextAction);
                            ADCalendarEvent event = new ADCalendarEvent();
                            event.setR_Request_ID(R_Request_ID);
                            cal.set(11, 0);
                            cal.set(12, 0);
                            cal.set(13, 0);
                            cal.set(14, 0);
                            event.setBeginDate(cal.getTime());
                            cal.add(11, 24);
                            event.setEndDate(cal.getTime());
                            event.setContent(summary);
                            event.setHeaderColor(headerColor);
                            event.setContentColor(contentColor);
                            event.setR_RequestType_ID(R_RequestType_ID);
                            event.setLocked(true);
                            events.add(event);
                        }
                        if (dateStartPlan == null || dateCompletePlan == null) continue;
                        Calendar calBegin = Calendar.getInstance();
                        calBegin.setTime(dateStartPlan);
                        if (startTime != null) {
                            Calendar cal1 = Calendar.getInstance();
                            cal1.setTimeInMillis(startTime.getTime());
                            calBegin.set(11, cal1.get(11));
                            calBegin.set(12, cal1.get(12));
                            calBegin.set(13, 0);
                            calBegin.set(14, 0);
                        } else {
                            calBegin.set(11, 0);
                            calBegin.set(12, 0);
                            calBegin.set(13, 0);
                            calBegin.set(14, 0);
                        }
                        Calendar calEnd = Calendar.getInstance();
                        calEnd.setTime(dateCompletePlan);
                        if (endTime != null) {
                            Calendar cal1 = Calendar.getInstance();
                            cal1.setTimeInMillis(endTime.getTime());
                            calEnd.set(11, cal1.get(11));
                            calEnd.set(12, cal1.get(12));
                            calEnd.set(13, 0);
                            calEnd.set(14, 0);
                        } else {
                            calEnd.add(11, 24);
                        }
                        ADCalendarEvent event = new ADCalendarEvent();
                        event.setR_Request_ID(R_Request_ID);
                        event.setBeginDate(calBegin.getTime());
                        event.setEndDate(calEnd.getTime());
                        if (event.getBeginDate().compareTo(event.getEndDate()) >= 0) continue;
                        event.setContent(summary);
                        event.setHeaderColor(headerColor);
                        event.setContentColor(contentColor);
                        event.setR_RequestType_ID(R_RequestType_ID);
                        event.setLocked(true);
                        events.add(event);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    DB.close(rs, (Statement)ps);
                    break block21;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, (Statement)ps);
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)ps);
        }
        return events;
    }

    public static ArrayList<X_R_RequestType> getRequestTypes(Properties ctx) {
        ArrayList<X_R_RequestType> types;
        block6: {
            types = new ArrayList<X_R_RequestType>();
            String sql = "SELECT * FROM R_RequestType WHERE AD_Client_ID = ? AND IsActive = 'Y' ORDER BY Name";
            CPreparedStatement ps = null;
            ResultSet rs = null;
            try {
                try {
                    ps = DB.prepareStatement((String)sql, null);
                    ps.setInt(1, Env.getAD_Client_ID((Properties)ctx));
                    rs = ps.executeQuery();
                    while (rs.next()) {
                        types.add(new X_R_RequestType(ctx, rs, null));
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    DB.close(rs, (Statement)ps);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, (Statement)ps);
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)ps);
        }
        return types;
    }

    public void onRefresh() {
        this.btnRefreshClicked();
    }

    @Override
    public void refresh(ServerPushTemplate template) {
        this.refreshModel();
        template.executeAsync(this);
        if (this.desktop != null && this.desktop.get() != null) {
            if (this.desktop.get() != this.getDesktop()) {
                ((Desktop)this.desktop.get()).removeListener((Object)this.listener);
                this.desktop = new WeakReference<Desktop>(this.getDesktop());
                ((Desktop)this.desktop.get()).addListener((Object)this.listener);
            }
        } else {
            this.desktop = new WeakReference<Desktop>(this.getDesktop());
            if (this.desktop.get() != null) {
                ((Desktop)this.desktop.get()).addListener((Object)this.listener);
            }
        }
    }

    @Override
    public void updateUI() {
        if (this.scm == null) {
            this.scm = new SimpleCalendarModel();
            this.calendars.setModel((CalendarModel)this.scm);
        }
        this.scm.clear();
        for (ADCalendarEvent event : this.events) {
            this.scm.add((CalendarEvent)event);
        }
        this.calendars.invalidate();
    }

    private void btnRefreshClicked() {
        this.refreshModel();
        this.updateUI();
    }

    private void refreshModel() {
        this.events = DPCalendar.getEvents(0, Env.getCtx());
    }

    private void updateDateLabel() {
        java.util.Date b = this.calendars.getBeginDate();
        java.util.Date e = this.calendars.getEndDate();
        SimpleDateFormat sdfV = DisplayType.getDateFormat();
        sdfV.setTimeZone(this.calendars.getDefaultTimeZone());
        this.lblDate.setValue(sdfV.format(b) + " - " + sdfV.format(e));
    }

    private void btnCurrentDateClicked() {
        this.calendars.setCurrentDate(Calendar.getInstance(this.calendars.getDefaultTimeZone()).getTime());
        this.updateDateLabel();
        this.updateUI();
    }

    private void divArrowClicked(boolean isNext) {
        if (isNext) {
            this.calendars.nextPage();
        } else {
            this.calendars.previousPage();
        }
        this.updateDateLabel();
        this.updateUI();
    }

    public void handleEvent(Event event) {
        if (event.getTopic().equals(ON_REQUEST_CHANGED_TOPIC)) {
            String clientId = (String)event.getProperty("AD_Client_ID");
            String salesRepId = (String)event.getProperty("SalesRep_ID");
            String userId = (String)event.getProperty("AD_User_ID");
            String createdBy = (String)event.getProperty("CreatedBy");
            String AD_Client_ID = Integer.toString(Env.getAD_Client_ID((Properties)Env.getCtx()));
            String AD_User_ID = Integer.toString(Env.getAD_User_ID((Properties)Env.getCtx()));
            if (clientId.equals(AD_Client_ID) && !"0".equals(AD_User_ID) && (salesRepId.equals(AD_User_ID) || userId.equals(AD_User_ID) || createdBy.equals(AD_User_ID))) {
                try {
                    if (this.desktop != null && this.desktop.get() != null && ((Desktop)this.desktop.get()).isAlive()) {
                        ServerPushTemplate template = new ServerPushTemplate((Desktop)this.desktop.get());
                        this.refresh(template);
                    } else {
                        EventManager.getInstance().unregister((EventHandler)this);
                    }
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, e.getLocalizedMessage(), (Throwable)e);
                }
            }
        }
    }

    public void onPageAttached(Page newpage, Page oldpage) {
        super.onPageAttached(newpage, oldpage);
        if (newpage != null) {
            EventManager.getInstance().register(ON_REQUEST_CHANGED_TOPIC, (EventHandler)this);
            if (this.desktop != null && this.desktop.get() != null) {
                ((Desktop)this.desktop.get()).removeListener((Object)this.listener);
            }
            this.desktop = new WeakReference<Desktop>(this.getDesktop());
            ((Desktop)this.desktop.get()).addListener((Object)this.listener);
        }
    }

    @Override
    public void onPageDetached(Page page) {
        super.onPageDetached(page);
        this.cleanup();
    }

    protected void cleanup() {
        EventManager.getInstance().unregister((EventHandler)this);
        this.desktop = null;
    }

    @Override
    public boolean isLazy() {
        return true;
    }

    static class RequestEventHandler
    extends AbstractEventHandler {
        RequestEventHandler() {
        }

        protected void doHandleEvent(Event event) {
            Trx trx;
            PO po = this.getPO(event);
            I_R_Request request = (I_R_Request)po;
            HashMap<String, String> message = new HashMap<String, String>();
            message.put("SalesRep_ID", Integer.toString(request.getSalesRep_ID()));
            message.put("AD_User_ID", Integer.toString(request.getAD_User_ID()));
            message.put("CreatedBy", Integer.toString(request.getCreatedBy()));
            message.put("AD_Client_ID", Integer.toString(request.getAD_Client_ID()));
            RequestRunnable runnable = new RequestRunnable(message);
            Trx trx2 = trx = po.get_TrxName() != null ? Trx.get((String)po.get_TrxName(), (boolean)false) : null;
            if (trx != null && trx.isActive()) {
                trx.addTrxEventListener((TrxEventListener)new TrxListener(runnable));
            } else {
                runnable.run();
            }
        }

        protected void initialize() {
            this.registerTableEvent("adempiere/po/afterNew", "R_Request");
            this.registerTableEvent("adempiere/po/afterChange", "R_Request");
            this.registerTableEvent("adempiere/po/afterDelete", "R_Request");
        }
    }

    static class RequestRunnable
    implements Runnable {
        private Map<String, String> message;

        protected RequestRunnable(Map<String, String> message) {
            this.message = message;
        }

        @Override
        public void run() {
            IMessageService service = Core.getMessageService();
            if (service != null) {
                ITopic topic = service.getTopic(DPCalendar.ON_REQUEST_CHANGED_TOPIC);
                topic.publish(this.message);
            } else {
                Event requestChangedEvent = EventManager.newEvent((String)DPCalendar.ON_REQUEST_CHANGED_TOPIC, this.message, (boolean)true);
                EventManager.getInstance().postEvent(requestChangedEvent);
            }
        }
    }

    static class TopicSubscriber
    implements ITopicSubscriber<Map<String, String>> {
        TopicSubscriber() {
        }

        public void onMessage(Map<String, String> message) {
            Event requestChangedEvent = EventManager.newEvent((String)DPCalendar.ON_REQUEST_CHANGED_TOPIC, message, (boolean)true);
            EventManager.getInstance().postEvent(requestChangedEvent);
        }
    }

    static class TrxListener
    implements TrxEventListener {
        private Runnable runnable;

        protected TrxListener(Runnable runnable) {
            this.runnable = runnable;
        }

        public void afterRollback(Trx trx, boolean success) {
        }

        public void afterCommit(Trx trx, boolean success) {
            if (success) {
                this.runnable.run();
            }
        }

        public void afterClose(Trx trx) {
            trx.removeTrxEventListener((TrxEventListener)this);
        }
    }
}

