/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.dashboard;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import org.adempiere.webui.ClientInfo;
import org.adempiere.webui.component.Tabpanel;
import org.adempiere.webui.component.Window;
import org.adempiere.webui.dashboard.ADCalendarEvent;
import org.adempiere.webui.dashboard.DPCalendar;
import org.adempiere.webui.dashboard.EventWindow;
import org.adempiere.webui.dashboard.RequestWindow;
import org.adempiere.webui.panel.ITabOnCloseHandler;
import org.adempiere.webui.session.SessionManager;
import org.adempiere.webui.theme.ThemeManager;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.compiere.model.MSysConfig;
import org.compiere.model.X_R_RequestType;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.encoders.EncoderUtil;
import org.jfree.chart.plot.PiePlot;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;
import org.zkoss.calendar.Calendars;
import org.zkoss.calendar.api.CalendarEvent;
import org.zkoss.calendar.api.CalendarModel;
import org.zkoss.calendar.event.CalendarsEvent;
import org.zkoss.calendar.impl.SimpleCalendarEvent;
import org.zkoss.calendar.impl.SimpleCalendarModel;
import org.zkoss.image.AImage;
import org.zkoss.image.Image;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.util.Callback;
import org.zkoss.zul.Borderlayout;
import org.zkoss.zul.Button;
import org.zkoss.zul.Label;
import org.zkoss.zul.Listbox;
import org.zkoss.zul.Listitem;
import org.zkoss.zul.Popup;
import org.zkoss.zul.Span;
import org.zkoss.zul.Tab;
import org.zkoss.zul.Timer;
import org.zkoss.zul.Toolbarbutton;

public class CalendarWindow
extends Window
implements EventListener<Event>,
ITabOnCloseHandler {
    private static final long serialVersionUID = 1576992746053720647L;
    private static final String ON_MOBILE_SET_SELECTED_TAB_ECHO = "onMobileSetSelectedTabEcho";
    private static final String ON_MOVE_DATE_EVENT = "onMoveDate";
    private static final String ON_UPDATE_VIEW_EVENT = "onUpdateView";
    private static final String ON_MOUSE_OVER_EVENT = "onMouseOver";
    private static final String ON_EVENT_UPDATE_EVENT = "onEventUpdate";
    private static final String ON_EVENT_EDIT_EVENT = "onEventEdit";
    private static final String ON_EVENT_CREATE_EVENT = "onEventCreate";
    private Calendars calendars;
    private SimpleCalendarModel scm;
    private Toolbarbutton btnRefresh;
    private Listbox lbxRequestTypes;
    private org.zkoss.zul.Image myChart;
    private Button btnCurrentDate;
    private Button btnSwitchTimeZone;
    private Label lblDate;
    private Component divArrowLeft;
    private Component divArrowRight;
    private Span FDOW;
    private Listbox lbxFDOW;
    private Component divTabDay;
    private Component divTabWeek;
    private Component divTabWeekdays;
    private Component divTabMonth;
    private Popup updateMsg;
    private Label popupLabel;
    private Timer timer;
    private EventWindow eventWin;

    public CalendarWindow(SimpleCalendarModel scm) {
        String[] days;
        this.scm = scm;
        Properties ctx = Env.getCtx();
        this.setTitle(Msg.getMsg((Properties)ctx, (String)"Calendar"));
        this.setAttribute("mode", "embedded");
        Component component = Executions.createComponents((String)ThemeManager.getThemeResource("zul/calendar/calendar.zul"), (Component)this, null);
        Borderlayout borderlayout = (Borderlayout)component.getFellow("main");
        borderlayout.setStyle("position: relative");
        ZKUpdateUtil.setWidth((HtmlBasedComponent)borderlayout, "100%");
        ZKUpdateUtil.setHeight((HtmlBasedComponent)borderlayout, "100%");
        this.calendars = (Calendars)component.getFellow("cal");
        this.calendars.setModel((CalendarModel)scm);
        if (this.calendars.getCurrentDate() != null) {
            this.calendars.setCurrentDate(this.calendars.getCurrentDate());
        }
        this.setTimeZone();
        this.btnRefresh = (Toolbarbutton)component.getFellow("btnRefresh");
        this.btnRefresh.addEventListener("onClick", (EventListener)this);
        this.lbxRequestTypes = (Listbox)component.getFellow("lbxRequestTypes");
        this.lbxRequestTypes.addEventListener("onSelect", (EventListener)this);
        this.lbxRequestTypes.appendItem(Msg.getMsg((Properties)ctx, (String)"ShowAll"), "0");
        ArrayList<X_R_RequestType> types = DPCalendar.getRequestTypes(Env.getCtx());
        for (X_R_RequestType type : types) {
            this.lbxRequestTypes.appendItem(type.getName(), "" + type.getR_RequestType_ID());
        }
        this.lbxRequestTypes.setSelectedIndex(0);
        this.myChart = (org.zkoss.zul.Image)component.getFellow("mychart");
        this.myChart.addEventListener("onCreate", (EventListener)this);
        this.btnCurrentDate = (Button)component.getFellow("btnCurrentDate");
        this.btnCurrentDate.addEventListener("onClick", (EventListener)this);
        this.btnSwitchTimeZone = (Button)component.getFellow("btnSwitchTimeZone");
        this.btnSwitchTimeZone.addEventListener("onClick", (EventListener)this);
        String alternateTimeZone = MSysConfig.getValue((String)"CALENDAR_ALTERNATE_TIMEZONE", (String)"Pacific Time=PST", (int)Env.getAD_Client_ID((Properties)Env.getCtx()));
        if (Util.isEmpty((String)alternateTimeZone, (boolean)true)) {
            this.btnSwitchTimeZone.setVisible(false);
        }
        this.lblDate = (Label)component.getFellow("lblDate");
        this.lblDate.addEventListener("onCreate", (EventListener)this);
        this.divArrowLeft = component.getFellow("divArrowLeft");
        this.divArrowLeft.addEventListener(ON_MOVE_DATE_EVENT, (EventListener)this);
        this.divArrowRight = component.getFellow("divArrowRight");
        this.divArrowRight.addEventListener(ON_MOVE_DATE_EVENT, (EventListener)this);
        this.FDOW = (Span)component.getFellow("FDOW");
        this.FDOW.addEventListener("onCreate", (EventListener)this);
        this.lbxFDOW = (Listbox)component.getFellow("lbxFDOW");
        this.lbxFDOW.addEventListener("onSelect", (EventListener)this);
        this.lbxFDOW.addEventListener("onCreate", (EventListener)this);
        String[] stringArray = days = new String[]{"Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday", "Sunday"};
        int n = days.length;
        int n2 = 0;
        while (n2 < n) {
            String day = stringArray[n2];
            this.lbxFDOW.appendItem(Msg.getMsg((Properties)Env.getCtx(), (String)day), day);
            ++n2;
        }
        this.divTabDay = component.getFellow("divTabDay");
        this.divTabDay.addEventListener(ON_UPDATE_VIEW_EVENT, (EventListener)this);
        this.divTabWeek = component.getFellow("divTabWeek");
        this.divTabWeek.addEventListener(ON_UPDATE_VIEW_EVENT, (EventListener)this);
        this.divTabWeekdays = component.getFellow("divTabWeekdays");
        this.divTabWeekdays.addEventListener(ON_UPDATE_VIEW_EVENT, (EventListener)this);
        this.divTabMonth = component.getFellow("divTabMonth");
        this.divTabMonth.addEventListener(ON_UPDATE_VIEW_EVENT, (EventListener)this);
        this.updateMsg = (Popup)component.getFellow("updateMsg");
        this.popupLabel = (Label)component.getFellow("popupLabel");
        this.timer = (Timer)component.getFellow("timer");
        this.appendChild(component);
        this.calendars.addEventListener(ON_EVENT_CREATE_EVENT, (EventListener)this);
        this.calendars.addEventListener(ON_EVENT_EDIT_EVENT, (EventListener)this);
        this.calendars.addEventListener(ON_EVENT_UPDATE_EVENT, (EventListener)this);
        this.calendars.addEventListener(ON_MOUSE_OVER_EVENT, (EventListener)this);
        if (ClientInfo.isMobile()) {
            this.addCallback("afterPageAttached", (Callback & Serializable)t -> this.afterPageAttached());
            this.addEventListener(ON_MOBILE_SET_SELECTED_TAB_ECHO, evt -> this.calendars.invalidate());
        }
        SessionManager.getAppDesktop().showWindow(this);
        Component parentTab = this.getParent();
        if (parentTab != null && parentTab.getClass().equals(Tabpanel.class)) {
            ((Tabpanel)parentTab).setOnCloseHandler(this);
        }
    }

    private void afterPageAttached() {
        Component p = this.getParent();
        while (p != null) {
            if (p instanceof Tabpanel) {
                p.addEventListener("onMobileSetSelectedTab", evt -> this.onMobileSelected());
                break;
            }
            p = p.getParent();
        }
    }

    private void onMobileSelected() {
        Events.echoEvent((String)ON_MOBILE_SET_SELECTED_TAB_ECHO, (Component)this, null);
    }

    @Override
    public void onClose(Tabpanel tabPanel) {
        this.calendars.setModel(null);
        Tab tab = tabPanel.getLinkedTab();
        tab.close();
    }

    public void onEvent(Event e) throws Exception {
        String type = e.getName();
        if (type.equals("onClick")) {
            if (e.getTarget() == this.btnRefresh) {
                this.btnRefreshClicked();
            } else if (e.getTarget() == this.btnCurrentDate) {
                this.btnCurrentDateClicked();
            } else if (e.getTarget() == this.btnSwitchTimeZone) {
                this.btnSwitchTimeZoneClicked();
            }
        } else if (type.equals("onCreate")) {
            if (e.getTarget() == this.lblDate) {
                this.updateDateLabel();
            } else if (e.getTarget() == this.FDOW) {
                this.FDOW.setVisible("month".equals(this.calendars.getMold()) || this.calendars.getDays() == 7);
            } else if (e.getTarget() == this.myChart) {
                this.syncModel();
            } else if (e.getTarget() == this.lbxFDOW) {
                this.lbxFDOW.setSelectedIndex(0);
            }
        } else if (type.equals(ON_MOVE_DATE_EVENT)) {
            if (e.getTarget() == this.divArrowLeft) {
                this.divArrowClicked(false);
            } else if (e.getTarget() == this.divArrowRight) {
                this.divArrowClicked(true);
            }
        } else if (type.equals(ON_UPDATE_VIEW_EVENT)) {
            String text = String.valueOf(e.getData());
            int days = Msg.getMsg((Properties)Env.getCtx(), (String)"Day").equals(text) ? 1 : (Msg.getMsg((Properties)Env.getCtx(), (String)"5Days").equals(text) ? 5 : (Msg.getMsg((Properties)Env.getCtx(), (String)"Week").equals(text) ? 7 : 0));
            this.divTabClicked(days);
        } else if (type.equals("onSelect")) {
            if (e.getTarget() == this.lbxRequestTypes) {
                Listitem li = this.lbxRequestTypes.getSelectedItem();
                if (li == null) {
                    return;
                }
                if (li.getValue() == null) {
                    return;
                }
                int R_RequestType_ID = Integer.parseInt(li.getValue().toString());
                this.scm.clear();
                ArrayList<ADCalendarEvent> events = DPCalendar.getEvents(R_RequestType_ID, Env.getCtx());
                for (ADCalendarEvent event : events) {
                    this.scm.add((CalendarEvent)event);
                }
                this.calendars.invalidate();
                this.syncModel();
            } else if (e.getTarget() == this.lbxFDOW) {
                this.calendars.setFirstDayOfWeek(this.lbxFDOW.getSelectedItem().getValue().toString());
                this.syncModel();
            }
        } else if (type.equals(ON_EVENT_CREATE_EVENT)) {
            if (e instanceof CalendarsEvent) {
                CalendarsEvent calendarsEvent = (CalendarsEvent)e;
                RequestWindow requestWin = new RequestWindow(calendarsEvent, this);
                SessionManager.getAppDesktop().showWindow(requestWin);
            }
        } else if (type.equals(ON_EVENT_EDIT_EVENT)) {
            CalendarsEvent calendarsEvent;
            CalendarEvent calendarEvent;
            if (e instanceof CalendarsEvent && (calendarEvent = (calendarsEvent = (CalendarsEvent)e).getCalendarEvent()) instanceof ADCalendarEvent) {
                ADCalendarEvent ce = (ADCalendarEvent)calendarEvent;
                if (this.eventWin == null) {
                    this.eventWin = new EventWindow();
                }
                this.eventWin.setData(ce);
                SessionManager.getAppDesktop().showWindow(this.eventWin);
            }
        } else if (type.equals(ON_EVENT_UPDATE_EVENT) && e instanceof CalendarsEvent) {
            CalendarsEvent evt = (CalendarsEvent)e;
            SimpleDateFormat sdf1 = new SimpleDateFormat("yyyy/MM/d");
            sdf1.setTimeZone(this.calendars.getDefaultTimeZone());
            StringBuilder sb = new StringBuilder("Update... from ");
            sb.append(sdf1.format(evt.getCalendarEvent().getBeginDate()));
            sb.append(" to ");
            sb.append(sdf1.format(evt.getBeginDate()));
            this.popupLabel.setValue(sb.toString());
            int left = evt.getX();
            int top = evt.getY();
            if (top + 100 > evt.getDesktopHeight()) {
                top = evt.getDesktopHeight() - 100;
            }
            if (left + 330 > evt.getDesktopWidth()) {
                left = evt.getDesktopWidth() - 330;
            }
            this.updateMsg.open(left, top);
            this.timer.start();
            Calendars cal = (Calendars)evt.getTarget();
            SimpleCalendarModel m = (SimpleCalendarModel)cal.getModel();
            SimpleCalendarEvent sce = (SimpleCalendarEvent)evt.getCalendarEvent();
            sce.setBeginDate(evt.getBeginDate());
            sce.setEndDate(evt.getEndDate());
            m.update((CalendarEvent)sce);
        }
    }

    private void syncModel() {
        Hashtable<CallSite, BigDecimal> ht = new Hashtable<CallSite, BigDecimal>();
        List list = this.calendars.getModel().get(this.calendars.getBeginDate(), this.calendars.getEndDate(), null);
        int size = list.size();
        Iterator it = list.iterator();
        while (it.hasNext()) {
            String key = "" + ((ADCalendarEvent)((Object)it.next())).getR_RequestType_ID();
            if (!ht.containsKey(key)) {
                ht.put((CallSite)((Object)key), BigDecimal.ONE);
                continue;
            }
            BigDecimal value = (BigDecimal)ht.get(key);
            ht.put((CallSite)((Object)key), value.add(BigDecimal.ONE));
        }
        Hashtable<Object, String> htTypes = new Hashtable<Object, String>();
        int i = 0;
        while (i < this.lbxRequestTypes.getItemCount()) {
            Listitem li = this.lbxRequestTypes.getItemAtIndex(i);
            if (li != null && li.getValue() != null) {
                htTypes.put(li.getValue(), li.getLabel());
            }
            ++i;
        }
        DefaultPieDataset pieDataset = new DefaultPieDataset();
        Enumeration keys = ht.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            BigDecimal value = (BigDecimal)ht.get(key);
            String name = (String)htTypes.get(key);
            pieDataset.setValue((Comparable)((Object)(name == null ? "" : name)), (Number)(size > 0 ? value.doubleValue() / (double)size * 100.0 : 0.0));
        }
        JFreeChart chart = ChartFactory.createPieChart((String)Msg.getMsg((Properties)Env.getCtx(), (String)"EventsAnalysis"), (PieDataset)pieDataset, (boolean)true, (boolean)true, (boolean)true);
        PiePlot plot = (PiePlot)chart.getPlot();
        plot.setForegroundAlpha(0.5f);
        BufferedImage bi = chart.createBufferedImage(600, 250);
        try {
            byte[] bytes = EncoderUtil.encode((BufferedImage)bi, (String)"png", (boolean)true);
            AImage image = new AImage("Pie Chart", bytes);
            this.myChart.setContent((Image)image);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        htTypes = null;
        ht = null;
    }

    public void onRefresh() {
        this.btnRefreshClicked();
    }

    private void btnRefreshClicked() {
        int R_RequestType_ID = 0;
        Listitem li = this.lbxRequestTypes.getSelectedItem();
        if (li != null && li.getValue() != null) {
            R_RequestType_ID = Integer.parseInt(li.getValue().toString());
        }
        int cnt = this.lbxRequestTypes.getItemCount();
        int i = cnt - 1;
        while (i >= 0) {
            this.lbxRequestTypes.removeItemAt(i);
            --i;
        }
        this.lbxRequestTypes.appendItem(Msg.getMsg((Properties)Env.getCtx(), (String)"ShowAll"), "0");
        ArrayList<X_R_RequestType> types = DPCalendar.getRequestTypes(Env.getCtx());
        for (X_R_RequestType requestType : types) {
            Listitem item = this.lbxRequestTypes.appendItem(requestType.getName(), "" + requestType.getR_RequestType_ID());
            if (R_RequestType_ID != requestType.getR_RequestType_ID()) continue;
            this.lbxRequestTypes.setSelectedItem(item);
        }
        if (this.lbxRequestTypes.getSelectedIndex() < 0) {
            this.lbxRequestTypes.setSelectedIndex(0);
        }
        this.scm.clear();
        ArrayList<ADCalendarEvent> events = DPCalendar.getEvents(R_RequestType_ID, Env.getCtx());
        for (ADCalendarEvent event : events) {
            this.scm.add((CalendarEvent)event);
        }
        this.calendars.invalidate();
        this.syncModel();
    }

    private void setTimeZone() {
        String alternateTimeZone = MSysConfig.getValue((String)"CALENDAR_ALTERNATE_TIMEZONE", (String)"Pacific Time=PST", (int)Env.getAD_Client_ID((Properties)Env.getCtx()));
        TimeZone defaultTimeZone = TimeZone.getDefault();
        this.calendars.addTimeZone(defaultTimeZone.getDisplayName(), defaultTimeZone);
        if (!Util.isEmpty((String)alternateTimeZone, (boolean)true) && !alternateTimeZone.equalsIgnoreCase(defaultTimeZone.getDisplayName())) {
            String[] pair = alternateTimeZone.split("=");
            this.calendars.addTimeZone(pair[0].trim(), pair[1].trim());
        }
    }

    private void updateDateLabel() {
        Date b = this.calendars.getBeginDate();
        Date e = this.calendars.getEndDate();
        SimpleDateFormat sdfV = DisplayType.getDateFormat();
        sdfV.setTimeZone(this.calendars.getDefaultTimeZone());
        this.lblDate.setValue(sdfV.format(b) + " - " + sdfV.format(e));
    }

    private void btnCurrentDateClicked() {
        this.calendars.setCurrentDate(Calendar.getInstance(this.calendars.getDefaultTimeZone()).getTime());
        this.updateDateLabel();
        this.syncModel();
    }

    private void btnSwitchTimeZoneClicked() {
        Map zone = this.calendars.getTimeZones();
        if (!zone.isEmpty()) {
            Map.Entry me = zone.entrySet().iterator().next();
            this.calendars.removeTimeZone((TimeZone)me.getKey());
            this.calendars.addTimeZone((String)me.getValue(), (TimeZone)me.getKey());
        }
        this.syncModel();
    }

    private void divArrowClicked(boolean isNext) {
        if (isNext) {
            this.calendars.nextPage();
        } else {
            this.calendars.previousPage();
        }
        this.updateDateLabel();
        this.syncModel();
    }

    private void divTabClicked(int days) {
        if (days > 0) {
            this.calendars.setMold("default");
            this.calendars.setDays(days);
        } else {
            this.calendars.setMold("month");
        }
        this.updateDateLabel();
        this.FDOW.setVisible("month".equals(this.calendars.getMold()) || this.calendars.getDays() == 7);
    }
}

