/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.component;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.adempiere.webui.component.ListCell;
import org.adempiere.webui.component.ListItem;
import org.adempiere.webui.component.ZkCssHelper;
import org.compiere.apps.form.TreeMaintenance;
import org.zkoss.lang.Objects;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zul.AbstractListModel;
import org.zkoss.zul.Listbox;
import org.zkoss.zul.Listcell;
import org.zkoss.zul.Listitem;
import org.zkoss.zul.ListitemRenderer;
import org.zkoss.zul.ListitemRendererExt;
import org.zkoss.zul.ext.Sortable;

public class SimpleListModel
extends AbstractListModel<Object>
implements ListitemRenderer<Object>,
ListitemRendererExt,
Sortable<Object> {
    private static final long serialVersionUID = -572148106182756840L;
    protected List<Object> list;
    private Comparator<Object> _sorting;
    private boolean _sortDir;
    private int[] maxLength;

    public SimpleListModel() {
        this(new ArrayList());
    }

    public SimpleListModel(List<?> list) {
        this.list = list;
    }

    public Object getElementAt(int index) {
        if (index >= 0 && index < this.list.size()) {
            return this.list.get(index);
        }
        return null;
    }

    public int getSize() {
        return this.list.size();
    }

    protected StringBuffer truncate(String src, int maxLength) {
        int j = maxLength;
        while (j > 0 && Character.isWhitespace(src.charAt(j - 1))) {
            --j;
        }
        return new StringBuffer(j + 3).append(src.substring(0, j)).append("...");
    }

    public void render(Listitem item, Object data, int index) throws Exception {
        if (data instanceof Object[]) {
            this.renderArray(item, (Object[])data);
        } else if (data instanceof Collection) {
            this.renderCollection(item, (Collection)data);
        } else {
            String value = data != null ? data.toString() : "";
            this.renderCell(0, item, value);
        }
    }

    protected void renderCell(int col, Listitem item, String value) {
        String tooltip = null;
        if (this.maxLength != null && this.maxLength.length > col && this.maxLength[col] > 0 && value.length() > this.maxLength[col]) {
            tooltip = value;
            value = this.truncate(value, this.maxLength[col]).toString();
        }
        ListCell listCell = new ListCell(value);
        listCell.setParent((Component)item);
        if (tooltip != null) {
            listCell.setTooltiptext(tooltip);
        }
        boolean isSummary = false;
        Object li = null;
        if (item != null && this.list != null) {
            li = this.list.get(item.getIndex());
        }
        if (li != null && li instanceof TreeMaintenance.ListItem) {
            isSummary = ((TreeMaintenance.ListItem)li).isSummary;
        }
        if (isSummary) {
            ZkCssHelper.appendStyle((HtmlBasedComponent)listCell, "font-weight: bold");
        }
    }

    private void renderCollection(Listitem item, Collection<?> data) {
        int i = 0;
        for (Object col : data) {
            String value = col != null ? col.toString() : "";
            this.renderCell(i, item, value);
            ++i;
        }
    }

    private void renderArray(Listitem item, Object[] data) {
        int i = 0;
        Object[] objectArray = data;
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            Object col = objectArray[n2];
            String value = col != null ? col.toString() : "";
            this.renderCell(i, item, value);
            ++i;
            ++n2;
        }
    }

    public int getControls() {
        return 1;
    }

    public Listcell newListcell(Listitem item) {
        return null;
    }

    public Listitem newListitem(Listbox listbox) {
        ListItem item = new ListItem();
        item.applyProperties();
        return item;
    }

    public void setMaxLength(int[] maxLength) {
        this.maxLength = maxLength;
    }

    public void addElement(Object obj) {
        this.list.add(obj);
        int index = this.list.size() - 1;
        this.fireEvent(1, index, index);
    }

    public void add(int index, Object obj) {
        this.list.add(index, obj);
        this.fireEvent(1, index, index);
    }

    public void removeAllElements() {
        this.list.clear();
        this.fireEvent(0, -1, -1);
    }

    public void removeElement(Object element) {
        int index = this.list.indexOf(element);
        this.list.remove(element);
        this.fireEvent(2, index, index);
    }

    public void setElementAt(Object element, int index) {
        this.list.set(index, element);
        this.fireEvent(0, index, index);
    }

    public int indexOf(Object value) {
        return this.list.indexOf(value);
    }

    public void sort(Comparator<Object> cmpr, boolean ascending) {
        this._sorting = cmpr;
        this._sortDir = ascending;
        Collections.sort(this.list, cmpr);
        this.fireEvent(3, -1, -1);
    }

    public String getSortDirection(Comparator<Object> cmpr) {
        if (Objects.equals(this._sorting, cmpr)) {
            return this._sortDir ? "ascending" : "descending";
        }
        return "natural";
    }
}

