/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.component;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Vector;
import org.adempiere.webui.event.WTableModelEvent;
import org.adempiere.webui.event.WTableModelListener;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zul.ListModel;
import org.zkoss.zul.ListModelList;
import org.zkoss.zul.ext.Sortable;

public class ListModelTable
extends ListModelList<Object>
implements Sortable<Object> {
    private static final long serialVersionUID = 1891313647781142789L;
    protected ArrayList<WTableModelListener> m_listeners = new ArrayList();
    private int m_noColumns;
    private Sortable<Object> sorter = null;

    public ListModelTable() {
    }

    public ListModelTable(Collection<?> collection) {
        super(collection);
        this.m_noColumns = 0;
        for (Object row : this.getInnerList()) {
            if (row instanceof List) {
                this.m_noColumns = Math.max(this.m_noColumns, ((List)row).size());
                continue;
            }
            throw new IllegalArgumentException("The collection must contain list of objects");
        }
    }

    public int getNoColumns() {
        return this.m_noColumns;
    }

    public void addColumn() {
        ++this.m_noColumns;
        this.ensureRowSize();
    }

    private void ensureRowSize() {
        for (List list : this.getInnerList()) {
            int i;
            if (list instanceof Vector) {
                ((Vector)list).setSize(this.m_noColumns);
                continue;
            }
            if (this.m_noColumns > list.size()) {
                i = list.size();
                while (i < this.m_noColumns) {
                    list.add(null);
                    ++i;
                }
                continue;
            }
            if (this.m_noColumns >= list.size()) continue;
            i = list.size();
            while (i > this.m_noColumns) {
                list.remove(i - 1);
                --i;
            }
        }
    }

    public void setNoColumns(int columns) {
        this.m_noColumns = columns;
        this.ensureRowSize();
    }

    public int getNoRows() {
        return this.getSize();
    }

    public Object getDataAt(int rowIndex, int columnIndex) {
        Object dataObject;
        try {
            List modelRow = (List)this.getElementAt(rowIndex);
            dataObject = modelRow.get(columnIndex);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Attempted to access nonexistent ListModelTable field at " + rowIndex + ", " + columnIndex);
        }
        return dataObject;
    }

    public void setDataAt(Object aValue, int row, int col) {
        block5: {
            try {
                if (this.getElementAt(row) instanceof List) {
                    List vector = (List)this.getElementAt(row);
                    try {
                        vector.set(col, aValue);
                        WTableModelEvent tcEvent = new WTableModelEvent((ListModel<?>)this, row, col);
                        this.fireTableChange(tcEvent);
                        break block5;
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        throw new IllegalArgumentException("Attempted to access nonexistent ListModelTable column at index " + col);
                    }
                }
                throw new IllegalArgumentException("The ListModelTable cannot contain anything other than object vectors as its row elements");
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new IllegalArgumentException("Attempted to access nonexistent ListModelTable row at index " + row);
            }
        }
    }

    public void setNoRows(int rowCount) {
        AbstractList newRow = null;
        int currentSize = this.getSize();
        if (rowCount >= currentSize) {
            boolean vector = this.getInnerList() instanceof Vector;
            while (this.getSize() < rowCount) {
                if (vector) {
                    newRow = new Vector(this.getNoColumns());
                    ((Vector)newRow).setSize(this.getNoColumns());
                    this.add(newRow);
                    continue;
                }
                newRow = new ArrayList(this.getNoColumns());
                int i = 0;
                while (i < this.getNoColumns()) {
                    newRow.add(null);
                    ++i;
                }
                this.add(newRow);
            }
        } else {
            if (rowCount == 0) {
                this.clearSelection();
            }
            this.removeRange(rowCount, currentSize);
        }
    }

    public void addTableModelListener(WTableModelListener listener) {
        if (listener == null) {
            return;
        }
        if (!this.m_listeners.contains(listener)) {
            this.m_listeners.add(listener);
        }
    }

    public void removeTableModelListener(WTableModelListener listener) {
        this.m_listeners.remove(listener);
    }

    private void fireTableChange(WTableModelEvent event) {
        for (WTableModelListener listener : this.m_listeners) {
            listener.tableChanged(event);
        }
    }

    public void sort(Comparator<Object> cmpr, boolean ascending) {
        if (this.sorter != null) {
            this.sorter.sort(cmpr, ascending);
        } else {
            Collections.sort(this.getInnerList(), cmpr);
        }
        WTableModelEvent event = new WTableModelEvent((ListModel<?>)this, -1, -1);
        this.fireTableChange(event);
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.getDataAt(rowIndex, columnIndex);
    }

    public void setValueAt(Object value, int row, int col) {
        this.setDataAt(value, row, col);
    }

    public int getRowCount() {
        return this.getSize();
    }

    public void updateComponent(int row) {
        this.updateComponent(row, row);
    }

    public void updateComponent(int fromRow, int toRow) {
        if (Executions.getCurrent() != null) {
            this.fireEvent(0, fromRow, toRow);
        }
    }

    public void setSorter(Sortable<Object> lme) {
        this.sorter = lme;
    }
}

