/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.component;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.adempiere.webui.LayoutUtils;
import org.adempiere.webui.component.Button;
import org.compiere.util.ValueNamePair;
import org.zkoss.addon.chosenbox.Chosenbox;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zul.Div;

public class ChosenSearchBox
extends Div {
    private static final long serialVersionUID = -3152111756471436612L;
    protected PropertyChangeSupport m_propertyChangeListeners = new PropertyChangeSupport((Object)this);
    protected Chosenbox<ValueNamePair> chosenbox;
    protected Button btn;

    public ChosenSearchBox(Chosenbox<ValueNamePair> chosenbox) {
        this.chosenbox = chosenbox;
        this.initComponents();
    }

    public ChosenSearchBox() {
        this.initComponents();
    }

    public void setButtonImage(String imageSrc) {
        this.btn.setImage(imageSrc);
    }

    private void initComponents() {
        if (this.chosenbox == null) {
            this.chosenbox = new Chosenbox();
        }
        this.chosenbox.setSclass("editor-input");
        this.chosenbox.setWidth("100%");
        this.appendChild((Component)this.chosenbox);
        this.btn = new Button();
        this.btn.setTabindex(-1);
        this.btn.setHflex("0");
        this.btn.setSclass("editor-button");
        this.appendChild((Component)this.btn);
        LayoutUtils.addSclass("editor-box", (HtmlBasedComponent)this);
        this.setTableEditorMode(false);
    }

    public Chosenbox<ValueNamePair> getChosenbox() {
        return this.chosenbox;
    }

    public void setEnabled(boolean enabled) {
        this.chosenbox.setDisabled(!enabled);
        this.btn.setEnabled(enabled);
        this.btn.setVisible(enabled);
        if (enabled) {
            if (this.btn.getParent() != this.chosenbox.getParent()) {
                this.btn.setParent(this.chosenbox.getParent());
            }
        } else if (this.btn.getParent() != null) {
            this.btn.detach();
        }
        if (enabled) {
            LayoutUtils.removeSclass("editor-input-disd", this.chosenbox);
        } else {
            LayoutUtils.addSclass("editor-input-disd", this.chosenbox);
        }
    }

    public boolean isEnabled() {
        return this.btn.isEnabled();
    }

    public boolean addEventListener(String evtnm, EventListener<?> listener) {
        if ("onClick".equals(evtnm)) {
            return this.btn.addEventListener(evtnm, listener);
        }
        return this.chosenbox.addEventListener(evtnm, listener);
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener l) {
        this.m_propertyChangeListeners.addPropertyChangeListener(l);
    }

    public void setToolTipText(String tooltiptext) {
        this.chosenbox.setTooltiptext(tooltiptext);
    }

    public Button getButton() {
        return this.btn;
    }

    public void setTableEditorMode(boolean flag) {
        if (flag) {
            this.setHflex("0");
            LayoutUtils.addSclass("grid-editor-input", this.chosenbox);
            LayoutUtils.addSclass("grid-editor-button", (HtmlBasedComponent)this.btn);
        } else {
            this.setHflex("1");
            LayoutUtils.removeSclass("grid-editor-input", this.chosenbox);
            LayoutUtils.removeSclass("grid-editor-button", (HtmlBasedComponent)this.btn);
        }
    }
}

