/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.component;

import java.util.List;
import org.adempiere.webui.adwindow.IADTabbox;
import org.adempiere.webui.component.ListItem;
import org.zkoss.zk.ui.Component;
import org.zkoss.zul.AbstractListModel;
import org.zkoss.zul.Listbox;
import org.zkoss.zul.Listcell;
import org.zkoss.zul.Listitem;
import org.zkoss.zul.ListitemRenderer;
import org.zkoss.zul.ListitemRendererExt;

public class ADTabListModel
extends AbstractListModel<Object>
implements ListitemRenderer<Object>,
ListitemRendererExt {
    private static final long serialVersionUID = 7683969121090679214L;
    protected List<ADTabLabel> listItems = null;
    private IADTabbox tabbox;

    public ADTabListModel(List<ADTabLabel> listItems, IADTabbox tabbox) {
        this.listItems = listItems;
        this.tabbox = tabbox;
    }

    public Object getElementAt(int index) {
        ADTabLabel item = index < this.listItems.size() ? this.listItems.get(index) : null;
        return item;
    }

    public int getSize() {
        return this.listItems.size();
    }

    public void render(Listitem item, Object data, int index) throws Exception {
        ADTabLabel tabLabel = (ADTabLabel)data;
        Listcell cell = new Listcell(tabLabel.label, null);
        if (tabLabel.tabLevel > 0) {
            cell.setStyle("padding-left:" + (tabLabel.tabLevel * 15 + 5) + "px");
        }
        cell.setParent((Component)item);
        int i = this.listItems.indexOf(tabLabel);
        int s = this.tabbox.getSelectedIndex();
        if (!this.tabbox.canNavigateTo(s, i)) {
            cell.setVisible(false);
        }
    }

    public int getControls() {
        return 1;
    }

    public Listcell newListcell(Listitem item) {
        return null;
    }

    public Listitem newListitem(Listbox listbox) {
        ListItem item = new ListItem();
        item.applyProperties();
        return item;
    }

    public static class ADTabLabel {
        public String label;
        public int tabLevel;
        public String description;
        public int windowNo = -1;
        public int AD_Tab_ID = -1;

        public ADTabLabel(String label, int tabLevel) {
            this.label = label;
            this.tabLevel = tabLevel;
        }

        public ADTabLabel(String label, int tabLevel, String description) {
            this(label, tabLevel);
            this.description = description;
        }

        public ADTabLabel(String label, int tabLevel, String description, int windowNo, int AD_Tab_ID) {
            this(label, tabLevel, description);
            this.windowNo = windowNo;
            this.AD_Tab_ID = AD_Tab_ID;
        }
    }
}

