/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.apps.graph;

import java.util.Properties;
import org.adempiere.webui.apps.AEnv;
import org.adempiere.webui.component.Label;
import org.adempiere.webui.component.Panel;
import org.adempiere.webui.component.ZkCssHelper;
import org.adempiere.webui.panel.ADForm;
import org.adempiere.webui.session.SessionManager;
import org.compiere.model.MDocumentStatus;
import org.compiere.model.MQuery;
import org.compiere.print.MPrintColor;
import org.compiere.print.MPrintFont;
import org.compiere.util.Env;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zul.Div;

public class WDocumentStatusIndicator
extends Panel
implements EventListener<Event> {
    private static final long serialVersionUID = -9076405331101242792L;
    private MDocumentStatus m_documentStatus = null;
    private int statusCount;
    private Label statusLabel;

    public WDocumentStatusIndicator(MDocumentStatus documentStatus) {
        this(documentStatus, false);
    }

    public WDocumentStatusIndicator(MDocumentStatus documentStatus, boolean lazy) {
        this.m_documentStatus = documentStatus;
        this.init();
        this.setSclass("activities-box");
        if (!lazy) {
            this.refresh();
            this.updateUI();
        }
    }

    public MDocumentStatus getDocumentStatus() {
        return this.m_documentStatus;
    }

    private void init() {
        Div div = new Div();
        this.appendChild((Component)div);
        Label nameLabel = new Label();
        nameLabel.setText(this.m_documentStatus.get_Translation("Name") + ": ");
        nameLabel.setTooltiptext(this.m_documentStatus.get_Translation("Description"));
        Object nameColorStyle = "";
        int Name_PrintColor_ID = this.m_documentStatus.getName_PrintColor_ID();
        if (Name_PrintColor_ID > 0) {
            MPrintColor printColor = MPrintColor.get((Properties)Env.getCtx(), (int)Name_PrintColor_ID);
            String color = ZkCssHelper.createHexColorString(printColor.getColor());
            nameColorStyle = "color:#" + color + ";";
        }
        int AD_PrintFont_ID = this.m_documentStatus.getName_PrintFont_ID();
        Object nameFontStyle = "";
        if (AD_PrintFont_ID > 0) {
            MPrintFont printFont = MPrintFont.get((int)AD_PrintFont_ID);
            String family = printFont.getFont().getFamily();
            boolean bold = printFont.getFont().isBold();
            boolean italic = printFont.getFont().isItalic();
            int pointSize = printFont.getFont().getSize();
            nameFontStyle = "font-family:'" + family + "';font-weight:" + (bold ? "bold" : "normal") + ";font-style:" + (italic ? "italic" : "normal") + ";font-size:" + pointSize + "pt";
        }
        nameLabel.setStyle((String)nameColorStyle + (String)nameFontStyle);
        div.appendChild((Component)nameLabel);
        this.statusLabel = new Label();
        Object numberColorStyle = "";
        int Number_PrintColor_ID = this.m_documentStatus.getNumber_PrintColor_ID();
        if (Number_PrintColor_ID > 0) {
            MPrintColor printColor = MPrintColor.get((Properties)Env.getCtx(), (int)Number_PrintColor_ID);
            String color = ZkCssHelper.createHexColorString(printColor.getColor());
            numberColorStyle = "color:#" + color + ";";
        }
        Object numberFontStyle = "";
        int Number_PrintFont_ID = this.m_documentStatus.getNumber_PrintFont_ID();
        if (Number_PrintFont_ID > 0) {
            MPrintFont printFont = MPrintFont.get((int)Number_PrintFont_ID);
            String family = printFont.getFont().getFamily();
            boolean bold = printFont.getFont().isBold();
            boolean italic = printFont.getFont().isItalic();
            int pointSize = printFont.getFont().getSize();
            numberFontStyle = "font-family:'" + family + "';font-weight:" + (bold ? "bold" : "normal") + ";font-style:" + (italic ? "italic" : "normal") + ";font-size:" + pointSize + "pt;";
            int margin = pointSize;
            numberFontStyle = (String)numberFontStyle + "margin-top:" + margin + "pt;margin-bottom:" + margin + "pt;";
        }
        this.statusLabel.setStyle((String)numberColorStyle + (String)numberFontStyle);
        div.appendChild((Component)this.statusLabel);
        this.addEventListener("onClick", this);
    }

    public void onEvent(Event event) throws Exception {
        int AD_Window_ID = this.m_documentStatus.getAD_Window_ID();
        int AD_Form_ID = this.m_documentStatus.getAD_Form_ID();
        if (AD_Window_ID > 0) {
            MQuery query = new MQuery(this.m_documentStatus.getAD_Table_ID());
            query.addRestriction(MDocumentStatus.getWhereClause((MDocumentStatus)this.m_documentStatus));
            AEnv.zoom(AD_Window_ID, query);
        } else if (AD_Form_ID > 0) {
            ADForm form = ADForm.openForm(AD_Form_ID);
            form.setAttribute("mode", "embedded");
            SessionManager.getAppDesktop().showWindow(form);
        }
    }

    public void refresh() {
        MDocumentStatus refresh_documentStatus = MDocumentStatus.get((Properties)Env.getCtx(), (int)this.m_documentStatus.getPA_DocumentStatus_ID());
        if (refresh_documentStatus != null) {
            this.m_documentStatus = refresh_documentStatus;
        }
        this.statusCount = MDocumentStatus.evaluate((MDocumentStatus)this.m_documentStatus);
    }

    public void updateUI() {
        this.statusLabel.setText(Integer.toString(this.statusCount));
    }

    public int getStatusCount() {
        return this.statusCount;
    }
}

