/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.apps.form;

import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.exceptions.DBException;
import org.adempiere.webui.component.Button;
import org.adempiere.webui.component.Label;
import org.adempiere.webui.component.ListModelTable;
import org.adempiere.webui.component.Textbox;
import org.adempiere.webui.component.WListItemRenderer;
import org.adempiere.webui.component.WListbox;
import org.adempiere.webui.panel.ADForm;
import org.adempiere.webui.theme.ThemeManager;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.compiere.model.MIssue;
import org.compiere.model.MSysConfig;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Trx;
import org.idempiere.ui.zk.annotation.Form;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zul.Borderlayout;
import org.zkoss.zul.Center;
import org.zkoss.zul.Div;
import org.zkoss.zul.Frozen;
import org.zkoss.zul.ListModel;
import org.zkoss.zul.North;
import org.zkoss.zul.South;

@Form
public class WSQLQuery
extends ADForm
implements EventListener<Event> {
    private static final long serialVersionUID = -6641250848300700313L;
    private static final CLogger log = CLogger.getCLogger(WSQLQuery.class);
    private Borderlayout layout = new Borderlayout();
    private Label m_lblSql = new Label("SQL");
    private Textbox m_txbSqlField = new Textbox();
    private Button m_btnSql = WSQLQuery.createProcessButton();
    private Textbox m_txbResultField = new Textbox();
    private ListModelTable model = null;
    private WListbox listbox = new WListbox();
    private static final String REGEX_REMOVE_COMMENTS = "/\\*(?:.|[\\n\\r])*?\\*/";
    private static final String REGEX_REMOVE_QUOTED_STRINGS = "'(?:.|[\\n\\r])*?'";
    private static final String REGEX_REMOVE_LEADING_SPACES = "^\\s+";

    @Override
    protected void initForm() {
        North north = new North();
        Center center = new Center();
        South south = new South();
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.layout, "100%");
        ZKUpdateUtil.setHeight((HtmlBasedComponent)this.layout, "100%");
        this.layout.setStyle("background-color: transparent; position: relative;");
        Div div = new Div();
        this.m_txbSqlField.setMultiline(true);
        this.m_txbSqlField.setMaxlength(10000);
        this.m_txbSqlField.setRows(3);
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.m_txbSqlField, "1");
        this.m_txbSqlField.setReadonly(false);
        this.m_btnSql.addEventListener("onClick", this);
        div.appendChild((Component)this.m_lblSql);
        div.appendChild((Component)this.m_txbSqlField);
        div.appendChild((Component)this.m_btnSql);
        north.appendChild((Component)div);
        this.layout.appendChild((Component)north);
        this.m_txbResultField.setRows(2);
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.m_txbResultField, "1");
        this.m_txbResultField.setReadonly(true);
        center.appendChild((Component)this.listbox);
        ZKUpdateUtil.setVflex((HtmlBasedComponent)this.listbox, "1");
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.listbox, "1");
        this.layout.appendChild((Component)center);
        south.appendChild((Component)this.m_txbResultField);
        this.layout.appendChild((Component)south);
        this.appendChild((Component)this.layout);
    }

    public static final Button createProcessButton() {
        Button btnProcess = new Button();
        if (ThemeManager.isUseFontIconForImage()) {
            btnProcess.setIconSclass("z-icon-Process");
        } else {
            btnProcess.setImage(ThemeManager.getThemeResource("images/Process24.png"));
        }
        btnProcess.setName(Msg.getMsg((Properties)Env.getCtx(), (String)"Process"));
        return btnProcess;
    }

    public String processStatement(String sqlStatement) {
        StringBuilder result;
        block27: {
            this.m_txbResultField.setText(null);
            this.listbox.clear();
            if (sqlStatement == null || sqlStatement.length() == 0) {
                return "";
            }
            StringBuilder sb = new StringBuilder();
            char[] chars = sqlStatement.toCharArray();
            int i = 0;
            while (i < chars.length) {
                char c = chars[i];
                if (Character.isWhitespace(c)) {
                    sb.append(' ');
                } else {
                    sb.append(c);
                }
                ++i;
            }
            String sql = sb.toString().trim();
            if (sql.length() == 0) {
                return "";
            }
            result = new StringBuilder();
            String SQL = sql.toUpperCase();
            String cleanSQL = SQL.replaceAll(REGEX_REMOVE_COMMENTS, "").replaceAll(REGEX_REMOVE_QUOTED_STRINGS, "").replaceFirst(REGEX_REMOVE_LEADING_SPACES, "");
            if (cleanSQL.contains(";")) {
                result.append("ERROR: Multiple Commands Not Allowed");
                return result.toString();
            }
            int timeout = MSysConfig.getIntValue((String)"FORM_SQL_QUERY_TIMEOUT_IN_SECONDS", (int)120);
            int maxRecords = MSysConfig.getIntValue((String)"FORM_SQL_QUERY_MAX_RECORDS", (int)500);
            String[] allowedKeywords = MSysConfig.getValue((String)"FORM_SQL_QUERY_ALLOWED_KEYWORDS", (String)"SELECT,WITH,SHOW").split(",");
            boolean isError = true;
            int i2 = 0;
            while (i2 < allowedKeywords.length) {
                if (cleanSQL.startsWith(allowedKeywords[i2] + " ")) {
                    isError = false;
                    break;
                }
                ++i2;
            }
            if (isError) {
                result.append("ERROR: Not Allowed Command");
                return result.toString();
            }
            ArrayList<String> header = new ArrayList<String>();
            header.add("#");
            this.model = new ListModelTable();
            Frozen frozen = new Frozen();
            frozen.setColumns(1);
            this.listbox.appendChild((Component)frozen);
            Trx trx = null;
            PreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    long start = System.currentTimeMillis();
                    String trxName = Trx.createTrxName((String)"WSQLQuery");
                    trx = Trx.get((String)trxName, (boolean)false);
                    trx.setDisplayName(this.getClass().getName() + "_processStatement");
                    trx.getConnection().setReadOnly(true);
                    pstmt = DB.prepareNormalReadReplicaStatement((String)sql, (String)trxName);
                    pstmt.setQueryTimeout(timeout);
                    rs = pstmt.executeQuery();
                    ResultSetMetaData meta = rs.getMetaData();
                    int count = 0;
                    int col = 1;
                    while (col <= meta.getColumnCount()) {
                        String columnName = meta.getColumnLabel(col);
                        header.add(columnName);
                        ++col;
                    }
                    while (rs.next()) {
                        if (count >= maxRecords) {
                            result.append("Maximum of " + maxRecords + " records reached.  ");
                            break;
                        }
                        ArrayList<Object> row = new ArrayList<Object>();
                        row.add(++count);
                        int col2 = 1;
                        while (col2 <= meta.getColumnCount()) {
                            String colName = ((String)header.get(col2)).toLowerCase();
                            if (rs.getObject(col2) instanceof BigDecimal && (colName.endsWith("_id") || colName.equals("createdby") || colName.equals("updatedby"))) {
                                row.add(rs.getInt(col2));
                            } else {
                                row.add(rs.getObject(col2));
                            }
                            ++col2;
                        }
                        this.model.add(row);
                    }
                    long end = System.currentTimeMillis();
                    BigDecimal durationSeconds = BigDecimal.valueOf(end).subtract(BigDecimal.valueOf(start)).divide(BigDecimal.valueOf(1000.0));
                    result.append("Count = ").append(count);
                    if (MSysConfig.getBooleanValue((String)"FORM_SQL_QUERY_LOG_ISSUE", (boolean)true)) {
                        MIssue issue = new MIssue(Env.getCtx(), 0, null);
                        issue.setIssueSummary("SQL executed on SQL Query form");
                        issue.setStackTrace(sql);
                        issue.setResponseText(result.toString());
                        issue.setIssueSource("X");
                        issue.setUserName(Env.getContext((Properties)Env.getCtx(), (String)"#AD_User_Name"));
                        issue.setAD_Form_ID(200018);
                        issue.setProcessed(true);
                        issue.setComments("Duration : " + String.valueOf(durationSeconds) + " seconds");
                        issue.saveEx();
                    }
                    WListItemRenderer renderer = new WListItemRenderer(header);
                    this.model.setNoColumns(header.size());
                    this.listbox.setModel((ListModel<?>)this.model);
                    this.listbox.setItemRenderer(renderer);
                    this.listbox.initialiseHeader();
                    this.listbox.setSizedByContent(true);
                }
                catch (Exception e) {
                    if (trx != null) {
                        trx.rollback();
                    }
                    if (DBException.isTimeout((Exception)e)) {
                        result.append("Maximum of " + timeout + " seconds reached, query cancelled.");
                    } else {
                        e.printStackTrace();
                        String exception = e.toString();
                        log.log(Level.SEVERE, "process statement: " + sql + " - " + exception);
                        result.append("Exception => ").append(exception);
                    }
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    if (trx != null) {
                        trx.close();
                        trx = null;
                    }
                    break block27;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                if (trx != null) {
                    trx.close();
                    trx = null;
                }
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
            if (trx != null) {
                trx.close();
                trx = null;
            }
        }
        return result.toString();
    }

    @Override
    public void onEvent(Event event) throws Exception {
        if (event.getTarget() == this.m_btnSql) {
            this.m_txbResultField.setText(this.processStatement(this.m_txbSqlField.getText()));
        }
        super.onEvent(event);
    }
}

