/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.apps;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Properties;
import org.adempiere.webui.LayoutUtils;
import org.adempiere.webui.apps.AEnv;
import org.adempiere.webui.component.Label;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.compiere.model.MColumn;
import org.compiere.model.MLookup;
import org.compiere.model.MLookupFactory;
import org.compiere.model.MLookupInfo;
import org.compiere.model.MQuery;
import org.compiere.model.MRole;
import org.compiere.model.MSearchDefinition;
import org.compiere.model.MSysConfig;
import org.compiere.model.MTable;
import org.compiere.model.MWindow;
import org.compiere.model.Query;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Language;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zul.A;
import org.zkoss.zul.Textbox;
import org.zkoss.zul.Vlayout;

public class DocumentSearchController
implements EventListener<Event> {
    private static final String MESSAGE_LABEL_STYLE = "color: rgba(0,0,0,0.34)";
    private static final String SEARCH_RESULT = "search.result";
    private static final String ON_SEARCH_DOCUMENTS_EVENT = "onSearchDocuments";
    private int MAX_RESULTS_PER_SEARCH_IN_DOCUMENT_CONTROLLER = MSysConfig.getIntValue((String)"MAX_RESULTS_PER_SEARCH_IN_DOCUMENT_CONTROLLER", (int)3, (int)Env.getAD_Client_ID((Properties)Env.getCtx()));
    private Vlayout layout;
    private ArrayList<SearchResult> list;
    private int selected = -1;
    private boolean showingGuide = false;

    public void create(Component parent) {
        this.layout = new Vlayout();
        this.layout.setStyle("padding: 3px; overflow:auto;");
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.layout, "100%");
        ZKUpdateUtil.setVflex((HtmlBasedComponent)this.layout, "true");
        parent.appendChild((Component)this.layout);
        this.layout.addEventListener(ON_SEARCH_DOCUMENTS_EVENT, (EventListener)this);
    }

    public void search(String value) {
        if (Util.isEmpty((String)value) || value.startsWith("/") && value.indexOf(" ") < 0) {
            if (!this.showingGuide) {
                this.layout.getChildren().clear();
            }
        } else {
            this.layout.getChildren().clear();
        }
        Events.echoEvent((String)ON_SEARCH_DOCUMENTS_EVENT, (Component)this.layout, (String)value);
    }

    private void onSearchDocuments(String searchString) {
        this.list = new ArrayList();
        if (Util.isEmpty((String)searchString) || searchString.startsWith("/") && searchString.indexOf(" ") < 0) {
            if (!this.showingGuide) {
                Query query = new Query(Env.getCtx(), "AD_SearchDefinition", "TransactionCode IS NOT NULL", null);
                List definitions = query.setOnlyActiveRecords(true).setOrderBy("TransactionCode").list();
                for (MSearchDefinition definition : definitions) {
                    Label label = new Label("/" + definition.getTransactionCode() + " " + definition.getName());
                    label.setStyle(MESSAGE_LABEL_STYLE);
                    this.layout.appendChild((Component)label);
                }
                this.showingGuide = true;
            }
            return;
        }
        this.showingGuide = false;
        List<SearchResult> list = this.doSearch(searchString);
        if (list.size() == 1 && list.get(0).getRecordId() == -1) {
            Label label = new Label(list.get(0).getLabel());
            label.setStyle(MESSAGE_LABEL_STYLE);
            this.layout.appendChild((Component)label);
        } else if (list.size() > 0) {
            Collections.sort(list, new Comparator<SearchResult>(){

                @Override
                public int compare(SearchResult o1, SearchResult o2) {
                    int r = o1.getWindowName().compareTo(o2.getWindowName());
                    if (r == 0) {
                        r = o1.getLabel().compareTo(o2.getLabel());
                    }
                    return r;
                }
            });
            String matchString = searchString.toLowerCase();
            if (searchString != null && searchString.startsWith("/") && searchString.indexOf(" ") > 1) {
                matchString = searchString.substring(searchString.indexOf(" ") + 1).toLowerCase();
            }
            String windowName = null;
            for (SearchResult result : list) {
                if (windowName == null || !windowName.equals(result.getWindowName())) {
                    windowName = result.getWindowName();
                    Label label = new Label(windowName);
                    LayoutUtils.addSclass("window-name", (HtmlBasedComponent)label);
                    this.layout.appendChild((Component)label);
                }
                A a2 = new A();
                a2.setAttribute(SEARCH_RESULT, (Object)result);
                this.layout.appendChild((Component)a2);
                LayoutUtils.addSclass("search-result", (HtmlBasedComponent)a2);
                a2.addEventListener("onClick", (EventListener)this);
                String label = result.getLabel();
                if (!Util.isEmpty((String)matchString, (boolean)true)) {
                    int match = label.toLowerCase().indexOf(matchString);
                    while (match >= 0) {
                        if (match > 0) {
                            a2.appendChild((Component)new Label(label.substring(0, match)));
                            l = new Label(label.substring(match, match + matchString.length()));
                            LayoutUtils.addSclass("highlight", (HtmlBasedComponent)l);
                            a2.appendChild((Component)l);
                            label = label.substring(match + matchString.length());
                        } else {
                            l = new Label(label.substring(0, matchString.length()));
                            LayoutUtils.addSclass("highlight", (HtmlBasedComponent)l);
                            a2.appendChild((Component)l);
                            label = label.substring(matchString.length());
                        }
                        match = label.toLowerCase().indexOf(matchString);
                    }
                }
                if (label.length() <= 0) continue;
                a2.appendChild((Component)new Label(label));
            }
            this.layout.invalidate();
        }
    }

    private List<SearchResult> doSearch(String searchString) {
        MRole role = MRole.get((Properties)Env.getCtx(), (int)Env.getAD_Role_ID((Properties)Env.getCtx()), (int)Env.getAD_User_ID((Properties)Env.getCtx()), (boolean)true);
        this.selected = -1;
        StringBuilder whereClause = new StringBuilder();
        String transactionCode = null;
        if (searchString != null && searchString.startsWith("/") && searchString.indexOf(" ") > 1) {
            transactionCode = searchString.substring(1, searchString.indexOf(" "));
            searchString = searchString.substring(searchString.indexOf(" ") + 1);
            whereClause.append("Upper(TransactionCode) = ?");
        } else {
            whereClause.append("TransactionCode IS NULL");
        }
        Query query = new Query(Env.getCtx(), "AD_SearchDefinition", whereClause.toString(), null);
        if (transactionCode != null) {
            query.setParameters(new Object[]{transactionCode.toUpperCase()});
        }
        List definitions = query.setOnlyActiveRecords(true).list();
        for (MSearchDefinition msd : definitions) {
            ArrayList<Object> params;
            MWindow powindow;
            MWindow window;
            StringBuilder sql;
            MTable table2;
            block21: {
                block19: {
                    block20: {
                        table2 = new MTable(Env.getCtx(), msd.getAD_Table_ID(), null);
                        sql = null;
                        window = msd.getAD_Window_ID() > 0 && role.getWindowAccess(msd.getAD_Window_ID()) != null ? MWindow.get((Properties)Env.getCtx(), (int)msd.getAD_Window_ID()) : null;
                        MWindow mWindow = powindow = msd.getPO_Window_ID() > 0 && role.getWindowAccess(msd.getPO_Window_ID()) != null ? MWindow.get((Properties)Env.getCtx(), (int)msd.getPO_Window_ID()) : null;
                        if (window == null && powindow == null) continue;
                        params = new ArrayList<Object>();
                        if (!msd.getSearchType().equals("T")) break block19;
                        MColumn column = MColumn.get((Properties)Env.getCtx(), (int)msd.getAD_Column_ID());
                        sql = new StringBuilder("SELECT ").append(table2.getTableName()).append("_ID, ").append(column.getColumnName());
                        sql.append(" FROM ").append(table2.getTableName()).append(" ");
                        if (msd.getDataType().equals("I")) {
                            sql.append("WHERE ").append(column.getColumnName()).append("=?");
                        } else {
                            sql.append("WHERE UPPER(").append(column.getColumnName()).append(") LIKE UPPER(?)");
                        }
                        sql.append(" AND AD_Client_ID=@#AD_Client_ID@  ");
                        if (!msd.getDataType().equals("I")) break block20;
                        params.add(Integer.valueOf(searchString.replaceAll("\\D", "")));
                        break block21;
                    }
                    if (!msd.getDataType().equals("S")) break block21;
                    if (searchString.endsWith("%")) {
                        params.add(searchString);
                    } else {
                        params.add(searchString + "%");
                    }
                    break block21;
                }
                if (msd.getSearchType().equals("Q")) {
                    sql = new StringBuilder().append(msd.getQuery());
                    int count = 1;
                    char[] cArray = sql.toString().toCharArray();
                    int n = cArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        char c = cArray[n2];
                        if (c == '?') {
                            ++count;
                        }
                        ++n2;
                    }
                    int i = 1;
                    while (i < count) {
                        if (msd.getDataType().equals("I")) {
                            params.add(Integer.valueOf(searchString.replaceAll("\\D", "")));
                        } else if (msd.getDataType().equals("S")) {
                            if (searchString.endsWith("%")) {
                                params.add(searchString);
                            } else {
                                params.add(searchString + "%");
                            }
                        }
                        ++i;
                    }
                }
            }
            MLookupInfo lookupInfo = MLookupFactory.getLookupInfo((Properties)Env.getCtx(), (int)-1, (int)-1, (int)30, (Language)Env.getLanguage((Properties)Env.getCtx()), (String)(table2.getTableName() + "_ID"), (int)0, (boolean)false, null);
            MLookup lookup = new MLookup(lookupInfo, -1);
            if (sql == null) continue;
            if (powindow != null) {
                if (window != null) {
                    this.doRetrieval(msd, sql, params, lookup, window, table2.getTableName(), " AND IsSOTrx='Y' ", this.list);
                }
                this.doRetrieval(msd, sql, params, lookup, powindow, table2.getTableName(), " AND IsSOTrx='N' ", this.list);
                continue;
            }
            if (window == null) continue;
            this.doRetrieval(msd, sql, params, lookup, window, table2.getTableName(), null, this.list);
        }
        return this.list;
    }

    private void doRetrieval(MSearchDefinition msd, StringBuilder builder, List<Object> params, MLookup lookup, MWindow window, String tableName, String extraWhereClase, List<SearchResult> list) {
        block13: {
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    boolean hasFullTextOperator;
                    Object sql = builder.toString();
                    if (!Util.isEmpty((String)extraWhereClase)) {
                        sql = (String)sql + extraWhereClase;
                    }
                    boolean bl = hasFullTextOperator = ((String)sql).indexOf("@@") >= 0;
                    if (hasFullTextOperator) {
                        sql = ((String)sql).replace("@@", "~!#$*");
                    }
                    sql = Env.parseContext((Properties)Env.getCtx(), (int)-1, (String)sql, (boolean)false, (boolean)true);
                    if (hasFullTextOperator) {
                        sql = ((String)sql).replace("~!#$*", "@@");
                    }
                    pstmt = DB.prepareStatement((String)sql, null);
                    if (params.size() > 0) {
                        DB.setParameters((PreparedStatement)pstmt, params);
                    }
                    pstmt.setQueryTimeout(1);
                    rs = pstmt.executeQuery();
                    int count = 0;
                    while (rs.next() && count < this.MAX_RESULTS_PER_SEARCH_IN_DOCUMENT_CONTROLLER) {
                        ++count;
                        int id = rs.getInt(1);
                        SearchResult result = new SearchResult();
                        result.setLabel(lookup.getDisplay((Object)id));
                        result.setRecordId(id);
                        result.setWindowName(window.get_Translation("Name"));
                        result.setWindowId(window.getAD_Window_ID());
                        result.setTableName(tableName);
                        if (rs.getMetaData().getColumnCount() > 1) {
                            result.setName(rs.getString(2));
                        }
                        list.add(result);
                    }
                }
                catch (SQLException e) {
                    SearchResult result = new SearchResult();
                    result.setRecordId(-1);
                    if (DB.getDatabase().isQueryTimeout(e)) {
                        result.setLabel(Msg.getMsg((Properties)Env.getCtx(), (String)"Timeout"));
                    } else {
                        result.setLabel(Msg.getMsg((Properties)Env.getCtx(), (String)"DBExecuteError"));
                        e.printStackTrace();
                    }
                    list.add(result);
                    DB.close(rs, pstmt);
                    break block13;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
        }
    }

    public void onEvent(Event event) throws Exception {
        if ("onClick".equals(event.getName())) {
            if (event.getTarget() instanceof A) {
                SearchResult result = (SearchResult)event.getTarget().getAttribute(SEARCH_RESULT);
                this.doZoom(result);
            }
        } else if (event.getName().equals(ON_SEARCH_DOCUMENTS_EVENT)) {
            this.onSearchDocuments((String)event.getData());
        }
    }

    private void doZoom(SearchResult result) {
        MQuery query = new MQuery();
        query.addRestriction(result.getTableName() + "_ID", "=", result.getRecordId());
        AEnv.zoom(result.getWindowId(), query);
    }

    public boolean onOk(Textbox textbox) {
        String text = textbox.getText();
        if (Util.isEmpty((String)text)) {
            return false;
        }
        text = text.toLowerCase();
        int size = this.layout.getChildren().size();
        A firstStart = null;
        A exact = null;
        int i = 0;
        while (i < size) {
            if (this.layout.getChildren().get(i) instanceof A) {
                A a2 = (A)this.layout.getChildren().get(i);
                SearchResult result = (SearchResult)a2.getAttribute(SEARCH_RESULT);
                if (result.getLabel().equalsIgnoreCase(text)) {
                    exact = a2;
                    break;
                }
                if (text.equalsIgnoreCase(result.getName())) {
                    exact = a2;
                    break;
                }
                if (firstStart == null && result.getLabel().toLowerCase().startsWith(text) && text.length() >= 3) {
                    firstStart = a2;
                }
            }
            ++i;
        }
        SearchResult result = null;
        if (exact != null) {
            result = (SearchResult)exact.getAttribute(SEARCH_RESULT);
        } else if (firstStart != null) {
            result = (SearchResult)firstStart.getAttribute(SEARCH_RESULT);
        }
        if (result != null) {
            this.doZoom(result);
            return true;
        }
        return false;
    }

    public SearchResult selectPrior() {
        if (this.selected > 0) {
            --this.selected;
            SearchResult result = this.list.get(this.selected);
            List links = this.layout.getChildren();
            for (Component link : links) {
                if (!(link instanceof A)) continue;
                A a2 = (A)link;
                if (result.getLabel().equals(a2.getLabel())) {
                    a2.setSclass("document-search-current-link");
                    continue;
                }
                if (!"document-search-current-link".equals(a2.getSclass())) continue;
                a2.setSclass(null);
            }
            return result;
        }
        return null;
    }

    public SearchResult selectNext() {
        if (this.selected < this.list.size() - 1) {
            ++this.selected;
            SearchResult result = this.list.get(this.selected);
            List links = this.layout.getChildren();
            for (Component link : links) {
                if (!(link instanceof A)) continue;
                A a2 = (A)link;
                if (result.getLabel().equals(a2.getLabel())) {
                    a2.setSclass("document-search-current-link");
                    continue;
                }
                if (!"document-search-current-link".equals(a2.getSclass())) continue;
                a2.setSclass(null);
            }
            return result;
        }
        return null;
    }

    public static class SearchResult {
        private String windowName;
        private int windowId;
        private String tableName;
        private int recordId;
        private String label;
        private String name;

        public int getWindowId() {
            return this.windowId;
        }

        public void setWindowId(int windowId) {
            this.windowId = windowId;
        }

        public String getTableName() {
            return this.tableName;
        }

        public void setTableName(String tableName) {
            this.tableName = tableName;
        }

        public String getWindowName() {
            return this.windowName;
        }

        public void setWindowName(String windowName) {
            this.windowName = windowName;
        }

        public int getRecordId() {
            return this.recordId;
        }

        public void setRecordId(int recordId) {
            this.recordId = recordId;
        }

        public String getLabel() {
            return this.label;
        }

        public void setLabel(String label) {
            this.label = label;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }
}

