/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.eclipse.equinox.http.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Map;
import java.util.Set;
import javax.servlet.Filter;
import javax.servlet.FilterRegistration;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRegistration;
import javax.servlet.SessionCookieConfig;
import javax.servlet.SessionTrackingMode;
import javax.servlet.descriptor.JspConfigDescriptor;
import org.adempiere.eclipse.equinox.http.servlet.ProxyContext;
import org.adempiere.eclipse.equinox.http.servlet.RequestDispatcherAdaptor;
import org.osgi.service.http.HttpContext;

public class ServletContextAdaptor
implements ServletContext {
    private ServletContext servletContext;
    HttpContext httpContext;
    private ProxyContext proxyContext;

    public ServletContextAdaptor(ProxyContext proxyContext, ServletContext servletContext, HttpContext httpContext) {
        this.servletContext = servletContext;
        this.httpContext = httpContext;
        this.proxyContext = proxyContext;
    }

    public Set<String> getResourcePaths(String name) {
        if (name == null || !name.startsWith("/")) {
            return null;
        }
        try {
            Method getResourcePathsMethod = this.httpContext.getClass().getMethod("getResourcePaths", String.class);
            if (!getResourcePathsMethod.canAccess(this.httpContext)) {
                getResourcePathsMethod.setAccessible(true);
            }
            return (Set)getResourcePathsMethod.invoke((Object)this.httpContext, name);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Object getAttribute(String attributeName) {
        Dictionary<String, Object> attributes = this.proxyContext.getContextAttributes(this.httpContext);
        return attributes.get(attributeName);
    }

    public Enumeration<String> getAttributeNames() {
        Dictionary<String, Object> attributes = this.proxyContext.getContextAttributes(this.httpContext);
        return attributes.keys();
    }

    public void setAttribute(String attributeName, Object attributeValue) {
        Dictionary<String, Object> attributes = this.proxyContext.getContextAttributes(this.httpContext);
        attributes.put(attributeName, attributeValue);
    }

    public void removeAttribute(String attributeName) {
        Dictionary<String, Object> attributes = this.proxyContext.getContextAttributes(this.httpContext);
        attributes.remove(attributeName);
    }

    public String getMimeType(String name) {
        String mimeType = this.httpContext.getMimeType(name);
        return mimeType != null ? mimeType : this.servletContext.getMimeType(name);
    }

    public URL getResource(String name) {
        return this.httpContext.getResource(name);
    }

    public InputStream getResourceAsStream(String name) {
        URL url = this.getResource(name);
        if (url != null) {
            try {
                return url.openStream();
            }
            catch (IOException e) {
                this.log("Error opening stream for resource '" + name + "'", e);
            }
        }
        return null;
    }

    public ServletContext getContext(String arg0) {
        return this.servletContext.getContext(arg0);
    }

    public String getInitParameter(String arg0) {
        return this.servletContext.getInitParameter(arg0);
    }

    public Enumeration<String> getInitParameterNames() {
        return this.servletContext.getInitParameterNames();
    }

    public int getMajorVersion() {
        return this.servletContext.getMajorVersion();
    }

    public int getMinorVersion() {
        return this.servletContext.getMinorVersion();
    }

    public RequestDispatcher getNamedDispatcher(String arg0) {
        return new RequestDispatcherAdaptor(this.servletContext.getNamedDispatcher(arg0));
    }

    public String getRealPath(String arg0) {
        return this.servletContext.getRealPath(arg0);
    }

    public RequestDispatcher getRequestDispatcher(String arg0) {
        return new RequestDispatcherAdaptor(this.servletContext.getRequestDispatcher(this.proxyContext.getServletPath() + arg0));
    }

    public String getServerInfo() {
        return this.servletContext.getServerInfo();
    }

    public Servlet getServlet(String arg0) throws ServletException {
        return this.servletContext.getServlet(arg0);
    }

    public String getServletContextName() {
        return this.servletContext.getServletContextName();
    }

    public Enumeration<String> getServletNames() {
        return this.servletContext.getServletNames();
    }

    public Enumeration<Servlet> getServlets() {
        return this.servletContext.getServlets();
    }

    public void log(Exception arg0, String arg1) {
        this.servletContext.log(arg0, arg1);
    }

    public void log(String arg0, Throwable arg1) {
        this.servletContext.log(arg0, arg1);
    }

    public void log(String arg0) {
        this.servletContext.log(arg0);
    }

    public String getContextPath() {
        try {
            Method getContextPathMethod = this.servletContext.getClass().getMethod("getContextPath", null);
            return (String)getContextPathMethod.invoke((Object)this.servletContext, null) + this.proxyContext.getServletPath();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public FilterRegistration.Dynamic addFilter(String arg0, String arg1) {
        return this.servletContext.addFilter(arg0, arg1);
    }

    public FilterRegistration.Dynamic addFilter(String arg0, Filter arg1) {
        return this.servletContext.addFilter(arg0, arg1);
    }

    public FilterRegistration.Dynamic addFilter(String arg0, Class<? extends Filter> arg1) {
        return this.servletContext.addFilter(arg0, arg1);
    }

    public void addListener(String arg0) {
        this.servletContext.addListener(arg0);
    }

    public void addListener(EventListener arg0) {
        this.servletContext.addListener(arg0);
    }

    public void addListener(Class<? extends EventListener> arg0) {
        this.servletContext.addListener(arg0);
    }

    public ServletRegistration.Dynamic addServlet(String arg0, String arg1) {
        return this.servletContext.addServlet(arg0, arg1);
    }

    public ServletRegistration.Dynamic addServlet(String arg0, Servlet arg1) {
        return this.servletContext.addServlet(arg0, arg1);
    }

    public ServletRegistration.Dynamic addServlet(String arg0, Class<? extends Servlet> arg1) {
        return this.servletContext.addServlet(arg0, arg1);
    }

    public <T extends Filter> T createFilter(Class<T> arg0) throws ServletException {
        return (T)this.servletContext.createFilter(arg0);
    }

    public <T extends EventListener> T createListener(Class<T> arg0) throws ServletException {
        return (T)this.servletContext.createListener(arg0);
    }

    public <T extends Servlet> T createServlet(Class<T> arg0) throws ServletException {
        return (T)this.servletContext.createServlet(arg0);
    }

    public void declareRoles(String ... arg0) {
        this.servletContext.declareRoles(arg0);
    }

    public ClassLoader getClassLoader() {
        return this.servletContext.getClassLoader();
    }

    public Set<SessionTrackingMode> getDefaultSessionTrackingModes() {
        return this.servletContext.getDefaultSessionTrackingModes();
    }

    public int getEffectiveMajorVersion() {
        return this.servletContext.getEffectiveMajorVersion();
    }

    public int getEffectiveMinorVersion() {
        return this.servletContext.getEffectiveMinorVersion();
    }

    public Set<SessionTrackingMode> getEffectiveSessionTrackingModes() {
        return this.servletContext.getEffectiveSessionTrackingModes();
    }

    public FilterRegistration getFilterRegistration(String arg0) {
        return this.servletContext.getFilterRegistration(arg0);
    }

    public Map<String, ? extends FilterRegistration> getFilterRegistrations() {
        return this.servletContext.getFilterRegistrations();
    }

    public JspConfigDescriptor getJspConfigDescriptor() {
        return this.servletContext.getJspConfigDescriptor();
    }

    public ServletRegistration getServletRegistration(String arg0) {
        return this.servletContext.getServletRegistration(arg0);
    }

    public Map<String, ? extends ServletRegistration> getServletRegistrations() {
        return this.servletContext.getServletRegistrations();
    }

    public SessionCookieConfig getSessionCookieConfig() {
        return this.servletContext.getSessionCookieConfig();
    }

    public boolean setInitParameter(String arg0, String arg1) {
        return this.servletContext.setInitParameter(arg0, arg1);
    }

    public void setSessionTrackingModes(Set<SessionTrackingMode> arg0) {
        this.servletContext.setSessionTrackingModes(arg0);
    }

    public String getVirtualServerName() {
        return this.servletContext.getVirtualServerName();
    }

    public ServletRegistration.Dynamic addJspFile(String servletName, String jspFile) {
        return this.servletContext.addJspFile(servletName, jspFile);
    }

    public int getSessionTimeout() {
        return this.servletContext.getSessionTimeout();
    }

    public void setSessionTimeout(int sessionTimeout) {
        this.servletContext.setSessionTimeout(sessionTimeout);
    }

    public String getRequestCharacterEncoding() {
        return this.servletContext.getRequestCharacterEncoding();
    }

    public void setRequestCharacterEncoding(String encoding) {
        this.servletContext.setRequestCharacterEncoding(encoding);
    }

    public String getResponseCharacterEncoding() {
        return this.servletContext.getResponseCharacterEncoding();
    }

    public void setResponseCharacterEncoding(String encoding) {
        this.servletContext.setResponseCharacterEncoding(encoding);
    }
}

