/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.eclipse.equinox.http.servlet;

import java.util.Dictionary;
import java.util.Hashtable;
import org.adempiere.eclipse.equinox.http.servlet.HttpServiceProxyFactory;
import org.adempiere.eclipse.equinox.http.servlet.ProxyServlet;
import org.eclipse.equinox.http.servlet.ExtendedHttpService;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.http.HttpService;

public class Activator
implements BundleActivator {
    private static final String DEFAULT_SERVICE_DESCRIPTION = "Equinox Servlet Bridge";
    private static final String DEFAULT_SERVICE_VENDOR = "Eclipse.org";
    private static final String[] HTTP_SERVICES_CLASSES = new String[]{HttpService.class.getName(), ExtendedHttpService.class.getName()};
    private static BundleContext context;
    private static ServiceRegistration<?> serviceRegistration;

    public void start(BundleContext bundleContext) throws Exception {
        context = bundleContext;
        serviceRegistration = Activator.startHttpServiceProxy(bundleContext);
    }

    public void stop(BundleContext bundleContext) throws Exception {
        Activator.stopHttpServiceProxy(bundleContext);
        context = null;
    }

    private static synchronized ServiceRegistration<?> startHttpServiceProxy(BundleContext bundleContext) {
        HttpServiceProxyFactory factory = new HttpServiceProxyFactory();
        Hashtable<String, String> serviceProperties = new Hashtable<String, String>(2);
        if (((Dictionary)serviceProperties).get("service.vendor") == null) {
            ((Dictionary)serviceProperties).put("service.vendor", DEFAULT_SERVICE_VENDOR);
        }
        if (((Dictionary)serviceProperties).get("service.description") == null) {
            ((Dictionary)serviceProperties).put("service.description", DEFAULT_SERVICE_DESCRIPTION);
        }
        return context.registerService(HTTP_SERVICES_CLASSES, (Object)factory, serviceProperties);
    }

    private static synchronized void stopHttpServiceProxy(BundleContext bundleContext) {
        serviceRegistration.unregister();
    }

    static synchronized void addProxyServlet(ProxyServlet proxyServlet) {
        HttpServiceProxyFactory.registerServletDelegate(proxyServlet.getHttpContext(), proxyServlet);
    }

    static synchronized void removeProxyServlet(ProxyServlet proxyServlet) {
        HttpServiceProxyFactory.unregisterServletDelegate(proxyServlet);
    }
}

