/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.stream.Collectors;
import org.adempiere.base.annotation.Parameter;
import org.adempiere.base.annotation.Process;
import org.adempiere.base.event.EventManager;
import org.adempiere.base.event.EventProperty;
import org.adempiere.util.IProcessUI;
import org.compiere.model.MPInstance;
import org.compiere.model.PO;
import org.compiere.process.ProcessCall;
import org.compiere.process.ProcessInfo;
import org.compiere.process.ProcessInfoLog;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.ProcessInfoUtil;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Trx;
import org.compiere.util.TrxEventListener;
import org.osgi.service.event.Event;

@Process
public abstract class SvrProcess
implements ProcessCall {
    public static final String PROCESS_INFO_CTX_KEY = "ProcessInfo";
    public static final String PROCESS_UI_CTX_KEY = "ProcessUI";
    private List<ProcessInfoLog> listEntryLog;
    private Properties m_ctx;
    private ProcessInfo m_pi;
    protected CLogger log = CLogger.getCLogger(this.getClass());
    private boolean m_locked = false;
    private PO m_lockedObject = null;
    private Trx m_trx;
    protected IProcessUI processUI;
    protected static String MSG_SaveErrorRowNotFound = "@SaveErrorRowNotFound@";
    protected static String MSG_InvalidArguments = "@InvalidArguments@";

    public void addBufferLog(int id, Timestamp date, BigDecimal number, String msg, int tableId, int recordId) {
        ProcessInfoLog entryLog = new ProcessInfoLog(id, date, number, msg, tableId, recordId);
        if (this.listEntryLog == null) {
            this.listEntryLog = new ArrayList<ProcessInfoLog>();
        }
        this.listEntryLog.add(entryLog);
    }

    @Override
    public final boolean startProcess(Properties ctx, ProcessInfo pi, Trx trx) {
        boolean localTrx;
        this.m_ctx = ctx == null ? Env.getCtx() : ctx;
        this.m_pi = pi;
        this.m_trx = trx;
        boolean bl = localTrx = this.m_trx == null;
        if (localTrx) {
            this.m_trx = Trx.get(Trx.createTrxName("SvrProcess"), true);
            this.m_trx.setDisplayName(this.getClass().getName() + "_startProcess");
        }
        this.m_pi.setTransactionName(this.m_trx.getTrxName());
        this.m_pi.setProcessUI(this.processUI);
        ClassLoader contextLoader = Thread.currentThread().getContextClassLoader();
        ClassLoader processLoader = this.getClass().getClassLoader();
        try {
            if (processLoader != contextLoader) {
                Thread.currentThread().setContextClassLoader(processLoader);
            }
            this.lock();
            boolean success = false;
            try {
                this.m_ctx.put(PROCESS_INFO_CTX_KEY, this.m_pi);
                if (this.processUI != null) {
                    this.m_ctx.put(PROCESS_UI_CTX_KEY, this.processUI);
                }
                success = this.process();
            }
            catch (Throwable throwable) {
                this.m_ctx.remove(PROCESS_INFO_CTX_KEY);
                this.m_ctx.remove(PROCESS_UI_CTX_KEY);
                if (localTrx) {
                    if (success) {
                        try {
                            this.m_trx.commit(true);
                        }
                        catch (Exception e) {
                            this.log.log(Level.SEVERE, "Commit failed.", e);
                            this.m_pi.addSummary("Commit Failed.");
                            this.m_pi.setError(true);
                        }
                    } else {
                        this.m_trx.rollback();
                    }
                    this.m_trx.close();
                    this.m_trx = null;
                    this.m_pi.setTransactionName(null);
                    this.unlock();
                    this.postProcess(!this.m_pi.isError());
                    this.sendProcessEvent("idempiere/postProcess");
                } else {
                    this.m_trx.addTrxEventListener(new TrxEventListener(){

                        @Override
                        public void afterRollback(Trx trx, boolean success) {
                        }

                        @Override
                        public void afterCommit(Trx trx, boolean success) {
                        }

                        @Override
                        public void afterClose(Trx trx) {
                            SvrProcess.this.unlock();
                            SvrProcess.this.m_trx = null;
                            SvrProcess.this.postProcess(!SvrProcess.this.m_pi.isError());
                            SvrProcess.this.sendProcessEvent("idempiere/postProcess");
                        }
                    });
                }
                Thread.currentThread().setContextClassLoader(contextLoader);
                throw throwable;
            }
            this.m_ctx.remove(PROCESS_INFO_CTX_KEY);
            this.m_ctx.remove(PROCESS_UI_CTX_KEY);
            if (localTrx) {
                if (success) {
                    try {
                        this.m_trx.commit(true);
                    }
                    catch (Exception e) {
                        this.log.log(Level.SEVERE, "Commit failed.", e);
                        this.m_pi.addSummary("Commit Failed.");
                        this.m_pi.setError(true);
                    }
                } else {
                    this.m_trx.rollback();
                }
                this.m_trx.close();
                this.m_trx = null;
                this.m_pi.setTransactionName(null);
                this.unlock();
                this.postProcess(!this.m_pi.isError());
                this.sendProcessEvent("idempiere/postProcess");
            } else {
                this.m_trx.addTrxEventListener(new /* invalid duplicate definition of identical inner class */);
            }
            Thread.currentThread().setContextClassLoader(contextLoader);
        }
        finally {
            if (processLoader != contextLoader) {
                Thread.currentThread().setContextClassLoader(contextLoader);
            }
        }
        return !this.m_pi.isError();
    }

    private boolean process() {
        Object msg = null;
        boolean success = true;
        try {
            this.autoFillParameters();
            this.prepare();
            Event eventBP = this.sendProcessEvent("idempiere/beforeProcess");
            List errorsBP = (List)eventBP.getProperty("event.errorMessages");
            if (errorsBP != null && !errorsBP.isEmpty()) {
                msg = "@Error@:" + (String)errorsBP.get(0);
            } else {
                Event eventAP;
                List errorsAP;
                msg = this.doIt();
                if (msg != null && !((String)msg).startsWith("@Error@") && (errorsAP = (List)(eventAP = this.sendProcessEvent("idempiere/afterProcess")).getProperty("event.errorMessages")) != null && !errorsAP.isEmpty()) {
                    msg = "@Error@:" + (String)errorsAP.get(0);
                }
            }
        }
        catch (Throwable e) {
            msg = e.getLocalizedMessage();
            if (msg == null) {
                msg = e.toString();
            }
            if (e.getCause() != null) {
                this.log.log(Level.SEVERE, Msg.parseTranslation(this.getCtx(), (String)msg), e.getCause());
            } else {
                this.log.log(Level.SEVERE, Msg.parseTranslation(this.getCtx(), (String)msg), e);
            }
            success = false;
        }
        if (msg != null && ((String)msg).startsWith("@Error@")) {
            success = false;
        }
        if (success) {
            this.m_trx.getConnection();
            this.m_trx.addTrxEventListener(new TrxEventListener(){

                @Override
                public void afterRollback(Trx trx, boolean success) {
                }

                @Override
                public void afterCommit(Trx trx, boolean success) {
                    if (success) {
                        SvrProcess.this.flushBufferLog();
                    }
                }

                @Override
                public void afterClose(Trx trx) {
                }
            });
        }
        msg = Msg.parseTranslation(this.m_ctx, (String)msg);
        this.m_pi.setSummary((String)msg, !success);
        return success;
    }

    private Event sendProcessEvent(String topic) {
        Event event = EventManager.newEvent(topic, new EventProperty("event.data", this.m_pi), new EventProperty("processUUID", this.m_pi.getAD_Process_UU()), new EventProperty("className", this.m_pi.getClassName()), new EventProperty("processClassName", this.getClass().getName()));
        EventManager.getInstance().sendEvent(event);
        return event;
    }

    protected abstract void prepare();

    protected abstract String doIt() throws Exception;

    protected void postProcess(boolean success) {
    }

    protected void commit() {
        if (this.m_trx != null) {
            this.m_trx.commit();
        }
    }

    protected void commitEx() throws SQLException {
        if (this.m_trx != null) {
            this.m_trx.commit(true);
        }
    }

    protected void rollback() {
        if (this.m_trx != null) {
            this.m_trx.rollback();
        }
    }

    protected boolean lockObject(PO po) {
        if (this.m_locked || this.m_lockedObject != null) {
            this.unlockObject();
        }
        if (po == null) {
            return false;
        }
        this.m_lockedObject = po;
        this.m_locked = this.m_lockedObject.lock();
        return this.m_locked;
    }

    protected boolean isLocked() {
        return this.m_locked;
    }

    protected boolean unlockObject() {
        boolean success = true;
        if (this.m_locked || this.m_lockedObject != null) {
            success = this.m_lockedObject.unlock(null);
        }
        this.m_locked = false;
        this.m_lockedObject = null;
        return success;
    }

    public ProcessInfo getProcessInfo() {
        return this.m_pi;
    }

    public Properties getCtx() {
        return this.m_ctx;
    }

    protected String getName() {
        return this.m_pi.getTitle();
    }

    protected int getAD_PInstance_ID() {
        return this.m_pi.getAD_PInstance_ID();
    }

    protected int getTable_ID() {
        return this.m_pi.getTable_ID();
    }

    protected int getRecord_ID() {
        return this.m_pi.getRecord_ID();
    }

    protected List<Integer> getRecord_IDs() {
        return this.m_pi.getRecord_IDs();
    }

    protected String getRecord_UU() {
        return this.m_pi.getRecord_UU();
    }

    protected List<String> getRecord_UUs() {
        return this.m_pi.getRecord_UUs();
    }

    protected int getAD_User_ID() {
        block8: {
            if (this.m_pi.getAD_User_ID() == null || this.m_pi.getAD_Client_ID() == null) {
                String sql = "SELECT AD_User_ID, AD_Client_ID FROM AD_PInstance WHERE AD_PInstance_ID=?";
                CPreparedStatement pstmt = null;
                ResultSet rs = null;
                try {
                    try {
                        pstmt = DB.prepareStatement(sql, this.get_TrxName());
                        pstmt.setInt(1, this.m_pi.getAD_PInstance_ID());
                        rs = pstmt.executeQuery();
                        if (rs.next()) {
                            this.m_pi.setAD_User_ID(rs.getInt(1));
                            this.m_pi.setAD_Client_ID(rs.getInt(2));
                        }
                    }
                    catch (SQLException e) {
                        this.log.log(Level.SEVERE, sql, e);
                        DB.close(rs, pstmt);
                        rs = null;
                        pstmt = null;
                        break block8;
                    }
                }
                catch (Throwable throwable) {
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    throw throwable;
                }
                DB.close(rs, pstmt);
                rs = null;
                Object var2_2 = null;
            }
        }
        if (this.m_pi.getAD_User_ID() == null) {
            return -1;
        }
        return this.m_pi.getAD_User_ID();
    }

    protected int getAD_Client_ID() {
        if (this.m_pi.getAD_Client_ID() == null) {
            this.getAD_User_ID();
            if (this.m_pi.getAD_Client_ID() == null) {
                return 0;
            }
        }
        return this.m_pi.getAD_Client_ID();
    }

    protected ProcessInfoParameter[] getParameter() {
        ProcessInfoParameter[] retValue = this.m_pi.getParameter();
        if (retValue == null) {
            ProcessInfoUtil.setParameterFromDB(this.m_pi);
            retValue = this.m_pi.getParameter();
        }
        return retValue;
    }

    public void addLog(int id, Timestamp date, BigDecimal number, String msg, int tableId, int recordId) {
        if (this.m_pi != null) {
            this.m_pi.addLog(id, date, number, msg, tableId, recordId);
        }
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(id + " - " + String.valueOf(date) + " - " + String.valueOf(number) + " - " + msg + " - " + tableId + " - " + recordId);
        }
    }

    public void addLog(int id, Timestamp date, BigDecimal number, String msg) {
        if (this.m_pi != null) {
            this.m_pi.addLog(id, date, number, msg);
        }
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(id + " - " + String.valueOf(date) + " - " + String.valueOf(number) + " - " + msg);
        }
    }

    public void addLog(String msg) {
        if (msg != null) {
            this.addLog(0, null, null, msg);
        }
    }

    private void flushBufferLog() {
        if (this.listEntryLog == null) {
            return;
        }
        for (ProcessInfoLog entryLog : this.listEntryLog) {
            if (this.m_pi != null) {
                this.m_pi.addLog(entryLog);
            }
            if (!this.log.isLoggable(Level.INFO)) continue;
            this.log.info(entryLog.getP_ID() + " - " + String.valueOf(entryLog.getP_Date()) + " - " + String.valueOf(entryLog.getP_Number()) + " - " + entryLog.getP_Msg() + " - " + entryLog.getAD_Table_ID() + " - " + entryLog.getRecord_ID());
        }
        this.listEntryLog = null;
    }

    public String saveProgress(int id, Timestamp date, BigDecimal number, String msg) {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(id + " - " + String.valueOf(date) + " - " + String.valueOf(number) + " - " + msg);
        }
        if (this.m_pi != null) {
            return this.m_pi.saveProgress(id, date, number, msg);
        }
        return "";
    }

    public String saveStatus(int id, Timestamp date, BigDecimal number, String msg) {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(id + " - " + String.valueOf(date) + " - " + String.valueOf(number) + " - " + msg);
        }
        if (this.m_pi != null) {
            return this.m_pi.saveStatus(id, date, number, msg);
        }
        return "";
    }

    public void updateProgress(String pInstanceLogUU, int id, Timestamp date, BigDecimal number, String msg) {
        if (this.m_pi != null) {
            this.m_pi.updateProgress(pInstanceLogUU, id, date, number, msg);
        }
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(pInstanceLogUU + " - " + id + " - " + String.valueOf(date) + " - " + String.valueOf(number) + " - " + msg);
        }
    }

    public Object doIt(String className, String methodName, Object[] args) {
        try {
            Class<?> clazz = Class.forName(className);
            Object object = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            Method[] methods = clazz.getMethods();
            int i2 = 0;
            while (i2 < methods.length) {
                if (methods[i2].getName().equals(methodName)) {
                    return methods[i2].invoke(object, args);
                }
                ++i2;
            }
        }
        catch (Exception ex) {
            this.log.log(Level.SEVERE, "doIt", ex);
            throw new RuntimeException(ex);
        }
        return null;
    }

    private void lock() {
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("AD_PInstance_ID=" + this.m_pi.getAD_PInstance_ID());
        }
        try {
            if (this.m_pi.getAD_PInstance_ID() > 0) {
                DB.executeUpdate("UPDATE AD_PInstance SET IsProcessing='Y' WHERE AD_PInstance_ID=" + this.m_pi.getAD_PInstance_ID(), null);
            }
        }
        catch (Exception e) {
            this.log.severe("lock() - " + e.getLocalizedMessage());
        }
    }

    private void unlock() {
        block11: {
            boolean noContext = Env.getCtx().isEmpty() && Env.getCtx().getProperty("#AD_Client_ID") == null;
            try {
                if (noContext) {
                    Env.getCtx().put("#AD_Client_ID", this.m_pi.getAD_Client_ID());
                }
                if (Thread.currentThread().isInterrupted()) {
                    Thread.interrupted();
                }
                if (this.m_pi.getAD_PInstance_ID() <= 0) break block11;
                MPInstance mpi = new MPInstance(this.getCtx(), this.m_pi.getAD_PInstance_ID(), null);
                if (mpi.get_ID() == 0) {
                    this.log.log(Level.INFO, "Did not find PInstance " + this.m_pi.getAD_PInstance_ID());
                    return;
                }
                try {
                    mpi.setIsProcessing(false);
                    mpi.setResult(!this.m_pi.isError());
                    mpi.setErrorMsg(this.m_pi.getSummary());
                    mpi.saveEx();
                    if (this.log.isLoggable(Level.FINE)) {
                        this.log.fine(mpi.toString());
                    }
                    ProcessInfoUtil.saveLogToDB(this.m_pi);
                }
                catch (Exception e) {
                    this.log.severe("unlock() - " + e.getLocalizedMessage());
                }
            }
            finally {
                if (noContext) {
                    Env.getCtx().remove("#AD_Client_ID");
                }
            }
        }
    }

    public String get_TrxName() {
        if (this.m_trx != null) {
            return this.m_trx.getTrxName();
        }
        return null;
    }

    @Override
    public void setProcessUI(IProcessUI monitor) {
        this.processUI = monitor;
    }

    protected void statusUpdate(String message) {
        if (this.processUI != null) {
            this.processUI.statusUpdate(message);
        }
    }

    private void autoFillParameters() {
        TreeMap<String, Field> map = new TreeMap<String, Field>(String.CASE_INSENSITIVE_ORDER);
        Class<?> target = this.getClass();
        while (target != null && !target.equals(SvrProcess.class)) {
            for (Field field : this.getFieldsWithParameters(target)) {
                field.setAccessible(true);
                Parameter pa = field.getAnnotation(Parameter.class);
                if (map.containsValue(field)) continue;
                String name = pa.name().isEmpty() ? field.getName() : pa.name();
                map.put(name.toLowerCase(), field);
            }
            target = target.getSuperclass();
        }
        if (map.size() == 0) {
            return;
        }
        ProcessInfoParameter[] processInfoParameterArray = this.getParameter();
        int n = processInfoParameterArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object candidate;
            Field notField;
            ProcessInfoParameter parameter = processInfoParameterArray[n2];
            String name = parameter.getParameterName().trim().toLowerCase();
            Field field = (Field)map.get(name);
            Field toField = map.containsKey(name + "_to") ? (Field)map.get(name + "_to") : null;
            Field field2 = notField = map.containsKey(name + "_not") ? (Field)map.get(name + "_not") : null;
            if (field == null) {
                candidate = "p_" + name;
                field = (Field)map.get(candidate);
                toField = map.containsKey((String)candidate + "_to") ? (Field)map.get((String)candidate + "_to") : null;
                Field field3 = notField = map.containsKey((String)candidate + "_not") ? (Field)map.get((String)candidate + "_not") : null;
            }
            if (field == null) {
                candidate = name.replace("_", "");
                field = (Field)map.get(candidate);
                toField = map.containsKey((String)candidate + "to") ? (Field)map.get((String)candidate + "to") : null;
                Field field4 = notField = map.containsKey((String)candidate + "not") ? (Field)map.get((String)candidate + "not") : null;
            }
            if (field != null) {
                Class<?> type = field.getType();
                try {
                    if (type.equals(Integer.TYPE) || type.equals(Integer.class)) {
                        field.set(this, parameter.getParameterAsInt());
                        if (parameter.getParameter_To() != null && toField != null) {
                            toField.set(this, parameter.getParameter_ToAsInt());
                        }
                    } else if (type.equals(String.class)) {
                        field.set(this, (String)parameter.getParameter());
                        if (notField != null) {
                            notField.set(this, parameter.isNotClause());
                        }
                    } else if (type.equals(Timestamp.class)) {
                        field.set(this, (Timestamp)parameter.getParameter());
                        if (parameter.getParameter_To() != null && toField != null) {
                            toField.set(this, (Timestamp)parameter.getParameter_To());
                        }
                    } else if (type.equals(BigDecimal.class)) {
                        field.set(this, (BigDecimal)parameter.getParameter());
                    } else if (type.equals(Boolean.TYPE) || type.equals(Boolean.class)) {
                        Object tmp = parameter.getParameter();
                        if (tmp instanceof String && tmp != null) {
                            field.set(this, "Y".equals(tmp));
                        } else {
                            field.set(this, tmp);
                        }
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            ++n2;
        }
    }

    private List<Field> getFieldsWithParameters(Class<?> clazz) {
        if (clazz != null) {
            return Arrays.stream(clazz.getDeclaredFields()).filter(f -> f.getAnnotation(Parameter.class) != null).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }
}

