/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.zk.pivot;

import com.google.common.net.MediaType;
import java.io.File;
import java.util.logging.Level;
import org.adempiere.base.Core;
import org.adempiere.webui.window.ZkReportViewer;
import org.compiere.print.ReportEngine;
import org.compiere.tools.FileUtil;
import org.compiere.util.CLogger;
import org.idempiere.print.renderer.IReportRenderer;
import org.idempiere.print.renderer.IReportRendererConfiguration;
import org.idempiere.ui.zk.report.IReportViewerRenderer;
import org.idempiere.zk.pivot.PivotReportRendererConfiguration;
import org.osgi.service.component.annotations.Component;
import org.zkoss.util.media.AMedia;

@Component(service={IReportViewerRenderer.class}, immediate=true)
public class PivotReportVieweRenderer
implements IReportViewerRenderer {
    private static final CLogger log = CLogger.getCLogger(PivotReportVieweRenderer.class);

    public String getId() {
        return "Pivot";
    }

    public String getExportLabel() {
        return this.getId();
    }

    public String getContentType() {
        return MediaType.HTML_UTF_8.toString();
    }

    public String getFileExtension() {
        return "pivot.html";
    }

    public boolean isExport() {
        return true;
    }

    public boolean isPreview(boolean roleCanExport) {
        return true;
    }

    public AMedia renderMedia(ZkReportViewer viewer, boolean export) {
        ReportEngine reportEngine = viewer.getReportEngine();
        try {
            String path = System.getProperty("java.io.tmpdir");
            Object prefix = this.makePrefix(reportEngine.getName());
            if (((String)prefix).length() < 3) {
                prefix = (String)prefix + "_".repeat(3 - ((String)prefix).length());
            }
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "Path=" + path + " Prefix=" + (String)prefix);
            }
            File file = FileUtil.createTempFile((String)prefix, (String)("." + this.getFileExtension()), (File)new File(path));
            IReportRenderer renderer = Core.getReportRenderer((String)this.getId());
            PivotReportRendererConfiguration config = new PivotReportRendererConfiguration().setLanguage(reportEngine.getPrintFormat().getLanguage()).setOutputFile(file).setExport(export);
            renderer.renderReport(reportEngine, (IReportRendererConfiguration)config);
            return new AMedia(file.getName(), this.getFileExtension(), this.getContentType(), file, false);
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    public boolean isSameContentForExportAndPreview() {
        return false;
    }
}

