/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.gmaps;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.zkoss.gmaps.AbstractMapModel;
import org.zkoss.lang.Objects;

public class MapModelMap
extends AbstractMapModel {
    private static final long serialVersionUID = 200807141725L;
    protected Map _map;

    public MapModelMap(Map map, boolean live) {
        this._map = live ? map : new LinkedHashMap(map);
    }

    public MapModelMap() {
        this._map = new LinkedHashMap();
    }

    public MapModelMap(Map map) {
        this._map = new LinkedHashMap(map);
    }

    public MapModelMap(int initialCapacity) {
        this._map = new LinkedHashMap(initialCapacity);
    }

    public MapModelMap(int initialCapacity, float loadFactor) {
        this._map = new LinkedHashMap(initialCapacity, loadFactor);
    }

    public Map getInnerMap() {
        return this._map;
    }

    public void clear() {
        if (!this._map.isEmpty()) {
            this._map.clear();
            this.fireEvent(4, null);
        }
    }

    public Collection getItemsIn(double swlat, double swlng, double nelat, double nelng, double cenlat, double cenlng, int zoom) {
        return Collections.unmodifiableMap(this._map).entrySet();
    }

    public boolean containsKey(Object key) {
        return this._map.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return this._map.containsValue(value);
    }

    public Set entrySet() {
        return new MyEntrySet(this._map.entrySet());
    }

    public boolean equals(Object o) {
        return this._map.equals(o instanceof MapModelMap ? ((MapModelMap)o)._map : o);
    }

    public String toString() {
        return this._map.toString();
    }

    public Object get(Object key) {
        return this._map.get(key);
    }

    public int hashCode() {
        return this._map.hashCode();
    }

    public boolean isEmpty() {
        return this._map.isEmpty();
    }

    public Set keySet() {
        return new MyKeySet(this._map.keySet(), 0);
    }

    private Map.Entry entryOfKey(Object key) {
        Map.Entry o;
        Iterator it = this._map.entrySet().iterator();
        while (!Objects.equals((Object)key, (o = it.next()).getKey())) {
        }
        return o;
    }

    private Map.Entry entryOfValue(Object val) {
        Map.Entry o;
        Iterator it = this._map.entrySet().iterator();
        while (!Objects.equals((Object)val, (o = it.next()).getValue())) {
        }
        return o;
    }

    public Object put(Object key, Object o) {
        Object ret;
        if (this._map.containsKey(key)) {
            if (Objects.equals((Object)o, this._map.get(key))) {
                return o;
            }
            Map.Entry entry = this.entryOfKey(key);
            ret = this._map.put(key, o);
            this.fireEvent(2, Collections.singleton(entry));
            this.fireEvent(1, Collections.singleton(entry));
        } else {
            ret = this._map.put(key, o);
            Map.Entry entry = this.entryOfKey(key);
            this.fireEvent(1, Collections.singleton(entry));
        }
        return ret;
    }

    public void putAll(Map c) {
        this._map.putAll(c);
        this.fireEvent(1, c.entrySet());
    }

    public Object remove(Object key) {
        if (this._map.containsKey(key)) {
            Map.Entry entry = this.entryOfKey(key);
            Object ret = this._map.remove(key);
            this.fireEvent(2, Collections.singleton(entry));
            return ret;
        }
        return null;
    }

    public int size() {
        return this._map.size();
    }

    public Collection values() {
        return new MyCollection(this._map.values());
    }

    private class MyCollection
    implements Collection {
        private Collection _inner;

        public MyCollection(Collection inner) {
            this._inner = inner;
        }

        public void clear() {
            this._inner.clear();
            MapModelMap.this.fireEvent(4, null);
        }

        public boolean remove(Object o) {
            boolean ret = this._inner.remove(o);
            if (ret) {
                MapModelMap.this.fireEvent(2, Collections.singleton(MapModelMap.this.entryOfValue(o)));
            }
            return ret;
        }

        public boolean removeAll(Collection c) {
            if (this._inner == c || this == c) {
                this.clear();
                return true;
            }
            LinkedList lst = new LinkedList();
            HashSet values = new HashSet(c);
            for (Map.Entry item : MapModelMap.this._map.entrySet()) {
                Object val = item.getValue();
                if (!values.contains(val)) continue;
                this._inner.remove(val);
                lst.add(item);
            }
            if (!lst.isEmpty()) {
                MapModelMap.this.fireEvent(2, lst);
                return true;
            }
            return false;
        }

        public boolean retainAll(Collection c) {
            if (this._inner == c || this == c) {
                return false;
            }
            LinkedList lst = new LinkedList();
            HashSet values = new HashSet(c);
            for (Map.Entry item : MapModelMap.this._map.entrySet()) {
                Object val = item.getValue();
                if (values.contains(val)) continue;
                this._inner.remove(val);
                lst.add(item);
            }
            if (!lst.isEmpty()) {
                MapModelMap.this.fireEvent(2, lst);
                return true;
            }
            return false;
        }

        public Iterator iterator() {
            return new MyIterator(this._inner.iterator(), 1);
        }

        public boolean add(Object o) {
            throw new UnsupportedOperationException("add()");
        }

        public boolean addAll(Collection col) {
            throw new UnsupportedOperationException("addAll()");
        }

        public boolean contains(Object o) {
            return this._inner == null ? false : this._inner.contains(o);
        }

        public boolean containsAll(Collection c) {
            return this._inner == null ? false : this._inner.containsAll(c);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof MyCollection) {
                return Objects.equals((Object)((MyCollection)o)._inner, (Object)this._inner);
            }
            return Objects.equals((Object)this._inner, (Object)o);
        }

        public int hashCode() {
            return this._inner == null ? 0 : this._inner.hashCode();
        }

        public boolean isEmpty() {
            return this._inner == null ? true : this._inner.isEmpty();
        }

        public int size() {
            return this._inner == null ? 0 : this._inner.size();
        }

        public Object[] toArray() {
            return this._inner == null ? new Object[]{} : this._inner.toArray();
        }

        public Object[] toArray(Object[] a) {
            return this._inner == null ? a : this._inner.toArray(a);
        }
    }

    private class MyEntrySet
    extends MyKeySet {
        private MyEntrySet(Set inner) {
            super(inner, 2);
        }
    }

    private class MyKeySet
    implements Set {
        protected final Set _set;
        protected final int _akey;

        public MyKeySet(Set inner, int akey) {
            this._set = inner;
            this._akey = akey;
        }

        public void clear() {
            MapModelMap.this.clear();
        }

        public boolean remove(Object o) {
            if (this._set.contains(o)) {
                MapModelMap.this.remove(o);
                return true;
            }
            return false;
        }

        public boolean removeAll(Collection c) {
            if (this._set == c || this == c) {
                this.clear();
                return true;
            }
            LinkedList lst = new LinkedList();
            if (this._akey == 0) {
                HashSet keys = new HashSet(c);
                for (Map.Entry item : MapModelMap.this._map.entrySet()) {
                    Object key = item.getKey();
                    if (!keys.contains(key)) continue;
                    this._set.remove(key);
                    lst.add(item);
                }
                MapModelMap.this.fireEvent(2, lst);
                return !lst.isEmpty();
            }
            boolean ret = this._set.removeAll(c);
            if (ret) {
                MapModelMap.this.fireEvent(2, c);
            }
            return ret;
        }

        public boolean retainAll(Collection c) {
            if (this._set == c || this == c) {
                return false;
            }
            LinkedList lst = new LinkedList();
            HashSet keys = new HashSet(c);
            if (this._akey == 0) {
                for (Map.Entry item : MapModelMap.this._map.entrySet()) {
                    Object key = item.getKey();
                    if (keys.contains(key)) continue;
                    this._set.remove(key);
                    lst.add(item);
                }
            } else {
                for (Map.Entry item : MapModelMap.this._map.entrySet()) {
                    if (keys.contains(item)) continue;
                    this._set.remove(item);
                    lst.add(item);
                }
            }
            if (!lst.isEmpty()) {
                MapModelMap.this.fireEvent(2, lst);
                return true;
            }
            return false;
        }

        public Iterator iterator() {
            return new MyIterator(this._set.iterator(), this._akey);
        }

        public boolean add(Object o) {
            throw new UnsupportedOperationException("add()");
        }

        public boolean addAll(Collection col) {
            throw new UnsupportedOperationException("addAll()");
        }

        public boolean contains(Object o) {
            return this._set == null ? false : this._set.contains(o);
        }

        public boolean containsAll(Collection c) {
            return this._set == null ? false : this._set.containsAll(c);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof MyKeySet) {
                return Objects.equals((Object)((MyKeySet)o)._set, (Object)this._set);
            }
            return Objects.equals((Object)this._set, (Object)o);
        }

        public int hashCode() {
            return this._set == null ? 0 : this._set.hashCode();
        }

        public boolean isEmpty() {
            return this._set == null ? true : this._set.isEmpty();
        }

        public int size() {
            return this._set == null ? 0 : this._set.size();
        }

        public Object[] toArray() {
            return this._set == null ? new Object[]{} : this._set.toArray();
        }

        public Object[] toArray(Object[] a) {
            return this._set == null ? a : this._set.toArray(a);
        }
    }

    private class MyIterator
    implements Iterator {
        private int _akey;
        private Iterator _it;
        private Object _current;

        public MyIterator(Iterator inner, int akey) {
            this._it = inner;
            this._akey = akey;
        }

        public boolean hasNext() {
            return this._it.hasNext();
        }

        public Object next() {
            this._current = this._it.next();
            return this._current;
        }

        public void remove() {
            this._it.remove();
            MapModelMap.this.fireEvent(2, Collections.singleton(this._akey == 0 ? MapModelMap.this.entryOfKey(this._current) : (this._akey == 1 ? MapModelMap.this.entryOfValue(this._current) : this._current)));
        }
    }
}

