/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.gmaps;

import java.io.IOException;
import java.util.Map;
import org.zkoss.gmaps.LatLng;
import org.zkoss.gmaps.Mapitem;
import org.zkoss.gmaps.event.CenterChangeEvent;
import org.zkoss.lang.Objects;
import org.zkoss.zk.au.AuRequest;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.sys.ContentRenderer;
import org.zkoss.zul.impl.XulElement;

public class Gcircle
extends XulElement
implements Mapitem {
    private static final long serialVersionUID = 7919622962923909687L;
    private LatLng _center = new LatLng(0.0, 0.0);
    private boolean _clickable = true;
    private boolean _editable;
    private String _fillColor;
    private int _fillOpacity = -1;
    private double _radius = 200.0;
    private String _strokeColor;
    private int _strokeOpacity = -1;
    private int _strokeWeight = -1;
    private boolean _circleVisible = true;
    private int _circleZIndex = -1;

    public double getLat() {
        return this._center.getLatitude();
    }

    public void setLat(double lat) {
        this.setCenter(new LatLng(lat, this._center.getLongitude()));
    }

    public double getLng() {
        return this._center.getLongitude();
    }

    public void setLng(double lng) {
        this.setCenter(new LatLng(this._center.getLatitude(), lng));
    }

    public void setCenter(LatLng center) {
        if (center == null) {
            throw new NullPointerException("center");
        }
        if (!Objects.equals((Object)((Object)this._center), (Object)((Object)center))) {
            this._center = center;
            this.smartUpdate("center", (Object)center);
        }
    }

    public LatLng getCenter() {
        return this._center;
    }

    public boolean isClickable() {
        return this._clickable;
    }

    public void setClickable(boolean clickable) {
        if (this._clickable != clickable) {
            this._clickable = clickable;
            this.smartUpdate("clickable", this._clickable);
        }
    }

    public boolean isEditable() {
        return this._editable;
    }

    public void setEditable(boolean editable) {
        if (this._editable != editable) {
            this._editable = editable;
            this.smartUpdate("editable", this._editable);
        }
    }

    public String getFillColor() {
        return this._fillColor;
    }

    public void setFillColor(String fillColor) {
        if (!Objects.equals((Object)this._fillColor, (Object)fillColor)) {
            this._fillColor = fillColor;
            this.smartUpdate("fillColor", this._fillColor);
        }
    }

    public int getFillOpacity() {
        return this._fillOpacity;
    }

    public void setFillOpacity(int fillOpacity) {
        if (fillOpacity < 0 || fillOpacity > 100) {
            throw new UiException("Fill opacity must between 0 to 100 (inclusive): " + fillOpacity);
        }
        if (this._fillOpacity != fillOpacity) {
            this._fillOpacity = fillOpacity;
            this.smartUpdate("fillOpacity", this._fillOpacity);
        }
    }

    public double getRadius() {
        return this._radius;
    }

    public void setRadius(double radius) {
        if (radius < 0.0) {
            throw new UiException("radius must greater then or equal to 0: " + radius);
        }
        if (this._radius != radius) {
            this._radius = radius;
            this.smartUpdate("radius", this._radius);
        }
    }

    public String getStrokeColor() {
        return this._strokeColor;
    }

    public void setStrokeColor(String strokeColor) {
        if (!Objects.equals((Object)this._strokeColor, (Object)strokeColor)) {
            this._strokeColor = strokeColor;
            this.smartUpdate("strokeColor", this._strokeColor);
        }
    }

    public int getStrokeOpacity() {
        return this._strokeOpacity;
    }

    public void setStrokeOpacity(int strokeOpacity) {
        if (strokeOpacity < 0 || strokeOpacity > 100) {
            throw new UiException("Stroke opacity must between 0 to 100 (inclusive): " + strokeOpacity);
        }
        if (this._strokeOpacity != strokeOpacity) {
            this._strokeOpacity = strokeOpacity;
            this.smartUpdate("strokeOpacity", this._strokeOpacity);
        }
    }

    public int getStrokeWeight() {
        return this._strokeWeight;
    }

    public void setStrokeWeight(int strokeWeight) {
        if (strokeWeight < 0) {
            throw new UiException("strokeWeight must greater then or equal to 0: " + strokeWeight);
        }
        if (this._strokeWeight != strokeWeight) {
            this._strokeWeight = strokeWeight;
            this.smartUpdate("strokeWeight", this._strokeWeight);
        }
    }

    public boolean isCircleVisible() {
        return this.isVisible();
    }

    public void setCircleVisible(boolean circleVisible) {
        this.setVisible(circleVisible);
    }

    public int getCircleZIndex() {
        return this._circleZIndex;
    }

    public void setCircleZIndex(int circleZIndex) {
        if (circleZIndex < 0) {
            throw new UiException("circleZIndex must greater then or equal to 0: " + circleZIndex);
        }
        if (this._circleZIndex != circleZIndex) {
            this._circleZIndex = circleZIndex;
            this.smartUpdate("circleZIndex", this._circleZIndex);
        }
    }

    public boolean isChildable() {
        return false;
    }

    protected void renderProperties(ContentRenderer renderer) throws IOException {
        super.renderProperties(renderer);
        renderer.render("center", (Object)this._center);
        if (!this._clickable) {
            renderer.render("clickable", this._clickable);
        }
        this.render(renderer, "editable", this._editable);
        this.render(renderer, "fillColor", this._fillColor);
        if (this._fillOpacity > -1) {
            renderer.render("fillOpacity", this._fillOpacity);
        }
        if (this._radius > -1.0) {
            renderer.render("radius", this._radius);
        }
        this.render(renderer, "strokeColor", this._strokeColor);
        if (this._strokeOpacity > -1) {
            renderer.render("strokeOpacity", this._strokeOpacity);
        }
        if (this._radius != 200.0) {
            renderer.render("strokeWeight", this._strokeWeight);
        }
        if (!this._circleVisible) {
            renderer.render("circleVisible", this._circleVisible);
        }
        if (this._circleZIndex > -1) {
            renderer.render("circleZIndex", this._circleZIndex);
        }
    }

    public void service(AuRequest request, boolean everError) {
        String cmd = request.getCommand();
        if (cmd.equals("onCenterChange")) {
            CenterChangeEvent evt = CenterChangeEvent.getCenterChangeEvent(request);
            this._center = evt.getCenter();
            Events.postEvent((Event)evt);
        } else if (cmd.equals("onRadiusChange")) {
            Map data = request.getData();
            this._radius = ((Number)data.get("radius")).doubleValue();
            Events.postEvent((Event)new Event("onRadiusChange", (Component)this, (Object)data));
        } else {
            super.service(request, everError);
        }
    }

    static {
        Gcircle.addClientEvent(Gcircle.class, (String)"onCenterChange", (int)8192);
        Gcircle.addClientEvent(Gcircle.class, (String)"onRadiusChange", (int)8192);
    }
}

