/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.test.workflow;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Properties;
import org.compiere.model.MBPartner;
import org.compiere.model.MClient;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutLine;
import org.compiere.model.MProduct;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.process.ProcessInfo;
import org.compiere.util.CacheMgt;
import org.compiere.util.Env;
import org.compiere.util.TimeUtil;
import org.compiere.wf.MWFActivity;
import org.compiere.wf.MWFNextCondition;
import org.compiere.wf.MWFNode;
import org.compiere.wf.MWFNodeNext;
import org.compiere.wf.MWFProcess;
import org.compiere.wf.MWorkflow;
import org.idempiere.test.AbstractTestCase;
import org.idempiere.test.DictionaryIDs;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class WFMaterialReceiptTest
extends AbstractTestCase {
    private static final int LOCATION_FROM_PATIO = 115;
    private static final int WF_PROCESS_SHIPMENT = 117;
    private static final int WF_PROCESS_SHIPMENT_NODE_COMPLETE = 190;
    private static final int PROCESS_SYNC_DOC_TRL = 321;
    private static final int COLUMN_M_INOUT_ISSOTRX = 3790;

    @Test
    public void testSplitAndWorkflow() {
        MWFNode nodeWait0 = null;
        MWFNodeNext fromCompleteToWait0 = null;
        MWFNextCondition conditionPurchase = null;
        MWFNode nodeSyncTrl1 = null;
        MWFNodeNext fromWait0ToSyncTrl1 = null;
        MWFNode nodeWaitAgain = null;
        MWFNodeNext fromWait0ToWaitAgain = null;
        MWFNode nodeSyncTrl2 = null;
        MWFNodeNext fromWaitAgainToSyncTrl2 = null;
        try {
            Properties ctx = Env.getCtx();
            String trxName = this.getTrxName();
            MClient client = new MClient(ctx, Env.getAD_Client_ID((Properties)ctx), trxName);
            client.setIsMultiLingualDocument(false);
            client.saveEx();
            MWorkflow wf = new MWorkflow(ctx, 117, trxName);
            nodeWait0 = new MWFNode(wf, "Wait0(AND Split)", "Wait0(AND Split)");
            nodeWait0.setClientOrg(Env.getAD_Client_ID((Properties)ctx), 0);
            nodeWait0.setAction("Z");
            nodeWait0.setWaitTime(0);
            nodeWait0.setSplitElement("A");
            nodeWait0.saveEx();
            MWFNode nodeComplete = new MWFNode(ctx, 190, trxName);
            fromCompleteToWait0 = new MWFNodeNext(nodeComplete, nodeWait0.getAD_WF_Node_ID());
            fromCompleteToWait0.setClientOrg(Env.getAD_Client_ID((Properties)ctx), 0);
            fromCompleteToWait0.setDescription("IsSOTrx=N");
            fromCompleteToWait0.saveEx();
            conditionPurchase = new MWFNextCondition(ctx, 0, trxName);
            conditionPurchase.setAD_WF_NodeNext_ID(fromCompleteToWait0.getAD_WF_NodeNext_ID());
            conditionPurchase.setOperation("==");
            conditionPurchase.setAD_Column_ID(3790);
            conditionPurchase.setValue("N");
            conditionPurchase.setSeqNo(10);
            conditionPurchase.setAndOr("O");
            conditionPurchase.saveEx();
            nodeSyncTrl1 = new MWFNode(wf, "SyncTrl1", "SyncTrl1");
            nodeSyncTrl1.setClientOrg(Env.getAD_Client_ID((Properties)ctx), 0);
            nodeSyncTrl1.setAction("P");
            nodeSyncTrl1.setAD_Process_ID(321);
            nodeSyncTrl1.saveEx();
            fromWait0ToSyncTrl1 = new MWFNodeNext(nodeWait0, nodeSyncTrl1.getAD_WF_Node_ID());
            fromWait0ToSyncTrl1.saveEx();
            nodeWaitAgain = new MWFNode(wf, "WaitAgain", "WaitAgain");
            nodeWaitAgain.setClientOrg(Env.getAD_Client_ID((Properties)ctx), 0);
            nodeWaitAgain.setAction("Z");
            nodeWaitAgain.setWaitTime(0);
            nodeWaitAgain.saveEx();
            fromWait0ToWaitAgain = new MWFNodeNext(nodeWait0, nodeWaitAgain.getAD_WF_Node_ID());
            fromWait0ToWaitAgain.saveEx();
            nodeSyncTrl2 = new MWFNode(wf, "SyncTrl2", "SyncTrl2");
            nodeSyncTrl2.setClientOrg(Env.getAD_Client_ID((Properties)ctx), 0);
            nodeSyncTrl2.setAction("P");
            nodeSyncTrl2.setAD_Process_ID(321);
            nodeSyncTrl2.saveEx();
            fromWaitAgainToSyncTrl2 = new MWFNodeNext(nodeWaitAgain, nodeSyncTrl2.getAD_WF_Node_ID());
            fromWaitAgainToSyncTrl2.saveEx();
            this.commit();
            CacheMgt.get().reset();
            MInOut mr = new MInOut(ctx, 0, trxName);
            mr.setBPartner(MBPartner.get((Properties)ctx, (int)DictionaryIDs.C_BPartner.PATIO.id));
            mr.setC_BPartner_Location_ID(115);
            mr.setM_Warehouse_ID(DictionaryIDs.M_Warehouse.HQ.id);
            mr.setC_DocType_ID(DictionaryIDs.C_DocType.MM_RECEIPT.id);
            mr.setIsSOTrx(false);
            mr.setMovementType("V+");
            mr.setDocStatus("DR");
            mr.setDocAction("CO");
            Timestamp today = TimeUtil.getDay((long)System.currentTimeMillis());
            mr.setDateOrdered(today);
            mr.saveEx();
            MInOutLine line1 = new MInOutLine(mr);
            line1.setLine(10);
            line1.setProduct(MProduct.get((Properties)ctx, (int)DictionaryIDs.M_Product.SEEDER.id));
            line1.setQty(new BigDecimal("1"));
            line1.setM_Locator_ID(DictionaryIDs.M_Locator.HQ.id);
            line1.saveEx();
            ProcessInfo info = MWorkflow.runDocumentActionWorkflow((PO)mr, (String)"CO");
            Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
            mr.load(trxName, new String[0]);
            Assertions.assertEquals((Object)"CO", (Object)mr.getDocStatus());
            MWFProcess proc = (MWFProcess)new Query(ctx, "AD_WF_Process", "AD_Table_ID=? AND Record_ID=?", trxName).setParameters(new Object[]{319, mr.getM_InOut_ID()}).firstOnly();
            MWFActivity[] acts = proc.getActivities(true, false, trxName);
            Assertions.assertEquals((int)7, (int)acts.length);
            MWFActivity[] mWFActivityArray = acts;
            int n = acts.length;
            int n2 = 0;
            while (n2 < n) {
                MWFActivity act = mWFActivityArray[n2];
                Assertions.assertEquals((Object)act.isProcessed(), (Object)true);
                ++n2;
            }
        }
        finally {
            this.rollback();
            if (fromWaitAgainToSyncTrl2 != null) {
                fromWaitAgainToSyncTrl2.delete(true);
            }
            if (nodeSyncTrl2 != null) {
                nodeSyncTrl2.delete(true);
            }
            if (fromWait0ToWaitAgain != null) {
                fromWait0ToWaitAgain.delete(true);
            }
            if (nodeWaitAgain != null) {
                nodeWaitAgain.delete(true);
            }
            if (fromWait0ToSyncTrl1 != null) {
                fromWait0ToSyncTrl1.delete(true);
            }
            if (nodeSyncTrl1 != null) {
                nodeSyncTrl1.delete(true);
            }
            if (conditionPurchase != null) {
                conditionPurchase.delete(true);
            }
            if (fromCompleteToWait0 != null) {
                fromCompleteToWait0.delete(true);
            }
            if (nodeWait0 != null) {
                nodeWait0.delete(true);
            }
            this.commit();
            CacheMgt.get().reset();
        }
    }
}

