/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.test.model;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Properties;
import org.compiere.acct.Doc;
import org.compiere.acct.DocManager;
import org.compiere.model.MAccount;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MAllocationHdr;
import org.compiere.model.MAllocationLine;
import org.compiere.model.MBPartner;
import org.compiere.model.MBankAccount;
import org.compiere.model.MCharge;
import org.compiere.model.MConversionRate;
import org.compiere.model.MCurrency;
import org.compiere.model.MDocType;
import org.compiere.model.MFactAcct;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MPayment;
import org.compiere.model.MPriceList;
import org.compiere.model.MPriceListVersion;
import org.compiere.model.MProduct;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.process.DocumentEngine;
import org.compiere.process.ProcessInfo;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.wf.MWorkflow;
import org.idempiere.test.AbstractTestCase;
import org.idempiere.test.ConversionRateHelper;
import org.idempiere.test.DictionaryIDs;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.ResourceLock;

public class Allocation2ndAcctSchemaTest
extends AbstractTestCase {
    @Test
    @ResourceLock(value="C_Conversion_Rate")
    public void testAllocateInvoicePaymentPosting_1() {
        MBPartner bpartner = MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.C_AND_W.id);
        MCharge charge = MCharge.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_Charge.FREIGHT.id);
        Timestamp currentDate = Env.getContextAsDate((Properties)Env.getCtx(), (String)"#Date");
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(currentDate.getTime());
        cal.add(5, -2);
        Timestamp date1 = new Timestamp(cal.getTimeInMillis());
        cal.setTimeInMillis(currentDate.getTime());
        cal.add(5, -1);
        Timestamp date2 = new Timestamp(cal.getTimeInMillis());
        Timestamp date3 = currentDate;
        int C_ConversionType_ID = DictionaryIDs.C_ConversionType.COMPANY.id;
        MCurrency usd = MCurrency.get((int)DictionaryIDs.C_Currency.USD.id);
        MCurrency euro = MCurrency.get((int)DictionaryIDs.C_Currency.EUR.id);
        BigDecimal eurToUsd1 = new BigDecimal(32.458922422202);
        MConversionRate cr1 = this.createConversionRate(euro.getC_Currency_ID(), usd.getC_Currency_ID(), C_ConversionType_ID, date1, eurToUsd1, false);
        BigDecimal eurToUsd2 = new BigDecimal(33.93972535567);
        MConversionRate cr2 = this.createConversionRate(euro.getC_Currency_ID(), usd.getC_Currency_ID(), C_ConversionType_ID, date2, eurToUsd2, false);
        BigDecimal eurToUsd3 = new BigDecimal(33.27812049435);
        MConversionRate cr3 = this.createConversionRate(euro.getC_Currency_ID(), usd.getC_Currency_ID(), C_ConversionType_ID, date3, eurToUsd3, false);
        int M_PriceList_ID = DictionaryIDs.M_PriceList.EXPORT.id;
        try {
            MInvoice invoice1 = this.createInvoice(true, bpartner, date1, M_PriceList_ID, C_ConversionType_ID);
            BigDecimal qty = BigDecimal.ONE;
            BigDecimal price = new BigDecimal(12587.48);
            this.createInvoiceLine(invoice1, 10, null, charge, qty, price);
            this.completeDocument((PO)invoice1);
            this.postDocument((PO)invoice1);
            MBankAccount ba = this.getBankAccount(usd.getC_Currency_ID());
            BigDecimal payAmt = new BigDecimal(18549.52);
            MPayment payment = this.createPayment(true, bpartner, ba.getC_BankAccount_ID(), date2, payAmt, euro.getC_Currency_ID(), C_ConversionType_ID);
            this.completeDocument((PO)payment);
            this.postDocument((PO)payment);
            MAllocationHdr alloc1 = this.createAllocationHdr(date2, euro.getC_Currency_ID());
            BigDecimal allocAmount = new BigDecimal(12587.48);
            this.createAllocationLine(alloc1, allocAmount, invoice1, payment);
            this.completeDocument((PO)alloc1);
            this.postDocument((PO)alloc1);
            MAcctSchema[] ass = MAcctSchema.getClientAcctSchema((Properties)Env.getCtx(), (int)Env.getAD_Client_ID((Properties)Env.getCtx()));
            MAllocationHdr[] allocList = MAllocationHdr.getOfInvoice((Properties)Env.getCtx(), (int)invoice1.getC_Invoice_ID(), (String)this.getTrxName());
            ArrayList<PostingLine> paymentLineList = new ArrayList<PostingLine>();
            ArrayList<PostingLine> tradeLineList = new ArrayList<PostingLine>();
            BigDecimal accountedDrAmt = this.getAccountedAmount(usd, allocAmount, cr2.getMultiplyRate());
            BigDecimal accountedCrAmt = this.getAccountedAmount(usd, allocAmount, cr1.getMultiplyRate());
            paymentLineList.add(new PostingLine(usd, accountedDrAmt, Env.ZERO));
            tradeLineList.add(new PostingLine(usd, Env.ZERO, accountedCrAmt));
            this.testAllocationPosting(ass, allocList, paymentLineList, tradeLineList);
            MInvoice invoice2 = this.createInvoice(true, bpartner, date3, M_PriceList_ID, C_ConversionType_ID);
            qty = BigDecimal.ONE;
            price = new BigDecimal(40125);
            this.createInvoiceLine(invoice2, 10, null, charge, qty, price);
            this.completeDocument((PO)invoice2);
            this.postDocument((PO)invoice2);
            MAllocationHdr alloc2 = this.createAllocationHdr(date3, euro.getC_Currency_ID());
            allocAmount = new BigDecimal(5962.04);
            this.createAllocationLine(alloc2, allocAmount, invoice2, payment);
            this.completeDocument((PO)alloc2);
            this.postDocument((PO)alloc2);
            allocList = MAllocationHdr.getOfInvoice((Properties)Env.getCtx(), (int)invoice2.getC_Invoice_ID(), (String)this.getTrxName());
            paymentLineList = new ArrayList();
            tradeLineList = new ArrayList();
            ArrayList<PostingLine> currBalList = new ArrayList<PostingLine>();
            accountedDrAmt = this.getAccountedAmount(usd, allocAmount, cr2.getMultiplyRate());
            accountedCrAmt = this.getAccountedAmount(usd, allocAmount, cr3.getMultiplyRate());
            paymentLineList.add(new PostingLine(usd, accountedDrAmt, Env.ZERO));
            tradeLineList.add(new PostingLine(usd, Env.ZERO, accountedCrAmt));
            BigDecimal currBalAmt = new BigDecimal(0.01).setScale(usd.getStdPrecision(), RoundingMode.HALF_UP);
            paymentLineList.add(new PostingLine(usd, Env.ZERO, currBalAmt));
            currBalList.add(new PostingLine(usd, currBalAmt, Env.ZERO));
            this.testAllocationPosting(ass, allocList, paymentLineList, tradeLineList, null, currBalList);
        }
        finally {
            this.rollback();
            this.deleteConversionRate(cr1);
            this.deleteConversionRate(cr2);
            this.deleteConversionRate(cr3);
        }
    }

    @Test
    @ResourceLock(value="C_Conversion_Rate")
    public void testAllocateInvoicePaymentPosting_2() {
        Timestamp currentDate;
        MBPartner bpartner = MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.SEED_FARM.id);
        MCharge charge = MCharge.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_Charge.FREIGHT.id);
        Timestamp date = currentDate = Env.getContextAsDate((Properties)Env.getCtx(), (String)"#Date");
        int C_ConversionType_ID = DictionaryIDs.C_ConversionType.COMPANY.id;
        MCurrency usd = MCurrency.get((int)DictionaryIDs.C_Currency.USD.id);
        MCurrency euro = MCurrency.get((int)DictionaryIDs.C_Currency.EUR.id);
        BigDecimal eurToUsd = new BigDecimal(32.458922422202);
        MConversionRate cr = this.createConversionRate(euro.getC_Currency_ID(), usd.getC_Currency_ID(), C_ConversionType_ID, date, eurToUsd, false);
        int M_PriceList_ID = DictionaryIDs.M_PriceList.EXPORT.id;
        try {
            MInvoice invoice1 = this.createInvoice(true, bpartner, date, M_PriceList_ID, C_ConversionType_ID);
            BigDecimal qty = BigDecimal.ONE;
            BigDecimal price = new BigDecimal(12587.48);
            this.createInvoiceLine(invoice1, 10, null, charge, qty, price);
            this.completeDocument((PO)invoice1);
            this.postDocument((PO)invoice1);
            MBankAccount ba = this.getBankAccount(usd.getC_Currency_ID());
            BigDecimal payAmt = new BigDecimal(18549.52);
            MPayment payment = this.createPayment(true, bpartner, ba.getC_BankAccount_ID(), date, payAmt, euro.getC_Currency_ID(), C_ConversionType_ID);
            this.completeDocument((PO)payment);
            this.postDocument((PO)payment);
            MAllocationHdr alloc1 = this.createAllocationHdr(date, euro.getC_Currency_ID());
            BigDecimal allocAmount = new BigDecimal(12587.48);
            this.createAllocationLine(alloc1, allocAmount, invoice1, payment);
            this.completeDocument((PO)alloc1);
            this.postDocument((PO)alloc1);
            MAcctSchema[] ass = MAcctSchema.getClientAcctSchema((Properties)Env.getCtx(), (int)Env.getAD_Client_ID((Properties)Env.getCtx()));
            MAllocationHdr[] allocList = MAllocationHdr.getOfInvoice((Properties)Env.getCtx(), (int)invoice1.getC_Invoice_ID(), (String)this.getTrxName());
            ArrayList<PostingLine> paymentLineList = new ArrayList<PostingLine>();
            ArrayList<PostingLine> tradeLineList = new ArrayList<PostingLine>();
            BigDecimal accountedDrAmt = this.getAccountedAmount(usd, allocAmount, cr.getMultiplyRate());
            BigDecimal accountedCrAmt = this.getAccountedAmount(usd, allocAmount, cr.getMultiplyRate());
            paymentLineList.add(new PostingLine(usd, accountedDrAmt, Env.ZERO));
            tradeLineList.add(new PostingLine(usd, Env.ZERO, accountedCrAmt));
            this.testAllocationPosting(ass, allocList, paymentLineList, tradeLineList);
            MInvoice invoice2 = this.createInvoice(true, bpartner, date, M_PriceList_ID, C_ConversionType_ID);
            qty = BigDecimal.ONE;
            price = new BigDecimal(40125);
            this.createInvoiceLine(invoice2, 10, null, charge, qty, price);
            this.completeDocument((PO)invoice2);
            this.postDocument((PO)invoice2);
            MAllocationHdr alloc2 = this.createAllocationHdr(date, euro.getC_Currency_ID());
            allocAmount = new BigDecimal(5962.04);
            this.createAllocationLine(alloc2, allocAmount, invoice2, payment);
            this.completeDocument((PO)alloc2);
            this.postDocument((PO)alloc2);
            allocList = MAllocationHdr.getOfInvoice((Properties)Env.getCtx(), (int)invoice2.getC_Invoice_ID(), (String)this.getTrxName());
            paymentLineList = new ArrayList();
            tradeLineList = new ArrayList();
            accountedDrAmt = this.getAccountedAmount(usd, allocAmount, cr.getMultiplyRate());
            accountedCrAmt = this.getAccountedAmount(usd, allocAmount, cr.getMultiplyRate());
            paymentLineList.add(new PostingLine(usd, accountedDrAmt, Env.ZERO));
            tradeLineList.add(new PostingLine(usd, Env.ZERO, accountedCrAmt));
            this.testAllocationPosting(ass, allocList, paymentLineList, tradeLineList, null, null);
        }
        finally {
            this.rollback();
            this.deleteConversionRate(cr);
        }
    }

    @Test
    @ResourceLock(value="C_Conversion_Rate")
    public void testAllocateInvoicePaymentPosting_3() {
        MBPartner bpartner = MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.PATIO.id);
        MCharge charge = MCharge.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_Charge.FREIGHT.id);
        Timestamp currentDate = Env.getContextAsDate((Properties)Env.getCtx(), (String)"#Date");
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(currentDate.getTime());
        cal.add(5, -1);
        Timestamp date1 = new Timestamp(cal.getTimeInMillis());
        Timestamp date2 = currentDate;
        int C_ConversionType_ID = DictionaryIDs.C_ConversionType.COMPANY.id;
        MCurrency usd = MCurrency.get((int)DictionaryIDs.C_Currency.USD.id);
        MCurrency euro = MCurrency.get((int)DictionaryIDs.C_Currency.EUR.id);
        BigDecimal eurToUsd1 = new BigDecimal(30.212666962751);
        MConversionRate cr1 = this.createConversionRate(euro.getC_Currency_ID(), usd.getC_Currency_ID(), C_ConversionType_ID, date1, eurToUsd1, false);
        BigDecimal eurToUsd2 = new BigDecimal(29.905289946739);
        MConversionRate cr2 = this.createConversionRate(euro.getC_Currency_ID(), usd.getC_Currency_ID(), C_ConversionType_ID, date2, eurToUsd2, false);
        int M_PriceList_ID = DictionaryIDs.M_PriceList.EXPORT.id;
        try {
            MBankAccount ba = this.getBankAccount(usd.getC_Currency_ID());
            BigDecimal payAmt = new BigDecimal(12000);
            MPayment payment = this.createPayment(true, bpartner, ba.getC_BankAccount_ID(), date1, payAmt, euro.getC_Currency_ID(), C_ConversionType_ID);
            this.completeDocument((PO)payment);
            this.postDocument((PO)payment);
            MInvoice invoice = this.createInvoice(true, bpartner, date2, M_PriceList_ID, C_ConversionType_ID);
            BigDecimal qty = BigDecimal.ONE;
            BigDecimal price = new BigDecimal(10700);
            this.createInvoiceLine(invoice, 10, null, charge, qty, price);
            this.completeDocument((PO)invoice);
            this.postDocument((PO)invoice);
            MAllocationHdr alloc = this.createAllocationHdr(date2, euro.getC_Currency_ID());
            BigDecimal allocAmount = new BigDecimal(10700);
            this.createAllocationLine(alloc, allocAmount, invoice, payment);
            this.completeDocument((PO)alloc);
            this.postDocument((PO)alloc);
            MAcctSchema[] ass = MAcctSchema.getClientAcctSchema((Properties)Env.getCtx(), (int)Env.getAD_Client_ID((Properties)Env.getCtx()));
            MAllocationHdr[] allocList = MAllocationHdr.getOfInvoice((Properties)Env.getCtx(), (int)invoice.getC_Invoice_ID(), (String)this.getTrxName());
            ArrayList<PostingLine> paymentLineList = new ArrayList<PostingLine>();
            ArrayList<PostingLine> tradeLineList = new ArrayList<PostingLine>();
            ArrayList<PostingLine> gainLossLineList = new ArrayList<PostingLine>();
            BigDecimal accountedDrAmt = this.getAccountedAmount(usd, allocAmount, cr1.getMultiplyRate());
            BigDecimal accountedCrAmt = this.getAccountedAmount(usd, allocAmount, cr2.getMultiplyRate());
            paymentLineList.add(new PostingLine(usd, accountedDrAmt, Env.ZERO));
            tradeLineList.add(new PostingLine(usd, Env.ZERO, accountedCrAmt));
            BigDecimal gainLossAmt = new BigDecimal(3.64).setScale(usd.getStdPrecision(), RoundingMode.HALF_UP);
            gainLossLineList.add(new PostingLine(usd, gainLossAmt, Env.ZERO));
            this.testAllocationPosting(ass, allocList, paymentLineList, tradeLineList, gainLossLineList, null);
        }
        finally {
            this.rollback();
            this.deleteConversionRate(cr1);
            this.deleteConversionRate(cr2);
        }
    }

    @Test
    @ResourceLock(value="C_Conversion_Rate")
    public void testAllocateInvoicePaymentPosting_4() {
        Timestamp currentDate;
        MBPartner bpartner = MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.AGRI_TECH.id);
        MCharge charge = MCharge.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_Charge.FREIGHT.id);
        Timestamp date = currentDate = Env.getContextAsDate((Properties)Env.getCtx(), (String)"#Date");
        int C_ConversionType_ID = DictionaryIDs.C_ConversionType.COMPANY.id;
        MCurrency usd = MCurrency.get((int)DictionaryIDs.C_Currency.USD.id);
        MCurrency euro = MCurrency.get((int)DictionaryIDs.C_Currency.EUR.id);
        BigDecimal eurToUsd = new BigDecimal(30.212666962751);
        MConversionRate cr = this.createConversionRate(euro.getC_Currency_ID(), usd.getC_Currency_ID(), C_ConversionType_ID, date, eurToUsd, false);
        int M_PriceList_ID = DictionaryIDs.M_PriceList.EXPORT.id;
        try {
            MBankAccount ba = this.getBankAccount(usd.getC_Currency_ID());
            BigDecimal payAmt = new BigDecimal(12000);
            MPayment payment = this.createPayment(true, bpartner, ba.getC_BankAccount_ID(), date, payAmt, euro.getC_Currency_ID(), C_ConversionType_ID);
            this.completeDocument((PO)payment);
            this.postDocument((PO)payment);
            MInvoice invoice = this.createInvoice(true, bpartner, date, M_PriceList_ID, C_ConversionType_ID);
            BigDecimal qty = BigDecimal.ONE;
            BigDecimal price = new BigDecimal(10700);
            this.createInvoiceLine(invoice, 10, null, charge, qty, price);
            this.completeDocument((PO)invoice);
            this.postDocument((PO)invoice);
            MAllocationHdr alloc = this.createAllocationHdr(date, euro.getC_Currency_ID());
            BigDecimal allocAmount = new BigDecimal(10700);
            this.createAllocationLine(alloc, allocAmount, invoice, payment);
            this.completeDocument((PO)alloc);
            this.postDocument((PO)alloc);
            MAcctSchema[] ass = MAcctSchema.getClientAcctSchema((Properties)Env.getCtx(), (int)Env.getAD_Client_ID((Properties)Env.getCtx()));
            MAllocationHdr[] allocList = MAllocationHdr.getOfInvoice((Properties)Env.getCtx(), (int)invoice.getC_Invoice_ID(), (String)this.getTrxName());
            ArrayList<PostingLine> paymentLineList = new ArrayList<PostingLine>();
            ArrayList<PostingLine> tradeLineList = new ArrayList<PostingLine>();
            BigDecimal accountedDrAmt = this.getAccountedAmount(usd, allocAmount, cr.getMultiplyRate());
            BigDecimal accountedCrAmt = this.getAccountedAmount(usd, allocAmount, cr.getMultiplyRate());
            paymentLineList.add(new PostingLine(usd, accountedDrAmt, Env.ZERO));
            tradeLineList.add(new PostingLine(usd, Env.ZERO, accountedCrAmt));
            this.testAllocationPosting(ass, allocList, paymentLineList, tradeLineList, null, null);
        }
        finally {
            this.rollback();
            this.deleteConversionRate(cr);
        }
    }

    @Test
    @ResourceLock(value="C_Conversion_Rate")
    public void testAllocateInvoicePaymentPosting_5() {
        MBPartner bpartner = MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.JOE_BLOCK.id);
        MCharge charge = MCharge.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_Charge.FREIGHT.id);
        Timestamp currentDate = Env.getContextAsDate((Properties)Env.getCtx(), (String)"#Date");
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(currentDate.getTime());
        cal.add(5, -1);
        Timestamp date1 = new Timestamp(cal.getTimeInMillis());
        Timestamp date2 = currentDate;
        int C_ConversionType_ID = DictionaryIDs.C_ConversionType.COMPANY.id;
        MCurrency usd = MCurrency.get((int)DictionaryIDs.C_Currency.USD.id);
        MCurrency euro = MCurrency.get((int)DictionaryIDs.C_Currency.EUR.id);
        BigDecimal eurToUsd1 = new BigDecimal(29.905289946739);
        MConversionRate cr1 = this.createConversionRate(euro.getC_Currency_ID(), usd.getC_Currency_ID(), C_ConversionType_ID, date1, eurToUsd1, false);
        BigDecimal eurToUsd2 = new BigDecimal(31.526248754713);
        MConversionRate cr2 = this.createConversionRate(euro.getC_Currency_ID(), usd.getC_Currency_ID(), C_ConversionType_ID, date2, eurToUsd2, false);
        int M_PriceList_ID = DictionaryIDs.M_PriceList.EXPORT.id;
        try {
            MInvoice invoice1 = this.createInvoice(true, bpartner, date1, M_PriceList_ID, C_ConversionType_ID);
            BigDecimal qty = BigDecimal.ONE;
            BigDecimal price = new BigDecimal(9362.5);
            this.createInvoiceLine(invoice1, 10, null, charge, qty, price);
            this.completeDocument((PO)invoice1);
            this.postDocument((PO)invoice1);
            MInvoice invoice2 = this.createInvoice(true, bpartner, date1, M_PriceList_ID, C_ConversionType_ID);
            qty = BigDecimal.ONE;
            price = new BigDecimal(9362.5);
            this.createInvoiceLine(invoice2, 10, null, charge, qty, price);
            this.completeDocument((PO)invoice2);
            this.postDocument((PO)invoice2);
            MInvoice invoice3 = this.createInvoice(true, bpartner, date1, M_PriceList_ID, C_ConversionType_ID);
            qty = BigDecimal.ONE;
            price = new BigDecimal(2587.26);
            this.createInvoiceLine(invoice3, 10, null, charge, qty, price);
            this.completeDocument((PO)invoice3);
            this.postDocument((PO)invoice3);
            MInvoice invoice4 = this.createInvoice(true, bpartner, date1, M_PriceList_ID, C_ConversionType_ID);
            qty = BigDecimal.ONE;
            price = new BigDecimal(14519.9);
            this.createInvoiceLine(invoice4, 10, null, charge, qty, price);
            this.completeDocument((PO)invoice4);
            this.postDocument((PO)invoice4);
            MInvoice invoice5 = this.createInvoice(true, bpartner, date1, M_PriceList_ID, C_ConversionType_ID);
            qty = BigDecimal.ONE;
            price = new BigDecimal(14329.44);
            this.createInvoiceLine(invoice5, 10, null, charge, qty, price);
            this.completeDocument((PO)invoice5);
            this.postDocument((PO)invoice5);
            MInvoice creditMemo1 = this.createCreditMemo(true, bpartner, date1, M_PriceList_ID, C_ConversionType_ID);
            qty = BigDecimal.ONE;
            price = new BigDecimal(936.25);
            this.createInvoiceLine(creditMemo1, 10, null, charge, qty, price);
            this.completeDocument((PO)creditMemo1);
            this.postDocument((PO)creditMemo1);
            MInvoice creditMemo2 = this.createCreditMemo(true, bpartner, date1, M_PriceList_ID, C_ConversionType_ID);
            qty = BigDecimal.ONE;
            price = new BigDecimal(936.25);
            this.createInvoiceLine(creditMemo2, 10, null, charge, qty, price);
            this.completeDocument((PO)creditMemo2);
            this.postDocument((PO)creditMemo2);
            MBankAccount ba = this.getBankAccount(usd.getC_Currency_ID());
            BigDecimal payAmt = new BigDecimal(48289.1);
            MPayment payment = this.createPayment(true, bpartner, ba.getC_BankAccount_ID(), date2, payAmt, euro.getC_Currency_ID(), C_ConversionType_ID);
            this.completeDocument((PO)payment);
            this.postDocument((PO)payment);
            MAllocationHdr alloc = this.createAllocationHdr(date2, euro.getC_Currency_ID());
            this.createAllocationLine(alloc, invoice1.getGrandTotal(), invoice1, payment);
            this.createAllocationLine(alloc, invoice2.getGrandTotal(), invoice2, payment);
            this.createAllocationLine(alloc, invoice3.getGrandTotal(), invoice3, payment);
            this.createAllocationLine(alloc, invoice4.getGrandTotal(), invoice4, payment);
            this.createAllocationLine(alloc, invoice5.getGrandTotal(), invoice5, payment);
            this.createAllocationLine(alloc, creditMemo1.getGrandTotal().negate(), creditMemo1, payment);
            this.createAllocationLine(alloc, creditMemo2.getGrandTotal().negate(), creditMemo2, payment);
            this.completeDocument((PO)alloc);
            this.postDocument((PO)alloc);
            MAcctSchema[] ass = MAcctSchema.getClientAcctSchema((Properties)Env.getCtx(), (int)Env.getAD_Client_ID((Properties)Env.getCtx()));
            MAllocationHdr[] allocList = MAllocationHdr.getOfPayment((Properties)Env.getCtx(), (int)payment.getC_Payment_ID(), (String)this.getTrxName());
            ArrayList<PostingLine> paymentLineList = new ArrayList<PostingLine>();
            ArrayList<PostingLine> tradeLineList = new ArrayList<PostingLine>();
            ArrayList<PostingLine> currBalLineList = new ArrayList<PostingLine>();
            BigDecimal accountedDrAmt = this.getAccountedAmount(usd, invoice1.getGrandTotal(), cr2.getMultiplyRate());
            BigDecimal accountedCrAmt = this.getAccountedAmount(usd, invoice1.getGrandTotal(), cr1.getMultiplyRate());
            paymentLineList.add(new PostingLine(usd, accountedDrAmt, Env.ZERO));
            tradeLineList.add(new PostingLine(usd, Env.ZERO, accountedCrAmt));
            accountedDrAmt = this.getAccountedAmount(usd, invoice2.getGrandTotal(), cr2.getMultiplyRate());
            accountedCrAmt = this.getAccountedAmount(usd, invoice2.getGrandTotal(), cr1.getMultiplyRate());
            paymentLineList.add(new PostingLine(usd, accountedDrAmt, Env.ZERO));
            tradeLineList.add(new PostingLine(usd, Env.ZERO, accountedCrAmt));
            accountedDrAmt = this.getAccountedAmount(usd, invoice3.getGrandTotal(), cr2.getMultiplyRate());
            accountedCrAmt = this.getAccountedAmount(usd, invoice3.getGrandTotal(), cr1.getMultiplyRate());
            paymentLineList.add(new PostingLine(usd, accountedDrAmt, Env.ZERO));
            tradeLineList.add(new PostingLine(usd, Env.ZERO, accountedCrAmt));
            accountedDrAmt = this.getAccountedAmount(usd, invoice4.getGrandTotal(), cr2.getMultiplyRate());
            accountedCrAmt = this.getAccountedAmount(usd, invoice4.getGrandTotal(), cr1.getMultiplyRate());
            paymentLineList.add(new PostingLine(usd, accountedDrAmt, Env.ZERO));
            tradeLineList.add(new PostingLine(usd, Env.ZERO, accountedCrAmt));
            accountedDrAmt = this.getAccountedAmount(usd, invoice5.getGrandTotal(), cr2.getMultiplyRate());
            accountedCrAmt = this.getAccountedAmount(usd, invoice5.getGrandTotal(), cr1.getMultiplyRate());
            paymentLineList.add(new PostingLine(usd, accountedDrAmt, Env.ZERO));
            tradeLineList.add(new PostingLine(usd, Env.ZERO, accountedCrAmt));
            accountedCrAmt = this.getAccountedAmount(usd, creditMemo1.getGrandTotal(), cr2.getMultiplyRate());
            accountedDrAmt = this.getAccountedAmount(usd, creditMemo1.getGrandTotal(), cr1.getMultiplyRate());
            paymentLineList.add(new PostingLine(usd, Env.ZERO, accountedCrAmt));
            tradeLineList.add(new PostingLine(usd, accountedDrAmt, Env.ZERO));
            accountedCrAmt = this.getAccountedAmount(usd, creditMemo2.getGrandTotal(), cr2.getMultiplyRate());
            accountedDrAmt = this.getAccountedAmount(usd, creditMemo2.getGrandTotal(), cr1.getMultiplyRate());
            paymentLineList.add(new PostingLine(usd, Env.ZERO, accountedCrAmt));
            tradeLineList.add(new PostingLine(usd, accountedDrAmt, Env.ZERO));
            BigDecimal currBalAmt = new BigDecimal(0.01).setScale(usd.getStdPrecision(), RoundingMode.HALF_UP);
            paymentLineList.add(new PostingLine(usd, currBalAmt, Env.ZERO));
            currBalLineList.add(new PostingLine(usd, Env.ZERO, currBalAmt));
            this.testAllocationPosting(ass, allocList, paymentLineList, tradeLineList, null, currBalLineList);
        }
        finally {
            this.rollback();
            this.deleteConversionRate(cr1);
            this.deleteConversionRate(cr2);
        }
    }

    @Test
    @ResourceLock(value="C_Conversion_Rate")
    public void testAllocateInvoicePaymentPosting_6() {
        Timestamp currentDate;
        MBPartner bpartner = MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.C_AND_W.id);
        MCharge charge = MCharge.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_Charge.FREIGHT.id);
        Timestamp date = currentDate = Env.getContextAsDate((Properties)Env.getCtx(), (String)"#Date");
        int C_ConversionType_ID = DictionaryIDs.C_ConversionType.COMPANY.id;
        MCurrency usd = MCurrency.get((int)DictionaryIDs.C_Currency.USD.id);
        MCurrency euro = MCurrency.get((int)DictionaryIDs.C_Currency.EUR.id);
        BigDecimal eurToUsd = new BigDecimal(29.905289946739);
        MConversionRate cr = this.createConversionRate(euro.getC_Currency_ID(), usd.getC_Currency_ID(), C_ConversionType_ID, date, eurToUsd, false);
        int M_PriceList_ID = DictionaryIDs.M_PriceList.EXPORT.id;
        try {
            MInvoice invoice1 = this.createInvoice(true, bpartner, date, M_PriceList_ID, C_ConversionType_ID);
            BigDecimal qty = BigDecimal.ONE;
            BigDecimal price = new BigDecimal(9362.5);
            this.createInvoiceLine(invoice1, 10, null, charge, qty, price);
            this.completeDocument((PO)invoice1);
            this.postDocument((PO)invoice1);
            MInvoice invoice2 = this.createInvoice(true, bpartner, date, M_PriceList_ID, C_ConversionType_ID);
            qty = BigDecimal.ONE;
            price = new BigDecimal(9362.5);
            this.createInvoiceLine(invoice2, 10, null, charge, qty, price);
            this.completeDocument((PO)invoice2);
            this.postDocument((PO)invoice2);
            MInvoice invoice3 = this.createInvoice(true, bpartner, date, M_PriceList_ID, C_ConversionType_ID);
            qty = BigDecimal.ONE;
            price = new BigDecimal(2587.26);
            this.createInvoiceLine(invoice3, 10, null, charge, qty, price);
            this.completeDocument((PO)invoice3);
            this.postDocument((PO)invoice3);
            MInvoice invoice4 = this.createInvoice(true, bpartner, date, M_PriceList_ID, C_ConversionType_ID);
            qty = BigDecimal.ONE;
            price = new BigDecimal(14519.9);
            this.createInvoiceLine(invoice4, 10, null, charge, qty, price);
            this.completeDocument((PO)invoice4);
            this.postDocument((PO)invoice4);
            MInvoice invoice5 = this.createInvoice(true, bpartner, date, M_PriceList_ID, C_ConversionType_ID);
            qty = BigDecimal.ONE;
            price = new BigDecimal(14329.44);
            this.createInvoiceLine(invoice5, 10, null, charge, qty, price);
            this.completeDocument((PO)invoice5);
            this.postDocument((PO)invoice5);
            MInvoice creditMemo1 = this.createCreditMemo(true, bpartner, date, M_PriceList_ID, C_ConversionType_ID);
            qty = BigDecimal.ONE;
            price = new BigDecimal(936.25);
            this.createInvoiceLine(creditMemo1, 10, null, charge, qty, price);
            this.completeDocument((PO)creditMemo1);
            this.postDocument((PO)creditMemo1);
            MInvoice creditMemo2 = this.createCreditMemo(true, bpartner, date, M_PriceList_ID, C_ConversionType_ID);
            qty = BigDecimal.ONE;
            price = new BigDecimal(936.25);
            this.createInvoiceLine(creditMemo2, 10, null, charge, qty, price);
            this.completeDocument((PO)creditMemo2);
            this.postDocument((PO)creditMemo2);
            MBankAccount ba = this.getBankAccount(usd.getC_Currency_ID());
            BigDecimal payAmt = new BigDecimal(48289.1);
            MPayment payment = this.createPayment(true, bpartner, ba.getC_BankAccount_ID(), date, payAmt, euro.getC_Currency_ID(), C_ConversionType_ID);
            this.completeDocument((PO)payment);
            this.postDocument((PO)payment);
            MAllocationHdr alloc = this.createAllocationHdr(date, euro.getC_Currency_ID());
            this.createAllocationLine(alloc, invoice1.getGrandTotal(), invoice1, payment);
            this.createAllocationLine(alloc, invoice2.getGrandTotal(), invoice2, payment);
            this.createAllocationLine(alloc, invoice3.getGrandTotal(), invoice3, payment);
            this.createAllocationLine(alloc, invoice4.getGrandTotal(), invoice4, payment);
            this.createAllocationLine(alloc, invoice5.getGrandTotal(), invoice5, payment);
            this.createAllocationLine(alloc, creditMemo1.getGrandTotal().negate(), creditMemo1, payment);
            this.createAllocationLine(alloc, creditMemo2.getGrandTotal().negate(), creditMemo2, payment);
            this.completeDocument((PO)alloc);
            this.postDocument((PO)alloc);
            MAcctSchema[] ass = MAcctSchema.getClientAcctSchema((Properties)Env.getCtx(), (int)Env.getAD_Client_ID((Properties)Env.getCtx()));
            MAllocationHdr[] allocList = MAllocationHdr.getOfPayment((Properties)Env.getCtx(), (int)payment.getC_Payment_ID(), (String)this.getTrxName());
            ArrayList<PostingLine> paymentLineList = new ArrayList<PostingLine>();
            ArrayList<PostingLine> tradeLineList = new ArrayList<PostingLine>();
            BigDecimal accountedDrAmt = this.getAccountedAmount(usd, invoice1.getGrandTotal(), cr.getMultiplyRate());
            BigDecimal accountedCrAmt = this.getAccountedAmount(usd, invoice1.getGrandTotal(), cr.getMultiplyRate());
            paymentLineList.add(new PostingLine(usd, accountedDrAmt, Env.ZERO));
            tradeLineList.add(new PostingLine(usd, Env.ZERO, accountedCrAmt));
            accountedDrAmt = this.getAccountedAmount(usd, invoice2.getGrandTotal(), cr.getMultiplyRate());
            accountedCrAmt = this.getAccountedAmount(usd, invoice2.getGrandTotal(), cr.getMultiplyRate());
            paymentLineList.add(new PostingLine(usd, accountedDrAmt, Env.ZERO));
            tradeLineList.add(new PostingLine(usd, Env.ZERO, accountedCrAmt));
            accountedDrAmt = this.getAccountedAmount(usd, invoice3.getGrandTotal(), cr.getMultiplyRate());
            accountedCrAmt = this.getAccountedAmount(usd, invoice3.getGrandTotal(), cr.getMultiplyRate());
            paymentLineList.add(new PostingLine(usd, accountedDrAmt, Env.ZERO));
            tradeLineList.add(new PostingLine(usd, Env.ZERO, accountedCrAmt));
            accountedDrAmt = this.getAccountedAmount(usd, invoice4.getGrandTotal(), cr.getMultiplyRate());
            accountedCrAmt = this.getAccountedAmount(usd, invoice4.getGrandTotal(), cr.getMultiplyRate());
            paymentLineList.add(new PostingLine(usd, accountedDrAmt, Env.ZERO));
            tradeLineList.add(new PostingLine(usd, Env.ZERO, accountedCrAmt));
            accountedDrAmt = this.getAccountedAmount(usd, invoice5.getGrandTotal(), cr.getMultiplyRate());
            accountedCrAmt = this.getAccountedAmount(usd, invoice5.getGrandTotal(), cr.getMultiplyRate());
            paymentLineList.add(new PostingLine(usd, accountedDrAmt, Env.ZERO));
            tradeLineList.add(new PostingLine(usd, Env.ZERO, accountedCrAmt));
            accountedCrAmt = this.getAccountedAmount(usd, creditMemo1.getGrandTotal(), cr.getMultiplyRate());
            accountedDrAmt = this.getAccountedAmount(usd, creditMemo1.getGrandTotal(), cr.getMultiplyRate());
            paymentLineList.add(new PostingLine(usd, Env.ZERO, accountedCrAmt));
            tradeLineList.add(new PostingLine(usd, accountedDrAmt, Env.ZERO));
            accountedCrAmt = this.getAccountedAmount(usd, creditMemo2.getGrandTotal(), cr.getMultiplyRate());
            accountedDrAmt = this.getAccountedAmount(usd, creditMemo2.getGrandTotal(), cr.getMultiplyRate());
            paymentLineList.add(new PostingLine(usd, Env.ZERO, accountedCrAmt));
            tradeLineList.add(new PostingLine(usd, accountedDrAmt, Env.ZERO));
            this.testAllocationPosting(ass, allocList, paymentLineList, tradeLineList, null, null);
        }
        finally {
            this.rollback();
            this.deleteConversionRate(cr);
        }
    }

    @Test
    @ResourceLock(value="C_Conversion_Rate")
    public void testAllocateInvoicePaymentPosting_7() {
        MBPartner bpartner = MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.SEED_FARM.id, (String)this.getTrxName());
        DB.getDatabase().forUpdate((PO)bpartner, 0);
        MCharge charge = MCharge.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_Charge.FREIGHT.id);
        Timestamp currentDate = Env.getContextAsDate((Properties)Env.getCtx(), (String)"#Date");
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(currentDate.getTime());
        cal.add(5, -1);
        Timestamp date1 = new Timestamp(cal.getTimeInMillis());
        Timestamp date2 = currentDate;
        int C_ConversionType_ID = DictionaryIDs.C_ConversionType.COMPANY.id;
        MCurrency usd = MCurrency.get((int)DictionaryIDs.C_Currency.USD.id);
        MCurrency euro = MCurrency.get((int)DictionaryIDs.C_Currency.EUR.id);
        BigDecimal eurToUsd1 = new BigDecimal(30.212666962751);
        MConversionRate cr1 = this.createConversionRate(euro.getC_Currency_ID(), usd.getC_Currency_ID(), C_ConversionType_ID, date1, eurToUsd1, false);
        BigDecimal eurToUsd2 = new BigDecimal(29.905289946739);
        MConversionRate cr2 = this.createConversionRate(euro.getC_Currency_ID(), usd.getC_Currency_ID(), C_ConversionType_ID, date2, eurToUsd2, false);
        int M_PriceList_ID = DictionaryIDs.M_PriceList.EXPORT.id;
        try {
            MBankAccount ba = this.getBankAccount(usd.getC_Currency_ID());
            BigDecimal payAmt = new BigDecimal(12000);
            MPayment payment = this.createPayment(true, bpartner, ba.getC_BankAccount_ID(), date1, payAmt, euro.getC_Currency_ID(), C_ConversionType_ID);
            this.completeDocument((PO)payment);
            this.postDocument((PO)payment);
            MInvoice invoice1 = this.createInvoice(true, bpartner, date2, M_PriceList_ID, C_ConversionType_ID);
            BigDecimal qty = BigDecimal.ONE;
            BigDecimal price = new BigDecimal(10700);
            this.createInvoiceLine(invoice1, 10, null, charge, qty, price);
            this.completeDocument((PO)invoice1);
            this.postDocument((PO)invoice1);
            MAllocationHdr alloc1 = this.createAllocationHdr(date2, euro.getC_Currency_ID());
            BigDecimal allocAmount = new BigDecimal(10700);
            this.createAllocationLine(alloc1, allocAmount, invoice1, payment);
            this.completeDocument((PO)alloc1);
            this.postDocument((PO)alloc1);
            MAcctSchema[] ass = MAcctSchema.getClientAcctSchema((Properties)Env.getCtx(), (int)Env.getAD_Client_ID((Properties)Env.getCtx()));
            MAllocationHdr[] allocList = MAllocationHdr.getOfInvoice((Properties)Env.getCtx(), (int)invoice1.getC_Invoice_ID(), (String)this.getTrxName());
            ArrayList<PostingLine> paymentLineList = new ArrayList<PostingLine>();
            ArrayList<PostingLine> tradeLineList = new ArrayList<PostingLine>();
            ArrayList<PostingLine> gainLossLineList = new ArrayList<PostingLine>();
            BigDecimal accountedDrAmt = this.getAccountedAmount(usd, allocAmount, cr1.getMultiplyRate());
            BigDecimal accountedCrAmt = this.getAccountedAmount(usd, allocAmount, cr2.getMultiplyRate());
            paymentLineList.add(new PostingLine(usd, accountedDrAmt, Env.ZERO));
            tradeLineList.add(new PostingLine(usd, Env.ZERO, accountedCrAmt));
            BigDecimal gainLossAmt = new BigDecimal(3.64).setScale(usd.getStdPrecision(), RoundingMode.HALF_UP);
            gainLossLineList.add(new PostingLine(usd, gainLossAmt, Env.ZERO));
            this.testAllocationPosting(ass, allocList, paymentLineList, tradeLineList, gainLossLineList, null);
            MInvoice invoice2 = this.createInvoice(true, bpartner, date2, M_PriceList_ID, C_ConversionType_ID);
            qty = BigDecimal.ONE;
            price = new BigDecimal(1300);
            this.createInvoiceLine(invoice2, 10, null, charge, qty, price);
            this.completeDocument((PO)invoice2);
            this.postDocument((PO)invoice2);
            MAllocationHdr alloc2 = this.createAllocationHdr(date2, euro.getC_Currency_ID());
            allocAmount = new BigDecimal(1300);
            this.createAllocationLine(alloc2, allocAmount, invoice2, payment);
            this.completeDocument((PO)alloc2);
            this.postDocument((PO)alloc2);
            allocList = MAllocationHdr.getOfInvoice((Properties)Env.getCtx(), (int)invoice2.getC_Invoice_ID(), (String)this.getTrxName());
            paymentLineList = new ArrayList();
            tradeLineList = new ArrayList();
            ArrayList<PostingLine> currBalLineList = new ArrayList<PostingLine>();
            accountedDrAmt = this.getAccountedAmount(usd, allocAmount, cr1.getMultiplyRate());
            accountedCrAmt = this.getAccountedAmount(usd, allocAmount, cr2.getMultiplyRate());
            paymentLineList.add(new PostingLine(usd, accountedDrAmt, Env.ZERO));
            tradeLineList.add(new PostingLine(usd, Env.ZERO, accountedCrAmt));
            BigDecimal currBalAmt = new BigDecimal(0.01).setScale(usd.getStdPrecision(), RoundingMode.HALF_UP);
            paymentLineList.add(new PostingLine(usd, Env.ZERO, currBalAmt));
            currBalLineList.add(new PostingLine(usd, currBalAmt, Env.ZERO));
            this.testAllocationPosting(ass, allocList, paymentLineList, tradeLineList, null, currBalLineList);
        }
        finally {
            this.rollback();
            this.deleteConversionRate(cr1);
            this.deleteConversionRate(cr2);
        }
    }

    @Test
    @ResourceLock(value="C_Conversion_Rate")
    public void testAllocateInvoicePaymentPosting_8() {
        Timestamp currentDate;
        MBPartner bpartner = MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.PATIO.id, (String)this.getTrxName());
        MCharge charge = MCharge.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_Charge.FREIGHT.id);
        Timestamp date = currentDate = Env.getContextAsDate((Properties)Env.getCtx(), (String)"#Date");
        int C_ConversionType_ID = DictionaryIDs.C_ConversionType.COMPANY.id;
        MCurrency usd = MCurrency.get((int)DictionaryIDs.C_Currency.USD.id);
        MCurrency euro = MCurrency.get((int)DictionaryIDs.C_Currency.EUR.id);
        BigDecimal eurToUsd = new BigDecimal(30.212666962751);
        MConversionRate cr = this.createConversionRate(euro.getC_Currency_ID(), usd.getC_Currency_ID(), C_ConversionType_ID, date, eurToUsd, false);
        int M_PriceList_ID = DictionaryIDs.M_PriceList.EXPORT.id;
        try {
            MBankAccount ba = this.getBankAccount(usd.getC_Currency_ID());
            BigDecimal payAmt = new BigDecimal(12000);
            DB.getDatabase().forUpdate((PO)bpartner, 0);
            MPayment payment = this.createPayment(true, bpartner, ba.getC_BankAccount_ID(), date, payAmt, euro.getC_Currency_ID(), C_ConversionType_ID);
            this.completeDocument((PO)payment);
            this.postDocument((PO)payment);
            MInvoice invoice1 = this.createInvoice(true, bpartner, date, M_PriceList_ID, C_ConversionType_ID);
            BigDecimal qty = BigDecimal.ONE;
            BigDecimal price = new BigDecimal(10700);
            this.createInvoiceLine(invoice1, 10, null, charge, qty, price);
            this.completeDocument((PO)invoice1);
            this.postDocument((PO)invoice1);
            MAllocationHdr alloc1 = this.createAllocationHdr(date, euro.getC_Currency_ID());
            BigDecimal allocAmount = new BigDecimal(10700);
            this.createAllocationLine(alloc1, allocAmount, invoice1, payment);
            this.completeDocument((PO)alloc1);
            this.postDocument((PO)alloc1);
            MAcctSchema[] ass = MAcctSchema.getClientAcctSchema((Properties)Env.getCtx(), (int)Env.getAD_Client_ID((Properties)Env.getCtx()));
            MAllocationHdr[] allocList = MAllocationHdr.getOfInvoice((Properties)Env.getCtx(), (int)invoice1.getC_Invoice_ID(), (String)this.getTrxName());
            ArrayList<PostingLine> paymentLineList = new ArrayList<PostingLine>();
            ArrayList<PostingLine> tradeLineList = new ArrayList<PostingLine>();
            BigDecimal accountedDrAmt = this.getAccountedAmount(usd, allocAmount, cr.getMultiplyRate());
            BigDecimal accountedCrAmt = this.getAccountedAmount(usd, allocAmount, cr.getMultiplyRate());
            paymentLineList.add(new PostingLine(usd, accountedDrAmt, Env.ZERO));
            tradeLineList.add(new PostingLine(usd, Env.ZERO, accountedCrAmt));
            this.testAllocationPosting(ass, allocList, paymentLineList, tradeLineList, null, null);
            MInvoice invoice2 = this.createInvoice(true, bpartner, date, M_PriceList_ID, C_ConversionType_ID);
            qty = BigDecimal.ONE;
            price = new BigDecimal(1300);
            this.createInvoiceLine(invoice2, 10, null, charge, qty, price);
            this.completeDocument((PO)invoice2);
            this.postDocument((PO)invoice2);
            MAllocationHdr alloc2 = this.createAllocationHdr(date, euro.getC_Currency_ID());
            allocAmount = new BigDecimal(1300);
            this.createAllocationLine(alloc2, allocAmount, invoice2, payment);
            this.completeDocument((PO)alloc2);
            this.postDocument((PO)alloc2);
            allocList = MAllocationHdr.getOfInvoice((Properties)Env.getCtx(), (int)invoice2.getC_Invoice_ID(), (String)this.getTrxName());
            paymentLineList = new ArrayList();
            tradeLineList = new ArrayList();
            ArrayList<PostingLine> currBalLineList = new ArrayList<PostingLine>();
            accountedDrAmt = this.getAccountedAmount(usd, allocAmount, cr.getMultiplyRate());
            accountedCrAmt = this.getAccountedAmount(usd, allocAmount, cr.getMultiplyRate());
            paymentLineList.add(new PostingLine(usd, accountedDrAmt, Env.ZERO));
            tradeLineList.add(new PostingLine(usd, Env.ZERO, accountedCrAmt));
            BigDecimal currBalAmt = new BigDecimal(0.01).setScale(usd.getStdPrecision(), RoundingMode.HALF_UP);
            paymentLineList.add(new PostingLine(usd, Env.ZERO, currBalAmt));
            currBalLineList.add(new PostingLine(usd, currBalAmt, Env.ZERO));
            this.testAllocationPosting(ass, allocList, paymentLineList, tradeLineList, null, currBalLineList);
        }
        finally {
            this.rollback();
            this.deleteConversionRate(cr);
        }
    }

    @Test
    @ResourceLock(value="C_Conversion_Rate")
    public void testAllocateInvoicePaymentPosting_9() {
        MBPartner bpartner = MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.AGRI_TECH.id, (String)this.getTrxName());
        DB.getDatabase().forUpdate((PO)bpartner, 0);
        MCharge charge = MCharge.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_Charge.FREIGHT.id);
        Timestamp currentDate = Env.getContextAsDate((Properties)Env.getCtx(), (String)"#Date");
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(currentDate.getTime());
        cal.add(5, -1);
        Timestamp date1 = new Timestamp(cal.getTimeInMillis());
        Timestamp date2 = currentDate;
        int C_ConversionType_ID = DictionaryIDs.C_ConversionType.COMPANY.id;
        MCurrency usd = MCurrency.get((int)DictionaryIDs.C_Currency.USD.id);
        MCurrency euro = MCurrency.get((int)DictionaryIDs.C_Currency.EUR.id);
        BigDecimal eurToUsd1 = new BigDecimal(30.212666962751);
        MConversionRate cr1 = this.createConversionRate(euro.getC_Currency_ID(), usd.getC_Currency_ID(), C_ConversionType_ID, date1, eurToUsd1, false);
        BigDecimal eurToUsd2 = new BigDecimal(29.905289946739);
        MConversionRate cr2 = this.createConversionRate(euro.getC_Currency_ID(), usd.getC_Currency_ID(), C_ConversionType_ID, date2, eurToUsd2, false);
        int M_PriceList_ID = DictionaryIDs.M_PriceList.EXPORT.id;
        try {
            MBankAccount ba = this.getBankAccount(usd.getC_Currency_ID());
            MInvoice invoice = this.createInvoice(true, bpartner, date1, M_PriceList_ID, C_ConversionType_ID);
            BigDecimal qty = BigDecimal.ONE;
            BigDecimal price = new BigDecimal(12000);
            this.createInvoiceLine(invoice, 10, null, charge, qty, price);
            this.completeDocument((PO)invoice);
            this.postDocument((PO)invoice);
            BigDecimal payAmt = new BigDecimal(10700);
            MPayment payment1 = this.createPayment(true, bpartner, ba.getC_BankAccount_ID(), date2, payAmt, euro.getC_Currency_ID(), C_ConversionType_ID);
            this.completeDocument((PO)payment1);
            this.postDocument((PO)payment1);
            MAllocationHdr alloc1 = this.createAllocationHdr(date2, euro.getC_Currency_ID());
            BigDecimal allocAmount = new BigDecimal(10700);
            this.createAllocationLine(alloc1, allocAmount, invoice, payment1);
            this.completeDocument((PO)alloc1);
            this.postDocument((PO)alloc1);
            MAcctSchema[] ass = MAcctSchema.getClientAcctSchema((Properties)Env.getCtx(), (int)Env.getAD_Client_ID((Properties)Env.getCtx()));
            MAllocationHdr[] allocList = MAllocationHdr.getOfPayment((Properties)Env.getCtx(), (int)payment1.getC_Payment_ID(), (String)this.getTrxName());
            ArrayList<PostingLine> paymentLineList = new ArrayList<PostingLine>();
            ArrayList<PostingLine> tradeLineList = new ArrayList<PostingLine>();
            ArrayList<PostingLine> gainLossLineList = new ArrayList<PostingLine>();
            BigDecimal accountedDrAmt = this.getAccountedAmount(usd, allocAmount, cr2.getMultiplyRate());
            BigDecimal accountedCrAmt = this.getAccountedAmount(usd, allocAmount, cr1.getMultiplyRate());
            paymentLineList.add(new PostingLine(usd, accountedDrAmt, Env.ZERO));
            tradeLineList.add(new PostingLine(usd, Env.ZERO, accountedCrAmt));
            BigDecimal gainLossAmt = new BigDecimal(3.64).setScale(usd.getStdPrecision(), RoundingMode.HALF_UP);
            gainLossLineList.add(new PostingLine(usd, Env.ZERO, gainLossAmt));
            this.testAllocationPosting(ass, allocList, paymentLineList, tradeLineList, gainLossLineList, null);
            payAmt = new BigDecimal(1300);
            MPayment payment2 = this.createPayment(true, bpartner, ba.getC_BankAccount_ID(), date2, payAmt, euro.getC_Currency_ID(), C_ConversionType_ID);
            this.completeDocument((PO)payment2);
            this.postDocument((PO)payment2);
            MAllocationHdr alloc2 = this.createAllocationHdr(date2, euro.getC_Currency_ID());
            allocAmount = new BigDecimal(1300);
            this.createAllocationLine(alloc2, allocAmount, invoice, payment2);
            this.completeDocument((PO)alloc2);
            this.postDocument((PO)alloc2);
            allocList = MAllocationHdr.getOfPayment((Properties)Env.getCtx(), (int)payment2.getC_Payment_ID(), (String)this.getTrxName());
            paymentLineList = new ArrayList();
            tradeLineList = new ArrayList();
            ArrayList<PostingLine> currBalLineList = new ArrayList<PostingLine>();
            accountedDrAmt = this.getAccountedAmount(usd, allocAmount, cr2.getMultiplyRate());
            accountedCrAmt = this.getAccountedAmount(usd, allocAmount, cr1.getMultiplyRate());
            paymentLineList.add(new PostingLine(usd, accountedDrAmt, Env.ZERO));
            tradeLineList.add(new PostingLine(usd, Env.ZERO, accountedCrAmt));
            BigDecimal currBalAmt = new BigDecimal(0.01).setScale(usd.getStdPrecision(), RoundingMode.HALF_UP);
            tradeLineList.add(new PostingLine(usd, currBalAmt, Env.ZERO));
            currBalLineList.add(new PostingLine(usd, Env.ZERO, currBalAmt));
            this.testAllocationPosting(ass, allocList, paymentLineList, tradeLineList, null, currBalLineList);
        }
        finally {
            this.rollback();
            this.deleteConversionRate(cr1);
            this.deleteConversionRate(cr2);
        }
    }

    @Test
    @ResourceLock(value="C_Conversion_Rate")
    public void testAllocateInvoicePaymentPosting_10() {
        Timestamp currentDate;
        MBPartner bpartner = MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.JOE_BLOCK.id);
        MCharge charge = MCharge.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_Charge.FREIGHT.id);
        Timestamp date = currentDate = Env.getContextAsDate((Properties)Env.getCtx(), (String)"#Date");
        int C_ConversionType_ID = DictionaryIDs.C_ConversionType.COMPANY.id;
        MCurrency usd = MCurrency.get((int)DictionaryIDs.C_Currency.USD.id);
        MCurrency euro = MCurrency.get((int)DictionaryIDs.C_Currency.EUR.id);
        BigDecimal eurToUsd = new BigDecimal(30.212666962751);
        MConversionRate cr = this.createConversionRate(euro.getC_Currency_ID(), usd.getC_Currency_ID(), C_ConversionType_ID, date, eurToUsd, false);
        int M_PriceList_ID = DictionaryIDs.M_PriceList.EXPORT.id;
        try {
            MBankAccount ba = this.getBankAccount(usd.getC_Currency_ID());
            MInvoice invoice = this.createInvoice(true, bpartner, date, M_PriceList_ID, C_ConversionType_ID);
            BigDecimal qty = BigDecimal.ONE;
            BigDecimal price = new BigDecimal(12000);
            this.createInvoiceLine(invoice, 10, null, charge, qty, price);
            this.completeDocument((PO)invoice);
            this.postDocument((PO)invoice);
            BigDecimal payAmt = new BigDecimal(10700);
            MPayment payment1 = this.createPayment(true, bpartner, ba.getC_BankAccount_ID(), date, payAmt, euro.getC_Currency_ID(), C_ConversionType_ID);
            this.completeDocument((PO)payment1);
            this.postDocument((PO)payment1);
            MAllocationHdr alloc1 = this.createAllocationHdr(date, euro.getC_Currency_ID());
            BigDecimal allocAmount = new BigDecimal(10700);
            this.createAllocationLine(alloc1, allocAmount, invoice, payment1);
            this.completeDocument((PO)alloc1);
            this.postDocument((PO)alloc1);
            MAcctSchema[] ass = MAcctSchema.getClientAcctSchema((Properties)Env.getCtx(), (int)Env.getAD_Client_ID((Properties)Env.getCtx()));
            MAllocationHdr[] allocList = MAllocationHdr.getOfPayment((Properties)Env.getCtx(), (int)payment1.getC_Payment_ID(), (String)this.getTrxName());
            ArrayList<PostingLine> paymentLineList = new ArrayList<PostingLine>();
            ArrayList<PostingLine> tradeLineList = new ArrayList<PostingLine>();
            BigDecimal accountedDrAmt = this.getAccountedAmount(usd, allocAmount, cr.getMultiplyRate());
            BigDecimal accountedCrAmt = this.getAccountedAmount(usd, allocAmount, cr.getMultiplyRate());
            paymentLineList.add(new PostingLine(usd, accountedDrAmt, Env.ZERO));
            tradeLineList.add(new PostingLine(usd, Env.ZERO, accountedCrAmt));
            this.testAllocationPosting(ass, allocList, paymentLineList, tradeLineList, null, null);
            payAmt = new BigDecimal(1300);
            MPayment payment2 = this.createPayment(true, bpartner, ba.getC_BankAccount_ID(), date, payAmt, euro.getC_Currency_ID(), C_ConversionType_ID);
            this.completeDocument((PO)payment2);
            this.postDocument((PO)payment2);
            MAllocationHdr alloc2 = this.createAllocationHdr(date, euro.getC_Currency_ID());
            allocAmount = new BigDecimal(1300);
            this.createAllocationLine(alloc2, allocAmount, invoice, payment2);
            this.completeDocument((PO)alloc2);
            this.postDocument((PO)alloc2);
            allocList = MAllocationHdr.getOfPayment((Properties)Env.getCtx(), (int)payment2.getC_Payment_ID(), (String)this.getTrxName());
            paymentLineList = new ArrayList();
            tradeLineList = new ArrayList();
            ArrayList<PostingLine> currBalLineList = new ArrayList<PostingLine>();
            accountedDrAmt = this.getAccountedAmount(usd, allocAmount, cr.getMultiplyRate());
            accountedCrAmt = this.getAccountedAmount(usd, allocAmount, cr.getMultiplyRate());
            paymentLineList.add(new PostingLine(usd, accountedDrAmt, Env.ZERO));
            tradeLineList.add(new PostingLine(usd, Env.ZERO, accountedCrAmt));
            BigDecimal currBalAmt = new BigDecimal(0.01).setScale(usd.getStdPrecision(), RoundingMode.HALF_UP);
            tradeLineList.add(new PostingLine(usd, currBalAmt, Env.ZERO));
            currBalLineList.add(new PostingLine(usd, Env.ZERO, currBalAmt));
            this.testAllocationPosting(ass, allocList, paymentLineList, tradeLineList, null, currBalLineList);
        }
        finally {
            this.rollback();
            this.deleteConversionRate(cr);
        }
    }

    @Test
    @ResourceLock(value="C_Conversion_Rate")
    public void testAllocateInvoicePaymentPosting_11() {
        MBPartner bpartner = MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.C_AND_W.id);
        MCharge charge = MCharge.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_Charge.FREIGHT.id);
        Timestamp currentDate = Env.getContextAsDate((Properties)Env.getCtx(), (String)"#Date");
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(currentDate.getTime());
        cal.add(5, -2);
        Timestamp date1 = new Timestamp(cal.getTimeInMillis());
        cal.setTimeInMillis(currentDate.getTime());
        cal.add(5, -1);
        Timestamp date2 = new Timestamp(cal.getTimeInMillis());
        Timestamp date3 = currentDate;
        int C_ConversionType_ID = DictionaryIDs.C_ConversionType.SPOT.id;
        MCurrency aud = MCurrency.get((int)DictionaryIDs.C_Currency.AUD.id);
        MCurrency eur = MCurrency.get((int)DictionaryIDs.C_Currency.EUR.id);
        MCurrency usd = MCurrency.get((int)DictionaryIDs.C_Currency.USD.id);
        BigDecimal audToEur = new BigDecimal(0.7);
        MConversionRate cr1a = this.createConversionRate(aud.getC_Currency_ID(), eur.getC_Currency_ID(), C_ConversionType_ID, date1, audToEur, true);
        BigDecimal audToUsd = new BigDecimal(0.8);
        MConversionRate cr1b = this.createConversionRate(aud.getC_Currency_ID(), usd.getC_Currency_ID(), C_ConversionType_ID, date1, audToUsd, true);
        audToEur = new BigDecimal(0.8);
        MConversionRate cr2a = this.createConversionRate(aud.getC_Currency_ID(), eur.getC_Currency_ID(), C_ConversionType_ID, date2, audToEur, true);
        audToUsd = new BigDecimal(0.9);
        MConversionRate cr2b = this.createConversionRate(aud.getC_Currency_ID(), usd.getC_Currency_ID(), C_ConversionType_ID, date2, audToUsd, true);
        audToEur = new BigDecimal(0.8);
        MConversionRate cr3a = this.createConversionRate(aud.getC_Currency_ID(), eur.getC_Currency_ID(), C_ConversionType_ID, date3, audToEur, true);
        audToUsd = new BigDecimal(0.9);
        MConversionRate cr3b = this.createConversionRate(aud.getC_Currency_ID(), usd.getC_Currency_ID(), C_ConversionType_ID, date3, audToUsd, true);
        MPriceList priceList = new MPriceList(Env.getCtx(), 0, null);
        priceList.setName("Export AUD " + System.currentTimeMillis());
        MCurrency australianDollar = MCurrency.get((int)DictionaryIDs.C_Currency.AUD.id);
        priceList.setC_Currency_ID(australianDollar.getC_Currency_ID());
        priceList.setPricePrecision(australianDollar.getStdPrecision());
        priceList.saveEx();
        MPriceListVersion plv = new MPriceListVersion(priceList);
        plv.setM_DiscountSchema_ID(DictionaryIDs.M_DiscountSchema.SALES_2001.id);
        plv.setValidFrom(currentDate);
        plv.saveEx();
        try {
            MBankAccount ba = this.getBankAccount(usd.getC_Currency_ID());
            MInvoice invoice = this.createInvoice(true, bpartner, date1, priceList.getM_PriceList_ID(), C_ConversionType_ID);
            BigDecimal qty = BigDecimal.ONE;
            BigDecimal price = new BigDecimal(1000);
            this.createInvoiceLine(invoice, 10, null, charge, qty, price);
            this.completeDocument((PO)invoice);
            this.postDocument((PO)invoice);
            BigDecimal payAmt = new BigDecimal(1000);
            MPayment payment = this.createPayment(true, bpartner, ba.getC_BankAccount_ID(), date2, payAmt, aud.getC_Currency_ID(), C_ConversionType_ID);
            this.completeDocument((PO)payment);
            this.postDocument((PO)payment);
            MAllocationHdr alloc = this.createAllocationHdr(date2, aud.getC_Currency_ID());
            BigDecimal allocAmount = new BigDecimal(1000);
            this.createAllocationLine(alloc, allocAmount, invoice, payment);
            this.completeDocument((PO)alloc);
            this.postDocument((PO)alloc);
            MAcctSchema[] ass = MAcctSchema.getClientAcctSchema((Properties)Env.getCtx(), (int)Env.getAD_Client_ID((Properties)Env.getCtx()));
            MAllocationHdr[] allocList = MAllocationHdr.getOfPayment((Properties)Env.getCtx(), (int)payment.getC_Payment_ID(), (String)this.getTrxName());
            ArrayList<PostingLine> paymentLineList = new ArrayList<PostingLine>();
            ArrayList<PostingLine> tradeLineList = new ArrayList<PostingLine>();
            ArrayList<PostingLine> gainLossLineList = new ArrayList<PostingLine>();
            BigDecimal accountedDrAmt = this.getAccountedAmount(usd, allocAmount, cr2b.getMultiplyRate());
            BigDecimal accountedCrAmt = this.getAccountedAmount(usd, allocAmount, cr2b.getMultiplyRate());
            paymentLineList.add(new PostingLine(usd, accountedDrAmt, Env.ZERO));
            tradeLineList.add(new PostingLine(usd, Env.ZERO, accountedCrAmt));
            BigDecimal gainLossAmt = new BigDecimal(100).setScale(usd.getStdPrecision(), RoundingMode.HALF_UP);
            gainLossLineList.add(new PostingLine(usd, Env.ZERO, gainLossAmt));
            tradeLineList.add(new PostingLine(usd, gainLossAmt, Env.ZERO));
            this.testAllocationPosting(ass, allocList, paymentLineList, tradeLineList, gainLossLineList, null);
            paymentLineList = new ArrayList();
            tradeLineList = new ArrayList();
            gainLossLineList = new ArrayList();
            accountedDrAmt = this.getAccountedAmount(eur, allocAmount, cr2a.getMultiplyRate());
            accountedCrAmt = this.getAccountedAmount(eur, allocAmount, cr2a.getMultiplyRate());
            paymentLineList.add(new PostingLine(eur, accountedDrAmt, Env.ZERO));
            tradeLineList.add(new PostingLine(eur, Env.ZERO, accountedCrAmt));
            gainLossAmt = new BigDecimal(100).setScale(eur.getStdPrecision(), RoundingMode.HALF_UP);
            gainLossLineList.add(new PostingLine(eur, Env.ZERO, gainLossAmt));
            tradeLineList.add(new PostingLine(eur, gainLossAmt, Env.ZERO));
            this.testAllocationPosting(ass, allocList, paymentLineList, tradeLineList, gainLossLineList, null);
            this.reverseDocument((PO)payment, false);
            MPayment reversalPayment = new MPayment(Env.getCtx(), payment.getReversal_ID(), this.getTrxName());
            this.postDocument((PO)reversalPayment);
            MAllocationHdr reversalAlloc = null;
            MAllocationHdr[] mAllocationHdrArray = allocList = MAllocationHdr.getOfPayment((Properties)Env.getCtx(), (int)payment.getC_Payment_ID(), (String)this.getTrxName());
            int n = allocList.length;
            int n2 = 0;
            while (n2 < n) {
                MAllocationHdr allocation = mAllocationHdrArray[n2];
                if (allocation.getReversal_ID() > 0 && allocation.getReversal_ID() < allocation.get_ID()) {
                    reversalAlloc = allocation;
                    break;
                }
                ++n2;
            }
            if (reversalAlloc == null) {
                reversalAlloc = new MAllocationHdr(Env.getCtx(), alloc.getReversal_ID(), this.getTrxName());
            }
            allocList = new MAllocationHdr[]{reversalAlloc};
            paymentLineList = new ArrayList();
            tradeLineList = new ArrayList();
            gainLossLineList = new ArrayList();
            accountedDrAmt = this.getAccountedAmount(usd, allocAmount, cr3b.getMultiplyRate());
            accountedCrAmt = this.getAccountedAmount(usd, allocAmount, cr3b.getMultiplyRate());
            tradeLineList.add(new PostingLine(usd, accountedDrAmt, Env.ZERO));
            paymentLineList.add(new PostingLine(usd, Env.ZERO, accountedCrAmt));
            gainLossAmt = new BigDecimal(100).setScale(usd.getStdPrecision(), RoundingMode.HALF_UP);
            gainLossLineList.add(new PostingLine(usd, gainLossAmt, Env.ZERO));
            tradeLineList.add(new PostingLine(usd, Env.ZERO, gainLossAmt));
            this.testAllocationPosting(ass, allocList, paymentLineList, tradeLineList, gainLossLineList, null);
            paymentLineList = new ArrayList();
            tradeLineList = new ArrayList();
            gainLossLineList = new ArrayList();
            accountedDrAmt = this.getAccountedAmount(eur, allocAmount, cr3a.getMultiplyRate());
            accountedCrAmt = this.getAccountedAmount(eur, allocAmount, cr3a.getMultiplyRate());
            tradeLineList.add(new PostingLine(eur, accountedDrAmt, Env.ZERO));
            paymentLineList.add(new PostingLine(eur, Env.ZERO, accountedCrAmt));
            gainLossAmt = new BigDecimal(100).setScale(eur.getStdPrecision(), RoundingMode.HALF_UP);
            gainLossLineList.add(new PostingLine(eur, gainLossAmt, Env.ZERO));
            tradeLineList.add(new PostingLine(eur, Env.ZERO, gainLossAmt));
            this.testAllocationPosting(ass, allocList, paymentLineList, tradeLineList, gainLossLineList, null);
        }
        finally {
            this.rollback();
            this.deleteConversionRate(cr1a);
            this.deleteConversionRate(cr1b);
            this.deleteConversionRate(cr2a);
            this.deleteConversionRate(cr2b);
            this.deleteConversionRate(cr3a);
            this.deleteConversionRate(cr3b);
            plv.deleteEx(true);
            priceList.deleteEx(true);
        }
    }

    @Test
    @ResourceLock(value="C_Conversion_Rate")
    public void testAllocateInvoicePaymentPosting_12() {
        MBPartner bpartner = MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.SEED_FARM.id);
        MCharge charge = MCharge.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_Charge.FREIGHT.id);
        Timestamp currentDate = Env.getContextAsDate((Properties)Env.getCtx(), (String)"#Date");
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(currentDate.getTime());
        cal.add(5, -2);
        Timestamp date1 = new Timestamp(cal.getTimeInMillis());
        cal.setTimeInMillis(currentDate.getTime());
        cal.add(5, -1);
        Timestamp date2 = new Timestamp(cal.getTimeInMillis());
        Timestamp date3 = currentDate;
        int C_ConversionType_ID = DictionaryIDs.C_ConversionType.SPOT.id;
        MCurrency aud = MCurrency.get((int)DictionaryIDs.C_Currency.AUD.id);
        MCurrency eur = MCurrency.get((int)DictionaryIDs.C_Currency.EUR.id);
        MCurrency usd = MCurrency.get((int)DictionaryIDs.C_Currency.USD.id);
        BigDecimal audToEur = new BigDecimal(0.7);
        MConversionRate cr1a = this.createConversionRate(aud.getC_Currency_ID(), eur.getC_Currency_ID(), C_ConversionType_ID, date1, audToEur, true);
        BigDecimal audToUsd = new BigDecimal(0.8);
        MConversionRate cr1b = this.createConversionRate(aud.getC_Currency_ID(), usd.getC_Currency_ID(), C_ConversionType_ID, date1, audToUsd, true);
        audToEur = new BigDecimal(0.8);
        MConversionRate cr2a = this.createConversionRate(aud.getC_Currency_ID(), eur.getC_Currency_ID(), C_ConversionType_ID, date2, audToEur, true);
        audToUsd = new BigDecimal(0.9);
        MConversionRate cr2b = this.createConversionRate(aud.getC_Currency_ID(), usd.getC_Currency_ID(), C_ConversionType_ID, date2, audToUsd, true);
        audToEur = new BigDecimal(0.8);
        MConversionRate cr3a = this.createConversionRate(aud.getC_Currency_ID(), eur.getC_Currency_ID(), C_ConversionType_ID, date3, audToEur, true);
        audToUsd = new BigDecimal(0.9);
        MConversionRate cr3b = this.createConversionRate(aud.getC_Currency_ID(), usd.getC_Currency_ID(), C_ConversionType_ID, date3, audToUsd, true);
        MPriceList priceList = new MPriceList(Env.getCtx(), 0, null);
        priceList.setName("Export AUD " + System.currentTimeMillis());
        MCurrency australianDollar = MCurrency.get((int)DictionaryIDs.C_Currency.AUD.id);
        priceList.setC_Currency_ID(australianDollar.getC_Currency_ID());
        priceList.setPricePrecision(australianDollar.getStdPrecision());
        priceList.saveEx();
        MPriceListVersion plv = new MPriceListVersion(priceList);
        plv.setM_DiscountSchema_ID(DictionaryIDs.M_DiscountSchema.SALES_2001.id);
        plv.setValidFrom(currentDate);
        plv.saveEx();
        try {
            MBankAccount ba = this.getBankAccount(usd.getC_Currency_ID());
            BigDecimal payAmt = new BigDecimal(1000);
            MPayment payment = this.createPayment(true, bpartner, ba.getC_BankAccount_ID(), date1, payAmt, aud.getC_Currency_ID(), C_ConversionType_ID);
            this.completeDocument((PO)payment);
            this.postDocument((PO)payment);
            MInvoice invoice = this.createInvoice(true, bpartner, date2, priceList.getM_PriceList_ID(), C_ConversionType_ID);
            BigDecimal qty = BigDecimal.ONE;
            BigDecimal price = new BigDecimal(1000);
            this.createInvoiceLine(invoice, 10, null, charge, qty, price);
            this.completeDocument((PO)invoice);
            this.postDocument((PO)invoice);
            MAllocationHdr alloc = this.createAllocationHdr(date2, aud.getC_Currency_ID());
            BigDecimal allocAmount = new BigDecimal(1000);
            this.createAllocationLine(alloc, allocAmount, invoice, payment);
            this.completeDocument((PO)alloc);
            this.postDocument((PO)alloc);
            MAcctSchema[] ass = MAcctSchema.getClientAcctSchema((Properties)Env.getCtx(), (int)Env.getAD_Client_ID((Properties)Env.getCtx()));
            MAllocationHdr[] allocList = MAllocationHdr.getOfPayment((Properties)Env.getCtx(), (int)payment.getC_Payment_ID(), (String)this.getTrxName());
            ArrayList<PostingLine> paymentLineList = new ArrayList<PostingLine>();
            ArrayList<PostingLine> tradeLineList = new ArrayList<PostingLine>();
            ArrayList<PostingLine> gainLossLineList = new ArrayList<PostingLine>();
            BigDecimal accountedDrAmt = this.getAccountedAmount(usd, allocAmount, cr1b.getMultiplyRate());
            BigDecimal accountedCrAmt = this.getAccountedAmount(usd, allocAmount, cr1b.getMultiplyRate());
            paymentLineList.add(new PostingLine(usd, accountedDrAmt, Env.ZERO));
            tradeLineList.add(new PostingLine(usd, Env.ZERO, accountedCrAmt));
            BigDecimal gainLossAmt = new BigDecimal(100).setScale(usd.getStdPrecision(), RoundingMode.HALF_UP);
            gainLossLineList.add(new PostingLine(usd, gainLossAmt, Env.ZERO));
            tradeLineList.add(new PostingLine(usd, Env.ZERO, gainLossAmt));
            this.testAllocationPosting(ass, allocList, paymentLineList, tradeLineList, gainLossLineList, null);
            paymentLineList = new ArrayList();
            tradeLineList = new ArrayList();
            gainLossLineList = new ArrayList();
            accountedDrAmt = this.getAccountedAmount(eur, allocAmount, cr1a.getMultiplyRate());
            accountedCrAmt = this.getAccountedAmount(eur, allocAmount, cr1a.getMultiplyRate());
            paymentLineList.add(new PostingLine(eur, accountedDrAmt, Env.ZERO));
            tradeLineList.add(new PostingLine(eur, Env.ZERO, accountedCrAmt));
            gainLossAmt = new BigDecimal(100).setScale(eur.getStdPrecision(), RoundingMode.HALF_UP);
            gainLossLineList.add(new PostingLine(eur, gainLossAmt, Env.ZERO));
            tradeLineList.add(new PostingLine(eur, Env.ZERO, gainLossAmt));
            this.testAllocationPosting(ass, allocList, paymentLineList, tradeLineList, gainLossLineList, null);
            this.reverseDocument((PO)invoice, false);
            MInvoice reversalInvoice = new MInvoice(Env.getCtx(), invoice.getReversal_ID(), this.getTrxName());
            this.postDocument((PO)reversalInvoice);
            MAllocationHdr reversalAlloc = null;
            MAllocationHdr[] mAllocationHdrArray = allocList = MAllocationHdr.getOfInvoice((Properties)Env.getCtx(), (int)invoice.getC_Invoice_ID(), (String)this.getTrxName());
            int n = allocList.length;
            int n2 = 0;
            while (n2 < n) {
                MAllocationHdr allocation = mAllocationHdrArray[n2];
                if (allocation.getReversal_ID() > 0 && allocation.getReversal_ID() < allocation.get_ID()) {
                    reversalAlloc = allocation;
                    break;
                }
                ++n2;
            }
            if (reversalAlloc == null) {
                reversalAlloc = new MAllocationHdr(Env.getCtx(), alloc.getReversal_ID(), this.getTrxName());
            }
            allocList = new MAllocationHdr[]{reversalAlloc};
            paymentLineList = new ArrayList();
            tradeLineList = new ArrayList();
            gainLossLineList = new ArrayList();
            accountedDrAmt = this.getAccountedAmount(usd, allocAmount, cr1b.getMultiplyRate());
            accountedCrAmt = this.getAccountedAmount(usd, allocAmount, cr1b.getMultiplyRate());
            tradeLineList.add(new PostingLine(usd, accountedDrAmt, Env.ZERO));
            paymentLineList.add(new PostingLine(usd, Env.ZERO, accountedCrAmt));
            gainLossAmt = new BigDecimal(100).setScale(usd.getStdPrecision(), RoundingMode.HALF_UP);
            gainLossLineList.add(new PostingLine(usd, Env.ZERO, gainLossAmt));
            tradeLineList.add(new PostingLine(usd, gainLossAmt, Env.ZERO));
            this.testAllocationPosting(ass, allocList, paymentLineList, tradeLineList, gainLossLineList, null);
            paymentLineList = new ArrayList();
            tradeLineList = new ArrayList();
            gainLossLineList = new ArrayList();
            accountedDrAmt = this.getAccountedAmount(eur, allocAmount, cr1a.getMultiplyRate());
            accountedCrAmt = this.getAccountedAmount(eur, allocAmount, cr1a.getMultiplyRate());
            tradeLineList.add(new PostingLine(eur, accountedDrAmt, Env.ZERO));
            paymentLineList.add(new PostingLine(eur, Env.ZERO, accountedCrAmt));
            gainLossAmt = new BigDecimal(100).setScale(eur.getStdPrecision(), RoundingMode.HALF_UP);
            gainLossLineList.add(new PostingLine(eur, Env.ZERO, gainLossAmt));
            tradeLineList.add(new PostingLine(eur, gainLossAmt, Env.ZERO));
            this.testAllocationPosting(ass, allocList, paymentLineList, tradeLineList, gainLossLineList, null);
        }
        finally {
            this.rollback();
            this.deleteConversionRate(cr1a);
            this.deleteConversionRate(cr1b);
            this.deleteConversionRate(cr2a);
            this.deleteConversionRate(cr2b);
            this.deleteConversionRate(cr3a);
            this.deleteConversionRate(cr3b);
            plv.deleteEx(true);
            priceList.deleteEx(true);
        }
    }

    @Test
    @ResourceLock(value="C_Conversion_Rate")
    public void testAllocateInvoicePosting_1() {
        MBPartner bpartner = MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.TREE_FARM.id);
        MCharge charge = MCharge.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_Charge.FREIGHT.id);
        Timestamp currentDate = Env.getContextAsDate((Properties)Env.getCtx(), (String)"#Date");
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(currentDate.getTime());
        cal.add(5, -1);
        Timestamp date1 = new Timestamp(cal.getTimeInMillis());
        Timestamp date2 = currentDate;
        int C_ConversionType_ID = DictionaryIDs.C_ConversionType.COMPANY.id;
        MCurrency usd = MCurrency.get((int)DictionaryIDs.C_Currency.USD.id);
        MCurrency euro = MCurrency.get((int)DictionaryIDs.C_Currency.EUR.id);
        BigDecimal eurToUsd1 = new BigDecimal(30);
        MConversionRate cr1 = this.createConversionRate(euro.getC_Currency_ID(), usd.getC_Currency_ID(), C_ConversionType_ID, date1, eurToUsd1);
        BigDecimal eurToUsd2 = new BigDecimal(31);
        MConversionRate cr2 = this.createConversionRate(euro.getC_Currency_ID(), usd.getC_Currency_ID(), C_ConversionType_ID, date2, eurToUsd2);
        int M_PriceList_ID = DictionaryIDs.M_PriceList.EXPORT.id;
        try {
            MInvoice invoice = this.createInvoice(true, bpartner, date1, M_PriceList_ID, C_ConversionType_ID);
            BigDecimal qty = BigDecimal.ONE;
            BigDecimal price = new BigDecimal(1000);
            this.createInvoiceLine(invoice, 10, null, charge, qty, price);
            this.completeDocument((PO)invoice);
            this.postDocument((PO)invoice);
            this.reverseDocument((PO)invoice, false);
            MInvoice reversalInvoice = new MInvoice(Env.getCtx(), invoice.getReversal_ID(), this.getTrxName());
            this.postDocument((PO)reversalInvoice);
            MAcctSchema[] ass = MAcctSchema.getClientAcctSchema((Properties)Env.getCtx(), (int)Env.getAD_Client_ID((Properties)Env.getCtx()));
            MAllocationHdr[] allocList = MAllocationHdr.getOfInvoice((Properties)Env.getCtx(), (int)invoice.getC_Invoice_ID(), (String)this.getTrxName());
            BigDecimal allocAmount = new BigDecimal(1000);
            ArrayList<PostingLine> tradeLineList = new ArrayList<PostingLine>();
            ArrayList<PostingLine> gainLossLineList = new ArrayList<PostingLine>();
            BigDecimal accountedDrAmt = this.getAccountedAmount(usd, allocAmount, cr2.getMultiplyRate());
            BigDecimal accountedCrAmt = this.getAccountedAmount(usd, allocAmount, cr1.getMultiplyRate());
            tradeLineList.add(new PostingLine(usd, accountedDrAmt, Env.ZERO));
            tradeLineList.add(new PostingLine(usd, Env.ZERO, accountedCrAmt));
            BigDecimal gainLossAmt = new BigDecimal(1000).setScale(usd.getStdPrecision(), RoundingMode.HALF_UP);
            gainLossLineList.add(new PostingLine(usd, Env.ZERO, gainLossAmt));
            this.testAllocationPosting(ass, allocList, null, tradeLineList, gainLossLineList, null);
        }
        finally {
            this.rollback();
            this.deleteConversionRate(cr1);
            this.deleteConversionRate(cr2);
        }
    }

    @Test
    @ResourceLock(value="C_Conversion_Rate")
    public void testAllocateInvoicePosting_2() {
        Timestamp currentDate;
        MBPartner bpartner = MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.C_AND_W.id);
        MCharge charge = MCharge.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_Charge.FREIGHT.id);
        Timestamp date = currentDate = Env.getContextAsDate((Properties)Env.getCtx(), (String)"#Date");
        int C_ConversionType_ID = DictionaryIDs.C_ConversionType.COMPANY.id;
        MCurrency usd = MCurrency.get((int)DictionaryIDs.C_Currency.USD.id);
        MCurrency euro = MCurrency.get((int)DictionaryIDs.C_Currency.EUR.id);
        BigDecimal eurToUsd = new BigDecimal(30);
        MConversionRate cr = this.createConversionRate(euro.getC_Currency_ID(), usd.getC_Currency_ID(), C_ConversionType_ID, date, eurToUsd);
        int M_PriceList_ID = DictionaryIDs.M_PriceList.EXPORT.id;
        try {
            MInvoice invoice = this.createInvoice(true, bpartner, date, M_PriceList_ID, C_ConversionType_ID);
            BigDecimal qty = BigDecimal.ONE;
            BigDecimal price = new BigDecimal(1000);
            this.createInvoiceLine(invoice, 10, null, charge, qty, price);
            this.completeDocument((PO)invoice);
            this.postDocument((PO)invoice);
            this.reverseDocument((PO)invoice);
            MInvoice reversalInvoice = new MInvoice(Env.getCtx(), invoice.getReversal_ID(), this.getTrxName());
            this.postDocument((PO)reversalInvoice);
            MAcctSchema[] ass = MAcctSchema.getClientAcctSchema((Properties)Env.getCtx(), (int)Env.getAD_Client_ID((Properties)Env.getCtx()));
            MAllocationHdr[] allocList = MAllocationHdr.getOfInvoice((Properties)Env.getCtx(), (int)invoice.getC_Invoice_ID(), (String)this.getTrxName());
            BigDecimal allocAmount = new BigDecimal(1000);
            ArrayList<PostingLine> tradeLineList = new ArrayList<PostingLine>();
            BigDecimal accountedDrAmt = this.getAccountedAmount(usd, allocAmount, cr.getMultiplyRate());
            BigDecimal accountedCrAmt = this.getAccountedAmount(usd, allocAmount, cr.getMultiplyRate());
            tradeLineList.add(new PostingLine(usd, accountedDrAmt, Env.ZERO));
            tradeLineList.add(new PostingLine(usd, Env.ZERO, accountedCrAmt));
            this.testAllocationPosting(ass, allocList, null, tradeLineList, null, null);
        }
        finally {
            this.rollback();
            this.deleteConversionRate(cr);
        }
    }

    @Test
    @ResourceLock(value="C_Conversion_Rate")
    public void testAllocateInvoicePosting_3() {
        MBPartner bpartner = MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.SEED_FARM.id);
        MCharge charge = MCharge.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_Charge.FREIGHT.id);
        Timestamp currentDate = Env.getContextAsDate((Properties)Env.getCtx(), (String)"#Date");
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(currentDate.getTime());
        cal.add(5, -1);
        Timestamp date1 = new Timestamp(cal.getTimeInMillis());
        Timestamp date2 = currentDate;
        int C_ConversionType_ID = DictionaryIDs.C_ConversionType.COMPANY.id;
        MCurrency usd = MCurrency.get((int)DictionaryIDs.C_Currency.USD.id);
        MCurrency euro = MCurrency.get((int)DictionaryIDs.C_Currency.EUR.id);
        BigDecimal eurToUsd1 = new BigDecimal(30);
        MConversionRate cr1 = this.createConversionRate(euro.getC_Currency_ID(), usd.getC_Currency_ID(), C_ConversionType_ID, date1, eurToUsd1);
        BigDecimal eurToUsd2 = new BigDecimal(31);
        MConversionRate cr2 = this.createConversionRate(euro.getC_Currency_ID(), usd.getC_Currency_ID(), C_ConversionType_ID, date2, eurToUsd2);
        int M_PriceList_ID = DictionaryIDs.M_PriceList.EXPORT.id;
        try {
            MInvoice invoice = this.createInvoice(true, bpartner, date1, M_PriceList_ID, C_ConversionType_ID);
            BigDecimal qty = BigDecimal.ONE;
            BigDecimal price = new BigDecimal(1000);
            this.createInvoiceLine(invoice, 10, null, charge, qty, price);
            this.completeDocument((PO)invoice);
            this.postDocument((PO)invoice);
            MInvoice creditMemo = this.createInvoice(true, true, bpartner, date2, M_PriceList_ID, C_ConversionType_ID);
            qty = BigDecimal.ONE;
            price = new BigDecimal(1000);
            this.createInvoiceLine(creditMemo, 10, null, charge, qty, price);
            this.completeDocument((PO)creditMemo);
            this.postDocument((PO)creditMemo);
            MAllocationHdr alloc = this.createAllocationHdr(date2, euro.getC_Currency_ID());
            BigDecimal allocAmount = new BigDecimal(1000);
            this.createAllocationLine(alloc, allocAmount, invoice, null);
            this.createAllocationLine(alloc, allocAmount.negate(), creditMemo, null);
            this.completeDocument((PO)alloc);
            this.postDocument((PO)alloc);
            MAcctSchema[] ass = MAcctSchema.getClientAcctSchema((Properties)Env.getCtx(), (int)Env.getAD_Client_ID((Properties)Env.getCtx()));
            MAllocationHdr[] allocList = MAllocationHdr.getOfInvoice((Properties)Env.getCtx(), (int)invoice.getC_Invoice_ID(), (String)this.getTrxName());
            ArrayList<PostingLine> tradeLineList = new ArrayList<PostingLine>();
            ArrayList<PostingLine> gainLossLineList = new ArrayList<PostingLine>();
            BigDecimal accountedDrAmt = this.getAccountedAmount(usd, allocAmount, cr2.getMultiplyRate());
            BigDecimal accountedCrAmt = this.getAccountedAmount(usd, allocAmount, cr1.getMultiplyRate());
            tradeLineList.add(new PostingLine(usd, accountedDrAmt, Env.ZERO));
            tradeLineList.add(new PostingLine(usd, Env.ZERO, accountedCrAmt));
            BigDecimal gainLossAmt = new BigDecimal(1000).setScale(usd.getStdPrecision(), RoundingMode.HALF_UP);
            gainLossLineList.add(new PostingLine(usd, Env.ZERO, gainLossAmt));
            this.testAllocationPosting(ass, allocList, null, tradeLineList, gainLossLineList, null);
        }
        finally {
            this.rollback();
            this.deleteConversionRate(cr1);
            this.deleteConversionRate(cr2);
        }
    }

    @Test
    @ResourceLock(value="C_Conversion_Rate")
    public void testAllocateInvoicePosting_4() {
        Timestamp currentDate;
        MBPartner bpartner = MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.PATIO.id);
        MCharge charge = MCharge.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_Charge.FREIGHT.id);
        Timestamp date = currentDate = Env.getContextAsDate((Properties)Env.getCtx(), (String)"#Date");
        int C_ConversionType_ID = DictionaryIDs.C_ConversionType.COMPANY.id;
        MCurrency usd = MCurrency.get((int)DictionaryIDs.C_Currency.USD.id);
        MCurrency euro = MCurrency.get((int)DictionaryIDs.C_Currency.EUR.id);
        BigDecimal eurToUsd = new BigDecimal(30);
        MConversionRate cr = this.createConversionRate(euro.getC_Currency_ID(), usd.getC_Currency_ID(), C_ConversionType_ID, date, eurToUsd);
        int M_PriceList_ID = DictionaryIDs.M_PriceList.EXPORT.id;
        try {
            MInvoice invoice = this.createInvoice(true, bpartner, date, M_PriceList_ID, C_ConversionType_ID);
            BigDecimal qty = BigDecimal.ONE;
            BigDecimal price = new BigDecimal(1000);
            this.createInvoiceLine(invoice, 10, null, charge, qty, price);
            this.completeDocument((PO)invoice);
            this.postDocument((PO)invoice);
            MInvoice creditMemo = this.createInvoice(true, true, bpartner, date, M_PriceList_ID, C_ConversionType_ID);
            qty = BigDecimal.ONE;
            price = new BigDecimal(1000);
            this.createInvoiceLine(creditMemo, 10, null, charge, qty, price);
            this.completeDocument((PO)creditMemo);
            this.postDocument((PO)creditMemo);
            MAllocationHdr alloc = this.createAllocationHdr(date, euro.getC_Currency_ID());
            BigDecimal allocAmount = new BigDecimal(1000);
            this.createAllocationLine(alloc, allocAmount, invoice, null);
            this.createAllocationLine(alloc, allocAmount.negate(), creditMemo, null);
            this.completeDocument((PO)alloc);
            this.postDocument((PO)alloc);
            MAcctSchema[] ass = MAcctSchema.getClientAcctSchema((Properties)Env.getCtx(), (int)Env.getAD_Client_ID((Properties)Env.getCtx()));
            MAllocationHdr[] allocList = MAllocationHdr.getOfInvoice((Properties)Env.getCtx(), (int)invoice.getC_Invoice_ID(), (String)this.getTrxName());
            ArrayList<PostingLine> tradeLineList = new ArrayList<PostingLine>();
            BigDecimal accountedDrAmt = this.getAccountedAmount(usd, allocAmount, cr.getMultiplyRate());
            BigDecimal accountedCrAmt = this.getAccountedAmount(usd, allocAmount, cr.getMultiplyRate());
            tradeLineList.add(new PostingLine(usd, accountedDrAmt, Env.ZERO));
            tradeLineList.add(new PostingLine(usd, Env.ZERO, accountedCrAmt));
            this.testAllocationPosting(ass, allocList, null, tradeLineList, null, null);
        }
        finally {
            this.rollback();
            this.deleteConversionRate(cr);
        }
    }

    @Test
    @ResourceLock(value="C_Conversion_Rate")
    public void testAllocatePaymentPosting_1() {
        MBPartner bpartner = MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.AGRI_TECH.id);
        Timestamp currentDate = Env.getContextAsDate((Properties)Env.getCtx(), (String)"#Date");
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(currentDate.getTime());
        cal.add(5, -1);
        Timestamp date1 = new Timestamp(cal.getTimeInMillis());
        Timestamp date2 = currentDate;
        int C_ConversionType_ID = DictionaryIDs.C_ConversionType.COMPANY.id;
        MCurrency usd = MCurrency.get((int)DictionaryIDs.C_Currency.USD.id);
        MCurrency euro = MCurrency.get((int)DictionaryIDs.C_Currency.EUR.id);
        BigDecimal eurToUsd1 = new BigDecimal(30);
        MConversionRate cr1 = this.createConversionRate(euro.getC_Currency_ID(), usd.getC_Currency_ID(), C_ConversionType_ID, date1, eurToUsd1);
        BigDecimal eurToUsd2 = new BigDecimal(31);
        MConversionRate cr2 = this.createConversionRate(euro.getC_Currency_ID(), usd.getC_Currency_ID(), C_ConversionType_ID, date2, eurToUsd2);
        try {
            MBankAccount ba = this.getBankAccount(usd.getC_Currency_ID());
            BigDecimal payAmt = new BigDecimal(1000);
            MPayment payment = this.createPayment(true, bpartner, ba.getC_BankAccount_ID(), date1, payAmt, euro.getC_Currency_ID(), C_ConversionType_ID);
            this.completeDocument((PO)payment);
            this.postDocument((PO)payment);
            this.reverseDocument((PO)payment, false);
            MPayment reversalPayment = new MPayment(Env.getCtx(), payment.getReversal_ID(), this.getTrxName());
            this.postDocument((PO)reversalPayment);
            MAcctSchema[] ass = MAcctSchema.getClientAcctSchema((Properties)Env.getCtx(), (int)Env.getAD_Client_ID((Properties)Env.getCtx()));
            MAllocationHdr[] allocList = MAllocationHdr.getOfPayment((Properties)Env.getCtx(), (int)payment.getC_Payment_ID(), (String)this.getTrxName());
            BigDecimal allocAmount = payAmt;
            ArrayList<PostingLine> paymentLineList = new ArrayList<PostingLine>();
            ArrayList<PostingLine> gainLossLineList = new ArrayList<PostingLine>();
            BigDecimal accountedDrAmt = this.getAccountedAmount(usd, allocAmount, cr1.getMultiplyRate());
            BigDecimal accountedCrAmt = this.getAccountedAmount(usd, allocAmount, cr2.getMultiplyRate());
            paymentLineList.add(new PostingLine(usd, accountedDrAmt, Env.ZERO));
            paymentLineList.add(new PostingLine(usd, Env.ZERO, accountedCrAmt));
            BigDecimal gainLossAmt = new BigDecimal(1000).setScale(usd.getStdPrecision(), RoundingMode.HALF_UP);
            gainLossLineList.add(new PostingLine(usd, gainLossAmt, Env.ZERO));
            this.testAllocationPosting(ass, allocList, paymentLineList, null, gainLossLineList, null);
        }
        finally {
            this.rollback();
            this.deleteConversionRate(cr1);
            this.deleteConversionRate(cr2);
        }
    }

    @Test
    @ResourceLock(value="C_Conversion_Rate")
    public void testAllocatePaymentPosting_2() {
        Timestamp currentDate;
        MBPartner bpartner = MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.TREE_FARM.id);
        Timestamp date = currentDate = Env.getContextAsDate((Properties)Env.getCtx(), (String)"#Date");
        int C_ConversionType_ID = DictionaryIDs.C_ConversionType.COMPANY.id;
        MCurrency usd = MCurrency.get((int)DictionaryIDs.C_Currency.USD.id);
        MCurrency euro = MCurrency.get((int)DictionaryIDs.C_Currency.EUR.id);
        BigDecimal eurToUsd = new BigDecimal(30);
        MConversionRate cr = this.createConversionRate(euro.getC_Currency_ID(), usd.getC_Currency_ID(), C_ConversionType_ID, date, eurToUsd);
        try {
            MBankAccount ba = this.getBankAccount(usd.getC_Currency_ID());
            BigDecimal payAmt = new BigDecimal(1000);
            MPayment payment = this.createPayment(true, bpartner, ba.getC_BankAccount_ID(), date, payAmt, euro.getC_Currency_ID(), C_ConversionType_ID);
            this.completeDocument((PO)payment);
            this.postDocument((PO)payment);
            this.reverseDocument((PO)payment, false);
            MPayment reversalPayment = new MPayment(Env.getCtx(), payment.getReversal_ID(), this.getTrxName());
            this.postDocument((PO)reversalPayment);
            MAcctSchema[] ass = MAcctSchema.getClientAcctSchema((Properties)Env.getCtx(), (int)Env.getAD_Client_ID((Properties)Env.getCtx()));
            MAllocationHdr[] allocList = MAllocationHdr.getOfPayment((Properties)Env.getCtx(), (int)payment.getC_Payment_ID(), (String)this.getTrxName());
            BigDecimal allocAmount = payAmt;
            ArrayList<PostingLine> paymentLineList = new ArrayList<PostingLine>();
            BigDecimal accountedDrAmt = this.getAccountedAmount(usd, allocAmount, cr.getMultiplyRate());
            BigDecimal accountedCrAmt = this.getAccountedAmount(usd, allocAmount, cr.getMultiplyRate());
            paymentLineList.add(new PostingLine(usd, accountedDrAmt, Env.ZERO));
            paymentLineList.add(new PostingLine(usd, Env.ZERO, accountedCrAmt));
            this.testAllocationPosting(ass, allocList, paymentLineList, null, null, null);
        }
        finally {
            this.rollback();
            this.deleteConversionRate(cr);
        }
    }

    @Test
    @ResourceLock(value="C_Conversion_Rate")
    public void testAllocatePaymentPosting_3() {
        MBPartner bpartner = MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.C_AND_W.id);
        Timestamp currentDate = Env.getContextAsDate((Properties)Env.getCtx(), (String)"#Date");
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(currentDate.getTime());
        cal.add(5, -1);
        Timestamp date1 = new Timestamp(cal.getTimeInMillis());
        Timestamp date2 = currentDate;
        int C_ConversionType_ID = DictionaryIDs.C_ConversionType.COMPANY.id;
        MCurrency usd = MCurrency.get((int)DictionaryIDs.C_Currency.USD.id);
        MCurrency euro = MCurrency.get((int)DictionaryIDs.C_Currency.EUR.id);
        BigDecimal eurToUsd1 = new BigDecimal(30);
        MConversionRate cr1 = this.createConversionRate(euro.getC_Currency_ID(), usd.getC_Currency_ID(), C_ConversionType_ID, date1, eurToUsd1);
        BigDecimal eurToUsd2 = new BigDecimal(31);
        MConversionRate cr2 = this.createConversionRate(euro.getC_Currency_ID(), usd.getC_Currency_ID(), C_ConversionType_ID, date2, eurToUsd2);
        try {
            MBankAccount ba = this.getBankAccount(usd.getC_Currency_ID());
            BigDecimal payAmt = new BigDecimal(1000);
            MPayment payment1 = this.createPayment(true, bpartner, ba.getC_BankAccount_ID(), date1, payAmt, euro.getC_Currency_ID(), C_ConversionType_ID);
            this.completeDocument((PO)payment1);
            this.postDocument((PO)payment1);
            MPayment payment2 = this.createPayment(true, bpartner, ba.getC_BankAccount_ID(), date2, payAmt.negate(), euro.getC_Currency_ID(), C_ConversionType_ID);
            this.completeDocument((PO)payment2);
            this.postDocument((PO)payment2);
            MAllocationHdr alloc = this.createAllocationHdr(date2, euro.getC_Currency_ID());
            BigDecimal allocAmount = new BigDecimal(1000);
            this.createAllocationLine(alloc, allocAmount, null, payment1);
            this.createAllocationLine(alloc, allocAmount.negate(), null, payment2);
            this.completeDocument((PO)alloc);
            this.postDocument((PO)alloc);
            MAcctSchema[] ass = MAcctSchema.getClientAcctSchema((Properties)Env.getCtx(), (int)Env.getAD_Client_ID((Properties)Env.getCtx()));
            MAllocationHdr[] allocList = MAllocationHdr.getOfPayment((Properties)Env.getCtx(), (int)payment1.getC_Payment_ID(), (String)this.getTrxName());
            ArrayList<PostingLine> paymentLineList = new ArrayList<PostingLine>();
            ArrayList<PostingLine> gainLossLineList = new ArrayList<PostingLine>();
            BigDecimal accountedDrAmt = this.getAccountedAmount(usd, allocAmount, cr1.getMultiplyRate());
            BigDecimal accountedCrAmt = this.getAccountedAmount(usd, allocAmount, cr2.getMultiplyRate());
            paymentLineList.add(new PostingLine(usd, accountedDrAmt, Env.ZERO));
            paymentLineList.add(new PostingLine(usd, Env.ZERO, accountedCrAmt));
            BigDecimal gainLossAmt = new BigDecimal(1000).setScale(usd.getStdPrecision(), RoundingMode.HALF_UP);
            gainLossLineList.add(new PostingLine(usd, gainLossAmt, Env.ZERO));
            this.testAllocationPosting(ass, allocList, paymentLineList, null, gainLossLineList, null);
        }
        finally {
            this.rollback();
            this.deleteConversionRate(cr1);
            this.deleteConversionRate(cr2);
        }
    }

    @Test
    @ResourceLock(value="C_Conversion_Rate")
    public void testAllocatePaymentPosting_4() {
        Timestamp currentDate;
        MBPartner bpartner = MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.TREE_FARM.id);
        Timestamp date = currentDate = Env.getContextAsDate((Properties)Env.getCtx(), (String)"#Date");
        int C_ConversionType_ID = DictionaryIDs.C_ConversionType.COMPANY.id;
        MCurrency usd = MCurrency.get((int)DictionaryIDs.C_Currency.USD.id);
        MCurrency euro = MCurrency.get((int)DictionaryIDs.C_Currency.EUR.id);
        BigDecimal eurToUsd = new BigDecimal(30);
        MConversionRate cr = this.createConversionRate(euro.getC_Currency_ID(), usd.getC_Currency_ID(), C_ConversionType_ID, date, eurToUsd);
        try {
            MBankAccount ba = this.getBankAccount(usd.getC_Currency_ID());
            BigDecimal payAmt = new BigDecimal(1000);
            MPayment payment1 = this.createPayment(true, bpartner, ba.getC_BankAccount_ID(), date, payAmt, euro.getC_Currency_ID(), C_ConversionType_ID);
            this.completeDocument((PO)payment1);
            this.postDocument((PO)payment1);
            MPayment payment2 = this.createPayment(true, bpartner, ba.getC_BankAccount_ID(), date, payAmt.negate(), euro.getC_Currency_ID(), C_ConversionType_ID);
            this.completeDocument((PO)payment2);
            this.postDocument((PO)payment2);
            MAllocationHdr alloc = this.createAllocationHdr(date, euro.getC_Currency_ID());
            BigDecimal allocAmount = new BigDecimal(1000);
            this.createAllocationLine(alloc, allocAmount, null, payment1);
            this.createAllocationLine(alloc, allocAmount.negate(), null, payment2);
            this.completeDocument((PO)alloc);
            this.postDocument((PO)alloc);
            MAcctSchema[] ass = MAcctSchema.getClientAcctSchema((Properties)Env.getCtx(), (int)Env.getAD_Client_ID((Properties)Env.getCtx()));
            MAllocationHdr[] allocList = MAllocationHdr.getOfPayment((Properties)Env.getCtx(), (int)payment1.getC_Payment_ID(), (String)this.getTrxName());
            ArrayList<PostingLine> paymentLineList = new ArrayList<PostingLine>();
            BigDecimal accountedDrAmt = this.getAccountedAmount(usd, allocAmount, cr.getMultiplyRate());
            BigDecimal accountedCrAmt = this.getAccountedAmount(usd, allocAmount, cr.getMultiplyRate());
            paymentLineList.add(new PostingLine(usd, accountedDrAmt, Env.ZERO));
            paymentLineList.add(new PostingLine(usd, Env.ZERO, accountedCrAmt));
            this.testAllocationPosting(ass, allocList, paymentLineList, null, null, null);
        }
        finally {
            this.rollback();
            this.deleteConversionRate(cr);
        }
    }

    @Test
    @ResourceLock(value="C_Conversion_Rate")
    public void testAllocatePaymentPosting_5() {
        MBPartner bpartner = MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.AGRI_TECH.id);
        Timestamp currentDate = Env.getContextAsDate((Properties)Env.getCtx(), (String)"#Date");
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(currentDate.getTime());
        cal.add(5, -1);
        Timestamp date1 = new Timestamp(cal.getTimeInMillis());
        Timestamp date2 = currentDate;
        int C_ConversionType_ID = DictionaryIDs.C_ConversionType.COMPANY.id;
        MCurrency usd = MCurrency.get((int)DictionaryIDs.C_Currency.USD.id);
        MCurrency euro = MCurrency.get((int)DictionaryIDs.C_Currency.EUR.id);
        BigDecimal eurToUsd1 = new BigDecimal(4);
        MConversionRate cr1 = this.createConversionRate(euro.getC_Currency_ID(), usd.getC_Currency_ID(), C_ConversionType_ID, date1, eurToUsd1);
        BigDecimal eurToUsd2 = new BigDecimal(5);
        MConversionRate cr2 = this.createConversionRate(euro.getC_Currency_ID(), usd.getC_Currency_ID(), C_ConversionType_ID, date2, eurToUsd2);
        try {
            MBankAccount ba = this.getBankAccount(usd.getC_Currency_ID());
            BigDecimal payAmt = new BigDecimal(1000);
            MPayment payment = this.createPayment(true, bpartner, ba.getC_BankAccount_ID(), date1, payAmt, euro.getC_Currency_ID(), C_ConversionType_ID);
            payment.setC_Charge_ID(DictionaryIDs.C_Charge.BANK.id);
            payment.saveEx();
            this.completeDocument((PO)payment);
            this.postDocument((PO)payment);
            this.reverseDocument((PO)payment, false);
            MPayment reversalPayment = new MPayment(Env.getCtx(), payment.getReversal_ID(), this.getTrxName());
            this.postDocument((PO)reversalPayment);
            MAcctSchema[] ass = MAcctSchema.getClientAcctSchema((Properties)Env.getCtx(), (int)Env.getAD_Client_ID((Properties)Env.getCtx()));
            MAllocationHdr[] allocList = MAllocationHdr.getOfPayment((Properties)Env.getCtx(), (int)payment.getC_Payment_ID(), (String)this.getTrxName());
            BigDecimal allocAmount = payAmt;
            ArrayList<PostingLine> paymentLineList = new ArrayList<PostingLine>();
            ArrayList<PostingLine> gainLossLineList = new ArrayList<PostingLine>();
            BigDecimal accountedDrAmt = this.getAccountedAmount(usd, allocAmount, cr1.getMultiplyRate());
            BigDecimal accountedCrAmt = this.getAccountedAmount(usd, allocAmount, cr2.getMultiplyRate());
            paymentLineList.add(new PostingLine(usd, accountedDrAmt, Env.ZERO));
            paymentLineList.add(new PostingLine(usd, Env.ZERO, accountedCrAmt));
            BigDecimal gainLossAmt = new BigDecimal(1000).setScale(usd.getStdPrecision(), RoundingMode.HALF_UP);
            gainLossLineList.add(new PostingLine(usd, gainLossAmt, Env.ZERO));
            this.testAllocationPosting(ass, allocList, paymentLineList, null, gainLossLineList, null);
        }
        finally {
            this.rollback();
            this.deleteConversionRate(cr1);
            this.deleteConversionRate(cr2);
        }
    }

    private MConversionRate createConversionRate(int C_Currency_ID, int C_Currency_ID_To, int C_ConversionType_ID, Timestamp date, BigDecimal rate) {
        return this.createConversionRate(C_Currency_ID, C_Currency_ID_To, C_ConversionType_ID, date, rate, true);
    }

    private MConversionRate createConversionRate(int C_Currency_ID, int C_Currency_ID_To, int C_ConversionType_ID, Timestamp date, BigDecimal rate, boolean isMultiplyRate) {
        return ConversionRateHelper.createConversionRate(C_Currency_ID, C_Currency_ID_To, C_ConversionType_ID, date, rate, isMultiplyRate);
    }

    private void deleteConversionRate(MConversionRate cr) {
        ConversionRateHelper.deleteConversionRate(cr);
    }

    private MInvoice createInvoice(boolean isSOTrx, MBPartner bpartner, Timestamp date, int M_PriceList_ID, int C_ConversionType_ID) {
        return this.createInvoice(isSOTrx, false, bpartner, date, M_PriceList_ID, C_ConversionType_ID);
    }

    private MInvoice createCreditMemo(boolean isSOTrx, MBPartner bpartner, Timestamp date, int M_PriceList_ID, int C_ConversionType_ID) {
        return this.createInvoice(isSOTrx, true, bpartner, date, M_PriceList_ID, C_ConversionType_ID);
    }

    private MInvoice createInvoice(boolean isSOTrx, boolean isCreditMemo, MBPartner bpartner, Timestamp date, int M_PriceList_ID, int C_ConversionType_ID) {
        MInvoice invoice = new MInvoice(Env.getCtx(), 0, this.getTrxName());
        invoice.setBPartner(bpartner);
        invoice.setIsSOTrx(isSOTrx);
        if (isCreditMemo) {
            invoice.setC_DocTypeTarget_ID(isSOTrx ? "ARC" : "APC");
        }
        invoice.setC_DocTypeTarget_ID();
        invoice.setDateInvoiced(date);
        invoice.setDateAcct(date);
        invoice.setM_PriceList_ID(M_PriceList_ID);
        invoice.setC_ConversionType_ID(C_ConversionType_ID);
        invoice.setC_PaymentTerm_ID(DictionaryIDs.C_PaymentTerm.IMMEDIATE.id);
        invoice.setDocStatus("DR");
        invoice.setDocAction("CO");
        invoice.saveEx();
        return invoice;
    }

    private MInvoiceLine createInvoiceLine(MInvoice invoice, int line, MProduct product, MCharge charge, BigDecimal qty, BigDecimal price) {
        MInvoiceLine invoiceLine = new MInvoiceLine(invoice);
        invoiceLine.setLine(line);
        if (product != null) {
            invoiceLine.setProduct(product);
        } else {
            invoiceLine.setC_Charge_ID(charge.getC_Charge_ID());
        }
        invoiceLine.setC_Tax_ID(DictionaryIDs.C_Tax.EXEMPT.id);
        invoiceLine.setQty(qty);
        invoiceLine.setPrice(price);
        invoiceLine.saveEx();
        return invoiceLine;
    }

    private MPayment createPayment(boolean isReceipt, MBPartner bpartner, int C_BankAccount_ID, Timestamp date, BigDecimal payAmt, int C_Currency_ID, int C_ConversionType_ID) {
        MPayment payment = new MPayment(Env.getCtx(), 0, this.getTrxName());
        payment.setC_BPartner_ID(bpartner.getC_BPartner_ID());
        payment.setC_BankAccount_ID(C_BankAccount_ID);
        payment.setC_DocType_ID(isReceipt);
        payment.setDateTrx(date);
        payment.setDateAcct(date);
        payment.setPayAmt(payAmt);
        payment.setC_Currency_ID(C_Currency_ID);
        payment.setC_ConversionType_ID(C_ConversionType_ID);
        payment.setTenderType("K");
        payment.setDocStatus("DR");
        payment.setDocAction("CO");
        payment.saveEx();
        return payment;
    }

    private MAllocationHdr createAllocationHdr(Timestamp date, int C_Currency_ID) {
        MAllocationHdr alloc = new MAllocationHdr(Env.getCtx(), true, date, C_Currency_ID, Env.getContext((Properties)Env.getCtx(), (String)"#AD_User_Name"), this.getTrxName());
        int doctypeAlloc = MDocType.getDocType((String)"CMA");
        alloc.setC_DocType_ID(doctypeAlloc);
        alloc.saveEx();
        return alloc;
    }

    private MAllocationLine createAllocationLine(MAllocationHdr alloc, BigDecimal allocAmount, MInvoice invoice, MPayment payment) {
        MAllocationLine aLine = new MAllocationLine(alloc, allocAmount, Env.ZERO, Env.ZERO, Env.ZERO);
        if (invoice != null) {
            aLine.setC_BPartner_ID(invoice.getC_BPartner_ID());
            aLine.setC_Invoice_ID(invoice.getC_Invoice_ID());
        }
        if (payment != null) {
            aLine.setC_BPartner_ID(payment.getC_BPartner_ID());
            aLine.setC_Payment_ID(payment.getC_Payment_ID());
        }
        aLine.saveEx();
        return aLine;
    }

    private void completeDocument(PO po) {
        ProcessInfo info = MWorkflow.runDocumentActionWorkflow((PO)po, (String)"CO");
        po.load(this.getTrxName(), new String[0]);
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        String docStatus = (String)po.get_Value("DocStatus");
        Assertions.assertEquals((Object)"CO", (Object)docStatus, (String)("CO != " + docStatus));
    }

    private void reverseDocument(PO po) {
        this.reverseDocument(po, true);
    }

    private void reverseDocument(PO po, boolean isReverseCorrect) {
        ProcessInfo info = MWorkflow.runDocumentActionWorkflow((PO)po, (String)(isReverseCorrect ? "RC" : "RA"));
        po.load(this.getTrxName(), new String[0]);
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        String docStatus = (String)po.get_Value("DocStatus");
        Assertions.assertEquals((Object)"RE", (Object)docStatus, (String)("RE != " + docStatus));
    }

    private void postDocument(PO po) {
        if (!po.get_ValueAsBoolean("Posted")) {
            String error = DocumentEngine.postImmediate((Properties)Env.getCtx(), (int)po.getAD_Client_ID(), (int)po.get_Table_ID(), (int)po.get_ID(), (boolean)false, (String)this.getTrxName());
            Assertions.assertTrue((error == null ? 1 : 0) != 0, (String)error);
        }
        po.load(this.getTrxName(), new String[0]);
        Assertions.assertTrue((boolean)po.get_ValueAsBoolean("Posted"));
    }

    private MBankAccount getBankAccount(int C_Currency_ID) {
        String whereClause = "AD_Org_ID=? AND C_Currency_ID=?";
        MBankAccount ba = (MBankAccount)new Query(Env.getCtx(), "C_BankAccount", whereClause, this.getTrxName()).setParameters(new Object[]{Env.getAD_Org_ID((Properties)Env.getCtx()), C_Currency_ID}).setOrderBy("IsDefault DESC").first();
        Assertions.assertTrue((ba != null ? 1 : 0) != 0, (String)"@NoAccountOrgCurrency@");
        return ba;
    }

    private void testAllocationPosting(MAcctSchema[] ass, MAllocationHdr[] allocList, ArrayList<PostingLine> paymentLineList, ArrayList<PostingLine> tradeLineList) {
        this.testAllocationPosting(ass, allocList, paymentLineList, tradeLineList, null, null);
    }

    private void testAllocationPosting(MAcctSchema[] ass, MAllocationHdr[] allocList, ArrayList<PostingLine> paymentLineList, ArrayList<PostingLine> tradeLineList, ArrayList<PostingLine> gainLossLineList, ArrayList<PostingLine> currBalLineList) {
        Assertions.assertTrue((allocList.length > 0 ? 1 : 0) != 0);
        if (paymentLineList == null) {
            paymentLineList = new ArrayList();
        }
        if (tradeLineList == null) {
            tradeLineList = new ArrayList();
        }
        if (gainLossLineList == null) {
            gainLossLineList = new ArrayList();
        }
        if (currBalLineList == null) {
            currBalLineList = new ArrayList();
        }
        HashMap<Integer, Object> totalPaymentAmtByCurrencyId = new HashMap<Integer, Object>();
        for (PostingLine paymentLine : paymentLineList) {
            Object totalAmt = (BigDecimal)totalPaymentAmtByCurrencyId.get(paymentLine.currency.get_ID());
            if (totalAmt == null) {
                totalAmt = Env.ZERO;
            }
            totalAmt = ((BigDecimal)totalAmt).add(paymentLine.amtAcctDr).subtract(paymentLine.amtAcctCr);
            totalPaymentAmtByCurrencyId.put(paymentLine.currency.get_ID(), totalAmt);
        }
        HashMap<Integer, Object> totalTradeAmtByCurrencyId = new HashMap<Integer, Object>();
        for (PostingLine tradeLine : tradeLineList) {
            Object totalAmt = (BigDecimal)totalTradeAmtByCurrencyId.get(tradeLine.currency.get_ID());
            if (totalAmt == null) {
                totalAmt = Env.ZERO;
            }
            totalAmt = ((BigDecimal)totalAmt).add(tradeLine.amtAcctDr).subtract(tradeLine.amtAcctCr);
            totalTradeAmtByCurrencyId.put(tradeLine.currency.get_ID(), totalAmt);
        }
        HashMap<Integer, BigDecimal> totalGainLossAmtByCurrencyId = new HashMap<Integer, BigDecimal>();
        for (PostingLine gainLossLine : gainLossLineList) {
            BigDecimal totalAmt = (BigDecimal)totalGainLossAmtByCurrencyId.get(gainLossLine.currency.get_ID());
            if (totalAmt == null) {
                totalAmt = Env.ZERO;
            }
            totalAmt = totalAmt.add(gainLossLine.amtAcctDr).subtract(gainLossLine.amtAcctCr);
            totalGainLossAmtByCurrencyId.put(gainLossLine.currency.get_ID(), totalAmt);
        }
        HashMap<Integer, BigDecimal> totalCurrBalAmtByCurrencyId = new HashMap<Integer, BigDecimal>();
        for (PostingLine currBalLine : currBalLineList) {
            BigDecimal totalAmt = (BigDecimal)totalCurrBalAmtByCurrencyId.get(currBalLine.currency.get_ID());
            if (totalAmt == null) {
                totalAmt = Env.ZERO;
            }
            totalAmt = totalAmt.add(currBalLine.amtAcctDr).subtract(currBalLine.amtAcctCr);
            totalCurrBalAmtByCurrencyId.put(currBalLine.currency.get_ID(), totalAmt);
        }
        MAllocationHdr[] mAllocationHdrArray = allocList;
        int n = allocList.length;
        int n2 = 0;
        while (n2 < n) {
            MAllocationLine line;
            MAllocationLine[] lines;
            MAllocationHdr alloc = mAllocationHdrArray[n2];
            this.postDocument((PO)alloc);
            int C_BPartner_ID = 0;
            int C_BankAccount_ID = 0;
            int C_Charge_ID = 0;
            MAllocationLine[] mAllocationLineArray = lines = alloc.getLines(false);
            int n3 = lines.length;
            int n4 = 0;
            while (n4 < n3) {
                line = mAllocationLineArray[n4];
                if (line.getC_Payment_ID() > 0) {
                    C_BPartner_ID = line.getC_Payment().getC_BPartner_ID();
                    C_BankAccount_ID = line.getC_Payment().getC_BankAccount_ID();
                    C_Charge_ID = line.getC_Payment().getC_Charge_ID();
                    break;
                }
                ++n4;
            }
            if (C_BPartner_ID == 0) {
                mAllocationLineArray = lines;
                n3 = lines.length;
                n4 = 0;
                while (n4 < n3) {
                    line = mAllocationLineArray[n4];
                    if (line.getC_Invoice_ID() > 0) {
                        C_BPartner_ID = line.getC_Invoice().getC_BPartner_ID();
                        break;
                    }
                    if (line.getC_Order_ID() > 0) {
                        C_BPartner_ID = line.getC_Order().getC_BPartner_ID();
                        break;
                    }
                    ++n4;
                }
            }
            mAllocationLineArray = ass;
            n3 = ass.length;
            n4 = 0;
            while (n4 < n3) {
                int[] ids;
                MAllocationLine as = mAllocationLineArray[n4];
                Doc doc = DocManager.getDocument((MAcctSchema)as, (int)735, (int)alloc.get_ID(), (String)this.getTrxName());
                if (C_BankAccount_ID > 0) {
                    doc.setC_BankAccount_ID(C_BankAccount_ID);
                }
                if (C_BPartner_ID > 0) {
                    doc.setC_BPartner_ID(C_BPartner_ID);
                }
                MAccount acctCharge = null;
                if (C_Charge_ID != 0) {
                    acctCharge = MCharge.getAccount((int)C_Charge_ID, (MAcctSchema)as);
                }
                MAccount acctUnallocatedCash = doc.getAccount(10, (MAcctSchema)as);
                MAccount acctReceivable = doc.getAccount(1, (MAcctSchema)as);
                MAccount acctLiability = doc.getAccount(2, (MAcctSchema)as);
                MAccount acctGain = MAccount.get((Properties)as.getCtx(), (int)as.getAcctSchemaDefault().getRealizedGain_Acct());
                MAccount acctLoss = MAccount.get((Properties)as.getCtx(), (int)as.getAcctSchemaDefault().getRealizedLoss_Acct());
                MAccount acctCurrBal = as.getCurrencyBalancing_Acct();
                BigDecimal totalPaymentAmtAcct = Env.ZERO;
                BigDecimal totalTradeAmtAcct = Env.ZERO;
                BigDecimal totalGainLossAmtAcct = Env.ZERO;
                BigDecimal totalCurrBalAmtAcct = Env.ZERO;
                String whereClause = "AD_Table_ID=735 AND Record_ID=" + alloc.get_ID() + " AND C_AcctSchema_ID=" + as.getC_AcctSchema_ID();
                int[] nArray = ids = MFactAcct.getAllIDs((String)"Fact_Acct", (String)whereClause, (String)this.getTrxName());
                int n5 = ids.length;
                int n6 = 0;
                while (n6 < n5) {
                    int id = nArray[n6];
                    MFactAcct fa = new MFactAcct(Env.getCtx(), id, this.getTrxName());
                    if (C_Charge_ID != 0 && acctCharge != null && acctCharge.getAccount_ID() == fa.getAccount_ID()) {
                        totalPaymentAmtAcct = totalPaymentAmtAcct.add(fa.getAmtAcctDr()).subtract(fa.getAmtAcctCr());
                    } else if (C_Charge_ID == 0 && acctUnallocatedCash != null && acctUnallocatedCash.getAccount_ID() == fa.getAccount_ID()) {
                        totalPaymentAmtAcct = totalPaymentAmtAcct.add(fa.getAmtAcctDr()).subtract(fa.getAmtAcctCr());
                    } else if (acctReceivable != null && acctReceivable.getAccount_ID() == fa.getAccount_ID() || acctLiability != null && acctLiability.getAccount_ID() == fa.getAccount_ID()) {
                        totalTradeAmtAcct = totalTradeAmtAcct.add(fa.getAmtAcctDr()).subtract(fa.getAmtAcctCr());
                    } else if (acctGain != null && acctGain.getAccount_ID() == fa.getAccount_ID() || acctLoss != null && acctLoss.getAccount_ID() == fa.getAccount_ID()) {
                        totalGainLossAmtAcct = totalGainLossAmtAcct.add(fa.getAmtAcctDr()).subtract(fa.getAmtAcctCr());
                    } else if (acctCurrBal != null && acctCurrBal.getAccount_ID() == fa.getAccount_ID()) {
                        totalCurrBalAmtAcct = totalCurrBalAmtAcct.add(fa.getAmtAcctDr()).subtract(fa.getAmtAcctCr());
                    }
                    ++n6;
                }
                BigDecimal totalAmtExpected = (BigDecimal)totalPaymentAmtByCurrencyId.get(as.getC_Currency_ID());
                if (totalAmtExpected != null && totalAmtExpected.compareTo(totalPaymentAmtAcct) == 0) {
                    totalPaymentAmtByCurrencyId.remove(as.getC_Currency_ID());
                }
                if ((totalAmtExpected = (BigDecimal)totalTradeAmtByCurrencyId.get(as.getC_Currency_ID())) != null && totalAmtExpected.compareTo(totalTradeAmtAcct) == 0) {
                    totalTradeAmtByCurrencyId.remove(as.getC_Currency_ID());
                }
                if ((totalAmtExpected = (BigDecimal)totalGainLossAmtByCurrencyId.get(as.getC_Currency_ID())) != null && totalAmtExpected.compareTo(totalGainLossAmtAcct) == 0) {
                    totalGainLossAmtByCurrencyId.remove(as.getC_Currency_ID());
                }
                if ((totalAmtExpected = (BigDecimal)totalCurrBalAmtByCurrencyId.get(as.getC_Currency_ID())) != null && totalAmtExpected.compareTo(totalCurrBalAmtAcct) == 0) {
                    totalCurrBalAmtByCurrencyId.remove(as.getC_Currency_ID());
                }
                ++n4;
            }
            ++n2;
        }
        Assertions.assertTrue((boolean)totalPaymentAmtByCurrencyId.isEmpty(), (String)totalPaymentAmtByCurrencyId.toString());
        Assertions.assertTrue((boolean)totalTradeAmtByCurrencyId.isEmpty(), (String)totalTradeAmtByCurrencyId.toString());
        Assertions.assertTrue((boolean)totalGainLossAmtByCurrencyId.isEmpty(), (String)totalGainLossAmtByCurrencyId.toString());
        Assertions.assertTrue((boolean)totalCurrBalAmtByCurrencyId.isEmpty(), (String)totalCurrBalAmtByCurrencyId.toString());
    }

    private BigDecimal getAccountedAmount(MCurrency currency, BigDecimal multiplyRate, BigDecimal sourceAmt) {
        return sourceAmt.multiply(multiplyRate).setScale(currency.getStdPrecision(), RoundingMode.HALF_UP);
    }

    private class PostingLine {
        private MCurrency currency;
        private BigDecimal amtAcctDr;
        private BigDecimal amtAcctCr;

        private PostingLine(MCurrency currency, BigDecimal amtAcctDr, BigDecimal amtAcctCr) {
            this.currency = currency;
            this.amtAcctDr = amtAcctDr;
            this.amtAcctCr = amtAcctCr;
        }

        public String toString() {
            return this.currency.toString() + ", " + String.valueOf(this.amtAcctDr) + ", " + String.valueOf(this.amtAcctCr) + "\n";
        }
    }
}

