/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.test.form;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Properties;
import org.compiere.grid.PaymentFormCheck;
import org.compiere.grid.PaymentFormCreditCard;
import org.compiere.grid.PaymentFormDirect;
import org.compiere.grid.PaymentFormOnCredit;
import org.compiere.model.GridTab;
import org.compiere.model.GridWindow;
import org.compiere.model.MBPartner;
import org.compiere.model.MBankAccountProcessor;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MPayment;
import org.compiere.model.MPaymentProcessor;
import org.compiere.model.MProduct;
import org.compiere.model.MQuery;
import org.compiere.model.PO;
import org.compiere.process.ProcessInfo;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.TimeUtil;
import org.compiere.util.Util;
import org.compiere.wf.MWorkflow;
import org.idempiere.test.AbstractTestCase;
import org.idempiere.test.DictionaryIDs;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class PaymentFormTest
extends AbstractTestCase {
    @Test
    public void testPaymentFormCheck() {
        MOrder order = new MOrder(Env.getCtx(), 0, this.getTrxName());
        order.setBPartner(MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.JOE_BLOCK.id));
        order.setC_DocTypeTarget_ID("SO");
        order.setDeliveryRule("O");
        order.setDocStatus("DR");
        order.setDocAction("CO");
        order.setPaymentRule("S");
        Timestamp today = TimeUtil.getDay((long)System.currentTimeMillis());
        order.setDateOrdered(today);
        order.setDatePromised(today);
        order.saveEx();
        MOrderLine line1 = new MOrderLine(order);
        line1.setLine(10);
        line1.setProduct(MProduct.get((Properties)Env.getCtx(), (int)DictionaryIDs.M_Product.AZALEA_BUSH.id));
        line1.setQty(new BigDecimal("1"));
        line1.setDatePromised(today);
        line1.saveEx();
        ProcessInfo info = MWorkflow.runDocumentActionWorkflow((PO)order, (String)"CO");
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        order.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((Object)"CO", (Object)order.getDocStatus());
        GridWindow gridWindow = GridWindow.get((Properties)Env.getCtx(), (int)1, (int)143);
        Assertions.assertNotNull((Object)gridWindow, (String)"Failed to load grid window of Sales Order");
        gridWindow.initTab(0);
        GridTab gridTab = gridWindow.getTab(0);
        MQuery query = new MQuery("C_Order");
        query.addRestriction("C_Order_ID", "=", order.get_ID());
        gridTab.setQuery(query);
        gridTab.getTableModel().setImportingMode(false, this.getTrxName());
        gridTab.query(false);
        Assertions.assertEquals((int)1, (int)gridTab.getRowCount(), (String)"Unexpected number of row retrieve from DB");
        Assertions.assertEquals((int)order.get_ID(), (int)gridTab.getRecord_ID(), (String)"Wrong record id");
        PaymentFormCheckImpl form = new PaymentFormCheckImpl(0, gridTab);
        form.loadData();
        ArrayList bankAccounts = form.getBankAccountList();
        Assertions.assertTrue((bankAccounts.size() > 0 ? 1 : 0) != 0, (String)"Failed to retrieve list of active bank accounts");
        Assertions.assertTrue((form.getSelectedBankAccountId() > 0 ? 1 : 0) != 0, (String)"Failed to set default selected bank account");
        form.routingNumber = "routingNumber1";
        form.accountNumber = "customerAccountNumber1";
        form.checkNumber = "checkNumber1";
        form.paymentAmount = order.getGrandTotal();
        boolean ok = form.saveChangesInTrx(this.getTrxName());
        Assertions.assertTrue((boolean)ok, (String)("Save failed: " + form.getProcessMessage()));
        Assertions.assertNotNull((Object)form.getPayment(), (String)"Payment not created");
        Assertions.assertTrue((form.getPayment().get_ID() > 0 ? 1 : 0) != 0, (String)"Payment not save successfully");
    }

    @Test
    public void testPaymentFormDirect() {
        MOrder order = new MOrder(Env.getCtx(), 0, this.getTrxName());
        order.setBPartner(MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.JOE_BLOCK.id));
        order.setC_DocTypeTarget_ID("SO");
        order.setDeliveryRule("O");
        order.setDocStatus("DR");
        order.setDocAction("CO");
        order.setPaymentRule("D");
        Timestamp today = TimeUtil.getDay((long)System.currentTimeMillis());
        order.setDateOrdered(today);
        order.setDatePromised(today);
        order.saveEx();
        MOrderLine line1 = new MOrderLine(order);
        line1.setLine(10);
        line1.setProduct(MProduct.get((Properties)Env.getCtx(), (int)DictionaryIDs.M_Product.AZALEA_BUSH.id));
        line1.setQty(new BigDecimal("1"));
        line1.setDatePromised(today);
        line1.saveEx();
        ProcessInfo info = MWorkflow.runDocumentActionWorkflow((PO)order, (String)"CO");
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        order.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((Object)"CO", (Object)order.getDocStatus());
        GridWindow gridWindow = GridWindow.get((Properties)Env.getCtx(), (int)1, (int)143);
        Assertions.assertNotNull((Object)gridWindow, (String)"Failed to load grid window of Sales Order");
        gridWindow.initTab(0);
        GridTab gridTab = gridWindow.getTab(0);
        MQuery query = new MQuery("C_Order");
        query.addRestriction("C_Order_ID", "=", order.get_ID());
        gridTab.setQuery(query);
        gridTab.getTableModel().setImportingMode(false, this.getTrxName());
        gridTab.query(false);
        Assertions.assertEquals((int)1, (int)gridTab.getRowCount(), (String)"Unexpected number of row retrieve from DB");
        Assertions.assertEquals((int)order.get_ID(), (int)gridTab.getRecord_ID(), (String)"Wrong record id");
        PaymentFormDirectImpl form = new PaymentFormDirectImpl(0, gridTab, true);
        try {
            form.dynInit();
        }
        catch (Exception e) {
            Assertions.fail((Throwable)e);
        }
        ArrayList bankAccounts = form.getBankAccountList();
        Assertions.assertTrue((bankAccounts.size() > 0 ? 1 : 0) != 0, (String)"Failed to retrieve list of active bank accounts");
        form.C_BankAccount_ID = ((KeyNamePair)bankAccounts.get(0)).getKey();
        form.routingNumber = "routingNumber1";
        form.accountNumber = "customerAccountNumber1";
        Assertions.assertEquals((Object)order.getGrandTotal().setScale(2, RoundingMode.HALF_EVEN), (Object)form.getPaymentAmount().setScale(2, RoundingMode.HALF_EVEN), (String)"Wrong Payment Form Amount");
        boolean ok = form.saveChangesInTrx(this.getTrxName());
        Assertions.assertTrue((boolean)ok, (String)("Save failed: " + form.getProcessMessage()));
        Assertions.assertNotNull((Object)form.getPayment(), (String)"Payment not created");
        Assertions.assertTrue((form.getPayment().get_ID() > 0 ? 1 : 0) != 0, (String)"Payment not save successfully");
        Assertions.assertEquals((Object)order.getGrandTotal().setScale(2, RoundingMode.HALF_EVEN), (Object)form.getPayment().getPayAmt().setScale(2, RoundingMode.HALF_EVEN), (String)"Wrong Payment Document Amount");
    }

    @Test
    public void testPaymentFormOnCredit() {
        MOrder order = new MOrder(Env.getCtx(), 0, this.getTrxName());
        order.setBPartner(MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.JOE_BLOCK.id));
        order.setC_DocTypeTarget_ID("SO");
        order.setDeliveryRule("O");
        order.setDocStatus("DR");
        order.setDocAction("CO");
        order.setPaymentRule("D");
        order.setC_PaymentTerm_ID(DictionaryIDs.C_PaymentTerm.TWO_PERCENT_10_NET_30.id);
        Timestamp today = TimeUtil.getDay((long)System.currentTimeMillis());
        order.setDateOrdered(today);
        order.setDatePromised(today);
        order.saveEx();
        MOrderLine line1 = new MOrderLine(order);
        line1.setLine(10);
        line1.setProduct(MProduct.get((Properties)Env.getCtx(), (int)DictionaryIDs.M_Product.AZALEA_BUSH.id));
        line1.setQty(new BigDecimal("1"));
        line1.setDatePromised(today);
        line1.saveEx();
        ProcessInfo info = MWorkflow.runDocumentActionWorkflow((PO)order, (String)"CO");
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        order.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((Object)"CO", (Object)order.getDocStatus());
        GridWindow gridWindow = GridWindow.get((Properties)Env.getCtx(), (int)1, (int)143);
        Assertions.assertNotNull((Object)gridWindow, (String)"Failed to load grid window of Sales Order");
        gridWindow.initTab(0);
        GridTab gridTab = gridWindow.getTab(0);
        MQuery query = new MQuery("C_Order");
        query.addRestriction("C_Order_ID", "=", order.get_ID());
        gridTab.setQuery(query);
        gridTab.getTableModel().setImportingMode(false, this.getTrxName());
        gridTab.query(false);
        Assertions.assertEquals((int)1, (int)gridTab.getRowCount(), (String)"Unexpected number of row retrieve from DB");
        Assertions.assertEquals((int)order.get_ID(), (int)gridTab.getRecord_ID(), (String)"Wrong record id");
        PaymentFormOnCreditImpl form = new PaymentFormOnCreditImpl(0, gridTab);
        try {
            form.dynInit();
        }
        catch (Exception e) {
            Assertions.fail((Throwable)e);
        }
        ArrayList terms = form.getPaymentTermList();
        Assertions.assertTrue((terms.size() > 0 ? 1 : 0) != 0, (String)"Failed to retrieve list of active payment terms");
        for (KeyNamePair term : terms) {
            if (term.getKey() != DictionaryIDs.C_PaymentTerm.NET_30.id) continue;
            form.setPaymentTerm(term.getKey());
        }
        form.saveChangesInTrx(this.getTrxName());
        Assertions.assertEquals((int)((Number)gridTab.getValue("C_PaymentTerm_ID")).intValue(), (int)form.getPaymentTerm(), (String)"Wrong Payment Term");
    }

    @Test
    public void testPaymentFormCreditCard() {
        MOrder order = new MOrder(Env.getCtx(), 0, this.getTrxName());
        order.setBPartner(MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.JOE_BLOCK.id));
        order.setC_DocTypeTarget_ID("SO");
        order.setDeliveryRule("O");
        order.setDocStatus("DR");
        order.setDocAction("CO");
        order.setPaymentRule("K");
        Timestamp today = TimeUtil.getDay((long)System.currentTimeMillis());
        order.setDateOrdered(today);
        order.setDatePromised(today);
        order.saveEx();
        MOrderLine line1 = new MOrderLine(order);
        line1.setLine(10);
        line1.setProduct(MProduct.get((Properties)Env.getCtx(), (int)DictionaryIDs.M_Product.AZALEA_BUSH.id));
        line1.setQty(new BigDecimal("1"));
        line1.setDatePromised(today);
        line1.saveEx();
        ProcessInfo info = MWorkflow.runDocumentActionWorkflow((PO)order, (String)"CO");
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        order.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((Object)"CO", (Object)order.getDocStatus());
        GridWindow gridWindow = GridWindow.get((Properties)Env.getCtx(), (int)1, (int)143);
        Assertions.assertNotNull((Object)gridWindow, (String)"Failed to load grid window of Sales Order");
        gridWindow.initTab(0);
        GridTab gridTab = gridWindow.getTab(0);
        MQuery query = new MQuery("C_Order");
        query.addRestriction("C_Order_ID", "=", order.get_ID());
        gridTab.setQuery(query);
        gridTab.getTableModel().setImportingMode(false, this.getTrxName());
        gridTab.query(false);
        Assertions.assertEquals((int)1, (int)gridTab.getRowCount(), (String)"Unexpected number of row retrieve from DB");
        Assertions.assertEquals((int)order.get_ID(), (int)gridTab.getRecord_ID(), (String)"Wrong record id");
        PaymentFormCreditCardImpl form = new PaymentFormCreditCardImpl(0, gridTab);
        try {
            form.dynInit();
        }
        catch (Exception e) {
            Assertions.fail((Throwable)e);
        }
        Assertions.assertEquals((Object)order.getGrandTotal().setScale(2, RoundingMode.HALF_EVEN), (Object)form.getPaymentAmount().setScale(2, RoundingMode.HALF_EVEN), (String)"Wrong Payment Form Amount");
        form.setCCType("M");
        form.CCNumber = "5555555555554444";
        form.CCVV = "123";
        form.CCExp = "1199";
        MBankAccountProcessor[] processors = MBankAccountProcessor.find((Properties)Env.getCtx(), (String)"C", (String)form.getCCType(), (int)this.getAD_Client_ID(), (int)order.getC_Currency_ID(), (BigDecimal)form.getPaymentAmount(), (String)this.getTrxName());
        Assertions.assertTrue((processors.length > 0 ? 1 : 0) != 0, (String)"Fail to retrieve default bank account processor for credit card");
        MPaymentProcessor mpp = null;
        String payProcessorClass = null;
        MBankAccountProcessor[] mBankAccountProcessorArray = processors;
        int n = processors.length;
        int n2 = 0;
        while (n2 < n) {
            MBankAccountProcessor processor = mBankAccountProcessorArray[n2];
            if (processor.accepts("C", form.getCCType())) {
                mpp = new MPaymentProcessor(Env.getCtx(), processor.getC_PaymentProcessor_ID(), null);
                break;
            }
            ++n2;
        }
        Assertions.assertNotNull(mpp, (String)"Failed to find default payment processor for credit card");
        try {
            payProcessorClass = mpp.getPayProcessorClass();
            mpp.setPayProcessorClass("org.compiere.model.PP_Dummy");
            mpp.saveCrossTenantSafeEx();
            boolean ok = form.saveChangesInTrx(this.getTrxName());
            Assertions.assertTrue((boolean)ok, (String)("Save failed: " + form.getProcessMessage()));
            Assertions.assertNotNull((Object)form.getPayment(), (String)"Payment not created");
            Assertions.assertTrue((form.getPayment().get_ID() > 0 ? 1 : 0) != 0, (String)"Payment not save successfully");
            Assertions.assertEquals((Object)order.getGrandTotal().setScale(2, RoundingMode.HALF_EVEN), (Object)form.getPayment().getPayAmt().setScale(2, RoundingMode.HALF_EVEN), (String)"Wrong Payment Document Amount");
        }
        finally {
            mpp.setPayProcessorClass(payProcessorClass);
            mpp.saveCrossTenantSafeEx();
        }
    }

    private class PaymentFormCheckImpl
    extends PaymentFormCheck {
        private String routingNumber;
        private String accountNumber;
        private String checkNumber;
        private BigDecimal paymentAmount;

        public PaymentFormCheckImpl(int windowNo, GridTab mTab) {
            super(windowNo, mTab);
            try {
                this.dynInit();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public boolean checkMandatory() {
            return true;
        }

        public int getSelectedBankAccountId() {
            if (this.selectedBankAccount != null) {
                return this.selectedBankAccount.getKey();
            }
            return 0;
        }

        public boolean saveChangesInTrx(String trxName) {
            return this.save(this.getSelectedBankAccountId(), this.routingNumber, this.accountNumber, this.checkNumber, this.paymentAmount, trxName);
        }

        public String getProcessMessage() {
            return this.processMsg;
        }

        public MPayment getPayment() {
            return this.m_mPayment;
        }

        public void showWindow() {
        }

        public void closeWindow() {
        }

        public Object getWindow() {
            return null;
        }
    }

    private class PaymentFormCreditCardImpl
    extends PaymentFormCreditCard {
        private String CCNumber;
        private String CCExp;
        private String CCVV;

        public PaymentFormCreditCardImpl(int windowNo, GridTab mTab) {
            super(windowNo, mTab);
        }

        public MPayment getPayment() {
            return this.m_mPayment;
        }

        public String getProcessMessage() {
            return this.processMsg;
        }

        public BigDecimal getPaymentAmount() {
            return this.m_Amount;
        }

        public void setCCType(String cctype) {
            this.m_CCType = cctype;
        }

        public String getCCType() {
            return this.m_CCType;
        }

        public boolean checkMandatory() {
            return true;
        }

        public boolean saveChangesInTrx(String trxName) {
            String msg = this.validateCreditCard(this.m_CCType, this.CCNumber, this.CCVV, this.CCExp, 0, null);
            if (!Util.isEmpty((String)msg, (boolean)true)) {
                this.processMsg = msg;
                return false;
            }
            if (!this.processOnline(this.m_CCType, this.CCNumber, this.CCVV, this.CCExp, 0, trxName)) {
                return false;
            }
            return this.save(this.m_CCType, this.CCNumber, this.CCExp, this.m_Amount, trxName);
        }

        public void showWindow() {
        }

        public void closeWindow() {
        }

        public Object getWindow() {
            return null;
        }
    }

    private class PaymentFormDirectImpl
    extends PaymentFormDirect {
        private String routingNumber;
        private String accountNumber;
        private int C_BankAccount_ID;

        public PaymentFormDirectImpl(int windowNo, GridTab mTab, boolean isDebit) {
            super(windowNo, mTab, isDebit);
        }

        public boolean checkMandatory() {
            return true;
        }

        public boolean saveChangesInTrx(String trxName) {
            return this.save(this.C_BankAccount_ID, this.routingNumber, this.accountNumber, trxName);
        }

        public void showWindow() {
        }

        public void closeWindow() {
        }

        public Object getWindow() {
            return null;
        }

        public BigDecimal getPaymentAmount() {
            return this.m_Amount;
        }

        public String getProcessMessage() {
            return this.processMsg;
        }

        public MPayment getPayment() {
            return this.m_mPayment;
        }
    }

    private class PaymentFormOnCreditImpl
    extends PaymentFormOnCredit {
        public PaymentFormOnCreditImpl(int windowNo, GridTab mTab) {
            super(windowNo, mTab);
        }

        public int getPaymentTerm() {
            return this.m_C_PaymentTerm_ID;
        }

        public void setPaymentTerm(int key) {
            this.m_C_PaymentTerm_ID = key;
        }

        public boolean checkMandatory() {
            return true;
        }

        public boolean saveChangesInTrx(String trxName) {
            return this.save(this.m_C_PaymentTerm_ID);
        }

        public void showWindow() {
        }

        public void closeWindow() {
        }

        public Object getWindow() {
            return null;
        }
    }
}

