/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.test.costing;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Timestamp;
import java.util.List;
import java.util.Properties;
import org.compiere.acct.Doc;
import org.compiere.acct.DocManager;
import org.compiere.model.MAccount;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MAttributeSet;
import org.compiere.model.MAttributeSetExclude;
import org.compiere.model.MAttributeSetInstance;
import org.compiere.model.MBPartner;
import org.compiere.model.MClient;
import org.compiere.model.MCost;
import org.compiere.model.MCostDetail;
import org.compiere.model.MFactAcct;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutLine;
import org.compiere.model.MInOutLineMA;
import org.compiere.model.MInventory;
import org.compiere.model.MInventoryLine;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLandedCost;
import org.compiere.model.MOrderLine;
import org.compiere.model.MPriceList;
import org.compiere.model.MPriceListVersion;
import org.compiere.model.MProcess;
import org.compiere.model.MProduct;
import org.compiere.model.MProductCategory;
import org.compiere.model.MProductCategoryAcct;
import org.compiere.model.MProductPrice;
import org.compiere.model.MProduction;
import org.compiere.model.MProductionLine;
import org.compiere.model.MProject;
import org.compiere.model.MProjectIssue;
import org.compiere.model.MStorageOnHand;
import org.compiere.model.PO;
import org.compiere.model.ProductCost;
import org.compiere.model.Query;
import org.compiere.process.DocumentEngine;
import org.compiere.process.ProcessInfo;
import org.compiere.process.ServerProcessCtl;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.TimeUtil;
import org.compiere.util.Trx;
import org.compiere.wf.MWorkflow;
import org.eevolution.model.MPPProductBOM;
import org.eevolution.model.MPPProductBOMLine;
import org.idempiere.test.AbstractTestCase;
import org.idempiere.test.DictionaryIDs;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.Isolated;

@Isolated
public class AveragePOCostingTest
extends AbstractTestCase {
    @Test
    public void testMaterialReceipt() {
        MProduct product = null;
        MClient client = MClient.get((Properties)Env.getCtx());
        MAcctSchema as = client.getAcctSchema();
        Assertions.assertEquals((Object)as.getCostingMethod(), (Object)"A", (String)"Default costing method not Average PO");
        try {
            product = new MProduct(Env.getCtx(), 0, null);
            product.setM_Product_Category_ID(DictionaryIDs.M_Product_Category.CHEMICALS.id);
            product.setName("testMaterialReceipt");
            product.setValue("testMaterialReceipt");
            product.setProductType("I");
            product.setIsStocked(true);
            product.setIsSold(true);
            product.setIsPurchased(true);
            product.setC_UOM_ID(DictionaryIDs.C_UOM.EACH.id);
            product.setC_TaxCategory_ID(DictionaryIDs.C_TaxCategory.STANDARD.id);
            product.saveEx();
            MPriceListVersion plv = MPriceList.get((int)DictionaryIDs.M_PriceList.PURCHASE.id).getPriceListVersion(null);
            MProductPrice pp = new MProductPrice(Env.getCtx(), 0, this.getTrxName());
            pp.setM_PriceList_Version_ID(plv.getM_PriceList_Version_ID());
            pp.setM_Product_ID(product.get_ID());
            pp.setPriceStd(new BigDecimal("2"));
            pp.setPriceList(new BigDecimal("2"));
            pp.saveEx();
            MInOutLine receiptLine = this.createPOAndMRForProduct(product.get_ID(), null, null);
            product.set_TrxName(this.getTrxName());
            MCost cost = product.getCostingRecord(as, this.getAD_Org_ID(), 0, as.getCostingMethod());
            Assertions.assertNotNull((Object)cost, (String)"No MCost record found");
            Assertions.assertEquals((Object)new BigDecimal("2.00"), (Object)cost.getCurrentCostPrice().setScale(2, RoundingMode.HALF_UP), (String)"Unexpected current cost price");
            MCostDetail cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_OrderLine_ID=?", (int)receiptLine.getC_OrderLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for material receipt line");
            Assertions.assertEquals((int)1, (int)cd.getQty().intValue(), (String)"Unexpected MCostDetail Qty");
            Assertions.assertEquals((Object)new BigDecimal("2.00"), (Object)cd.getAmt().setScale(2, RoundingMode.HALF_UP), (String)"Unexpected MCostDetail Amt");
            receiptLine = this.createPOAndMRForProduct(product.get_ID(), null, new BigDecimal("3.00"));
            cost.load(this.getTrxName(), new String[0]);
            Assertions.assertEquals((Object)new BigDecimal("2.50"), (Object)cost.getCurrentCostPrice().setScale(2, RoundingMode.HALF_UP), (String)"Unexpected current cost price");
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_OrderLine_ID=?", (int)receiptLine.getC_OrderLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for material receipt line");
            Assertions.assertEquals((int)1, (int)cd.getQty().intValue(), (String)"Unexpected MCostDetail Qty");
            Assertions.assertEquals((Object)new BigDecimal("3.00"), (Object)cd.getAmt().setScale(2, RoundingMode.HALF_UP), (String)"Unexpected MCostDetail Amt");
            MInOut receipt = new MInOut(Env.getCtx(), receiptLine.getM_InOut_ID(), this.getTrxName());
            ProcessInfo info = MWorkflow.runDocumentActionWorkflow((PO)receipt, (String)"RA");
            Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
            receipt.load(this.getTrxName(), new String[0]);
            Assertions.assertEquals((Object)"RE", (Object)receipt.getDocStatus(), (String)"Unexpected Document Status");
            MInOut reverse = new MInOut(Env.getCtx(), receipt.getReversal_ID(), this.getTrxName());
            if (!reverse.isPosted()) {
                String error = DocumentEngine.postImmediate((Properties)Env.getCtx(), (int)reverse.getAD_Client_ID(), (int)reverse.get_Table_ID(), (int)reverse.get_ID(), (boolean)false, (String)this.getTrxName());
                Assertions.assertNull((Object)error, (String)error);
            }
            cost.load(this.getTrxName(), new String[0]);
            Assertions.assertEquals((Object)new BigDecimal("2.00"), (Object)cost.getCurrentCostPrice().setScale(2, RoundingMode.HALF_UP), (String)"Unexpected current cost price");
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_OrderLine_ID=?", (int)receiptLine.getC_OrderLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertEquals((int)0, (int)cd.getQty().intValue(), (String)"Unexpected MCostDetail Qty");
            Assertions.assertEquals((Object)new BigDecimal("0.00"), (Object)cd.getAmt().setScale(2, RoundingMode.HALF_UP), (String)"Unexpected MCostDetail Amt");
        }
        finally {
            this.rollback();
            if (product != null) {
                product.set_TrxName(null);
                product.deleteEx(true);
            }
        }
    }

    @Test
    public void testShipment() {
        MProduct product = new MProduct(Env.getCtx(), DictionaryIDs.M_Product.AZALEA_BUSH.id, this.getTrxName());
        MClient client = MClient.get((Properties)Env.getCtx());
        MAcctSchema as = client.getAcctSchema();
        Assertions.assertEquals((Object)as.getCostingMethod(), (Object)"A", (String)"Default costing method not Average PO");
        MCost cost = product.getCostingRecord(as, this.getAD_Org_ID(), 0, as.getCostingMethod());
        if (cost == null || cost.getCurrentCostPrice().signum() == 0) {
            this.createPOAndMRForProduct(DictionaryIDs.M_Product.AZALEA_BUSH.id, null, new BigDecimal("5.00"));
            cost = product.getCostingRecord(as, this.getAD_Org_ID(), 0, as.getCostingMethod());
        }
        BigDecimal currentCost = cost.getCurrentCostPrice();
        MOrder order = new MOrder(Env.getCtx(), 0, this.getTrxName());
        order.setBPartner(MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.JOE_BLOCK.id));
        order.setC_DocTypeTarget_ID("SO");
        order.setDeliveryRule("O");
        order.setDocStatus("DR");
        order.setDocAction("CO");
        Timestamp today = TimeUtil.getDay((long)System.currentTimeMillis());
        order.setDatePromised(today);
        order.saveEx();
        MOrderLine line1 = new MOrderLine(order);
        line1.setLine(10);
        line1.setProduct(MProduct.get((Properties)Env.getCtx(), (int)DictionaryIDs.M_Product.AZALEA_BUSH.id));
        line1.setQty(new BigDecimal("1"));
        line1.setDatePromised(today);
        line1.saveEx();
        ProcessInfo info = MWorkflow.runDocumentActionWorkflow((PO)order, (String)"CO");
        order.load(this.getTrxName(), new String[0]);
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        Assertions.assertEquals((Object)"CO", (Object)order.getDocStatus(), (String)"Unexpected Document Status");
        MInOut shipment = new MInOut(order, DictionaryIDs.C_DocType.MM_SHIPMENT.id, order.getDateOrdered());
        shipment.setDocStatus("DR");
        shipment.setDocAction("CO");
        shipment.saveEx();
        MInOutLine shipmentLine = new MInOutLine(shipment);
        shipmentLine.setOrderLine(line1, 0, new BigDecimal("1"));
        shipmentLine.setQty(new BigDecimal("1"));
        shipmentLine.saveEx();
        info = MWorkflow.runDocumentActionWorkflow((PO)shipment, (String)"CO");
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        shipment.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((Object)"CO", (Object)shipment.getDocStatus(), (String)"Unexpected Document Status");
        cost.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((Object)currentCost.setScale(2, RoundingMode.HALF_UP), (Object)cost.getCurrentCostPrice().setScale(2, RoundingMode.HALF_UP), (String)"Unexpected current cost price");
        MCostDetail cd = MCostDetail.get((Properties)Env.getCtx(), (String)"M_InOutLine_ID=?", (int)shipmentLine.get_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
        Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for shipment line");
        Assertions.assertEquals((int)-1, (int)cd.getQty().intValue(), (String)"Unexpected MCostDetail Qty");
        Assertions.assertEquals((Object)currentCost.negate().setScale(2, RoundingMode.HALF_UP), (Object)cd.getAmt().setScale(2, RoundingMode.HALF_UP), (String)"Unexpected MCostDetail Amt");
        info = MWorkflow.runDocumentActionWorkflow((PO)shipment, (String)"RA");
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        shipment.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((Object)"RE", (Object)shipment.getDocStatus(), (String)"Unexpected Document Status");
        cost.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((Object)currentCost.setScale(2, RoundingMode.HALF_UP), (Object)cost.getCurrentCostPrice().setScale(2, RoundingMode.HALF_UP), (String)"Unexpected current cost price");
        MInOut reversal = new MInOut(Env.getCtx(), shipment.getReversal_ID(), this.getTrxName());
        MInOutLine[] reversalLines = reversal.getLines();
        cd = MCostDetail.get((Properties)Env.getCtx(), (String)"M_InOutLine_ID=?", (int)reversalLines[0].get_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
        Assertions.assertEquals((int)1, (int)cd.getQty().intValue(), (String)"Unexpected MCostDetail Qty");
        Assertions.assertEquals((Object)currentCost.setScale(2, RoundingMode.HALF_UP), (Object)cd.getAmt().setScale(2, RoundingMode.HALF_UP), (String)"Unexpected current cost price");
    }

    @Test
    public void testInternalUse() {
        MClient client = MClient.get((Properties)Env.getCtx());
        MAcctSchema as = client.getAcctSchema();
        Assertions.assertEquals((Object)as.getCostingMethod(), (Object)"A", (String)"Default costing method not Average PO");
        MProduct product = new MProduct(Env.getCtx(), DictionaryIDs.M_Product.MULCH.id, this.getTrxName());
        MCost cost = product.getCostingRecord(as, this.getAD_Org_ID(), 0, as.getCostingMethod());
        if (cost == null || cost.getCurrentCostPrice().signum() == 0 || cost.getCurrentQty().signum() == 0) {
            this.createPOAndMRForProduct(DictionaryIDs.M_Product.MULCH.id, null, null);
            cost = product.getCostingRecord(as, this.getAD_Org_ID(), 0, as.getCostingMethod());
        }
        Assertions.assertNotNull((Object)cost, (String)"No MCost Record");
        BigDecimal currentCost = cost.getCurrentCostPrice();
        MInventory inventory = new MInventory(Env.getCtx(), 0, this.getTrxName());
        inventory.setC_DocType_ID(DictionaryIDs.C_DocType.INTERNAL_USE_INVENTORY.id);
        inventory.saveEx();
        MInventoryLine line = new MInventoryLine(Env.getCtx(), 0, this.getTrxName());
        line.setM_Inventory_ID(inventory.get_ID());
        line.setM_Product_ID(DictionaryIDs.M_Product.MULCH.id);
        line.setQtyInternalUse(new BigDecimal("1.00"));
        line.setC_Charge_ID(DictionaryIDs.C_Charge.COMMISSIONS.id);
        line.setM_Locator_ID(DictionaryIDs.M_Locator.HQ.id);
        line.saveEx();
        ProcessInfo info = MWorkflow.runDocumentActionWorkflow((PO)inventory, (String)"CO");
        inventory.load(this.getTrxName(), new String[0]);
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        Assertions.assertEquals((Object)"CO", (Object)inventory.getDocStatus(), (String)"Unexpected Document Status");
        MCostDetail cd = MCostDetail.get((Properties)Env.getCtx(), (String)"M_InventoryLine_ID=?", (int)line.getM_InventoryLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
        Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for internal use line");
        Assertions.assertEquals((int)-1, (int)cd.getQty().intValue(), (String)"Unexpected MCostDetail Qty");
        Assertions.assertEquals((Object)currentCost.negate().setScale(2, RoundingMode.HALF_UP), (Object)cd.getAmt().setScale(2, RoundingMode.HALF_UP), (String)"Unexpected MCostDetail Amt");
        cost.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((Object)currentCost.setScale(2, RoundingMode.HALF_UP), (Object)cost.getCurrentCostPrice().setScale(2, RoundingMode.HALF_UP), (String)"Unexpected current cost");
        info = MWorkflow.runDocumentActionWorkflow((PO)inventory, (String)"RA");
        inventory.load(this.getTrxName(), new String[0]);
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        Assertions.assertEquals((Object)"RE", (Object)inventory.getDocStatus(), (String)"Unexpected Document Status");
        MInventory reversal = new MInventory(Env.getCtx(), inventory.getReversal_ID(), this.getTrxName());
        cd = MCostDetail.get((Properties)Env.getCtx(), (String)"M_InventoryLine_ID=?", (int)reversal.getLines(false)[0].getM_InventoryLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
        Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for internal use line");
        Assertions.assertEquals((int)1, (int)cd.getQty().intValue(), (String)"Unexpected MCostDetail Qty");
        Assertions.assertEquals((Object)currentCost.setScale(2, RoundingMode.HALF_UP), (Object)cd.getAmt().setScale(2, RoundingMode.HALF_UP), (String)"Unexpected MCostDetail Amt");
        cost.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((Object)currentCost.setScale(2, RoundingMode.HALF_UP), (Object)cost.getCurrentCostPrice().setScale(2, RoundingMode.HALF_UP), (String)"Unexpected current cost");
    }

    @Test
    public void testProjectIssue() {
        MClient client = MClient.get((Properties)Env.getCtx());
        MAcctSchema as = client.getAcctSchema();
        Assertions.assertEquals((Object)as.getCostingMethod(), (Object)"A", (String)"Default costing method not Average PO");
        MProduct product = new MProduct(Env.getCtx(), DictionaryIDs.M_Product.MULCH.id, this.getTrxName());
        MCost cost = product.getCostingRecord(as, this.getAD_Org_ID(), 0, as.getCostingMethod());
        if (cost == null || cost.getCurrentCostPrice().signum() == 0 || cost.getCurrentQty().signum() == 0) {
            this.createPOAndMRForProduct(DictionaryIDs.M_Product.MULCH.id, null, null);
            cost = product.getCostingRecord(as, this.getAD_Org_ID(), 0, as.getCostingMethod());
        }
        Assertions.assertNotNull((Object)cost, (String)"No MCost Record");
        BigDecimal currentCost = cost.getCurrentCostPrice();
        MProject project = new MProject(Env.getCtx(), 0, this.getTrxName());
        project.setName("testProjectIssue");
        project.setC_Currency_ID(DictionaryIDs.C_Currency.USD.id);
        project.saveEx();
        MProjectIssue issue = new MProjectIssue(project);
        issue.setM_Product_ID(DictionaryIDs.M_Product.MULCH.id);
        issue.setLine(10);
        issue.setM_Locator_ID(DictionaryIDs.M_Locator.HQ.id);
        issue.setMovementQty(new BigDecimal("1.00"));
        issue.saveEx();
        ProcessInfo info = MWorkflow.runDocumentActionWorkflow((PO)issue, (String)"CO");
        issue.load(this.getTrxName(), new String[0]);
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        Assertions.assertEquals((Object)"CO", (Object)issue.getDocStatus(), (String)"Unexpected Document Status");
        if (!issue.isPosted()) {
            String error = DocumentEngine.postImmediate((Properties)Env.getCtx(), (int)issue.getAD_Client_ID(), (int)issue.get_Table_ID(), (int)issue.get_ID(), (boolean)false, (String)this.getTrxName());
            Assertions.assertNull((Object)error, (String)error);
        }
        MCostDetail cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_ProjectIssue_ID=?", (int)issue.getC_ProjectIssue_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
        Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for project issue line");
        Assertions.assertEquals((int)-1, (int)cd.getQty().intValue(), (String)"Unexpected MCostDetail Qty");
        Assertions.assertEquals((Object)currentCost.negate().setScale(2, RoundingMode.HALF_UP), (Object)cd.getAmt().setScale(2, RoundingMode.HALF_UP), (String)"Unexpected MCostDetail Amt");
        cost.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((Object)currentCost.setScale(2, RoundingMode.HALF_UP), (Object)cost.getCurrentCostPrice().setScale(2, RoundingMode.HALF_UP), (String)"Unexpected current cost");
        info = MWorkflow.runDocumentActionWorkflow((PO)issue, (String)"RA");
        issue.load(this.getTrxName(), new String[0]);
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        Assertions.assertEquals((Object)"RE", (Object)issue.getDocStatus(), (String)"Unexpected Document Status");
        cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_ProjectIssue_ID=?", (int)issue.getReversal_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
        Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for project issue line");
        Assertions.assertEquals((int)1, (int)cd.getQty().intValue(), (String)"Unexpected MCostDetail Qty");
        Assertions.assertEquals((Object)currentCost.setScale(2, RoundingMode.HALF_UP), (Object)cd.getAmt().setScale(2, RoundingMode.HALF_UP), (String)"Unexpected MCostDetail Amt");
        cost.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((Object)currentCost.setScale(2, RoundingMode.HALF_UP), (Object)cost.getCurrentCostPrice().setScale(2, RoundingMode.HALF_UP), (String)"Unexpected current cost");
    }

    @Test
    public void testProduction() {
        MProduct mulch = new MProduct(Env.getCtx(), DictionaryIDs.M_Product.MULCH.id, this.getTrxName());
        MProduct azb = new MProduct(Env.getCtx(), DictionaryIDs.M_Product.AZALEA_BUSH.id, this.getTrxName());
        MProduct mulchX = new MProduct(Env.getCtx(), 0, null);
        mulchX.setName("MulchX2");
        mulchX.setIsBOM(true);
        mulchX.setIsStocked(true);
        mulchX.setC_UOM_ID(mulch.getC_UOM_ID());
        mulchX.setM_Product_Category_ID(mulch.getM_Product_Category_ID());
        mulchX.setProductType(mulch.getProductType());
        mulchX.setM_AttributeSet_ID(mulch.getM_AttributeSet_ID());
        mulchX.setC_TaxCategory_ID(mulch.getC_TaxCategory_ID());
        mulchX.saveEx();
        try {
            MClient client = MClient.get((Properties)Env.getCtx());
            MAcctSchema as = client.getAcctSchema();
            Assertions.assertEquals((Object)as.getCostingMethod(), (Object)"A", (String)"Default costing method not Average PO");
            MCost cost = mulch.getCostingRecord(as, this.getAD_Org_ID(), 0, as.getCostingMethod());
            if (cost == null || cost.getCurrentCostPrice().signum() == 0 || cost.getCurrentQty().signum() == 0) {
                this.createPOAndMRForProduct(DictionaryIDs.M_Product.MULCH.id, null, null);
                cost = mulch.getCostingRecord(as, this.getAD_Org_ID(), 0, as.getCostingMethod());
            }
            BigDecimal mulchCost = cost.getCurrentCostPrice();
            cost = azb.getCostingRecord(as, this.getAD_Org_ID(), 0, as.getCostingMethod());
            if (cost == null || cost.getCurrentCostPrice().signum() == 0 || cost.getCurrentQty().signum() == 0) {
                this.createPOAndMRForProduct(DictionaryIDs.M_Product.AZALEA_BUSH.id, null, null);
                cost = azb.getCostingRecord(as, this.getAD_Org_ID(), 0, as.getCostingMethod());
            }
            BigDecimal azbCost = cost.getCurrentCostPrice();
            MPPProductBOM bom = new MPPProductBOM(Env.getCtx(), 0, this.getTrxName());
            bom.setM_Product_ID(mulchX.get_ID());
            bom.setBOMType("A");
            bom.setBOMUse("A");
            bom.setName(mulchX.getName());
            bom.saveEx();
            MPPProductBOMLine line1 = new MPPProductBOMLine(bom);
            line1.setM_Product_ID(DictionaryIDs.M_Product.MULCH.id);
            line1.setQtyBOM(new BigDecimal("1"));
            line1.saveEx();
            MPPProductBOMLine line2 = new MPPProductBOMLine(bom);
            line2.setM_Product_ID(DictionaryIDs.M_Product.AZALEA_BUSH.id);
            line2.setQtyBOM(new BigDecimal("1"));
            line2.saveEx();
            mulchX.load(null, new String[0]);
            mulchX.setIsVerified(true);
            mulchX.saveEx();
            MProduction production = new MProduction(Env.getCtx(), 0, this.getTrxName());
            production.setM_Product_ID(mulchX.get_ID());
            production.setM_Locator_ID(DictionaryIDs.M_Locator.HQ.id);
            production.setIsUseProductionPlan(false);
            production.setMovementDate(this.getLoginDate());
            production.setDocAction("CO");
            production.setDocStatus("DR");
            production.setIsComplete(false);
            production.setProductionQty(new BigDecimal("1"));
            production.setPP_Product_BOM_ID(bom.getPP_Product_BOM_ID());
            production.saveEx();
            int productionCreate = 53226;
            MProcess process = MProcess.get((Properties)Env.getCtx(), (int)productionCreate);
            ProcessInfo pi = new ProcessInfo(process.getName(), process.get_ID());
            pi.setAD_Client_ID(this.getAD_Client_ID());
            pi.setAD_User_ID(this.getAD_User_ID());
            pi.setRecord_ID(production.get_ID());
            pi.setTransactionName(this.getTrxName());
            ServerProcessCtl.process((ProcessInfo)pi, (Trx)this.getTrx(), (boolean)false);
            Assertions.assertFalse((boolean)pi.isError(), (String)pi.getSummary());
            production.load(this.getTrxName(), new String[0]);
            MProductionLine[] plines = production.getLines();
            Assertions.assertEquals((Object)"Y", (Object)production.getIsCreated(), (String)"MProduction.IsCreated != Y");
            Assertions.assertTrue((plines.length > 0 ? 1 : 0) != 0, (String)"No Production Lines");
            Assertions.assertEquals((int)3, (int)plines.length, (String)"Unexpected number of production lines");
            ProcessInfo info = MWorkflow.runDocumentActionWorkflow((PO)production, (String)"CO");
            production.load(this.getTrxName(), new String[0]);
            Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
            Assertions.assertEquals((Object)"CO", (Object)production.getDocStatus(), (String)("Production Status=" + production.getDocStatus()));
            BigDecimal rollup = mulchCost.add(azbCost);
            MCostDetail cd = MCostDetail.get((Properties)Env.getCtx(), (String)"M_ProductionLine_ID=?", (int)plines[0].getM_ProductionLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for project issue line");
            Assertions.assertEquals((int)1, (int)cd.getQty().intValue(), (String)"Unexpected MCostDetail Qty");
            Assertions.assertEquals((Object)rollup.setScale(2, RoundingMode.HALF_UP), (Object)cd.getAmt().setScale(2, RoundingMode.HALF_UP), (String)"Unexpected MCostDetail Amt");
            mulchX.set_TrxName(this.getTrxName());
            cost = mulchX.getCostingRecord(as, this.getAD_Org_ID(), 0, as.getCostingMethod());
            Assertions.assertEquals((Object)rollup.setScale(2, RoundingMode.HALF_UP), (Object)cost.getCurrentCostPrice().setScale(2, RoundingMode.HALF_UP), (String)"Unexpected current cost");
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"M_ProductionLine_ID=?", (int)plines[1].getM_ProductionLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for project issue line");
            Assertions.assertEquals((int)-1, (int)cd.getQty().intValue(), (String)"Unexpected MCostDetail Qty");
            Assertions.assertEquals((Object)mulchCost.negate().setScale(2, RoundingMode.HALF_UP), (Object)cd.getAmt().setScale(2, RoundingMode.HALF_UP), (String)"Unexpected MCostDetail Amt");
            cost = mulch.getCostingRecord(as, this.getAD_Org_ID(), 0, as.getCostingMethod());
            Assertions.assertEquals((Object)mulchCost.setScale(2, RoundingMode.HALF_UP), (Object)cost.getCurrentCostPrice().setScale(2, RoundingMode.HALF_UP), (String)"Unexpected current cost");
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"M_ProductionLine_ID=?", (int)plines[2].getM_ProductionLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for project issue line");
            Assertions.assertEquals((int)-1, (int)cd.getQty().intValue(), (String)"Unexpected MCostDetail Qty");
            Assertions.assertEquals((Object)azbCost.negate().setScale(2, RoundingMode.HALF_UP), (Object)cd.getAmt().setScale(2, RoundingMode.HALF_UP), (String)"Unexpected MCostDetail Amt");
            cost = azb.getCostingRecord(as, this.getAD_Org_ID(), 0, as.getCostingMethod());
            Assertions.assertEquals((Object)azbCost.setScale(2, RoundingMode.HALF_UP), (Object)cost.getCurrentCostPrice().setScale(2, RoundingMode.HALF_UP), (String)"Unexpected current cost");
            info = MWorkflow.runDocumentActionWorkflow((PO)production, (String)"RA");
            production.load(this.getTrxName(), new String[0]);
            Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
            Assertions.assertEquals((Object)"RE", (Object)production.getDocStatus(), (String)("Production Status=" + production.getDocStatus()));
            MProduction reversal = new MProduction(Env.getCtx(), production.getReversal_ID(), this.getTrxName());
            MProductionLine[] reversalLines = reversal.getLines();
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"M_ProductionLine_ID=?", (int)reversalLines[0].getM_ProductionLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for project issue line");
            Assertions.assertEquals((int)-1, (int)cd.getQty().intValue(), (String)"Unexpected MCostDetail Qty");
            Assertions.assertEquals((Object)rollup.negate().setScale(2, RoundingMode.HALF_UP), (Object)cd.getAmt().setScale(2, RoundingMode.HALF_UP), (String)"Unexpected MCostDetail Amt");
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"M_ProductionLine_ID=?", (int)reversalLines[1].getM_ProductionLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for project issue line");
            Assertions.assertEquals((int)1, (int)cd.getQty().intValue(), (String)"Unexpected MCostDetail Qty");
            Assertions.assertEquals((Object)mulchCost.setScale(2, RoundingMode.HALF_UP), (Object)cd.getAmt().setScale(2, RoundingMode.HALF_UP), (String)"Unexpected MCostDetail Amt");
            cost = mulch.getCostingRecord(as, this.getAD_Org_ID(), 0, as.getCostingMethod());
            Assertions.assertEquals((Object)mulchCost.setScale(2, RoundingMode.HALF_UP), (Object)cost.getCurrentCostPrice().setScale(2, RoundingMode.HALF_UP), (String)"Unexpected current cost");
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"M_ProductionLine_ID=?", (int)reversalLines[2].getM_ProductionLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for project issue line");
            Assertions.assertEquals((int)1, (int)cd.getQty().intValue(), (String)"Unexpected MCostDetail Qty");
            Assertions.assertEquals((Object)azbCost.setScale(2, RoundingMode.HALF_UP), (Object)cd.getAmt().setScale(2, RoundingMode.HALF_UP), (String)"Unexpected MCostDetail Amt");
            cost = azb.getCostingRecord(as, this.getAD_Org_ID(), 0, as.getCostingMethod());
        }
        catch (Throwable throwable) {
            this.rollback();
            DB.executeUpdateEx((String)"delete from m_cost where m_product_id=?", (Object[])new Object[]{mulchX.get_ID()}, null);
            mulchX.set_TrxName(null);
            mulchX.deleteEx(true);
            throw throwable;
        }
        this.rollback();
        DB.executeUpdateEx((String)"delete from m_cost where m_product_id=?", (Object[])new Object[]{mulchX.get_ID()}, null);
        mulchX.set_TrxName(null);
        mulchX.deleteEx(true);
    }

    @Test
    public void testMRAndShipmentByLot() {
        MClient client = MClient.get((Properties)Env.getCtx());
        MAcctSchema as = client.getAcctSchema();
        MProductCategory lotLevel = new MProductCategory(Env.getCtx(), 0, null);
        lotLevel.setName("testMaterialReceiptLot");
        lotLevel.saveEx();
        MProduct product = null;
        MAttributeSetExclude exclude = null;
        MAttributeSetExclude exclude1 = null;
        try {
            MAttributeSet mas = new MAttributeSet(Env.getCtx(), DictionaryIDs.M_AttributeSet.FERTILIZER_LOT.id, this.getTrxName());
            mas.setMandatoryType("N");
            mas.saveEx();
            exclude = new MAttributeSetExclude(Env.getCtx(), 0, null);
            exclude.setM_AttributeSet_ID(mas.get_ID());
            exclude.setAD_Table_ID(260);
            exclude.setIsSOTrx(true);
            exclude.saveEx();
            exclude1 = new MAttributeSetExclude(Env.getCtx(), 0, null);
            exclude1.setM_AttributeSet_ID(mas.get_ID());
            exclude1.setAD_Table_ID(320);
            exclude1.setIsSOTrx(true);
            exclude1.saveEx();
            MProductCategoryAcct lotLevelAcct = MProductCategoryAcct.get((int)lotLevel.get_ID(), (int)as.get_ID());
            lotLevelAcct = new MProductCategoryAcct(Env.getCtx(), lotLevelAcct);
            lotLevelAcct.setCostingLevel("B");
            lotLevelAcct.saveEx();
            product = new MProduct(Env.getCtx(), 0, null);
            product.setM_Product_Category_ID(lotLevel.get_ID());
            product.setName("testMaterialReceiptLot");
            product.setProductType("I");
            product.setIsStocked(true);
            product.setIsSold(true);
            product.setIsPurchased(true);
            product.setC_UOM_ID(DictionaryIDs.C_UOM.EACH.id);
            product.setC_TaxCategory_ID(DictionaryIDs.C_TaxCategory.STANDARD.id);
            product.setM_AttributeSet_ID(DictionaryIDs.M_AttributeSet.FERTILIZER_LOT.id);
            product.saveEx();
            MPriceListVersion plv = MPriceList.get((int)DictionaryIDs.M_PriceList.PURCHASE.id).getPriceListVersion(null);
            MProductPrice pp = new MProductPrice(Env.getCtx(), 0, this.getTrxName());
            pp.setM_PriceList_Version_ID(plv.getM_PriceList_Version_ID());
            pp.setM_Product_ID(product.get_ID());
            pp.setPriceStd(new BigDecimal("2"));
            pp.setPriceList(new BigDecimal("2"));
            pp.saveEx();
            MAttributeSetInstance asi1 = new MAttributeSetInstance(Env.getCtx(), 0, this.getTrxName());
            asi1.setM_AttributeSet_ID(DictionaryIDs.M_AttributeSet.FERTILIZER_LOT.id);
            asi1.setLot("Lot1");
            asi1.saveEx();
            MInOutLine line1 = this.createPOAndMRForProduct(product.get_ID(), asi1, new BigDecimal("2.00"));
            MAttributeSetInstance asi2 = new MAttributeSetInstance(Env.getCtx(), 0, this.getTrxName());
            asi2.setM_AttributeSet_ID(DictionaryIDs.M_AttributeSet.FERTILIZER_LOT.id);
            asi2.setLot("Lot2");
            asi2.saveEx();
            MInOutLine line2 = this.createPOAndMRForProduct(product.get_ID(), asi2, new BigDecimal("3.00"));
            MCostDetail cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_OrderLine_ID=?", (int)line1.getC_OrderLine_ID(), (int)asi1.get_ID(), (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for order line1");
            Assertions.assertEquals((int)1, (int)cd.getQty().intValue(), (String)"Unexpected MCostDetail Qty");
            Assertions.assertEquals((Object)new BigDecimal("2").setScale(2, RoundingMode.HALF_UP), (Object)cd.getAmt().setScale(2, RoundingMode.HALF_UP), (String)"Unexpected MCostDetail Amt");
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_OrderLine_ID=?", (int)line2.getC_OrderLine_ID(), (int)asi2.get_ID(), (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for order line1");
            Assertions.assertEquals((int)1, (int)cd.getQty().intValue(), (String)"Unexpected MCostDetail Qty");
            Assertions.assertEquals((Object)new BigDecimal("3").setScale(2, RoundingMode.HALF_UP), (Object)cd.getAmt().setScale(2, RoundingMode.HALF_UP), (String)"Unexpected MCostDetail Amt");
            product.set_TrxName(this.getTrxName());
            MCost cost1 = product.getCostingRecord(as, this.getAD_Org_ID(), asi1.get_ID(), as.getCostingMethod());
            Assertions.assertNotNull((Object)cost1, (String)"MCost record not found");
            Assertions.assertEquals((Object)new BigDecimal("2.00"), (Object)cost1.getCurrentCostPrice().setScale(2, RoundingMode.HALF_UP));
            MCost cost2 = product.getCostingRecord(as, this.getAD_Org_ID(), asi2.get_ID(), as.getCostingMethod());
            Assertions.assertNotNull((Object)cost2, (String)"MCost record not found");
            Assertions.assertEquals((Object)new BigDecimal("3.00"), (Object)cost2.getCurrentCostPrice().setScale(2, RoundingMode.HALF_UP));
            ProductCost pc = new ProductCost(Env.getCtx(), line1.getM_Product_ID(), line1.getM_AttributeSetInstance_ID(), this.getTrxName());
            MAccount asset = pc.getAccount(3, as);
            Doc doc = DocManager.getDocument((MAcctSchema)as, (int)319, (int)line1.getM_InOut_ID(), (String)this.getTrxName());
            doc.setC_BPartner_ID(line1.getParent().getC_BPartner_ID());
            MAccount acctNIR = doc.getAccount(51, as);
            Query query = MFactAcct.createRecordIdQuery((int)319, (int)line1.getM_InOut_ID(), (int)as.getC_AcctSchema_ID(), (String)this.getTrxName());
            List fas = query.list();
            Assertions.assertTrue((fas.size() > 0 ? 1 : 0) != 0, (String)"Failed to retrieve fact posting entries for shipment document");
            boolean nirFound = false;
            boolean assetFound = false;
            for (MFactAcct fa : fas) {
                if (asset.getAccount_ID() == fa.getAccount_ID()) {
                    if (line1.get_ID() == fa.getLine_ID()) {
                        Assertions.assertEquals((Object)fa.getAmtSourceDr().abs().toPlainString(), (Object)fa.getAmtSourceDr().toPlainString(), (String)"Not DR Asset");
                        Assertions.assertTrue((fa.getAmtSourceDr().signum() > 0 ? 1 : 0) != 0, (String)"Not DR Asset");
                    }
                    assetFound = true;
                    continue;
                }
                if (acctNIR.getAccount_ID() != fa.getAccount_ID()) continue;
                if (line1.get_ID() == fa.getLine_ID()) {
                    Assertions.assertEquals((Object)fa.getAmtSourceCr().abs().toPlainString(), (Object)fa.getAmtSourceCr().toPlainString(), (String)"Not CR Not Invoiced Receipt");
                    Assertions.assertTrue((fa.getAmtSourceCr().signum() > 0 ? 1 : 0) != 0, (String)"Not CR Not Invoiced Receipt");
                }
                nirFound = true;
            }
            Assertions.assertTrue((boolean)nirFound, (String)"No Not Invoiced Receipt posting found");
            Assertions.assertTrue((boolean)assetFound, (String)"No Product Asset posting found");
            MOrder order = new MOrder(Env.getCtx(), 0, this.getTrxName());
            order.setBPartner(MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.JOE_BLOCK.id));
            order.setC_DocTypeTarget_ID("SO");
            order.setDeliveryRule("O");
            order.setDocStatus("DR");
            order.setDocAction("CO");
            Timestamp today = TimeUtil.getDay((long)System.currentTimeMillis());
            order.setDatePromised(today);
            order.saveEx();
            MOrderLine ol1 = new MOrderLine(order);
            ol1.setLine(10);
            ol1.setProduct(product);
            ol1.setQty(new BigDecimal("2"));
            ol1.setDatePromised(today);
            ol1.saveEx();
            ProcessInfo info = MWorkflow.runDocumentActionWorkflow((PO)order, (String)"CO");
            order.load(this.getTrxName(), new String[0]);
            Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
            Assertions.assertEquals((Object)"CO", (Object)order.getDocStatus(), (String)"Unexpected document status");
            MInOut shipment = new MInOut(order, DictionaryIDs.C_DocType.MM_SHIPMENT.id, order.getDateOrdered());
            shipment.setDocStatus("DR");
            shipment.setDocAction("CO");
            shipment.saveEx();
            MInOutLine shipmentLine = new MInOutLine(shipment);
            shipmentLine.setOrderLine(ol1, 0, new BigDecimal("2"));
            shipmentLine.setQty(new BigDecimal("2"));
            shipmentLine.saveEx();
            info = MWorkflow.runDocumentActionWorkflow((PO)shipment, (String)"CO");
            Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
            shipment.load(this.getTrxName(), new String[0]);
            Assertions.assertEquals((Object)"CO", (Object)shipment.getDocStatus(), (String)"Unexpected document status");
            MInOutLineMA[] linema = MInOutLineMA.get((Properties)Env.getCtx(), (int)shipmentLine.get_ID(), (String)this.getTrxName());
            Assertions.assertEquals((int)2, (int)linema.length, (String)"Unexpected number of MInOutLineMA records");
            Assertions.assertEquals((int)linema[0].getM_AttributeSetInstance_ID(), (int)asi1.get_ID(), (String)"Unexpected M_AttributeSetInstance_ID for MInOutLineMA 1");
            Assertions.assertEquals((int)linema[1].getM_AttributeSetInstance_ID(), (int)asi2.get_ID(), (String)"Unexpected M_AttributeSetInstance_ID for MInOutLineMA 2");
            Assertions.assertEquals((int)1, (int)linema[0].getMovementQty().intValue(), (String)"Unexpected MovementQty for MInOutLineMA 1");
            Assertions.assertEquals((int)1, (int)linema[1].getMovementQty().intValue(), (String)"Unexpected MovementQty for MInOutLineMA 2");
            if (!shipment.isPosted()) {
                String error = DocumentEngine.postImmediate((Properties)Env.getCtx(), (int)shipment.getAD_Client_ID(), (int)shipment.get_Table_ID(), (int)shipment.get_ID(), (boolean)false, (String)this.getTrxName());
                Assertions.assertTrue((error == null ? 1 : 0) != 0, (String)error);
            }
            pc = new ProductCost(Env.getCtx(), shipmentLine.getM_Product_ID(), shipmentLine.getM_AttributeSetInstance_ID(), this.getTrxName());
            MAccount cogs = pc.getAccount(4, as);
            asset = pc.getAccount(3, as);
            query = MFactAcct.createRecordIdQuery((int)319, (int)shipment.getM_InOut_ID(), (int)as.getC_AcctSchema_ID(), (String)this.getTrxName());
            fas = query.list();
            Assertions.assertTrue((fas.size() > 0 ? 1 : 0) != 0, (String)"Failed to retrieve fact posting entries for shipment document");
            boolean cogsFound = false;
            assetFound = false;
            for (MFactAcct fa : fas) {
                if (cogs.getAccount_ID() == fa.getAccount_ID()) {
                    if (shipmentLine.get_ID() == fa.getLine_ID()) {
                        Assertions.assertEquals((Object)fa.getAmtSourceDr().abs().toPlainString(), (Object)fa.getAmtSourceDr().toPlainString(), (String)"Not DR COGS");
                        Assertions.assertTrue((fa.getAmtSourceDr().signum() > 0 ? 1 : 0) != 0, (String)"Not DR COGS");
                    }
                    cogsFound = true;
                    continue;
                }
                if (asset.getAccount_ID() != fa.getAccount_ID()) continue;
                if (shipmentLine.get_ID() == fa.getLine_ID()) {
                    Assertions.assertEquals((Object)fa.getAmtSourceCr().abs().toPlainString(), (Object)fa.getAmtSourceCr().toPlainString(), (String)"Not CR Product Asset");
                    Assertions.assertTrue((fa.getAmtSourceCr().signum() > 0 ? 1 : 0) != 0, (String)"Not CR Product Asset");
                }
                assetFound = true;
            }
            Assertions.assertTrue((boolean)cogsFound, (String)"No COGS posting found");
            Assertions.assertTrue((boolean)assetFound, (String)"No Product Asset posting found");
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"M_InOutLine_ID=?", (int)shipmentLine.getM_InOutLine_ID(), (int)linema[0].getM_AttributeSetInstance_ID(), (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for order line1");
            Assertions.assertEquals((int)-1, (int)cd.getQty().intValue(), (String)"Unexpected MCostDetail Qty");
            Assertions.assertEquals((Object)new BigDecimal("2").negate().setScale(2, RoundingMode.HALF_UP), (Object)cd.getAmt().setScale(2, RoundingMode.HALF_UP), (String)"Unexpected MCostDetail Amt");
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"M_InOutLine_ID=?", (int)shipmentLine.getM_InOutLine_ID(), (int)linema[1].getM_AttributeSetInstance_ID(), (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for order line1");
            Assertions.assertEquals((int)-1, (int)cd.getQty().intValue(), (String)"Unexpected MCostDetail Qty");
            Assertions.assertEquals((Object)new BigDecimal("3").negate().setScale(2, RoundingMode.HALF_UP), (Object)cd.getAmt().setScale(2, RoundingMode.HALF_UP), (String)"Unexpected MCostDetail Amt");
            info = MWorkflow.runDocumentActionWorkflow((PO)shipment, (String)"RA");
            Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
            shipment.load(this.getTrxName(), new String[0]);
            Assertions.assertEquals((Object)"RE", (Object)shipment.getDocStatus(), (String)"Unexpected document status");
            MInOut reversal = new MInOut(Env.getCtx(), shipment.getReversal_ID(), this.getTrxName());
            MInOutLine[] reversalLines = reversal.getLines();
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"M_InOutLine_ID=?", (int)reversalLines[0].getM_InOutLine_ID(), (int)asi1.getM_AttributeSetInstance_ID(), (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for order line1");
            Assertions.assertEquals((int)1, (int)cd.getQty().intValue(), (String)"Unexpected MCostDetail Qty");
            Assertions.assertEquals((Object)new BigDecimal("2").setScale(2, RoundingMode.HALF_UP), (Object)cd.getAmt().setScale(2, RoundingMode.HALF_UP), (String)"Unexpected MCostDetail Amt");
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"M_InOutLine_ID=?", (int)reversalLines[0].getM_InOutLine_ID(), (int)asi2.getM_AttributeSetInstance_ID(), (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for order line1");
            Assertions.assertEquals((int)1, (int)cd.getQty().intValue(), (String)"Unexpected MCostDetail Qty");
            Assertions.assertEquals((Object)new BigDecimal("3").setScale(2, RoundingMode.HALF_UP), (Object)cd.getAmt().setScale(2, RoundingMode.HALF_UP), (String)"Unexpected MCostDetail Amt");
            cost1 = product.getCostingRecord(as, this.getAD_Org_ID(), asi1.get_ID(), as.getCostingMethod());
            Assertions.assertNotNull((Object)cost1, (String)"MCost record not found");
            Assertions.assertEquals((Object)new BigDecimal("2.00"), (Object)cost1.getCurrentCostPrice().setScale(2, RoundingMode.HALF_UP));
            cost2 = product.getCostingRecord(as, this.getAD_Org_ID(), asi2.get_ID(), as.getCostingMethod());
            Assertions.assertNotNull((Object)cost2, (String)"MCost record not found");
            Assertions.assertEquals((Object)new BigDecimal("3.00"), (Object)cost2.getCurrentCostPrice().setScale(2, RoundingMode.HALF_UP));
            MInOut mr2 = new MInOut(Env.getCtx(), line2.getM_InOut_ID(), this.getTrxName());
            info = MWorkflow.runDocumentActionWorkflow((PO)mr2, (String)"RA");
            Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
            mr2.load(this.getTrxName(), new String[0]);
            Assertions.assertEquals((Object)"RE", (Object)mr2.getDocStatus(), (String)"Unexpected document status");
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_OrderLine_ID=?", (int)line2.getC_OrderLine_ID(), (int)asi2.getM_AttributeSetInstance_ID(), (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for order line2");
            Assertions.assertEquals((int)0, (int)cd.getQty().intValue(), (String)"Unexpected MCostDetail Qty");
            Assertions.assertEquals((Object)new BigDecimal("0").setScale(2, RoundingMode.HALF_UP), (Object)cd.getAmt().setScale(2, RoundingMode.HALF_UP), (String)"Unexpected MCostDetail Amt");
        }
        finally {
            this.rollback();
            if (exclude != null) {
                exclude.deleteEx(true);
            }
            if (exclude1 != null) {
                exclude1.deleteEx(true);
            }
            if (product != null) {
                product.set_TrxName(null);
                product.deleteEx(true);
            }
            lotLevel.deleteEx(true);
        }
    }

    @Test
    public void testCostAdjustment() {
        MClient client = MClient.get((Properties)Env.getCtx());
        MAcctSchema as = client.getAcctSchema();
        Assertions.assertEquals((Object)as.getCostingMethod(), (Object)"A", (String)"Default costing method not Average PO");
        MProduct product = new MProduct(Env.getCtx(), DictionaryIDs.M_Product.MULCH.id, this.getTrxName());
        MCost cost = product.getCostingRecord(as, this.getAD_Org_ID(), 0, as.getCostingMethod());
        if (cost == null || cost.getCurrentCostPrice().signum() == 0 || cost.getCurrentQty().signum() == 0) {
            this.createPOAndMRForProduct(DictionaryIDs.M_Product.MULCH.id, null, null);
            cost = product.getCostingRecord(as, this.getAD_Org_ID(), 0, as.getCostingMethod());
        }
        Assertions.assertNotNull((Object)cost, (String)"No MCost Record");
        BigDecimal currentCost = cost.getCurrentCostPrice();
        BigDecimal adjustment = new BigDecimal("0.25");
        MInventory inventory = new MInventory(Env.getCtx(), 0, this.getTrxName());
        inventory.setC_DocType_ID(DictionaryIDs.C_DocType.COST_ADJUSTMENT.id);
        inventory.setC_Currency_ID(as.getC_Currency_ID());
        inventory.setCostingMethod(as.getCostingMethod());
        inventory.saveEx();
        MInventoryLine line = new MInventoryLine(Env.getCtx(), 0, this.getTrxName());
        line.setM_Inventory_ID(inventory.get_ID());
        line.setM_Product_ID(DictionaryIDs.M_Product.MULCH.id);
        line.setC_Charge_ID(DictionaryIDs.C_Charge.COMMISSIONS.id);
        line.setCurrentCostPrice(currentCost);
        line.setNewCostPrice(currentCost.add(adjustment));
        line.saveEx();
        ProcessInfo info = MWorkflow.runDocumentActionWorkflow((PO)inventory, (String)"CO");
        inventory.load(this.getTrxName(), new String[0]);
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        Assertions.assertEquals((Object)"CO", (Object)inventory.getDocStatus(), (String)"Unexpected Document Status");
        MCostDetail cd = MCostDetail.get((Properties)Env.getCtx(), (String)"M_InventoryLine_ID=?", (int)line.getM_InventoryLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
        Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for internal use line");
        Assertions.assertEquals((int)0, (int)cd.getQty().intValue(), (String)"Unexpected MCostDetail Qty");
        Assertions.assertEquals((Object)adjustment.setScale(2, RoundingMode.HALF_UP), (Object)cd.getAmt().setScale(2, RoundingMode.HALF_UP), (String)"Unexpected MCostDetail Amt");
        cost.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((Object)currentCost.add(adjustment).setScale(2, RoundingMode.HALF_UP), (Object)cost.getCurrentCostPrice().setScale(2, RoundingMode.HALF_UP), (String)"Unexpected current cost");
        info = MWorkflow.runDocumentActionWorkflow((PO)inventory, (String)"RA");
        inventory.load(this.getTrxName(), new String[0]);
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        Assertions.assertEquals((Object)"RE", (Object)inventory.getDocStatus(), (String)"Unexpected Document Status");
        MInventory reversal = new MInventory(Env.getCtx(), inventory.getReversal_ID(), this.getTrxName());
        MInventoryLine[] reversalLines = reversal.getLines(true);
        cd = MCostDetail.get((Properties)Env.getCtx(), (String)"M_InventoryLine_ID=?", (int)reversalLines[0].getM_InventoryLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
        Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for internal use line");
        Assertions.assertEquals((int)0, (int)cd.getQty().intValue(), (String)"Unexpected MCostDetail Qty");
        Assertions.assertEquals((Object)adjustment.negate().setScale(2, RoundingMode.HALF_UP), (Object)cd.getAmt().setScale(2, RoundingMode.HALF_UP), (String)"Unexpected MCostDetail Amt");
        cost.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((Object)currentCost.setScale(2, RoundingMode.HALF_UP), (Object)cost.getCurrentCostPrice().setScale(2, RoundingMode.HALF_UP), (String)"Unexpected current cost");
    }

    @Test
    public void testPhysicalInventory() {
        MClient client = MClient.get((Properties)Env.getCtx());
        MAcctSchema as = client.getAcctSchema();
        Assertions.assertEquals((Object)as.getCostingMethod(), (Object)"A", (String)"Default costing method not Average PO");
        MProduct product = new MProduct(Env.getCtx(), DictionaryIDs.M_Product.MULCH.id, this.getTrxName());
        this.createPOAndMRForProduct(DictionaryIDs.M_Product.MULCH.id, null, null);
        MCost cost = product.getCostingRecord(as, this.getAD_Org_ID(), 0, as.getCostingMethod());
        Assertions.assertNotNull((Object)cost, (String)"No MCost Record");
        BigDecimal currentCost = cost.getCurrentCostPrice();
        MInventory inventory = new MInventory(Env.getCtx(), 0, this.getTrxName());
        inventory.setC_DocType_ID(DictionaryIDs.C_DocType.MATERIAL_PHYSICAL_INVENTORY.id);
        inventory.saveEx();
        MInventoryLine line = new MInventoryLine(Env.getCtx(), 0, this.getTrxName());
        line.setM_Inventory_ID(inventory.get_ID());
        line.setM_Product_ID(DictionaryIDs.M_Product.MULCH.id);
        line.setM_Locator_ID(DictionaryIDs.M_Locator.HQ.id);
        BigDecimal qtyOnHand = MStorageOnHand.getQtyOnHandForLocator((int)line.getM_Product_ID(), (int)line.getM_Locator_ID(), (int)0, (String)this.getTrxName());
        line.setQtyBook(qtyOnHand);
        line.setQtyCount(line.getQtyBook().add(new BigDecimal("1")));
        line.saveEx();
        ProcessInfo info = MWorkflow.runDocumentActionWorkflow((PO)inventory, (String)"CO");
        inventory.load(this.getTrxName(), new String[0]);
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        Assertions.assertEquals((Object)"CO", (Object)inventory.getDocStatus(), (String)"Unexpected Document Status");
        MCostDetail cd = MCostDetail.get((Properties)Env.getCtx(), (String)"M_InventoryLine_ID=?", (int)line.getM_InventoryLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
        Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for internal use line");
        Assertions.assertEquals((int)1, (int)cd.getQty().intValue(), (String)"Unexpected MCostDetail Qty");
        Assertions.assertEquals((Object)currentCost.setScale(2, RoundingMode.HALF_UP), (Object)cd.getAmt().setScale(2, RoundingMode.HALF_UP), (String)"Unexpected MCostDetail Amt");
        cost.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((Object)currentCost.setScale(2, RoundingMode.HALF_UP), (Object)cost.getCurrentCostPrice().setScale(2, RoundingMode.HALF_UP), (String)"Unexpected current cost");
        info = MWorkflow.runDocumentActionWorkflow((PO)inventory, (String)"RA");
        inventory.load(this.getTrxName(), new String[0]);
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        Assertions.assertEquals((Object)"RE", (Object)inventory.getDocStatus(), (String)"Unexpected Document Status");
        MInventory reversal = new MInventory(Env.getCtx(), inventory.getReversal_ID(), this.getTrxName());
        MInventoryLine[] reversalLines = reversal.getLines(true);
        cd = MCostDetail.get((Properties)Env.getCtx(), (String)"M_InventoryLine_ID=?", (int)reversalLines[0].getM_InventoryLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
        Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for internal use line");
        Assertions.assertEquals((int)-1, (int)cd.getQty().intValue(), (String)"Unexpected MCostDetail Qty");
        Assertions.assertEquals((Object)currentCost.negate().setScale(2, RoundingMode.HALF_UP), (Object)cd.getAmt().setScale(2, RoundingMode.HALF_UP), (String)"Unexpected MCostDetail Amt");
        cost.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((Object)currentCost.setScale(2, RoundingMode.HALF_UP), (Object)cost.getCurrentCostPrice().setScale(2, RoundingMode.HALF_UP), (String)"Unexpected current cost");
    }

    @Test
    public void testLandedCostForPO() {
        MClient client = MClient.get((Properties)Env.getCtx());
        MAcctSchema as = client.getAcctSchema();
        Assertions.assertEquals((Object)as.getCostingMethod(), (Object)"A", (String)"Default costing method not Average PO");
        MProduct product = null;
        try {
            List cds;
            product = new MProduct(Env.getCtx(), 0, null);
            product.setM_Product_Category_ID(DictionaryIDs.M_Product_Category.STANDARD.id);
            product.setName("testLandedCostForPO");
            product.setProductType("I");
            product.setIsStocked(true);
            product.setIsSold(true);
            product.setIsPurchased(true);
            product.setC_UOM_ID(DictionaryIDs.C_UOM.EACH.id);
            product.setC_TaxCategory_ID(DictionaryIDs.C_TaxCategory.STANDARD.id);
            product.saveEx();
            MPriceListVersion plv = MPriceList.get((int)DictionaryIDs.M_PriceList.PURCHASE.id).getPriceListVersion(null);
            MProductPrice pp = new MProductPrice(Env.getCtx(), 0, this.getTrxName());
            pp.setM_PriceList_Version_ID(plv.getM_PriceList_Version_ID());
            pp.setM_Product_ID(product.get_ID());
            pp.setPriceStd(new BigDecimal("2"));
            pp.setPriceList(new BigDecimal("2"));
            pp.saveEx();
            MOrder order = new MOrder(Env.getCtx(), 0, this.getTrxName());
            order.setBPartner(MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.PATIO.id));
            order.setC_DocTypeTarget_ID(DictionaryIDs.C_DocType.PURCHASE_ORDER.id);
            order.setIsSOTrx(false);
            order.setSalesRep_ID(DictionaryIDs.AD_User.GARDEN_ADMIN.id);
            order.setDocStatus("DR");
            order.setDocAction("CO");
            Timestamp today = TimeUtil.getDay((long)System.currentTimeMillis());
            order.setDateOrdered(today);
            order.setDatePromised(today);
            order.saveEx();
            MOrderLine line1 = new MOrderLine(order);
            line1.setLine(10);
            line1.setProduct(new MProduct(Env.getCtx(), product.get_ID(), this.getTrxName()));
            line1.setQty(new BigDecimal("1"));
            line1.setDatePromised(today);
            line1.setPrice(new BigDecimal("2"));
            line1.saveEx();
            MOrderLandedCost landedCost = new MOrderLandedCost(Env.getCtx(), 0, this.getTrxName());
            landedCost.setC_Order_ID(order.get_ID());
            landedCost.setLandedCostDistribution("C");
            landedCost.setM_CostElement_ID(DictionaryIDs.M_CostElement.FREIGHT.id);
            landedCost.setAmt(new BigDecimal("0.30"));
            landedCost.saveEx();
            ProcessInfo info = MWorkflow.runDocumentActionWorkflow((PO)order, (String)"CO");
            Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
            order.load(this.getTrxName(), new String[0]);
            Assertions.assertEquals((Object)"CO", (Object)order.getDocStatus());
            MInOut receipt1 = new MInOut(order, DictionaryIDs.C_DocType.MM_RECEIPT.id, order.getDateOrdered());
            receipt1.setDocStatus("DR");
            receipt1.setDocAction("CO");
            receipt1.saveEx();
            MInOutLine receiptLine1 = new MInOutLine(receipt1);
            receiptLine1.setOrderLine(line1, 0, new BigDecimal("1"));
            receiptLine1.setQty(new BigDecimal("1"));
            receiptLine1.saveEx();
            info = MWorkflow.runDocumentActionWorkflow((PO)receipt1, (String)"CO");
            Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
            receipt1.load(this.getTrxName(), new String[0]);
            Assertions.assertEquals((Object)"CO", (Object)receipt1.getDocStatus());
            if (!receipt1.isPosted()) {
                String error = DocumentEngine.postImmediate((Properties)Env.getCtx(), (int)receipt1.getAD_Client_ID(), (int)receipt1.get_Table_ID(), (int)receipt1.get_ID(), (boolean)false, (String)this.getTrxName());
                Assertions.assertNull((Object)error, (String)error);
            }
            Assertions.assertTrue(((cds = MCostDetail.list((Properties)Env.getCtx(), (String)"C_OrderLine_ID=?", (int)line1.getC_OrderLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName())).size() == 2 ? 1 : 0) != 0, (String)"MCostDetail not found for order line1");
            for (MCostDetail cd : cds) {
                if (cd.getM_CostElement_ID() == 0) {
                    Assertions.assertEquals((int)1, (int)cd.getQty().intValue(), (String)"Unexpected MCostDetail Qty");
                    Assertions.assertEquals((Object)new BigDecimal("2.00").setScale(2, RoundingMode.HALF_UP), (Object)cd.getAmt().setScale(2, RoundingMode.HALF_UP), (String)"Unexpected MCostDetail Amt");
                    continue;
                }
                if (cd.getM_CostElement_ID() != DictionaryIDs.M_CostElement.FREIGHT.id) continue;
                Assertions.assertEquals((int)1, (int)cd.getQty().intValue(), (String)"Unexpected MCostDetail Qty");
                Assertions.assertEquals((Object)new BigDecimal("0.30").setScale(2, RoundingMode.HALF_UP), (Object)cd.getAmt().setScale(2, RoundingMode.HALF_UP), (String)"Unexpected MCostDetail Amt");
            }
            product.set_TrxName(this.getTrxName());
            MCost cost = product.getCostingRecord(as, this.getAD_Org_ID(), 0, as.getCostingMethod());
            Assertions.assertNotNull((Object)cost, (String)"No MCost record found");
            Assertions.assertEquals((Object)new BigDecimal("2.30"), (Object)cost.getCurrentCostPrice().setScale(2, RoundingMode.HALF_UP), (String)"Unexpected current cost price");
            info = MWorkflow.runDocumentActionWorkflow((PO)receipt1, (String)"RA");
            Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
            receipt1.load(this.getTrxName(), new String[0]);
            Assertions.assertEquals((Object)"RE", (Object)receipt1.getDocStatus());
            cds = MCostDetail.list((Properties)Env.getCtx(), (String)"C_OrderLine_ID=?", (int)line1.getC_OrderLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertTrue((cds.size() == 2 ? 1 : 0) != 0, (String)"MCostDetail not found for order line1");
            for (MCostDetail cd : cds) {
                if (cd.getM_CostElement_ID() == 0) {
                    Assertions.assertEquals((int)0, (int)cd.getQty().intValue(), (String)"Unexpected MCostDetail Qty");
                    Assertions.assertEquals((Object)new BigDecimal("0").setScale(2, RoundingMode.HALF_UP), (Object)cd.getAmt().setScale(2, RoundingMode.HALF_UP), (String)"Unexpected MCostDetail Amt");
                    continue;
                }
                if (cd.getM_CostElement_ID() != DictionaryIDs.M_CostElement.FREIGHT.id) continue;
                Assertions.assertEquals((int)0, (int)cd.getQty().intValue(), (String)"Unexpected MCostDetail Qty");
                Assertions.assertEquals((Object)new BigDecimal("0").setScale(2, RoundingMode.HALF_UP), (Object)cd.getAmt().setScale(2, RoundingMode.HALF_UP), (String)"Unexpected MCostDetail Amt");
            }
        }
        finally {
            this.rollback();
            if (product != null) {
                product.set_TrxName(null);
                product.deleteEx(true);
            }
        }
    }

    private MInOutLine createPOAndMRForProduct(int productId, MAttributeSetInstance asi, BigDecimal price) {
        MOrder order = new MOrder(Env.getCtx(), 0, this.getTrxName());
        order.setBPartner(MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.PATIO.id));
        order.setC_DocTypeTarget_ID(DictionaryIDs.C_DocType.PURCHASE_ORDER.id);
        order.setIsSOTrx(false);
        order.setSalesRep_ID(DictionaryIDs.AD_User.GARDEN_ADMIN.id);
        order.setDocStatus("DR");
        order.setDocAction("CO");
        Timestamp today = TimeUtil.getDay((long)System.currentTimeMillis());
        order.setDateOrdered(today);
        order.setDatePromised(today);
        order.saveEx();
        MOrderLine line1 = new MOrderLine(order);
        line1.setLine(10);
        line1.setProduct(new MProduct(Env.getCtx(), productId, this.getTrxName()));
        line1.setQty(new BigDecimal("1"));
        line1.setDatePromised(today);
        if (price != null) {
            line1.setPrice(price);
        }
        if (asi != null) {
            line1.setM_AttributeSetInstance_ID(asi.getM_AttributeSetInstance_ID());
        }
        line1.saveEx();
        ProcessInfo info = MWorkflow.runDocumentActionWorkflow((PO)order, (String)"CO");
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        order.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((Object)"CO", (Object)order.getDocStatus());
        MInOut receipt1 = new MInOut(order, DictionaryIDs.C_DocType.MM_RECEIPT.id, order.getDateOrdered());
        receipt1.setDocStatus("DR");
        receipt1.setDocAction("CO");
        receipt1.saveEx();
        MInOutLine receiptLine1 = new MInOutLine(receipt1);
        receiptLine1.setOrderLine(line1, 0, new BigDecimal("1"));
        receiptLine1.setQty(new BigDecimal("1"));
        if (asi != null) {
            receiptLine1.setM_AttributeSetInstance_ID(asi.get_ID());
        }
        receiptLine1.saveEx();
        info = MWorkflow.runDocumentActionWorkflow((PO)receipt1, (String)"CO");
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        receipt1.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((Object)"CO", (Object)receipt1.getDocStatus());
        if (!receipt1.isPosted()) {
            String error = DocumentEngine.postImmediate((Properties)Env.getCtx(), (int)receipt1.getAD_Client_ID(), (int)receipt1.get_Table_ID(), (int)receipt1.get_ID(), (boolean)false, (String)this.getTrxName());
            Assertions.assertNull((Object)error, (String)error);
        }
        return receiptLine1;
    }
}

