/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.test.base;

import java.util.Dictionary;
import java.util.Hashtable;
import org.adempiere.base.Core;
import org.adempiere.base.IProcessFactory;
import org.compiere.process.ProcessCall;
import org.compiere.process.SvrProcess;
import org.idempiere.process.IMappedProcessFactory;
import org.idempiere.process.MappedProcessFactory;
import org.idempiere.test.AbstractTestCase;
import org.idempiere.test.TestActivator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.MethodOrderer;
import org.junit.jupiter.api.Order;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestMethodOrder;
import org.osgi.framework.BundleContext;

@TestMethodOrder(value=MethodOrderer.OrderAnnotation.class)
public class MappedProcessFactoryTest
extends AbstractTestCase {
    @Test
    @Order(value=1)
    public void testDefaultMappedProcessFactory() {
        IMappedProcessFactory mappedFactory = Core.getMappedProcessFactory();
        mappedFactory.addMapping(MyTest.class.getName(), () -> new MyTest());
        ProcessCall pc = Core.getProcess((String)MyTest.class.getName());
        Assertions.assertNotNull((Object)pc, (String)("Can't instantiate process class " + MyTest.class.getName()));
        Assertions.assertTrue((boolean)(pc instanceof MyTest), (String)("ProcessCall not instanceof " + MyTest.class.getName() + ", it is of type " + pc.getClass().getName()));
    }

    @Test
    @Order(value=2)
    public void testCustomMappedModelFactory() {
        BundleContext bc = TestActivator.context;
        Hashtable<String, Integer> properties = new Hashtable<String, Integer>();
        ((Dictionary)properties).put("service.ranking", 2);
        bc.registerService(IProcessFactory.class, (Object)new MyFactory(), properties);
        ProcessCall pc = Core.getProcess((String)MyTest2.class.getName());
        Assertions.assertNotNull((Object)pc, (String)("Can't instantiate process class " + MyTest2.class.getName()));
        Assertions.assertTrue((boolean)(pc instanceof MyTest2), (String)("ProcessCall not instanceof " + MyTest2.class.getName() + ", it is of type " + pc.getClass().getName()));
    }

    private static final class MyFactory
    extends MappedProcessFactory {
        public MyFactory() {
            this.addMapping(MyTest2.class.getName(), () -> new MyTest2());
        }
    }

    private static final class MyTest
    extends SvrProcess {
        private MyTest() {
        }

        protected void prepare() {
        }

        protected String doIt() throws Exception {
            return null;
        }
    }

    private static final class MyTest2
    extends SvrProcess {
        private MyTest2() {
        }

        protected void prepare() {
        }

        protected String doIt() throws Exception {
            return null;
        }
    }
}

