/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.test.adwindow;

import java.util.ArrayList;
import java.util.Optional;
import java.util.Properties;
import org.adempiere.webui.apps.AEnv;
import org.compiere.model.GridFieldVO;
import org.compiere.model.GridTabVO;
import org.compiere.model.GridWindowVO;
import org.compiere.model.MField;
import org.compiere.model.MSession;
import org.compiere.model.MTab;
import org.compiere.model.MUserDefField;
import org.compiere.model.MUserDefTab;
import org.compiere.model.MUserDefWin;
import org.compiere.util.CCache;
import org.compiere.util.CacheInterface;
import org.compiere.util.CacheMgt;
import org.compiere.util.Env;
import org.idempiere.test.AbstractTestCase;
import org.idempiere.test.DictionaryIDs;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.junit.jupiter.api.parallel.Isolated;

@Isolated
@Execution(value=ExecutionMode.SAME_THREAD)
public class GridWindowTest
extends AbstractTestCase {
    @Test
    public void testGridWindowCache() {
        CacheInterface[] cacheInstances;
        int testRecordIdFieldId = 207570;
        String gridWindowVOCacheName = "AD_Window|GridWindowVO";
        String gridTabVOsCacheName = "GridTabVOs Cache";
        GridWindowVO.get((int)127, (int)0);
        CCache gridTabVOsCache = null;
        CCache gridWindowVOCache = null;
        CacheInterface[] cacheInterfaceArray = cacheInstances = CacheMgt.get().getInstancesAsArray();
        int n = cacheInstances.length;
        int n2 = 0;
        while (n2 < n) {
            CacheInterface cacheInstance = cacheInterfaceArray[n2];
            if (cacheInstance instanceof CCache) {
                CCache ccache = (CCache)cacheInstance;
                if (ccache.getName().equals(gridTabVOsCacheName)) {
                    gridTabVOsCache = ccache;
                } else if (ccache.getName().equals(gridWindowVOCacheName)) {
                    gridWindowVOCache = ccache;
                }
            }
            ++n2;
        }
        Assertions.assertNotNull(gridWindowVOCache, (String)"Can't find cache for GridWindowVO");
        Assertions.assertNotNull(gridTabVOsCache, (String)"Can't find cache for GridTabVOs");
        gridWindowVOCache.reset();
        gridTabVOsCache.reset();
        long gridWindowVOCacheHit = gridWindowVOCache.getHit();
        long gridTabVOsCacheHit = gridTabVOsCache.getHit();
        Env.setContext((Properties)Env.getCtx(), (String)"#AD_Role_ID", (int)DictionaryIDs.AD_Role.GARDEN_WORLD_ADMIN.id);
        GridWindowVO.get((int)127, (int)0);
        GridWindowVO windowVO = GridWindowVO.create((Properties)Env.getCtx(), (int)1, (int)127);
        ArrayList fields = ((GridTabVO)windowVO.Tabs.get(0)).getFields();
        Optional<GridFieldVO> optional = fields.stream().filter(e -> e.AD_Field_ID == testRecordIdFieldId).findFirst();
        Assertions.assertTrue((boolean)optional.isPresent(), (String)"Not Found, Record ID field of Test Window");
        Assertions.assertTrue((gridWindowVOCache.getHit() > gridWindowVOCacheHit ? 1 : 0) != 0, (String)"GridWindowVO cache hit doesn't increase as expected");
        Assertions.assertTrue((gridTabVOsCache.getHit() > gridTabVOsCacheHit ? 1 : 0) != 0, (String)"GridTabVOs cache hit doesn't increase as expected");
        gridWindowVOCacheHit = gridWindowVOCache.getHit();
        gridTabVOsCacheHit = gridTabVOsCache.getHit();
        Env.setContext((Properties)Env.getCtx(), (String)"#AD_Role_ID", (int)DictionaryIDs.AD_Role.GARDEN_WORLD_ADMIN_NOT_ADVANCED.id);
        windowVO = GridWindowVO.create((Properties)Env.getCtx(), (int)1, (int)127);
        fields = ((GridTabVO)windowVO.Tabs.get(0)).getFields();
        optional = fields.stream().filter(e -> e.AD_Field_ID == testRecordIdFieldId).findFirst();
        Assertions.assertFalse((boolean)optional.isPresent(), (String)"Record ID field of Test Window found for not advanced role");
        Assertions.assertTrue((gridWindowVOCache.getHit() > gridWindowVOCacheHit ? 1 : 0) != 0, (String)"GridWindowVO cache hit doesn't increase as expected");
        Assertions.assertTrue((gridTabVOsCache.getHit() == gridTabVOsCacheHit ? 1 : 0) != 0, (String)"Unexpected increase of GridTabVOs cache hit");
        gridWindowVOCacheHit = gridWindowVOCache.getHit();
        gridTabVOsCacheHit = gridTabVOsCache.getHit();
        Env.setContext((Properties)Env.getCtx(), (String)"#AD_Role_ID", (int)DictionaryIDs.AD_Role.GARDEN_WORLD_ADMIN.id);
        windowVO = GridWindowVO.get((int)127, (int)1);
        fields = ((GridTabVO)windowVO.Tabs.get(0)).getFields();
        optional = fields.stream().filter(e -> e.AD_Field_ID == testRecordIdFieldId).findFirst();
        Assertions.assertTrue((boolean)optional.isPresent(), (String)"Not Found, Record ID field of Test Window");
        Assertions.assertTrue((gridWindowVOCache.getHit() > gridWindowVOCacheHit ? 1 : 0) != 0, (String)"GridWindowVO cache hit doesn't increase as expected");
        Assertions.assertTrue((gridTabVOsCache.getHit() > gridTabVOsCacheHit ? 1 : 0) != 0, (String)"GridTabVOs cache hit doesn't increase as expected");
        gridWindowVOCacheHit = gridWindowVOCache.getHit();
        gridTabVOsCacheHit = gridTabVOsCache.getHit();
        Env.setContext((Properties)Env.getCtx(), (String)"#AD_Role_ID", (int)DictionaryIDs.AD_Role.GARDEN_WORLD_ADMIN_NOT_ADVANCED.id);
        windowVO = GridWindowVO.get((int)127, (int)1);
        fields = ((GridTabVO)windowVO.Tabs.get(0)).getFields();
        optional = fields.stream().filter(e -> e.AD_Field_ID == testRecordIdFieldId).findFirst();
        Assertions.assertFalse((boolean)optional.isPresent(), (String)"Record ID field of Test Window found for not advanced role");
        Assertions.assertTrue((gridWindowVOCache.getHit() > gridWindowVOCacheHit ? 1 : 0) != 0, (String)"GridWindowVO cache hit doesn't increase as expected");
        Assertions.assertTrue((gridTabVOsCache.getHit() > gridTabVOsCacheHit ? 1 : 0) != 0, (String)"GridTabVOs cache hit doesn't increase as expected");
        gridWindowVOCacheHit = gridWindowVOCache.getHit();
        gridTabVOsCacheHit = gridTabVOsCache.getHit();
        Env.setContext((Properties)Env.getCtx(), (String)"#AD_Role_ID", (int)DictionaryIDs.AD_Role.GARDEN_WORLD_ADMIN.id);
        Env.setContext((Properties)Env.getCtx(), (String)"#AD_Session_ID", (String)("" + System.currentTimeMillis()));
        windowVO = AEnv.getMWindowVO((int)1, (int)127, (int)0);
        fields = ((GridTabVO)windowVO.Tabs.get(0)).getFields();
        optional = fields.stream().filter(e -> e.AD_Field_ID == testRecordIdFieldId).findFirst();
        Assertions.assertTrue((boolean)optional.isPresent(), (String)"Not Found, Record ID field of Test Window");
        Assertions.assertTrue((gridWindowVOCache.getHit() > gridWindowVOCacheHit ? 1 : 0) != 0, (String)"GridWindowVO cache hit doesn't increase as expected");
        Assertions.assertTrue((gridTabVOsCache.getHit() > gridTabVOsCacheHit ? 1 : 0) != 0, (String)"GridTabVOs cache hit doesn't increase as expected");
        gridWindowVOCacheHit = gridWindowVOCache.getHit();
        gridTabVOsCacheHit = gridTabVOsCache.getHit();
        windowVO = AEnv.getMWindowVO((int)1, (int)127, (int)0);
        fields = ((GridTabVO)windowVO.Tabs.get(0)).getFields();
        optional = fields.stream().filter(e -> e.AD_Field_ID == testRecordIdFieldId).findFirst();
        Assertions.assertTrue((boolean)optional.isPresent(), (String)"Not Found, Record ID field of Test Window");
        Assertions.assertTrue((gridWindowVOCache.getHit() == gridWindowVOCacheHit ? 1 : 0) != 0, (String)"Unexpected increase of GridWindowVO cache hit");
        Assertions.assertTrue((gridTabVOsCache.getHit() == gridTabVOsCacheHit ? 1 : 0) != 0, (String)"Unexpected increase of GridTabVOs cache hit");
        gridWindowVOCacheHit = gridWindowVOCache.getHit();
        gridTabVOsCacheHit = gridTabVOsCache.getHit();
        Env.setContext((Properties)Env.getCtx(), (String)"#AD_Role_ID", (int)DictionaryIDs.AD_Role.GARDEN_WORLD_ADMIN_NOT_ADVANCED.id);
        Env.setContext((Properties)Env.getCtx(), (String)"#AD_Session_ID", (String)("" + System.currentTimeMillis()));
        windowVO = AEnv.getMWindowVO((int)1, (int)127, (int)0);
        fields = ((GridTabVO)windowVO.Tabs.get(0)).getFields();
        optional = fields.stream().filter(e -> e.AD_Field_ID == testRecordIdFieldId).findFirst();
        Assertions.assertFalse((boolean)optional.isPresent(), (String)"Record ID field of Test Window found for not advanced role");
        Assertions.assertTrue((gridWindowVOCache.getHit() > gridWindowVOCacheHit ? 1 : 0) != 0, (String)"GridWindowVO cache hit doesn't increase as expected");
        Assertions.assertTrue((gridTabVOsCache.getHit() > gridTabVOsCacheHit ? 1 : 0) != 0, (String)"GridTabVOs cache hit doesn't increase as expected");
        gridWindowVOCacheHit = gridWindowVOCache.getHit();
        gridTabVOsCacheHit = gridTabVOsCache.getHit();
        windowVO = AEnv.getMWindowVO((int)1, (int)127, (int)0);
        fields = ((GridTabVO)windowVO.Tabs.get(0)).getFields();
        optional = fields.stream().filter(e -> e.AD_Field_ID == testRecordIdFieldId).findFirst();
        Assertions.assertFalse((boolean)optional.isPresent(), (String)"Record ID field of Test Window found for not advanced role");
        Assertions.assertTrue((gridWindowVOCache.getHit() == gridWindowVOCacheHit ? 1 : 0) != 0, (String)"Unexpected increase of GridWindowVO cache hit");
        Assertions.assertTrue((gridTabVOsCache.getHit() == gridTabVOsCacheHit ? 1 : 0) != 0, (String)"Unexpected increase of GridTabVOs cache hit");
        gridWindowVOCacheHit = gridWindowVOCache.getHit();
        gridTabVOsCacheHit = gridTabVOsCache.getHit();
    }

    @Test
    public void testUserDefWin() {
        int testTabId = 152;
        int testDateField = 425;
        MUserDefWin win = new MUserDefWin(Env.getCtx(), 0, null);
        win.setAD_Window_ID(127);
        win.setAD_Role_ID(DictionaryIDs.AD_Role.GARDEN_WORLD_ADMIN.id);
        win.saveEx();
        MUserDefTab tab = new MUserDefTab(Env.getCtx(), 0, null);
        tab.setAD_UserDef_Win_ID(win.get_ID());
        tab.setAD_Tab_ID(testTabId);
        String tabName = MTab.get((int)testTabId).getName();
        String customTabName = tabName + "|" + win.get_ID();
        tab.setName(customTabName);
        tab.saveEx();
        MUserDefField field = new MUserDefField(Env.getCtx(), 0, null);
        field.setAD_UserDef_Tab_ID(tab.get_ID());
        String fieldName = MField.get((int)testDateField).getName();
        String customFieldName = fieldName + "|" + tab.get_ID();
        field.setAD_Field_ID(testDateField);
        field.setName(customFieldName);
        field.saveEx();
        try {
            MSession.create((Properties)Env.getCtx());
            Env.setContext((Properties)Env.getCtx(), (String)"#AD_Role_ID", (int)DictionaryIDs.AD_Role.GARDEN_WORLD_ADMIN.id);
            GridWindowVO windowVO = GridWindowVO.create((Properties)Env.getCtx(), (int)1, (int)127);
            Assertions.assertNotNull((Object)windowVO.Tabs, (String)"Failed to retrieve GridTabVOs");
            Assertions.assertEquals((int)1, (int)windowVO.Tabs.size(), (String)"Failed to retrieve GridTabVOs");
            Assertions.assertEquals((Object)customTabName, (Object)((GridTabVO)windowVO.Tabs.get((int)0)).Name, (String)"Not getting name from MUserDefTab");
            Optional<GridFieldVO> optional = ((GridTabVO)windowVO.Tabs.get(0)).getFields().stream().filter(e -> e.AD_Field_ID == testDateField).findFirst();
            Assertions.assertTrue((boolean)optional.isPresent(), (String)"Failed to find Date field of Test window");
            Assertions.assertEquals((Object)customFieldName, (Object)optional.get().Header, (String)"Not getting custom header from MUserDefField");
            windowVO = GridWindowVO.get((int)127, (int)1);
            Assertions.assertNotNull((Object)windowVO.Tabs, (String)"Failed to retrieve GridTabVOs");
            Assertions.assertEquals((int)1, (int)windowVO.Tabs.size(), (String)"Failed to retrieve GridTabVOs");
            Assertions.assertEquals((Object)customTabName, (Object)((GridTabVO)windowVO.Tabs.get((int)0)).Name, (String)"Not getting name from MUserDefTab");
            optional = ((GridTabVO)windowVO.Tabs.get(0)).getFields().stream().filter(e -> e.AD_Field_ID == testDateField).findFirst();
            Assertions.assertTrue((boolean)optional.isPresent(), (String)"Failed to find Date field of Test window");
            Assertions.assertEquals((Object)customFieldName, (Object)optional.get().Header, (String)"Not getting custom header from MUserDefField");
            windowVO = AEnv.getMWindowVO((int)1, (int)127, (int)0);
            Assertions.assertNotNull((Object)windowVO.Tabs, (String)"Failed to retrieve GridTabVOs");
            Assertions.assertEquals((int)1, (int)windowVO.Tabs.size(), (String)"Failed to retrieve GridTabVOs");
            Assertions.assertEquals((Object)customTabName, (Object)((GridTabVO)windowVO.Tabs.get((int)0)).Name, (String)"Not getting name from MUserDefTab");
            optional = ((GridTabVO)windowVO.Tabs.get(0)).getFields().stream().filter(e -> e.AD_Field_ID == testDateField).findFirst();
            Assertions.assertTrue((boolean)optional.isPresent(), (String)"Failed to find Date field of Test window");
            Assertions.assertEquals((Object)customFieldName, (Object)optional.get().Header, (String)"Not getting custom header from MUserDefField");
            MSession.create((Properties)Env.getCtx());
            Env.setContext((Properties)Env.getCtx(), (String)"#AD_Role_ID", (int)DictionaryIDs.AD_Role.GARDEN_WORLD_ADMIN_NOT_ADVANCED.id);
            windowVO = GridWindowVO.create((Properties)Env.getCtx(), (int)1, (int)127);
            Assertions.assertNotNull((Object)windowVO.Tabs, (String)"Failed to retrieve GridTabVOs");
            Assertions.assertEquals((int)1, (int)windowVO.Tabs.size(), (String)"Failed to retrieve GridTabVOs");
            Assertions.assertEquals((Object)tabName, (Object)((GridTabVO)windowVO.Tabs.get((int)0)).Name, (String)"Not getting original name from AD_Tab");
            optional = ((GridTabVO)windowVO.Tabs.get(0)).getFields().stream().filter(e -> e.AD_Field_ID == testDateField).findFirst();
            Assertions.assertTrue((boolean)optional.isPresent(), (String)"Failed to find Date field of Test window");
            Assertions.assertEquals((Object)fieldName, (Object)optional.get().Header, (String)"Not getting original header from AD_Field");
            windowVO = GridWindowVO.get((int)127, (int)1);
            Assertions.assertNotNull((Object)windowVO.Tabs, (String)"Failed to retrieve GridTabVOs");
            Assertions.assertEquals((int)1, (int)windowVO.Tabs.size(), (String)"Failed to retrieve GridTabVOs");
            Assertions.assertEquals((Object)tabName, (Object)((GridTabVO)windowVO.Tabs.get((int)0)).Name, (String)"Not getting original name from AD_Tab");
            optional = ((GridTabVO)windowVO.Tabs.get(0)).getFields().stream().filter(e -> e.AD_Field_ID == testDateField).findFirst();
            Assertions.assertTrue((boolean)optional.isPresent(), (String)"Failed to find Date field of Test window");
            Assertions.assertEquals((Object)fieldName, (Object)optional.get().Header, (String)"Not getting original header from AD_Field");
            windowVO = AEnv.getMWindowVO((int)1, (int)127, (int)0);
            Assertions.assertNotNull((Object)windowVO.Tabs, (String)"Failed to retrieve GridTabVOs");
            Assertions.assertEquals((int)1, (int)windowVO.Tabs.size(), (String)"Failed to retrieve GridTabVOs");
            Assertions.assertEquals((Object)tabName, (Object)((GridTabVO)windowVO.Tabs.get((int)0)).Name, (String)"Not getting original name from AD_Tab");
            optional = ((GridTabVO)windowVO.Tabs.get(0)).getFields().stream().filter(e -> e.AD_Field_ID == testDateField).findFirst();
            Assertions.assertTrue((boolean)optional.isPresent(), (String)"Failed to find Date field of Test window");
            Assertions.assertEquals((Object)fieldName, (Object)optional.get().Header, (String)"Not getting original header from AD_Field");
        }
        finally {
            field.deleteEx(true);
            tab.deleteEx(true);
            win.deleteEx(true);
        }
    }
}

