/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.test.model;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Properties;
import org.compiere.model.MUOM;
import org.compiere.model.MUOMConversion;
import org.compiere.util.CacheMgt;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.idempiere.test.AbstractTestCase;
import org.idempiere.test.DictionaryIDs;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class MUOMConversionTest
extends AbstractTestCase {
    @Test
    public void testConversion() {
        MUOM each = new MUOM(Env.getCtx(), DictionaryIDs.C_UOM.EACH.id, this.getTrxName());
        MUOM hour = new MUOM(Env.getCtx(), DictionaryIDs.C_UOM.HOUR.id, this.getTrxName());
        MUOMConversion conv1 = new MUOMConversion(each);
        conv1.set_TrxName(null);
        conv1.setC_UOM_To_ID(DictionaryIDs.C_UOM.HOUR.id);
        conv1.setMultiplyRate(new BigDecimal("1.15"));
        conv1.setDivideRate(BigDecimal.ZERO);
        conv1.saveCrossTenantSafeEx();
        MUOMConversion conv2 = null;
        MUOMConversion conv3 = null;
        try {
            BigDecimal converted = MUOMConversion.convertProductTo((Properties)Env.getCtx(), (int)DictionaryIDs.M_Product.OAK.id, (int)DictionaryIDs.C_UOM.HOUR.id, (BigDecimal)new BigDecimal("1"));
            Assertions.assertEquals((Object)new BigDecimal("1.15"), (Object)converted);
            converted = MUOMConversion.convertProductTo((Properties)Env.getCtx(), (int)DictionaryIDs.M_Product.OAK.id, (int)DictionaryIDs.C_UOM.HOUR.id, (BigDecimal)new BigDecimal("1"), (int)-1);
            Assertions.assertEquals((Object)new BigDecimal("1.15"), (Object)converted);
            converted = MUOMConversion.convertProductTo((Properties)Env.getCtx(), (int)DictionaryIDs.M_Product.OAK.id, (int)DictionaryIDs.C_UOM.HOUR.id, (BigDecimal)new BigDecimal("1"), (int)1);
            Assertions.assertEquals((Object)new BigDecimal("1.2"), (Object)converted);
            conv2 = new MUOMConversion(Env.getCtx(), 0, null);
            conv2.setC_UOM_ID(DictionaryIDs.C_UOM.EACH.id);
            conv2.setC_UOM_To_ID(DictionaryIDs.C_UOM.HOUR.id);
            conv2.setMultiplyRate(new BigDecimal("1.35"));
            conv2.saveEx();
            converted = MUOMConversion.convertProductTo((Properties)Env.getCtx(), (int)DictionaryIDs.M_Product.OAK.id, (int)DictionaryIDs.C_UOM.HOUR.id, (BigDecimal)new BigDecimal("1"));
            Assertions.assertEquals((Object)new BigDecimal("1.35"), (Object)converted);
            converted = MUOMConversion.convertProductTo((Properties)Env.getCtx(), (int)DictionaryIDs.M_Product.OAK.id, (int)DictionaryIDs.C_UOM.HOUR.id, (BigDecimal)new BigDecimal("1"), (int)-1);
            Assertions.assertEquals((Object)new BigDecimal("1.35"), (Object)converted);
            converted = MUOMConversion.convertProductTo((Properties)Env.getCtx(), (int)DictionaryIDs.M_Product.OAK.id, (int)DictionaryIDs.C_UOM.HOUR.id, (BigDecimal)new BigDecimal("1"), (int)1);
            Assertions.assertEquals((Object)new BigDecimal("1.4"), (Object)converted);
            conv3 = new MUOMConversion(Env.getCtx(), 0, null);
            conv3.setM_Product_ID(DictionaryIDs.M_Product.OAK.id);
            conv3.setC_UOM_ID(DictionaryIDs.C_UOM.EACH.id);
            conv3.setC_UOM_To_ID(DictionaryIDs.C_UOM.HOUR.id);
            conv3.setMultiplyRate(new BigDecimal("0.75"));
            conv3.saveEx();
            CacheMgt.get().reset();
            converted = MUOMConversion.convertProductTo((Properties)Env.getCtx(), (int)DictionaryIDs.M_Product.OAK.id, (int)DictionaryIDs.C_UOM.HOUR.id, (BigDecimal)new BigDecimal("1"));
            Assertions.assertEquals((Object)new BigDecimal("0.75"), (Object)converted);
            converted = MUOMConversion.convertProductTo((Properties)Env.getCtx(), (int)DictionaryIDs.M_Product.OAK.id, (int)DictionaryIDs.C_UOM.HOUR.id, (BigDecimal)new BigDecimal("1"), (int)-1);
            Assertions.assertEquals((Object)new BigDecimal("0.75"), (Object)converted);
            converted = MUOMConversion.convertProductTo((Properties)Env.getCtx(), (int)DictionaryIDs.M_Product.OAK.id, (int)DictionaryIDs.C_UOM.HOUR.id, (BigDecimal)new BigDecimal("1"), (int)1);
            Assertions.assertEquals((Object)new BigDecimal("0.8"), (Object)converted);
            converted = MUOMConversion.convertProductFrom((Properties)Env.getCtx(), (int)DictionaryIDs.M_Product.OAK.id, (int)DictionaryIDs.C_UOM.HOUR.id, (BigDecimal)new BigDecimal("1"));
            Assertions.assertEquals((Object)hour.round(conv3.getDivideRate(), true), (Object)converted);
            conv3.deleteEx(true);
            conv3 = null;
            CacheMgt.get().reset();
            converted = MUOMConversion.convertProductFrom((Properties)Env.getCtx(), (int)DictionaryIDs.M_Product.OAK.id, (int)DictionaryIDs.C_UOM.HOUR.id, (BigDecimal)new BigDecimal("1"));
            Assertions.assertEquals((Object)hour.round(conv2.getDivideRate(), true), (Object)converted);
            converted = MUOMConversion.convertProductFrom((Properties)Env.getCtx(), (int)DictionaryIDs.M_Product.OAK.id, (int)DictionaryIDs.C_UOM.HOUR.id, (BigDecimal)new BigDecimal("1"), (int)1);
            Assertions.assertEquals((Object)conv2.getDivideRate().setScale(1, RoundingMode.HALF_UP), (Object)converted);
            conv2.deleteEx(true);
            conv2 = null;
            converted = MUOMConversion.convertProductFrom((Properties)Env.getCtx(), (int)DictionaryIDs.M_Product.OAK.id, (int)DictionaryIDs.C_UOM.HOUR.id, (BigDecimal)new BigDecimal("1"));
            Assertions.assertEquals((Object)hour.round(conv1.getDivideRate(), true), (Object)converted);
            converted = MUOMConversion.convertProductFrom((Properties)Env.getCtx(), (int)DictionaryIDs.M_Product.OAK.id, (int)DictionaryIDs.C_UOM.HOUR.id, (BigDecimal)new BigDecimal("1"), (int)1);
            Assertions.assertEquals((Object)conv1.getDivideRate().setScale(1, RoundingMode.HALF_UP), (Object)converted);
        }
        catch (Throwable throwable) {
            this.rollback();
            DB.executeUpdateEx((String)"DELETE FROM C_UOM_Conversion WHERE C_UOM_Conversion_ID=?", (Object[])new Object[]{conv1.get_ID()}, null);
            if (conv2 != null) {
                conv2.deleteEx(true);
            }
            if (conv3 != null) {
                conv3.deleteEx(true);
            }
            throw throwable;
        }
        this.rollback();
        DB.executeUpdateEx((String)"DELETE FROM C_UOM_Conversion WHERE C_UOM_Conversion_ID=?", (Object[])new Object[]{conv1.get_ID()}, null);
        if (conv2 != null) {
            conv2.deleteEx(true);
        }
        if (conv3 != null) {
            conv3.deleteEx(true);
        }
    }
}

