/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.test.model;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Properties;
import java.util.logging.LogRecord;
import org.compiere.acct.Doc;
import org.compiere.acct.DocManager;
import org.compiere.model.MAccount;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MAllocationHdr;
import org.compiere.model.MAllocationLine;
import org.compiere.model.MBPartner;
import org.compiere.model.MBankAccount;
import org.compiere.model.MClient;
import org.compiere.model.MConversionRate;
import org.compiere.model.MCurrency;
import org.compiere.model.MDocType;
import org.compiere.model.MFactAcct;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MPayment;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.process.DocumentEngine;
import org.compiere.process.ProcessInfo;
import org.compiere.util.CLogErrorBuffer;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.TimeUtil;
import org.compiere.wf.MWorkflow;
import org.idempiere.test.AbstractTestCase;
import org.idempiere.test.ConversionRateHelper;
import org.idempiere.test.DictionaryIDs;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.Isolated;
import org.junit.jupiter.api.parallel.ResourceLock;

@Isolated
public class AllocationTest
extends AbstractTestCase {
    @Test
    public void testAllocateCharge() {
        int severeCount = 0;
        LogRecord[] errorLogs = CLogErrorBuffer.get((boolean)true).getRecords(true);
        if (errorLogs != null) {
            severeCount = errorLogs.length;
        }
        Properties ctx = Env.getCtx();
        String trxName = this.getTrxName();
        MBPartner bpartner = new MBPartner(ctx, DictionaryIDs.C_BPartner.C_AND_W.id, trxName);
        BigDecimal initialBalance = bpartner.getTotalOpenBalance();
        MPayment payment1 = new MPayment(ctx, 0, trxName);
        payment1.setC_BPartner_ID(DictionaryIDs.C_BPartner.C_AND_W.id);
        payment1.setC_DocType_ID(true);
        payment1.setDocStatus("DR");
        payment1.setDocAction("CO");
        payment1.setPayAmt(Env.ONEHUNDRED);
        payment1.setTenderType("K");
        payment1.setC_BankAccount_ID(DictionaryIDs.C_BankAccount.ACCOUNT_1234.id);
        payment1.setC_Currency_ID(DictionaryIDs.C_Currency.USD.id);
        payment1.setDateTrx(TimeUtil.getDay(null));
        payment1.setDateAcct(TimeUtil.getDay(null));
        payment1.saveEx();
        ProcessInfo info = MWorkflow.runDocumentActionWorkflow((PO)payment1, (String)"CO");
        payment1.load(trxName, new String[0]);
        Assertions.assertFalse((boolean)info.isError(), (String)("Error processing payment: " + info.getSummary()));
        Assertions.assertEquals((Object)"CO", (Object)payment1.getDocStatus(), (String)("Payment document status is not completed: " + payment1.getDocStatus()));
        Assertions.assertTrue((boolean)payment1.isPosted(), (String)"Payment not posted");
        bpartner.load(trxName, new String[0]);
        BigDecimal actualBalance = bpartner.getTotalOpenBalance();
        Assertions.assertTrue((actualBalance.compareTo(initialBalance.subtract(Env.ONEHUNDRED)) == 0 ? 1 : 0) != 0);
        MAllocationHdr alloc = new MAllocationHdr(Env.getCtx(), true, payment1.getDateTrx(), DictionaryIDs.C_Currency.USD.id, Env.getContext((Properties)Env.getCtx(), (String)"#AD_User_Name"), trxName);
        alloc.setAD_Org_ID(payment1.getAD_Org_ID());
        int doctypeAlloc = MDocType.getDocType((String)"CMA");
        alloc.setC_DocType_ID(doctypeAlloc);
        alloc.setDescription(alloc.getDescriptionForManualAllocation(payment1.getC_BPartner_ID(), trxName));
        alloc.saveEx();
        MAllocationLine aLine1 = new MAllocationLine(alloc, Env.ONEHUNDRED, Env.ZERO, Env.ZERO, Env.ZERO);
        aLine1.setDocInfo(DictionaryIDs.C_BPartner.C_AND_W.id, 0, 0);
        aLine1.setPaymentInfo(payment1.getC_Payment_ID(), 0);
        aLine1.saveEx();
        MAllocationLine aLine2 = new MAllocationLine(alloc, Env.ONEHUNDRED.negate(), Env.ZERO, Env.ZERO, Env.ZERO);
        aLine2.setC_Charge_ID(DictionaryIDs.C_Charge.FREIGHT.id);
        aLine2.setC_BPartner_ID(DictionaryIDs.C_BPartner.C_AND_W.id);
        aLine2.saveEx();
        Assertions.assertTrue((boolean)alloc.processIt("CO"));
        alloc.saveEx();
        payment1.load(trxName, new String[0]);
        Assertions.assertTrue((boolean)payment1.isAllocated(), (String)"Payment not allocated");
        bpartner.load(trxName, new String[0]);
        actualBalance = bpartner.getTotalOpenBalance();
        Assertions.assertTrue((actualBalance.compareTo(initialBalance) == 0 ? 1 : 0) != 0);
        MAllocationHdr[] alloc1 = MAllocationHdr.getOfPayment((Properties)ctx, (int)payment1.getC_Payment_ID(), (String)trxName);
        Assertions.assertTrue((boolean)alloc1[0].delete(true, trxName));
        payment1.load(trxName, new String[0]);
        Assertions.assertFalse((boolean)payment1.isAllocated(), (String)"Payment not allocated");
        bpartner.load(trxName, new String[0]);
        actualBalance = bpartner.getTotalOpenBalance();
        Assertions.assertTrue((actualBalance.compareTo(initialBalance.subtract(Env.ONEHUNDRED)) == 0 ? 1 : 0) != 0);
        errorLogs = CLogErrorBuffer.get((boolean)true).getRecords(true);
        if (errorLogs != null) {
            Assertions.assertEquals((int)severeCount, (int)errorLogs.length, (String)("Severe errors recorded in log: " + errorLogs.length));
        }
        this.rollback();
    }

    @Test
    public void testAllocateInvoiceArAp() {
        MBPartner bpartner = MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.JOE_BLOCK.id);
        Timestamp date = TimeUtil.getDay(null);
        MCurrency usd = MCurrency.get((int)DictionaryIDs.C_Currency.USD.id);
        int payterm = DictionaryIDs.C_PaymentTerm.TWO_PERCENT_10_NET_30.id;
        int taxid = DictionaryIDs.C_Tax.CT_SALES.id;
        MInvoice invoiceAr = this.createInvoice(true, false, date, date, bpartner.getC_BPartner_ID(), payterm, taxid, Env.ONEHUNDRED);
        Assertions.assertEquals((Object)invoiceAr.getTotalLines().setScale(2, RoundingMode.HALF_UP), (Object)new BigDecimal("100.00"));
        Assertions.assertEquals((Object)invoiceAr.getGrandTotal().setScale(2, RoundingMode.HALF_UP), (Object)new BigDecimal("106.00"));
        this.completeDocument((PO)invoiceAr);
        this.postDocument((PO)invoiceAr);
        MInvoice invoiceAp = this.createInvoice(false, false, date, date, bpartner.getC_BPartner_ID(), payterm, taxid, Env.ONEHUNDRED);
        this.completeDocument((PO)invoiceAp);
        this.postDocument((PO)invoiceAp);
        MAllocationHdr alloc = new MAllocationHdr(Env.getCtx(), true, date, usd.getC_Currency_ID(), Env.getContext((Properties)Env.getCtx(), (String)"#AD_User_Name"), this.getTrxName());
        alloc.setAD_Org_ID(invoiceAr.getAD_Org_ID());
        int doctypeAlloc = MDocType.getDocType((String)"CMA");
        alloc.setC_DocType_ID(doctypeAlloc);
        alloc.saveEx();
        MAllocationLine aLine1 = new MAllocationLine(alloc, invoiceAp.getOpenAmt(), Env.ZERO, Env.ZERO, Env.ZERO);
        aLine1.setDocInfo(invoiceAp.getC_BPartner_ID(), 0, invoiceAp.getC_Invoice_ID());
        aLine1.saveEx();
        MAllocationLine aLine2 = new MAllocationLine(alloc, invoiceAr.getOpenAmt(), Env.ZERO, Env.ZERO, Env.ZERO);
        aLine2.setDocInfo(invoiceAr.getC_BPartner_ID(), 0, invoiceAr.getC_Invoice_ID());
        aLine2.saveEx();
        this.completeDocument((PO)alloc);
        this.postDocument((PO)alloc);
        alloc.load(this.getTrxName(), new String[0]);
        Assertions.assertTrue((boolean)alloc.isPosted(), (String)"Allocation not posted");
    }

    @Test
    public void testAllocateCustomerInvoice() {
        int severeCount = 0;
        LogRecord[] errorLogs = CLogErrorBuffer.get((boolean)true).getRecords(true);
        if (errorLogs != null) {
            severeCount = errorLogs.length;
        }
        Properties ctx = Env.getCtx();
        String trxName = this.getTrxName();
        MBPartner bpartner = new MBPartner(ctx, DictionaryIDs.C_BPartner.PATIO.id, trxName);
        DB.getDatabase().forUpdate((PO)bpartner, 0);
        BigDecimal initialBalance = bpartner.getTotalOpenBalance();
        MInvoice invoice = new MInvoice(ctx, 0, trxName);
        invoice.setBPartner(MBPartner.get((Properties)ctx, (int)DictionaryIDs.C_BPartner.PATIO.id));
        invoice.setC_DocTypeTarget_ID("ARI");
        invoice.setC_DocType_ID(invoice.getC_DocTypeTarget_ID());
        invoice.setPaymentRule("S");
        invoice.setC_PaymentTerm_ID(DictionaryIDs.C_PaymentTerm.IMMEDIATE.id);
        Timestamp today = TimeUtil.getDay((long)System.currentTimeMillis());
        invoice.setDateInvoiced(today);
        invoice.setDateAcct(today);
        invoice.setDocStatus("DR");
        invoice.setDocAction("CO");
        invoice.saveEx();
        MInvoiceLine line1 = new MInvoiceLine(invoice);
        line1.setLine(10);
        line1.setC_Charge_ID(DictionaryIDs.C_Charge.FREIGHT.id);
        line1.setQty(new BigDecimal("1"));
        line1.setPrice(Env.ONEHUNDRED);
        line1.saveEx();
        ProcessInfo info = MWorkflow.runDocumentActionWorkflow((PO)invoice, (String)"CO");
        invoice.load(trxName, new String[0]);
        Assertions.assertFalse((boolean)info.isError(), (String)("Error processing invoice: " + info.getSummary()));
        Assertions.assertEquals((Object)"CO", (Object)invoice.getDocStatus(), (String)("Invoice document status is not completed: " + invoice.getDocStatus()));
        Assertions.assertTrue((Env.ONEHUNDRED.compareTo(invoice.getGrandTotal()) == 0 ? 1 : 0) != 0, (String)("Invoice grand total not as expected: " + invoice.getGrandTotal().toPlainString()));
        Assertions.assertTrue((boolean)invoice.isPosted(), (String)"Invoice not posted");
        bpartner.load(trxName, new String[0]);
        BigDecimal actualBalance = bpartner.getTotalOpenBalance();
        Assertions.assertTrue((actualBalance.compareTo(initialBalance.add(Env.ONEHUNDRED)) == 0 ? 1 : 0) != 0);
        MPayment payment1 = new MPayment(ctx, 0, trxName);
        payment1.setC_Invoice_ID(invoice.getC_Invoice_ID());
        payment1.setC_BPartner_ID(invoice.getC_BPartner_ID());
        payment1.setC_DocType_ID(true);
        payment1.setDocStatus("DR");
        payment1.setDocAction("CO");
        payment1.setPayAmt(Env.ONEHUNDRED);
        payment1.setTenderType("K");
        payment1.setC_BankAccount_ID(DictionaryIDs.C_BankAccount.ACCOUNT_1234.id);
        payment1.setC_Currency_ID(DictionaryIDs.C_Currency.USD.id);
        payment1.setDateTrx(invoice.getDateInvoiced());
        payment1.setDateAcct(invoice.getDateInvoiced());
        payment1.saveEx();
        info = MWorkflow.runDocumentActionWorkflow((PO)payment1, (String)"CO");
        payment1.load(trxName, new String[0]);
        Assertions.assertFalse((boolean)info.isError(), (String)("Error processing payment: " + info.getSummary()));
        Assertions.assertEquals((Object)"CO", (Object)payment1.getDocStatus(), (String)("Payment document status is not completed: " + payment1.getDocStatus()));
        Assertions.assertEquals((Object)false, (Object)invoice.isPaid(), (String)"Invoice isPaid() is not false");
        Assertions.assertTrue((boolean)payment1.isPosted(), (String)"Payment not posted");
        bpartner.load(trxName, new String[0]);
        actualBalance = bpartner.getTotalOpenBalance();
        Assertions.assertTrue((actualBalance.compareTo(initialBalance) == 0 ? 1 : 0) != 0);
        MAllocationHdr[] alloc1 = MAllocationHdr.getOfPayment((Properties)ctx, (int)payment1.getC_Payment_ID(), (String)trxName);
        Assertions.assertTrue((boolean)alloc1[0].delete(true, trxName));
        bpartner.load(trxName, new String[0]);
        actualBalance = bpartner.getTotalOpenBalance();
        Assertions.assertTrue((actualBalance.compareTo(initialBalance) == 0 ? 1 : 0) != 0);
        errorLogs = CLogErrorBuffer.get((boolean)true).getRecords(true);
        if (errorLogs != null) {
            Assertions.assertEquals((int)severeCount, (int)errorLogs.length, (String)("Severe errors recorded in log: " + errorLogs.length));
        }
        this.rollback();
    }

    @Test
    public void testAllocateVendorInvoice() {
        int severeCount = 0;
        LogRecord[] errorLogs = CLogErrorBuffer.get((boolean)true).getRecords(true);
        if (errorLogs != null) {
            severeCount = errorLogs.length;
        }
        Properties ctx = Env.getCtx();
        String trxName = this.getTrxName();
        MBPartner bpartner = new MBPartner(ctx, DictionaryIDs.C_BPartner.TREE_FARM.id, trxName);
        BigDecimal initialBalance = bpartner.getTotalOpenBalance();
        MInvoice invoice = new MInvoice(ctx, 0, trxName);
        invoice.setBPartner(MBPartner.get((Properties)ctx, (int)DictionaryIDs.C_BPartner.TREE_FARM.id));
        invoice.setC_DocTypeTarget_ID("API");
        invoice.setC_DocType_ID(invoice.getC_DocTypeTarget_ID());
        invoice.setPaymentRule("S");
        invoice.setC_PaymentTerm_ID(DictionaryIDs.C_PaymentTerm.IMMEDIATE.id);
        Timestamp today = TimeUtil.getDay((long)System.currentTimeMillis());
        invoice.setDateInvoiced(today);
        invoice.setDateAcct(today);
        invoice.setDocStatus("DR");
        invoice.setDocAction("CO");
        invoice.saveEx();
        MInvoiceLine line1 = new MInvoiceLine(invoice);
        line1.setLine(10);
        line1.setC_Charge_ID(DictionaryIDs.C_Charge.FREIGHT.id);
        line1.setQty(new BigDecimal("1"));
        line1.setPrice(Env.ONEHUNDRED);
        line1.saveEx();
        ProcessInfo info = MWorkflow.runDocumentActionWorkflow((PO)invoice, (String)"CO");
        invoice.load(trxName, new String[0]);
        Assertions.assertFalse((boolean)info.isError(), (String)("Error processing invoice: " + info.getSummary()));
        Assertions.assertEquals((Object)"CO", (Object)invoice.getDocStatus(), (String)("Invoice document status is not completed: " + invoice.getDocStatus()));
        Assertions.assertTrue((Env.ONEHUNDRED.compareTo(invoice.getGrandTotal()) == 0 ? 1 : 0) != 0, (String)("Invoice grand total not as expected: " + invoice.getGrandTotal().toPlainString()));
        Assertions.assertTrue((boolean)invoice.isPosted(), (String)"Invoice not posted");
        bpartner.load(trxName, new String[0]);
        BigDecimal actualBalance = bpartner.getTotalOpenBalance();
        Assertions.assertTrue((actualBalance.compareTo(initialBalance.subtract(Env.ONEHUNDRED)) == 0 ? 1 : 0) != 0);
        MPayment payment1 = new MPayment(ctx, 0, trxName);
        payment1.setC_Invoice_ID(invoice.getC_Invoice_ID());
        payment1.setC_BPartner_ID(invoice.getC_BPartner_ID());
        payment1.setC_DocType_ID(false);
        payment1.setDocStatus("DR");
        payment1.setDocAction("CO");
        payment1.setPayAmt(Env.ONEHUNDRED);
        payment1.setTenderType("K");
        payment1.setC_BankAccount_ID(DictionaryIDs.C_BankAccount.ACCOUNT_1234.id);
        payment1.setC_Currency_ID(DictionaryIDs.C_Currency.USD.id);
        payment1.setDateTrx(invoice.getDateInvoiced());
        payment1.setDateAcct(invoice.getDateInvoiced());
        payment1.saveEx();
        info = MWorkflow.runDocumentActionWorkflow((PO)payment1, (String)"CO");
        payment1.load(trxName, new String[0]);
        Assertions.assertFalse((boolean)info.isError(), (String)("Error processing payment: " + info.getSummary()));
        Assertions.assertEquals((Object)"CO", (Object)payment1.getDocStatus(), (String)("Payment document status is not completed: " + payment1.getDocStatus()));
        Assertions.assertEquals((Object)false, (Object)invoice.isPaid(), (String)"Invoice isPaid() is not false");
        Assertions.assertTrue((boolean)payment1.isPosted(), (String)"Payment not posted");
        bpartner.load(trxName, new String[0]);
        actualBalance = bpartner.getTotalOpenBalance();
        Assertions.assertTrue((actualBalance.compareTo(initialBalance) == 0 ? 1 : 0) != 0);
        MAllocationHdr[] alloc1 = MAllocationHdr.getOfPayment((Properties)ctx, (int)payment1.getC_Payment_ID(), (String)trxName);
        Assertions.assertTrue((boolean)alloc1[0].delete(true, trxName));
        bpartner.load(trxName, new String[0]);
        actualBalance = bpartner.getTotalOpenBalance();
        Assertions.assertTrue((actualBalance.compareTo(initialBalance) == 0 ? 1 : 0) != 0);
        errorLogs = CLogErrorBuffer.get((boolean)true).getRecords(true);
        if (errorLogs != null) {
            Assertions.assertEquals((int)severeCount, (int)errorLogs.length, (String)("Severe errors recorded in log: " + errorLogs.length));
        }
        this.rollback();
    }

    @Test
    @ResourceLock(value="C_Conversion_Rate")
    public void testPaymentReversePosting() {
        MBPartner bpartner = MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.COLOR_INC.id);
        Timestamp currentDate = Env.getContextAsDate((Properties)Env.getCtx(), (String)"#Date");
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(currentDate.getTime());
        cal.add(5, -1);
        Timestamp date1 = new Timestamp(cal.getTimeInMillis());
        Timestamp date2 = currentDate;
        int C_ConversionType_ID = DictionaryIDs.C_ConversionType.COMPANY.id;
        MCurrency usd = MCurrency.get((int)DictionaryIDs.C_Currency.USD.id);
        MCurrency euro = MCurrency.get((int)DictionaryIDs.C_Currency.EUR.id);
        BigDecimal eurToUsd1 = new BigDecimal(30);
        MConversionRate cr1 = this.createConversionRate(usd.getC_Currency_ID(), euro.getC_Currency_ID(), C_ConversionType_ID, date1, eurToUsd1, false);
        BigDecimal eurToUsd2 = new BigDecimal(31);
        MConversionRate cr2 = this.createConversionRate(usd.getC_Currency_ID(), euro.getC_Currency_ID(), C_ConversionType_ID, date2, eurToUsd2, false);
        try {
            MAcctSchema[] ass;
            Object whereClause = "AD_Org_ID=? AND C_Currency_ID=?";
            MBankAccount ba = (MBankAccount)new Query(Env.getCtx(), "C_BankAccount", (String)whereClause, this.getTrxName()).setParameters(new Object[]{Env.getAD_Org_ID((Properties)Env.getCtx()), usd.getC_Currency_ID()}).setOrderBy("IsDefault DESC").first();
            Assertions.assertTrue((ba != null ? 1 : 0) != 0, (String)"@NoAccountOrgCurrency@");
            BigDecimal payAmt = new BigDecimal(1000);
            MPayment payment = this.createReceiptPayment(bpartner.getC_BPartner_ID(), ba.getC_BankAccount_ID(), date1, euro.getC_Currency_ID(), C_ConversionType_ID, payAmt);
            this.completeDocument((PO)payment);
            this.postDocument((PO)payment);
            this.reverseAccrualDocument((PO)payment);
            MPayment reversalPayment = new MPayment(Env.getCtx(), payment.getReversal_ID(), this.getTrxName());
            this.postDocument((PO)reversalPayment);
            MAllocationHdr[] allocations = MAllocationHdr.getOfPayment((Properties)Env.getCtx(), (int)payment.getC_Payment_ID(), (String)this.getTrxName());
            Assertions.assertTrue((allocations.length == 1 ? 1 : 0) != 0);
            MAllocationHdr allocation = allocations[0];
            this.postDocument((PO)allocation);
            MAcctSchema[] mAcctSchemaArray = ass = MAcctSchema.getClientAcctSchema((Properties)Env.getCtx(), (int)Env.getAD_Client_ID((Properties)Env.getCtx()));
            int n = ass.length;
            int n2 = 0;
            while (n2 < n) {
                MAcctSchema as = mAcctSchemaArray[n2];
                if (as.getC_Currency_ID() == usd.getC_Currency_ID()) {
                    int[] ids;
                    Doc doc = DocManager.getDocument((MAcctSchema)as, (int)735, (int)allocation.get_ID(), (String)this.getTrxName());
                    doc.setC_BankAccount_ID(ba.getC_BankAccount_ID());
                    MAccount acctUC = doc.getAccount(10, as);
                    MAccount acctLoss = MAccount.get((Properties)as.getCtx(), (int)as.getAcctSchemaDefault().getRealizedLoss_Acct());
                    BigDecimal ucAmtAcctDr = new BigDecimal(30000);
                    BigDecimal ucAmtAcctCr = new BigDecimal(31000);
                    BigDecimal lossAmtAcct = new BigDecimal(1000);
                    whereClause = "AD_Table_ID=735 AND Record_ID=" + allocation.get_ID() + " AND C_AcctSchema_ID=" + as.getC_AcctSchema_ID();
                    int[] nArray = ids = MFactAcct.getAllIDs((String)"Fact_Acct", (String)whereClause, (String)this.getTrxName());
                    int n3 = ids.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        int id = nArray[n4];
                        MFactAcct fa = new MFactAcct(Env.getCtx(), id, this.getTrxName());
                        if (acctUC.getAccount_ID() == fa.getAccount_ID()) {
                            if (fa.getAmtAcctDr().signum() > 0) {
                                Assertions.assertTrue((fa.getAmtAcctDr().compareTo(ucAmtAcctDr) == 0 ? 1 : 0) != 0, (String)(fa.getAmtAcctDr().toPlainString() + "!=" + ucAmtAcctDr.toPlainString()));
                            } else if (fa.getAmtAcctDr().signum() < 0) {
                                Assertions.assertTrue((fa.getAmtAcctDr().compareTo(ucAmtAcctCr.negate()) == 0 ? 1 : 0) != 0, (String)(fa.getAmtAcctDr().toPlainString() + "!=" + ucAmtAcctCr.negate().toPlainString()));
                            } else if (fa.getAmtAcctCr().signum() > 0) {
                                Assertions.assertTrue((fa.getAmtAcctCr().compareTo(ucAmtAcctCr) == 0 ? 1 : 0) != 0, (String)(fa.getAmtAcctCr().toPlainString() + "!=" + ucAmtAcctCr.toPlainString()));
                            }
                        } else if (acctLoss.getAccount_ID() == fa.getAccount_ID()) {
                            Assertions.assertTrue((fa.getAmtAcctDr().compareTo(lossAmtAcct) == 0 ? 1 : 0) != 0, (String)(fa.getAmtAcctDr().toPlainString() + "!=" + lossAmtAcct.toPlainString()));
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        finally {
            this.rollback();
            this.deleteConversionRate(cr1);
            this.deleteConversionRate(cr2);
        }
    }

    @Test
    @ResourceLock(value="C_Conversion_Rate")
    public void testPaymentReverseImmediatePosting() {
        try {
            MAllocationHdr[] allocations;
            boolean isImmediate = MClient.isClientAccountingImmediate();
            if (!isImmediate) {
                return;
            }
            MBPartner bpartner = MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.JOE_BLOCK.id);
            Timestamp date = TimeUtil.getDay(null);
            MCurrency usd = MCurrency.get((int)DictionaryIDs.C_Currency.USD.id);
            int payterm = DictionaryIDs.C_PaymentTerm.IMMEDIATE.id;
            int taxid = DictionaryIDs.C_Tax.EXEMPT.id;
            MInvoice invoice = this.createInvoice(false, false, date, date, bpartner.getC_BPartner_ID(), payterm, taxid, Env.ONEHUNDRED);
            this.completeDocument((PO)invoice);
            Assertions.assertTrue((boolean)invoice.isPosted(), (String)"Invoice not posted");
            String whereClause = "AD_Org_ID=? AND C_Currency_ID=?";
            MBankAccount ba = (MBankAccount)new Query(Env.getCtx(), "C_BankAccount", whereClause, this.getTrxName()).setParameters(new Object[]{Env.getAD_Org_ID((Properties)Env.getCtx()), usd.getC_Currency_ID()}).setOrderBy("IsDefault DESC").first();
            Assertions.assertTrue((ba != null ? 1 : 0) != 0, (String)"@NoAccountOrgCurrency@");
            MPayment payment = this.createPayment(bpartner.getC_BPartner_ID(), ba.getC_BankAccount_ID(), date, usd.getC_Currency_ID(), 0, Env.ONEHUNDRED);
            payment.setC_Invoice_ID(invoice.getC_Invoice_ID());
            payment.saveEx();
            this.completeDocument((PO)payment);
            Assertions.assertTrue((boolean)payment.isPosted(), (String)"Payment not posted");
            MAllocationHdr[] mAllocationHdrArray = allocations = MAllocationHdr.getOfPayment((Properties)Env.getCtx(), (int)payment.getC_Payment_ID(), (String)this.getTrxName());
            int n = allocations.length;
            int n2 = 0;
            while (n2 < n) {
                MAllocationHdr allocation = mAllocationHdrArray[n2];
                Assertions.assertTrue((boolean)allocation.isPosted(), (String)"Allocation not posted");
                ++n2;
            }
            this.reverseCorrectDocument((PO)payment);
            MPayment reversalPayment = new MPayment(Env.getCtx(), payment.getReversal_ID(), this.getTrxName());
            Assertions.assertTrue((boolean)reversalPayment.isPosted(), (String)"Reversal payment not posted");
            MAllocationHdr[] mAllocationHdrArray2 = allocations = MAllocationHdr.getOfPayment((Properties)Env.getCtx(), (int)reversalPayment.getC_Payment_ID(), (String)this.getTrxName());
            int n3 = allocations.length;
            n = 0;
            while (n < n3) {
                MAllocationHdr allocation = mAllocationHdrArray2[n];
                Assertions.assertTrue((boolean)allocation.isPosted(), (String)"Allocation not posted");
                ++n;
            }
        }
        finally {
            this.rollback();
        }
    }

    @Test
    @ResourceLock(value="C_Conversion_Rate")
    public void testInvoiceReversePostingWithDiffCurrency() {
        MBPartner bpartner = MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.C_AND_W.id);
        Timestamp date = Env.getContextAsDate((Properties)Env.getCtx(), (String)"#Date");
        int C_ConversionType_ID = DictionaryIDs.C_ConversionType.COMPANY.id;
        MCurrency usd = MCurrency.get((int)DictionaryIDs.C_Currency.USD.id);
        MCurrency euro = MCurrency.get((int)DictionaryIDs.C_Currency.EUR.id);
        BigDecimal eurToUsd = new BigDecimal(6.3836578E-5);
        MConversionRate cr = this.createConversionRate(usd.getC_Currency_ID(), euro.getC_Currency_ID(), C_ConversionType_ID, date, eurToUsd, false);
        int M_PriceList_ID = DictionaryIDs.M_PriceList.EXPORT.id;
        BigDecimal totalLines = new BigDecimal(33300);
        try {
            MAcctSchema[] ass;
            MInvoice invoice = new MInvoice(Env.getCtx(), 0, this.getTrxName());
            invoice.setBPartner(bpartner);
            invoice.setIsSOTrx(false);
            invoice.setC_DocTypeTarget_ID();
            invoice.setDateInvoiced(date);
            invoice.setDateAcct(date);
            invoice.setM_PriceList_ID(M_PriceList_ID);
            invoice.setC_ConversionType_ID(C_ConversionType_ID);
            invoice.setC_PaymentTerm_ID(DictionaryIDs.C_PaymentTerm.IMMEDIATE.id);
            invoice.setDocStatus("DR");
            invoice.setDocAction("CO");
            invoice.saveEx();
            MInvoiceLine invoiceLine = new MInvoiceLine(invoice);
            invoiceLine.setLine(10);
            invoiceLine.setC_Charge_ID(DictionaryIDs.C_Charge.FREIGHT.id);
            invoiceLine.setC_Tax_ID(DictionaryIDs.C_Tax.EXEMPT.id);
            invoiceLine.setQty(BigDecimal.ONE);
            invoiceLine.setPrice(totalLines);
            invoiceLine.saveEx();
            this.completeDocument((PO)invoice);
            this.postDocument((PO)invoice);
            this.reverseAccrualDocument((PO)invoice);
            MInvoice reversalInvoice = new MInvoice(Env.getCtx(), invoice.getReversal_ID(), this.getTrxName());
            this.postDocument((PO)reversalInvoice);
            MAllocationHdr[] allocations = MAllocationHdr.getOfInvoice((Properties)Env.getCtx(), (int)invoice.getC_Invoice_ID(), (String)this.getTrxName());
            Assertions.assertTrue((allocations.length == 1 ? 1 : 0) != 0);
            MAllocationHdr allocation = allocations[0];
            this.postDocument((PO)allocation);
            MAcctSchema[] mAcctSchemaArray = ass = MAcctSchema.getClientAcctSchema((Properties)Env.getCtx(), (int)Env.getAD_Client_ID((Properties)Env.getCtx()));
            int n = ass.length;
            int n2 = 0;
            while (n2 < n) {
                MAcctSchema as = mAcctSchemaArray[n2];
                if (as.getC_Currency_ID() == usd.getC_Currency_ID()) {
                    int[] ids;
                    Doc doc = DocManager.getDocument((MAcctSchema)as, (int)735, (int)allocation.get_ID(), (String)this.getTrxName());
                    doc.setC_BPartner_ID(invoice.getC_BPartner_ID());
                    MAccount acctLiability = doc.getAccount(2, as);
                    BigDecimal tradeAmtAcct = new BigDecimal(2.13).setScale(usd.getStdPrecision(), RoundingMode.HALF_UP);
                    String whereClause = "AD_Table_ID=735 AND Record_ID=" + allocation.get_ID() + " AND C_AcctSchema_ID=" + as.getC_AcctSchema_ID();
                    int[] nArray = ids = MFactAcct.getAllIDs((String)"Fact_Acct", (String)whereClause, (String)this.getTrxName());
                    int n3 = ids.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        int id = nArray[n4];
                        MFactAcct fa = new MFactAcct(Env.getCtx(), id, this.getTrxName());
                        if (acctLiability.getAccount_ID() == fa.getAccount_ID()) {
                            if (fa.getAmtAcctDr().signum() > 0) {
                                Assertions.assertTrue((fa.getAmtAcctDr().compareTo(tradeAmtAcct) == 0 ? 1 : 0) != 0, (String)(fa.getAmtAcctDr().toPlainString() + "!=" + tradeAmtAcct.toPlainString()));
                            } else if (fa.getAmtAcctDr().signum() < 0) {
                                Assertions.assertTrue((fa.getAmtAcctDr().compareTo(tradeAmtAcct.negate()) == 0 ? 1 : 0) != 0, (String)(fa.getAmtAcctDr().toPlainString() + "!=" + tradeAmtAcct.negate().toPlainString()));
                            } else if (fa.getAmtAcctCr().signum() > 0) {
                                Assertions.assertTrue((fa.getAmtAcctCr().compareTo(tradeAmtAcct) == 0 ? 1 : 0) != 0, (String)(fa.getAmtAcctCr().toPlainString() + "!=" + tradeAmtAcct.toPlainString()));
                            }
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        finally {
            this.rollback();
            this.deleteConversionRate(cr);
        }
    }

    @Test
    @ResourceLock(value="C_Conversion_Rate")
    public void testAllocatePaymentPosting() {
        MBPartner bpartner = MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.CHROME_INC.id);
        Timestamp currentDate = Env.getContextAsDate((Properties)Env.getCtx(), (String)"#Date");
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(currentDate.getTime());
        cal.add(5, -1);
        Timestamp date1 = new Timestamp(cal.getTimeInMillis());
        Timestamp date2 = currentDate;
        int C_ConversionType_ID = DictionaryIDs.C_ConversionType.COMPANY.id;
        MCurrency usd = MCurrency.get((int)DictionaryIDs.C_Currency.USD.id);
        MCurrency euro = MCurrency.get((int)DictionaryIDs.C_Currency.EUR.id);
        BigDecimal eurToUsd1 = new BigDecimal(30);
        MConversionRate cr1 = this.createConversionRate(usd.getC_Currency_ID(), euro.getC_Currency_ID(), C_ConversionType_ID, date1, eurToUsd1, false);
        BigDecimal eurToUsd2 = new BigDecimal(31);
        MConversionRate cr2 = this.createConversionRate(usd.getC_Currency_ID(), euro.getC_Currency_ID(), C_ConversionType_ID, date2, eurToUsd2, false);
        try {
            MAcctSchema[] ass;
            Object whereClause = "AD_Org_ID=? AND C_Currency_ID=?";
            MBankAccount ba = (MBankAccount)new Query(Env.getCtx(), "C_BankAccount", (String)whereClause, this.getTrxName()).setParameters(new Object[]{Env.getAD_Org_ID((Properties)Env.getCtx()), usd.getC_Currency_ID()}).setOrderBy("IsDefault DESC").first();
            Assertions.assertTrue((ba != null ? 1 : 0) != 0, (String)"@NoAccountOrgCurrency@");
            BigDecimal payAmt = new BigDecimal(1000);
            MPayment payment1 = this.createReceiptPayment(bpartner.getC_BPartner_ID(), ba.getC_BankAccount_ID(), date1, euro.getC_Currency_ID(), C_ConversionType_ID, payAmt);
            this.completeDocument((PO)payment1);
            this.postDocument((PO)payment1);
            MPayment payment2 = this.createReceiptPayment(bpartner.getC_BPartner_ID(), ba.getC_BankAccount_ID(), date2, euro.getC_Currency_ID(), C_ConversionType_ID, payAmt.negate());
            this.completeDocument((PO)payment2);
            this.postDocument((PO)payment2);
            MAllocationHdr alloc = new MAllocationHdr(Env.getCtx(), true, date2, euro.getC_Currency_ID(), Env.getContext((Properties)Env.getCtx(), (String)"#AD_User_Name"), this.getTrxName());
            alloc.setAD_Org_ID(payment2.getAD_Org_ID());
            int doctypeAlloc = MDocType.getDocType((String)"CMA");
            alloc.setC_DocType_ID(doctypeAlloc);
            alloc.setDescription(alloc.getDescriptionForManualAllocation(payment2.getC_BPartner_ID(), this.getTrxName()));
            alloc.saveEx();
            MAllocationLine aLine1 = new MAllocationLine(alloc, payment1.getPayAmt(), Env.ZERO, Env.ZERO, Env.ZERO);
            aLine1.setDocInfo(payment1.getC_BPartner_ID(), 0, 0);
            aLine1.setPaymentInfo(payment1.getC_Payment_ID(), 0);
            aLine1.saveEx();
            MAllocationLine aLine2 = new MAllocationLine(alloc, payment2.getPayAmt(), Env.ZERO, Env.ZERO, Env.ZERO);
            aLine2.setDocInfo(payment2.getC_BPartner_ID(), 0, 0);
            aLine2.setPaymentInfo(payment2.getC_Payment_ID(), 0);
            aLine2.saveEx();
            this.completeDocument((PO)alloc);
            this.postDocument((PO)alloc);
            MAllocationHdr[] allocations = MAllocationHdr.getOfPayment((Properties)Env.getCtx(), (int)payment1.getC_Payment_ID(), (String)this.getTrxName());
            Assertions.assertTrue((allocations.length == 1 ? 1 : 0) != 0);
            MAllocationHdr allocation = allocations[0];
            this.postDocument((PO)allocation);
            MAcctSchema[] mAcctSchemaArray = ass = MAcctSchema.getClientAcctSchema((Properties)Env.getCtx(), (int)Env.getAD_Client_ID((Properties)Env.getCtx()));
            int n = ass.length;
            int n2 = 0;
            while (n2 < n) {
                MAcctSchema as = mAcctSchemaArray[n2];
                if (as.getC_Currency_ID() == usd.getC_Currency_ID()) {
                    int[] ids;
                    Doc doc = DocManager.getDocument((MAcctSchema)as, (int)735, (int)allocation.get_ID(), (String)this.getTrxName());
                    doc.setC_BankAccount_ID(ba.getC_BankAccount_ID());
                    MAccount acctUC = doc.getAccount(10, as);
                    MAccount acctLoss = MAccount.get((Properties)as.getCtx(), (int)as.getAcctSchemaDefault().getRealizedLoss_Acct());
                    BigDecimal ucAmtAcctDr = new BigDecimal(30000);
                    BigDecimal ucAmtAcctCr = new BigDecimal(31000);
                    BigDecimal lossAmtAcct = new BigDecimal(1000);
                    whereClause = "AD_Table_ID=735 AND Record_ID=" + allocation.get_ID() + " AND C_AcctSchema_ID=" + as.getC_AcctSchema_ID();
                    int[] nArray = ids = MFactAcct.getAllIDs((String)"Fact_Acct", (String)whereClause, (String)this.getTrxName());
                    int n3 = ids.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        int id = nArray[n4];
                        MFactAcct fa = new MFactAcct(Env.getCtx(), id, this.getTrxName());
                        if (acctUC.getAccount_ID() == fa.getAccount_ID()) {
                            if (fa.getAmtAcctDr().signum() > 0) {
                                Assertions.assertTrue((fa.getAmtAcctDr().compareTo(ucAmtAcctDr) == 0 ? 1 : 0) != 0, (String)(fa.getAmtAcctDr().toPlainString() + "!=" + ucAmtAcctDr.toPlainString()));
                            } else if (fa.getAmtAcctDr().signum() < 0) {
                                Assertions.assertTrue((fa.getAmtAcctDr().compareTo(ucAmtAcctCr.negate()) == 0 ? 1 : 0) != 0, (String)(fa.getAmtAcctDr().toPlainString() + "!=" + ucAmtAcctCr.negate().toPlainString()));
                            } else if (fa.getAmtAcctCr().signum() > 0) {
                                Assertions.assertTrue((fa.getAmtAcctCr().compareTo(ucAmtAcctCr) == 0 ? 1 : 0) != 0, (String)(fa.getAmtAcctCr().toPlainString() + "!=" + ucAmtAcctCr.toPlainString()));
                            }
                        } else if (acctLoss.getAccount_ID() == fa.getAccount_ID()) {
                            Assertions.assertTrue((fa.getAmtAcctDr().compareTo(lossAmtAcct) == 0 ? 1 : 0) != 0, (String)(fa.getAmtAcctDr().toPlainString() + "!=" + lossAmtAcct.toPlainString()));
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        finally {
            this.rollback();
            this.deleteConversionRate(cr1);
            this.deleteConversionRate(cr2);
        }
    }

    private MConversionRate createConversionRate(int C_Currency_ID, int C_Currency_ID_To, int C_ConversionType_ID, Timestamp date, BigDecimal rate, boolean isMultiplyRate) {
        return ConversionRateHelper.createConversionRate(C_Currency_ID, C_Currency_ID_To, C_ConversionType_ID, date, rate, isMultiplyRate);
    }

    private void deleteConversionRate(MConversionRate cr) {
        ConversionRateHelper.deleteConversionRate(cr);
    }

    private MPayment createReceiptPayment(int C_BPartner_ID, int C_BankAccount_ID, Timestamp date, int C_Currency_ID, int C_ConversionType_ID, BigDecimal payAmt) {
        MPayment payment = new MPayment(Env.getCtx(), 0, this.getTrxName());
        payment.setC_BankAccount_ID(C_BankAccount_ID);
        payment.setC_DocType_ID(true);
        payment.setDateTrx(date);
        payment.setDateAcct(date);
        payment.setC_BPartner_ID(C_BPartner_ID);
        payment.setPayAmt(payAmt);
        payment.setC_Currency_ID(C_Currency_ID);
        payment.setC_ConversionType_ID(C_ConversionType_ID);
        payment.setTenderType("K");
        payment.setDocStatus("DR");
        payment.setDocAction("CO");
        payment.saveEx();
        return payment;
    }

    private MPayment createPayment(int C_BPartner_ID, int C_BankAccount_ID, Timestamp date, int C_Currency_ID, int C_ConversionType_ID, BigDecimal payAmt) {
        MPayment payment = new MPayment(Env.getCtx(), 0, this.getTrxName());
        payment.setC_BankAccount_ID(C_BankAccount_ID);
        payment.setC_DocType_ID(false);
        payment.setDateTrx(date);
        payment.setDateAcct(date);
        payment.setC_BPartner_ID(C_BPartner_ID);
        payment.setPayAmt(payAmt);
        payment.setC_Currency_ID(C_Currency_ID);
        payment.setC_ConversionType_ID(C_ConversionType_ID);
        payment.setTenderType("K");
        payment.setDocStatus("DR");
        payment.setDocAction("CO");
        payment.saveEx();
        return payment;
    }

    private void completeDocument(PO po) {
        ProcessInfo info = MWorkflow.runDocumentActionWorkflow((PO)po, (String)"CO");
        po.load(this.getTrxName(), new String[0]);
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        String docStatus = (String)po.get_Value("DocStatus");
        Assertions.assertEquals((Object)"CO", (Object)docStatus, (String)("CO != " + docStatus));
    }

    private void reverseAccrualDocument(PO po) {
        ProcessInfo info = MWorkflow.runDocumentActionWorkflow((PO)po, (String)"RA");
        po.load(this.getTrxName(), new String[0]);
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        String docStatus = (String)po.get_Value("DocStatus");
        Assertions.assertEquals((Object)"RE", (Object)docStatus, (String)("RE != " + docStatus));
    }

    private void reverseCorrectDocument(PO po) {
        ProcessInfo info = MWorkflow.runDocumentActionWorkflow((PO)po, (String)"RC");
        po.load(this.getTrxName(), new String[0]);
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        String docStatus = (String)po.get_Value("DocStatus");
        Assertions.assertEquals((Object)"RE", (Object)docStatus, (String)("RE != " + docStatus));
    }

    private void postDocument(PO po) {
        if (!po.get_ValueAsBoolean("Posted")) {
            String error = DocumentEngine.postImmediate((Properties)Env.getCtx(), (int)po.getAD_Client_ID(), (int)po.get_Table_ID(), (int)po.get_ID(), (boolean)false, (String)this.getTrxName());
            Assertions.assertTrue((error == null ? 1 : 0) != 0, (String)error);
        }
        po.load(this.getTrxName(), new String[0]);
        Assertions.assertTrue((boolean)po.get_ValueAsBoolean("Posted"));
    }

    @Test
    public void testAllocatePaymentPostingWithWriteOffandDiscountARInv() {
        MBPartner bpartner = MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.JOE_BLOCK.id);
        Timestamp currentDate = Env.getContextAsDate((Properties)Env.getCtx(), (String)"#Date");
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(currentDate.getTime());
        Timestamp date = new Timestamp(cal.getTimeInMillis());
        MCurrency usd = MCurrency.get((int)DictionaryIDs.C_Currency.USD.id);
        try {
            MAcctSchema[] ass;
            Object whereClause = "AD_Org_ID=? AND C_Currency_ID=?";
            MBankAccount ba = (MBankAccount)new Query(Env.getCtx(), "C_BankAccount", (String)whereClause, this.getTrxName()).setParameters(new Object[]{Env.getAD_Org_ID((Properties)Env.getCtx()), usd.getC_Currency_ID()}).setOrderBy("IsDefault DESC").first();
            Assertions.assertTrue((ba != null ? 1 : 0) != 0, (String)"@NoAccountOrgCurrency@");
            int payterm = DictionaryIDs.C_PaymentTerm.TWO_PERCENT_10_NET_30.id;
            int taxid = DictionaryIDs.C_Tax.CT_SALES.id;
            MInvoice invoice = this.createInvoice(true, false, date, date, bpartner.getC_BPartner_ID(), payterm, taxid, Env.ONEHUNDRED);
            Assertions.assertEquals((Object)invoice.getTotalLines().setScale(2, RoundingMode.HALF_UP), (Object)new BigDecimal("100.00"));
            Assertions.assertEquals((Object)invoice.getGrandTotal().setScale(2, RoundingMode.HALF_UP), (Object)new BigDecimal("106.00"));
            BigDecimal payAmt = new BigDecimal("102");
            MPayment payment = this.createReceiptPayment(bpartner.getC_BPartner_ID(), ba.getC_BankAccount_ID(), date, usd.getC_Currency_ID(), 0, payAmt);
            this.completeDocument((PO)payment);
            this.postDocument((PO)payment);
            MAllocationHdr alloc = new MAllocationHdr(Env.getCtx(), true, date, usd.getC_Currency_ID(), Env.getContext((Properties)Env.getCtx(), (String)"#AD_User_Name"), this.getTrxName());
            alloc.setAD_Org_ID(payment.getAD_Org_ID());
            int doctypeAlloc = MDocType.getDocType((String)"CMA");
            alloc.setC_DocType_ID(doctypeAlloc);
            alloc.setDescription(alloc.getDescriptionForManualAllocation(payment.getC_BPartner_ID(), this.getTrxName()));
            alloc.saveEx();
            BigDecimal discount = new BigDecimal("2");
            BigDecimal writeoff = new BigDecimal("2");
            MAllocationLine aLine1 = new MAllocationLine(alloc, payment.getPayAmt(), discount, writeoff, Env.ZERO);
            aLine1.setDocInfo(payment.getC_BPartner_ID(), 0, 0);
            aLine1.setPaymentInfo(payment.getC_Payment_ID(), 0);
            aLine1.setC_Invoice_ID(invoice.getC_Invoice_ID());
            aLine1.saveEx();
            this.completeDocument((PO)alloc);
            this.postDocument((PO)alloc);
            MAcctSchema[] mAcctSchemaArray = ass = MAcctSchema.getClientAcctSchema((Properties)Env.getCtx(), (int)Env.getAD_Client_ID((Properties)Env.getCtx()));
            int n = ass.length;
            int n2 = 0;
            while (n2 < n) {
                MAcctSchema as = mAcctSchemaArray[n2];
                if (as.getC_Currency_ID() == usd.getC_Currency_ID()) {
                    int[] ids;
                    Doc doc = DocManager.getDocument((MAcctSchema)as, (int)735, (int)alloc.get_ID(), (String)this.getTrxName());
                    doc.setC_BankAccount_ID(ba.getC_BankAccount_ID());
                    MAccount acctUC = new MAccount(Env.getCtx(), as.getAcctSchemaDefault().getB_UnallocatedCash_Acct(), this.getTrxName());
                    MAccount acctDEP = new MAccount(Env.getCtx(), as.getAcctSchemaDefault().getPayDiscount_Exp_Acct(), this.getTrxName());
                    MAccount acctWO = new MAccount(Env.getCtx(), as.getAcctSchemaDefault().getWriteOff_Acct(), this.getTrxName());
                    MAccount acctART = new MAccount(Env.getCtx(), as.getAcctSchemaDefault().getC_Receivable_Acct(), this.getTrxName());
                    MAccount acctTD = new MAccount(Env.getCtx(), as.getAcctSchemaDefault().getT_Due_Acct(), this.getTrxName());
                    whereClause = "AD_Table_ID=735 AND Record_ID=" + alloc.get_ID() + " AND C_AcctSchema_ID=" + as.getC_AcctSchema_ID() + " ORDER BY Created";
                    int[] nArray = ids = MFactAcct.getAllIDs((String)"Fact_Acct", (String)whereClause, (String)this.getTrxName());
                    int n3 = ids.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        int id = nArray[n4];
                        MFactAcct fa = new MFactAcct(Env.getCtx(), id, this.getTrxName());
                        if (fa.getAccount_ID() == acctUC.getAccount_ID()) {
                            Assertions.assertEquals((Object)fa.getAmtAcctDr().setScale(2, RoundingMode.HALF_UP), (Object)new BigDecimal("102.00"));
                            Assertions.assertEquals((Object)fa.getAmtAcctCr().setScale(2, RoundingMode.HALF_UP), (Object)new BigDecimal("0.00"));
                        } else if (fa.getAccount_ID() == acctDEP.getAccount_ID()) {
                            if (fa.getAmtAcctDr().setScale(2, RoundingMode.HALF_UP).compareTo(Env.ZERO) > 0) {
                                Assertions.assertEquals((Object)fa.getAmtAcctDr().setScale(2, RoundingMode.HALF_UP), (Object)new BigDecimal("2.00"));
                                Assertions.assertEquals((Object)fa.getAmtAcctCr().setScale(2, RoundingMode.HALF_UP), (Object)new BigDecimal("0.00"));
                            } else {
                                Assertions.assertEquals((Object)fa.getAmtAcctDr().setScale(2, RoundingMode.HALF_UP), (Object)new BigDecimal("0.00"));
                                Assertions.assertEquals((Object)fa.getAmtAcctCr().setScale(2, RoundingMode.HALF_UP), (Object)new BigDecimal("0.11"));
                            }
                        } else if (fa.getAccount_ID() == acctWO.getAccount_ID()) {
                            if (fa.getAmtAcctDr().setScale(2, RoundingMode.HALF_UP).compareTo(Env.ZERO) > 0) {
                                Assertions.assertEquals((Object)fa.getAmtAcctDr().setScale(2, RoundingMode.HALF_UP), (Object)new BigDecimal("2.00"));
                                Assertions.assertEquals((Object)fa.getAmtAcctCr().setScale(2, RoundingMode.HALF_UP), (Object)new BigDecimal("0.00"));
                            } else {
                                Assertions.assertEquals((Object)fa.getAmtAcctDr().setScale(2, RoundingMode.HALF_UP), (Object)new BigDecimal("0.00"));
                                Assertions.assertEquals((Object)fa.getAmtAcctCr().setScale(2, RoundingMode.HALF_UP), (Object)new BigDecimal("0.11"));
                            }
                        } else if (fa.getAccount_ID() == acctART.getAccount_ID()) {
                            Assertions.assertEquals((Object)fa.getAmtAcctDr().setScale(2, RoundingMode.HALF_UP), (Object)new BigDecimal("0.00"));
                            Assertions.assertEquals((Object)fa.getAmtAcctCr().setScale(2, RoundingMode.HALF_UP), (Object)new BigDecimal("106.00"));
                        } else if (fa.getAccount_ID() == acctTD.getAccount_ID()) {
                            Assertions.assertEquals((Object)fa.getAmtAcctDr().setScale(2, RoundingMode.HALF_UP), (Object)new BigDecimal("0.11"));
                            Assertions.assertEquals((Object)fa.getAmtAcctCr().setScale(2, RoundingMode.HALF_UP), (Object)new BigDecimal("0.00"));
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        finally {
            this.rollback();
        }
    }

    @Test
    public void testAllocatePaymentPostingWithWriteOffandDiscountARCredMemo() {
        MBPartner bpartner = MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.JOE_BLOCK.id);
        Timestamp currentDate = Env.getContextAsDate((Properties)Env.getCtx(), (String)"#Date");
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(currentDate.getTime());
        Timestamp date = new Timestamp(cal.getTimeInMillis());
        MCurrency usd = MCurrency.get((int)DictionaryIDs.C_Currency.USD.id);
        try {
            MAcctSchema[] ass;
            Object whereClause = "AD_Org_ID=? AND C_Currency_ID=?";
            MBankAccount ba = (MBankAccount)new Query(Env.getCtx(), "C_BankAccount", (String)whereClause, this.getTrxName()).setParameters(new Object[]{Env.getAD_Org_ID((Properties)Env.getCtx()), usd.getC_Currency_ID()}).setOrderBy("IsDefault DESC").first();
            Assertions.assertTrue((ba != null ? 1 : 0) != 0, (String)"@NoAccountOrgCurrency@");
            int payterm = DictionaryIDs.C_PaymentTerm.TWO_PERCENT_10_NET_30.id;
            int taxid = DictionaryIDs.C_Tax.CT_SALES.id;
            MInvoice invoice = this.createInvoice(true, true, date, date, bpartner.getC_BPartner_ID(), payterm, taxid, Env.ONEHUNDRED);
            Assertions.assertEquals((Object)invoice.getTotalLines().setScale(2, RoundingMode.HALF_UP), (Object)new BigDecimal("100.00"));
            Assertions.assertEquals((Object)invoice.getGrandTotal().setScale(2, RoundingMode.HALF_UP), (Object)new BigDecimal("106.00"));
            BigDecimal payAmt = new BigDecimal("102");
            MPayment payment = this.createPayment(bpartner.getC_BPartner_ID(), ba.getC_BankAccount_ID(), date, usd.getC_Currency_ID(), 0, payAmt);
            this.completeDocument((PO)payment);
            this.postDocument((PO)payment);
            MAllocationHdr alloc = new MAllocationHdr(Env.getCtx(), true, date, usd.getC_Currency_ID(), Env.getContext((Properties)Env.getCtx(), (String)"#AD_User_Name"), this.getTrxName());
            alloc.setAD_Org_ID(payment.getAD_Org_ID());
            int doctypeAlloc = MDocType.getDocType((String)"CMA");
            alloc.setC_DocType_ID(doctypeAlloc);
            alloc.setDescription(alloc.getDescriptionForManualAllocation(payment.getC_BPartner_ID(), this.getTrxName()));
            alloc.saveEx();
            BigDecimal discount = new BigDecimal("2").negate();
            BigDecimal writeoff = new BigDecimal("2").negate();
            MAllocationLine aLine1 = new MAllocationLine(alloc, payment.getPayAmt().negate(), discount, writeoff, Env.ZERO);
            aLine1.setDocInfo(payment.getC_BPartner_ID(), 0, 0);
            aLine1.setPaymentInfo(payment.getC_Payment_ID(), 0);
            aLine1.setC_Invoice_ID(invoice.getC_Invoice_ID());
            aLine1.saveEx();
            this.completeDocument((PO)alloc);
            this.postDocument((PO)alloc);
            MAcctSchema[] mAcctSchemaArray = ass = MAcctSchema.getClientAcctSchema((Properties)Env.getCtx(), (int)Env.getAD_Client_ID((Properties)Env.getCtx()));
            int n = ass.length;
            int n2 = 0;
            while (n2 < n) {
                MAcctSchema as = mAcctSchemaArray[n2];
                if (as.getC_Currency_ID() == usd.getC_Currency_ID()) {
                    int[] ids;
                    Doc doc = DocManager.getDocument((MAcctSchema)as, (int)735, (int)alloc.get_ID(), (String)this.getTrxName());
                    doc.setC_BankAccount_ID(ba.getC_BankAccount_ID());
                    MAccount acctPS = new MAccount(Env.getCtx(), as.getAcctSchemaDefault().getB_PaymentSelect_Acct(), this.getTrxName());
                    MAccount acctDEP = new MAccount(Env.getCtx(), as.getAcctSchemaDefault().getPayDiscount_Exp_Acct(), this.getTrxName());
                    MAccount acctWO = new MAccount(Env.getCtx(), as.getAcctSchemaDefault().getWriteOff_Acct(), this.getTrxName());
                    MAccount acctART = new MAccount(Env.getCtx(), as.getAcctSchemaDefault().getC_Receivable_Acct(), this.getTrxName());
                    MAccount acctTD = new MAccount(Env.getCtx(), as.getAcctSchemaDefault().getT_Due_Acct(), this.getTrxName());
                    whereClause = "AD_Table_ID=735 AND Record_ID=" + alloc.get_ID() + " AND C_AcctSchema_ID=" + as.getC_AcctSchema_ID() + " ORDER BY Created";
                    int[] nArray = ids = MFactAcct.getAllIDs((String)"Fact_Acct", (String)whereClause, (String)this.getTrxName());
                    int n3 = ids.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        int id = nArray[n4];
                        MFactAcct fa = new MFactAcct(Env.getCtx(), id, this.getTrxName());
                        if (fa.getAccount_ID() == acctPS.getAccount_ID()) {
                            Assertions.assertEquals((Object)fa.getAmtAcctDr().setScale(2, RoundingMode.HALF_UP), (Object)new BigDecimal("102.00").negate());
                            Assertions.assertEquals((Object)fa.getAmtAcctCr().setScale(2, RoundingMode.HALF_UP), (Object)new BigDecimal("0.00"));
                        } else if (fa.getAccount_ID() == acctDEP.getAccount_ID()) {
                            if (fa.getAmtAcctDr().setScale(2, RoundingMode.HALF_UP).compareTo(Env.ZERO) < 0) {
                                Assertions.assertEquals((Object)fa.getAmtAcctDr().setScale(2, RoundingMode.HALF_UP), (Object)new BigDecimal("2.00").negate());
                                Assertions.assertEquals((Object)fa.getAmtAcctCr().setScale(2, RoundingMode.HALF_UP), (Object)new BigDecimal("0.00"));
                            } else {
                                Assertions.assertEquals((Object)fa.getAmtAcctDr().setScale(2, RoundingMode.HALF_UP), (Object)new BigDecimal("0.11"));
                                Assertions.assertEquals((Object)fa.getAmtAcctCr().setScale(2, RoundingMode.HALF_UP), (Object)new BigDecimal("0.00"));
                            }
                        } else if (fa.getAccount_ID() == acctWO.getAccount_ID()) {
                            if (fa.getAmtAcctDr().setScale(2, RoundingMode.HALF_UP).compareTo(Env.ZERO) < 0) {
                                Assertions.assertEquals((Object)fa.getAmtAcctDr().setScale(2, RoundingMode.HALF_UP), (Object)new BigDecimal("2.00").negate());
                                Assertions.assertEquals((Object)fa.getAmtAcctCr().setScale(2, RoundingMode.HALF_UP), (Object)new BigDecimal("0.00"));
                            } else {
                                Assertions.assertEquals((Object)fa.getAmtAcctDr().setScale(2, RoundingMode.HALF_UP), (Object)new BigDecimal("0.11"));
                                Assertions.assertEquals((Object)fa.getAmtAcctCr().setScale(2, RoundingMode.HALF_UP), (Object)new BigDecimal("0.00"));
                            }
                        } else if (fa.getAccount_ID() == acctART.getAccount_ID()) {
                            Assertions.assertEquals((Object)fa.getAmtAcctDr().setScale(2, RoundingMode.HALF_UP), (Object)new BigDecimal("0.00"));
                            Assertions.assertEquals((Object)fa.getAmtAcctCr().setScale(2, RoundingMode.HALF_UP), (Object)new BigDecimal("106.00").negate());
                        } else if (fa.getAccount_ID() == acctTD.getAccount_ID()) {
                            Assertions.assertEquals((Object)fa.getAmtAcctDr().setScale(2, RoundingMode.HALF_UP), (Object)new BigDecimal("0.00"));
                            Assertions.assertEquals((Object)fa.getAmtAcctCr().setScale(2, RoundingMode.HALF_UP), (Object)new BigDecimal("0.11"));
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        finally {
            this.rollback();
        }
    }

    @Test
    public void testAllocatePaymentPostingWithWriteOffandDiscountAPInv() {
        MBPartner bpartner = MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.PATIO.id);
        Timestamp currentDate = Env.getContextAsDate((Properties)Env.getCtx(), (String)"#Date");
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(currentDate.getTime());
        Timestamp date = new Timestamp(cal.getTimeInMillis());
        MCurrency usd = MCurrency.get((int)DictionaryIDs.C_Currency.USD.id);
        try {
            MAcctSchema[] ass;
            Object whereClause = "AD_Org_ID=? AND C_Currency_ID=?";
            MBankAccount ba = (MBankAccount)new Query(Env.getCtx(), "C_BankAccount", (String)whereClause, this.getTrxName()).setParameters(new Object[]{Env.getAD_Org_ID((Properties)Env.getCtx()), usd.getC_Currency_ID()}).setOrderBy("IsDefault DESC").first();
            Assertions.assertTrue((ba != null ? 1 : 0) != 0, (String)"@NoAccountOrgCurrency@");
            int payterm = DictionaryIDs.C_PaymentTerm.IMMEDIATE.id;
            int taxid = DictionaryIDs.C_Tax.CT_SALES.id;
            MInvoice invoice = this.createInvoice(false, false, date, date, bpartner.getC_BPartner_ID(), payterm, taxid, Env.ONEHUNDRED);
            Assertions.assertEquals((Object)invoice.getTotalLines().setScale(2, RoundingMode.HALF_UP), (Object)new BigDecimal("100.00"));
            Assertions.assertEquals((Object)invoice.getGrandTotal().setScale(2, RoundingMode.HALF_UP), (Object)new BigDecimal("106.00"));
            BigDecimal payAmt = new BigDecimal("102");
            MPayment payment = this.createPayment(bpartner.getC_BPartner_ID(), ba.getC_BankAccount_ID(), date, usd.getC_Currency_ID(), 0, payAmt);
            this.completeDocument((PO)payment);
            this.postDocument((PO)payment);
            MAllocationHdr alloc = new MAllocationHdr(Env.getCtx(), true, date, usd.getC_Currency_ID(), Env.getContext((Properties)Env.getCtx(), (String)"#AD_User_Name"), this.getTrxName());
            alloc.setAD_Org_ID(payment.getAD_Org_ID());
            int doctypeAlloc = MDocType.getDocType((String)"CMA");
            alloc.setC_DocType_ID(doctypeAlloc);
            alloc.setDescription(alloc.getDescriptionForManualAllocation(payment.getC_BPartner_ID(), this.getTrxName()));
            alloc.saveEx();
            BigDecimal discount = new BigDecimal("2").negate();
            BigDecimal writeoff = new BigDecimal("2").negate();
            MAllocationLine aLine1 = new MAllocationLine(alloc, payment.getPayAmt().negate(), discount, writeoff, Env.ZERO);
            aLine1.setDocInfo(payment.getC_BPartner_ID(), 0, 0);
            aLine1.setPaymentInfo(payment.getC_Payment_ID(), 0);
            aLine1.setC_Invoice_ID(invoice.getC_Invoice_ID());
            aLine1.saveEx();
            this.completeDocument((PO)alloc);
            this.postDocument((PO)alloc);
            MAcctSchema[] mAcctSchemaArray = ass = MAcctSchema.getClientAcctSchema((Properties)Env.getCtx(), (int)Env.getAD_Client_ID((Properties)Env.getCtx()));
            int n = ass.length;
            int n2 = 0;
            while (n2 < n) {
                MAcctSchema as = mAcctSchemaArray[n2];
                if (as.getC_Currency_ID() == usd.getC_Currency_ID()) {
                    int[] ids;
                    Doc doc = DocManager.getDocument((MAcctSchema)as, (int)735, (int)alloc.get_ID(), (String)this.getTrxName());
                    doc.setC_BankAccount_ID(ba.getC_BankAccount_ID());
                    MAccount acctPT = new MAccount(Env.getCtx(), as.getAcctSchemaDefault().getV_Liability_Acct(), this.getTrxName());
                    MAccount acctDRE = new MAccount(Env.getCtx(), as.getAcctSchemaDefault().getPayDiscount_Rev_Acct(), this.getTrxName());
                    MAccount acctWO = new MAccount(Env.getCtx(), as.getAcctSchemaDefault().getWriteOff_Acct(), this.getTrxName());
                    MAccount acctPS = new MAccount(Env.getCtx(), as.getAcctSchemaDefault().getB_PaymentSelect_Acct(), this.getTrxName());
                    MAccount acctTD = new MAccount(Env.getCtx(), as.getAcctSchemaDefault().getT_Credit_Acct(), this.getTrxName());
                    whereClause = "AD_Table_ID=735 AND Record_ID=" + alloc.get_ID() + " AND C_AcctSchema_ID=" + as.getC_AcctSchema_ID() + " ORDER BY Created";
                    int[] nArray = ids = MFactAcct.getAllIDs((String)"Fact_Acct", (String)whereClause, (String)this.getTrxName());
                    int n3 = ids.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        int id = nArray[n4];
                        MFactAcct fa = new MFactAcct(Env.getCtx(), id, this.getTrxName());
                        if (fa.getAccount_ID() == acctPT.getAccount_ID()) {
                            Assertions.assertEquals((Object)fa.getAmtAcctDr().setScale(2, RoundingMode.HALF_UP), (Object)new BigDecimal("106.00"));
                            Assertions.assertEquals((Object)fa.getAmtAcctCr().setScale(2, RoundingMode.HALF_UP), (Object)new BigDecimal("0.00"));
                        } else if (fa.getAccount_ID() == acctDRE.getAccount_ID()) {
                            if (fa.getAmtAcctCr().setScale(2, RoundingMode.HALF_UP).compareTo(Env.ZERO) > 0) {
                                Assertions.assertEquals((Object)fa.getAmtAcctDr().setScale(2, RoundingMode.HALF_UP), (Object)new BigDecimal("0.00"));
                                Assertions.assertEquals((Object)fa.getAmtAcctCr().setScale(2, RoundingMode.HALF_UP), (Object)new BigDecimal("2.00"));
                            } else {
                                Assertions.assertEquals((Object)fa.getAmtAcctDr().setScale(2, RoundingMode.HALF_UP), (Object)new BigDecimal("0.11"));
                                Assertions.assertEquals((Object)fa.getAmtAcctCr().setScale(2, RoundingMode.HALF_UP), (Object)new BigDecimal("0.00"));
                            }
                        } else if (fa.getAccount_ID() == acctWO.getAccount_ID()) {
                            if (fa.getAmtAcctCr().setScale(2, RoundingMode.HALF_UP).compareTo(Env.ZERO) > 0) {
                                Assertions.assertEquals((Object)fa.getAmtAcctDr().setScale(2, RoundingMode.HALF_UP), (Object)new BigDecimal("0.00"));
                                Assertions.assertEquals((Object)fa.getAmtAcctCr().setScale(2, RoundingMode.HALF_UP), (Object)new BigDecimal("2.00"));
                            } else {
                                Assertions.assertEquals((Object)fa.getAmtAcctDr().setScale(2, RoundingMode.HALF_UP), (Object)new BigDecimal("0.11"));
                                Assertions.assertEquals((Object)fa.getAmtAcctCr().setScale(2, RoundingMode.HALF_UP), (Object)new BigDecimal("0.00"));
                            }
                        } else if (fa.getAccount_ID() == acctPS.getAccount_ID()) {
                            Assertions.assertEquals((Object)fa.getAmtAcctDr().setScale(2, RoundingMode.HALF_UP), (Object)new BigDecimal("0.00"));
                            Assertions.assertEquals((Object)fa.getAmtAcctCr().setScale(2, RoundingMode.HALF_UP), (Object)new BigDecimal("102.00"));
                        } else if (fa.getAccount_ID() == acctTD.getAccount_ID()) {
                            Assertions.assertEquals((Object)fa.getAmtAcctDr().setScale(2, RoundingMode.HALF_UP), (Object)new BigDecimal("0.00"));
                            Assertions.assertEquals((Object)fa.getAmtAcctCr().setScale(2, RoundingMode.HALF_UP), (Object)new BigDecimal("0.11"));
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        finally {
            this.rollback();
        }
    }

    @Test
    public void testAllocatePaymentPostingWithWriteOffandDiscountAPCrMe() {
        MBPartner bpartner = MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.PATIO.id);
        Timestamp currentDate = Env.getContextAsDate((Properties)Env.getCtx(), (String)"#Date");
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(currentDate.getTime());
        Timestamp date = new Timestamp(cal.getTimeInMillis());
        MCurrency usd = MCurrency.get((int)DictionaryIDs.C_Currency.USD.id);
        try {
            MAcctSchema[] ass;
            Object whereClause = "AD_Org_ID=? AND C_Currency_ID=?";
            MBankAccount ba = (MBankAccount)new Query(Env.getCtx(), "C_BankAccount", (String)whereClause, this.getTrxName()).setParameters(new Object[]{Env.getAD_Org_ID((Properties)Env.getCtx()), usd.getC_Currency_ID()}).setOrderBy("IsDefault DESC").first();
            Assertions.assertTrue((ba != null ? 1 : 0) != 0, (String)"@NoAccountOrgCurrency@");
            int payterm = DictionaryIDs.C_PaymentTerm.IMMEDIATE.id;
            int taxid = DictionaryIDs.C_Tax.CT_SALES.id;
            MInvoice invoice = this.createInvoice(false, true, date, date, bpartner.getC_BPartner_ID(), payterm, taxid, Env.ONEHUNDRED);
            Assertions.assertEquals((Object)invoice.getTotalLines().setScale(2, RoundingMode.HALF_UP), (Object)new BigDecimal("100.00"));
            Assertions.assertEquals((Object)invoice.getGrandTotal().setScale(2, RoundingMode.HALF_UP), (Object)new BigDecimal("106.00"));
            BigDecimal payAmt = new BigDecimal("102");
            MPayment payment = this.createReceiptPayment(bpartner.getC_BPartner_ID(), ba.getC_BankAccount_ID(), date, usd.getC_Currency_ID(), 0, payAmt);
            this.completeDocument((PO)payment);
            this.postDocument((PO)payment);
            MAllocationHdr alloc = new MAllocationHdr(Env.getCtx(), true, date, usd.getC_Currency_ID(), Env.getContext((Properties)Env.getCtx(), (String)"#AD_User_Name"), this.getTrxName());
            alloc.setAD_Org_ID(payment.getAD_Org_ID());
            int doctypeAlloc = MDocType.getDocType((String)"CMA");
            alloc.setC_DocType_ID(doctypeAlloc);
            alloc.setDescription(alloc.getDescriptionForManualAllocation(payment.getC_BPartner_ID(), this.getTrxName()));
            alloc.saveEx();
            BigDecimal discount = new BigDecimal("2");
            BigDecimal writeoff = new BigDecimal("2");
            MAllocationLine aLine1 = new MAllocationLine(alloc, payment.getPayAmt(), discount, writeoff, Env.ZERO);
            aLine1.setDocInfo(payment.getC_BPartner_ID(), 0, 0);
            aLine1.setPaymentInfo(payment.getC_Payment_ID(), 0);
            aLine1.setC_Invoice_ID(invoice.getC_Invoice_ID());
            aLine1.saveEx();
            this.completeDocument((PO)alloc);
            this.postDocument((PO)alloc);
            MAcctSchema[] mAcctSchemaArray = ass = MAcctSchema.getClientAcctSchema((Properties)Env.getCtx(), (int)Env.getAD_Client_ID((Properties)Env.getCtx()));
            int n = ass.length;
            int n2 = 0;
            while (n2 < n) {
                MAcctSchema as = mAcctSchemaArray[n2];
                if (as.getC_Currency_ID() == usd.getC_Currency_ID()) {
                    int[] ids;
                    Doc doc = DocManager.getDocument((MAcctSchema)as, (int)735, (int)alloc.get_ID(), (String)this.getTrxName());
                    doc.setC_BankAccount_ID(ba.getC_BankAccount_ID());
                    MAccount acctPT = new MAccount(Env.getCtx(), as.getAcctSchemaDefault().getV_Liability_Acct(), this.getTrxName());
                    MAccount acctDRE = new MAccount(Env.getCtx(), as.getAcctSchemaDefault().getPayDiscount_Rev_Acct(), this.getTrxName());
                    MAccount acctWO = new MAccount(Env.getCtx(), as.getAcctSchemaDefault().getWriteOff_Acct(), this.getTrxName());
                    MAccount acctUC = new MAccount(Env.getCtx(), as.getAcctSchemaDefault().getB_UnallocatedCash_Acct(), this.getTrxName());
                    MAccount acctTD = new MAccount(Env.getCtx(), as.getAcctSchemaDefault().getT_Credit_Acct(), this.getTrxName());
                    whereClause = "AD_Table_ID=735 AND Record_ID=" + alloc.get_ID() + " AND C_AcctSchema_ID=" + as.getC_AcctSchema_ID() + " ORDER BY Created";
                    int[] nArray = ids = MFactAcct.getAllIDs((String)"Fact_Acct", (String)whereClause, (String)this.getTrxName());
                    int n3 = ids.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        int id = nArray[n4];
                        MFactAcct fa = new MFactAcct(Env.getCtx(), id, this.getTrxName());
                        if (fa.getAccount_ID() == acctPT.getAccount_ID()) {
                            Assertions.assertEquals((Object)fa.getAmtAcctDr().setScale(2, RoundingMode.HALF_UP), (Object)new BigDecimal("106.00").negate());
                            Assertions.assertEquals((Object)fa.getAmtAcctCr().setScale(2, RoundingMode.HALF_UP), (Object)new BigDecimal("0.00"));
                        } else if (fa.getAccount_ID() == acctDRE.getAccount_ID()) {
                            if (fa.getAmtAcctCr().setScale(2, RoundingMode.HALF_UP).compareTo(Env.ZERO) < 0) {
                                Assertions.assertEquals((Object)fa.getAmtAcctDr().setScale(2, RoundingMode.HALF_UP), (Object)new BigDecimal("0.00"));
                                Assertions.assertEquals((Object)fa.getAmtAcctCr().setScale(2, RoundingMode.HALF_UP), (Object)new BigDecimal("2.00").negate());
                            } else {
                                Assertions.assertEquals((Object)fa.getAmtAcctDr().setScale(2, RoundingMode.HALF_UP), (Object)new BigDecimal("0.00"));
                                Assertions.assertEquals((Object)fa.getAmtAcctCr().setScale(2, RoundingMode.HALF_UP), (Object)new BigDecimal("0.11"));
                            }
                        } else if (fa.getAccount_ID() == acctWO.getAccount_ID()) {
                            if (fa.getAmtAcctCr().setScale(2, RoundingMode.HALF_UP).compareTo(Env.ZERO) < 0) {
                                Assertions.assertEquals((Object)fa.getAmtAcctDr().setScale(2, RoundingMode.HALF_UP), (Object)new BigDecimal("0.00"));
                                Assertions.assertEquals((Object)fa.getAmtAcctCr().setScale(2, RoundingMode.HALF_UP), (Object)new BigDecimal("2.00").negate());
                            } else {
                                Assertions.assertEquals((Object)fa.getAmtAcctDr().setScale(2, RoundingMode.HALF_UP), (Object)new BigDecimal("0.00"));
                                Assertions.assertEquals((Object)fa.getAmtAcctCr().setScale(2, RoundingMode.HALF_UP), (Object)new BigDecimal("0.11"));
                            }
                        } else if (fa.getAccount_ID() == acctUC.getAccount_ID()) {
                            Assertions.assertEquals((Object)fa.getAmtAcctDr().setScale(2, RoundingMode.HALF_UP), (Object)new BigDecimal("0.00"));
                            Assertions.assertEquals((Object)fa.getAmtAcctCr().setScale(2, RoundingMode.HALF_UP), (Object)new BigDecimal("102.00").negate());
                        } else if (fa.getAccount_ID() == acctTD.getAccount_ID()) {
                            Assertions.assertEquals((Object)fa.getAmtAcctDr().setScale(2, RoundingMode.HALF_UP), (Object)new BigDecimal("0.11"));
                            Assertions.assertEquals((Object)fa.getAmtAcctCr().setScale(2, RoundingMode.HALF_UP), (Object)new BigDecimal("0.00"));
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        finally {
            this.rollback();
        }
    }

    @Test
    public void testPaymentPostingWithWriteOffandDiscountARInv() {
        MBPartner bpartner = MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.JOE_BLOCK.id);
        Timestamp currentDate = Env.getContextAsDate((Properties)Env.getCtx(), (String)"#Date");
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(currentDate.getTime());
        Timestamp date = new Timestamp(cal.getTimeInMillis());
        MCurrency usd = MCurrency.get((int)DictionaryIDs.C_Currency.USD.id);
        try {
            MAcctSchema[] ass;
            Object whereClause = "AD_Org_ID=? AND C_Currency_ID=?";
            MBankAccount ba = (MBankAccount)new Query(Env.getCtx(), "C_BankAccount", (String)whereClause, this.getTrxName()).setParameters(new Object[]{Env.getAD_Org_ID((Properties)Env.getCtx()), usd.getC_Currency_ID()}).setOrderBy("IsDefault DESC").first();
            Assertions.assertTrue((ba != null ? 1 : 0) != 0, (String)"@NoAccountOrgCurrency@");
            int payterm = DictionaryIDs.C_PaymentTerm.TWO_PERCENT_10_NET_30.id;
            int taxid = DictionaryIDs.C_Tax.CT_SALES.id;
            MInvoice invoice = this.createInvoice(true, false, date, date, bpartner.getC_BPartner_ID(), payterm, taxid, Env.ONEHUNDRED);
            Assertions.assertEquals((Object)invoice.getTotalLines().setScale(2, RoundingMode.HALF_UP), (Object)new BigDecimal("100.00"));
            Assertions.assertEquals((Object)invoice.getGrandTotal().setScale(2, RoundingMode.HALF_UP), (Object)new BigDecimal("106.00"));
            BigDecimal payAmt = new BigDecimal("102");
            BigDecimal discount = new BigDecimal("2");
            BigDecimal writeoff = new BigDecimal("2");
            MPayment payment = new MPayment(Env.getCtx(), 0, this.getTrxName());
            payment.setC_BankAccount_ID(ba.getC_BankAccount_ID());
            payment.setC_DocType_ID(true);
            payment.setDateTrx(date);
            payment.setDateAcct(date);
            payment.setC_BPartner_ID(bpartner.getC_BPartner_ID());
            payment.setC_Invoice_ID(invoice.getC_Invoice_ID());
            payment.setPayAmt(payAmt);
            payment.setDiscountAmt(discount);
            payment.setWriteOffAmt(writeoff);
            payment.setC_Currency_ID(usd.getC_Currency_ID());
            payment.setC_ConversionType_ID(0);
            payment.setTenderType("K");
            payment.setDocStatus("DR");
            payment.setDocAction("CO");
            payment.saveEx();
            this.completeDocument((PO)payment);
            this.postDocument((PO)payment);
            MAllocationHdr[] allocationa = MAllocationHdr.getOfInvoice((Properties)Env.getCtx(), (int)invoice.getC_Invoice_ID(), (String)this.getTrxName());
            MAcctSchema[] mAcctSchemaArray = ass = MAcctSchema.getClientAcctSchema((Properties)Env.getCtx(), (int)Env.getAD_Client_ID((Properties)Env.getCtx()));
            int n = ass.length;
            int n2 = 0;
            while (n2 < n) {
                MAcctSchema as = mAcctSchemaArray[n2];
                if (as.getC_Currency_ID() == usd.getC_Currency_ID()) {
                    int[] ids;
                    Doc doc = DocManager.getDocument((MAcctSchema)as, (int)735, (int)allocationa[0].get_ID(), (String)this.getTrxName());
                    doc.setC_BankAccount_ID(ba.getC_BankAccount_ID());
                    MAccount acctUC = new MAccount(Env.getCtx(), as.getAcctSchemaDefault().getB_UnallocatedCash_Acct(), this.getTrxName());
                    MAccount acctDEP = new MAccount(Env.getCtx(), as.getAcctSchemaDefault().getPayDiscount_Exp_Acct(), this.getTrxName());
                    MAccount acctWO = new MAccount(Env.getCtx(), as.getAcctSchemaDefault().getWriteOff_Acct(), this.getTrxName());
                    MAccount acctART = new MAccount(Env.getCtx(), as.getAcctSchemaDefault().getC_Receivable_Acct(), this.getTrxName());
                    MAccount acctTD = new MAccount(Env.getCtx(), as.getAcctSchemaDefault().getT_Due_Acct(), this.getTrxName());
                    whereClause = "AD_Table_ID=735 AND Record_ID=" + allocationa[0].get_ID() + " AND C_AcctSchema_ID=" + as.getC_AcctSchema_ID() + " ORDER BY Created";
                    int[] nArray = ids = MFactAcct.getAllIDs((String)"Fact_Acct", (String)whereClause, (String)this.getTrxName());
                    int n3 = ids.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        int id = nArray[n4];
                        MFactAcct fa = new MFactAcct(Env.getCtx(), id, this.getTrxName());
                        if (fa.getAccount_ID() == acctUC.getAccount_ID()) {
                            Assertions.assertEquals((Object)fa.getAmtAcctDr().setScale(2, RoundingMode.HALF_UP), (Object)new BigDecimal("102.00"));
                            Assertions.assertEquals((Object)fa.getAmtAcctCr().setScale(2, RoundingMode.HALF_UP), (Object)new BigDecimal("0.00"));
                        } else if (fa.getAccount_ID() == acctDEP.getAccount_ID()) {
                            if (fa.getAmtAcctDr().setScale(2, RoundingMode.HALF_UP).compareTo(Env.ZERO) > 0) {
                                Assertions.assertEquals((Object)fa.getAmtAcctDr().setScale(2, RoundingMode.HALF_UP), (Object)new BigDecimal("2.00"));
                                Assertions.assertEquals((Object)fa.getAmtAcctCr().setScale(2, RoundingMode.HALF_UP), (Object)new BigDecimal("0.00"));
                            } else {
                                Assertions.assertEquals((Object)fa.getAmtAcctDr().setScale(2, RoundingMode.HALF_UP), (Object)new BigDecimal("0.00"));
                                Assertions.assertEquals((Object)fa.getAmtAcctCr().setScale(2, RoundingMode.HALF_UP), (Object)new BigDecimal("0.11"));
                            }
                        } else if (fa.getAccount_ID() == acctWO.getAccount_ID()) {
                            if (fa.getAmtAcctDr().setScale(2, RoundingMode.HALF_UP).compareTo(Env.ZERO) > 0) {
                                Assertions.assertEquals((Object)fa.getAmtAcctDr().setScale(2, RoundingMode.HALF_UP), (Object)new BigDecimal("2.00"));
                                Assertions.assertEquals((Object)fa.getAmtAcctCr().setScale(2, RoundingMode.HALF_UP), (Object)new BigDecimal("0.00"));
                            } else {
                                Assertions.assertEquals((Object)fa.getAmtAcctDr().setScale(2, RoundingMode.HALF_UP), (Object)new BigDecimal("0.00"));
                                Assertions.assertEquals((Object)fa.getAmtAcctCr().setScale(2, RoundingMode.HALF_UP), (Object)new BigDecimal("0.11"));
                            }
                        } else if (fa.getAccount_ID() == acctART.getAccount_ID()) {
                            Assertions.assertEquals((Object)fa.getAmtAcctDr().setScale(2, RoundingMode.HALF_UP), (Object)new BigDecimal("0.00"));
                            Assertions.assertEquals((Object)fa.getAmtAcctCr().setScale(2, RoundingMode.HALF_UP), (Object)new BigDecimal("106.00"));
                        } else if (fa.getAccount_ID() == acctTD.getAccount_ID()) {
                            Assertions.assertEquals((Object)fa.getAmtAcctDr().setScale(2, RoundingMode.HALF_UP), (Object)new BigDecimal("0.11"));
                            Assertions.assertEquals((Object)fa.getAmtAcctCr().setScale(2, RoundingMode.HALF_UP), (Object)new BigDecimal("0.00"));
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        finally {
            this.rollback();
        }
    }

    @Test
    public void testPaymentPostingWithWriteOffandDiscountARCredMemo() {
        MBPartner bpartner = MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.JOE_BLOCK.id);
        Timestamp currentDate = Env.getContextAsDate((Properties)Env.getCtx(), (String)"#Date");
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(currentDate.getTime());
        Timestamp date = new Timestamp(cal.getTimeInMillis());
        MCurrency usd = MCurrency.get((int)DictionaryIDs.C_Currency.USD.id);
        try {
            MAcctSchema[] ass;
            Object whereClause = "AD_Org_ID=? AND C_Currency_ID=?";
            MBankAccount ba = (MBankAccount)new Query(Env.getCtx(), "C_BankAccount", (String)whereClause, this.getTrxName()).setParameters(new Object[]{Env.getAD_Org_ID((Properties)Env.getCtx()), usd.getC_Currency_ID()}).setOrderBy("IsDefault DESC").first();
            Assertions.assertTrue((ba != null ? 1 : 0) != 0, (String)"@NoAccountOrgCurrency@");
            int payterm = DictionaryIDs.C_PaymentTerm.TWO_PERCENT_10_NET_30.id;
            int taxid = DictionaryIDs.C_Tax.CT_SALES.id;
            MInvoice invoice = this.createInvoice(true, true, date, date, bpartner.getC_BPartner_ID(), payterm, taxid, Env.ONEHUNDRED);
            Assertions.assertEquals((Object)invoice.getTotalLines().setScale(2, RoundingMode.HALF_UP), (Object)new BigDecimal("100.00"));
            Assertions.assertEquals((Object)invoice.getGrandTotal().setScale(2, RoundingMode.HALF_UP), (Object)new BigDecimal("106.00"));
            BigDecimal payAmt = new BigDecimal("102").negate();
            BigDecimal discount = new BigDecimal("2").negate();
            BigDecimal writeoff = new BigDecimal("2").negate();
            MPayment payment = new MPayment(Env.getCtx(), 0, this.getTrxName());
            payment.setC_BankAccount_ID(ba.getC_BankAccount_ID());
            payment.setC_DocType_ID(true);
            payment.setDateTrx(date);
            payment.setDateAcct(date);
            payment.setC_BPartner_ID(bpartner.getC_BPartner_ID());
            payment.setC_Invoice_ID(invoice.getC_Invoice_ID());
            payment.setPayAmt(payAmt);
            payment.setDiscountAmt(discount);
            payment.setWriteOffAmt(writeoff);
            payment.setC_Currency_ID(usd.getC_Currency_ID());
            payment.setC_ConversionType_ID(0);
            payment.setTenderType("K");
            payment.setDocStatus("DR");
            payment.setDocAction("CO");
            payment.saveEx();
            this.completeDocument((PO)payment);
            this.postDocument((PO)payment);
            MAllocationHdr[] allocationa = MAllocationHdr.getOfInvoice((Properties)Env.getCtx(), (int)invoice.getC_Invoice_ID(), (String)this.getTrxName());
            MAcctSchema[] mAcctSchemaArray = ass = MAcctSchema.getClientAcctSchema((Properties)Env.getCtx(), (int)Env.getAD_Client_ID((Properties)Env.getCtx()));
            int n = ass.length;
            int n2 = 0;
            while (n2 < n) {
                MAcctSchema as = mAcctSchemaArray[n2];
                if (as.getC_Currency_ID() == usd.getC_Currency_ID()) {
                    int[] ids;
                    Doc doc = DocManager.getDocument((MAcctSchema)as, (int)735, (int)allocationa[0].get_ID(), (String)this.getTrxName());
                    doc.setC_BankAccount_ID(ba.getC_BankAccount_ID());
                    MAccount acctPS = new MAccount(Env.getCtx(), as.getAcctSchemaDefault().getB_PaymentSelect_Acct(), this.getTrxName());
                    MAccount acctDEP = new MAccount(Env.getCtx(), as.getAcctSchemaDefault().getPayDiscount_Exp_Acct(), this.getTrxName());
                    MAccount acctWO = new MAccount(Env.getCtx(), as.getAcctSchemaDefault().getWriteOff_Acct(), this.getTrxName());
                    MAccount acctART = new MAccount(Env.getCtx(), as.getAcctSchemaDefault().getC_Receivable_Acct(), this.getTrxName());
                    MAccount acctTD = new MAccount(Env.getCtx(), as.getAcctSchemaDefault().getT_Due_Acct(), this.getTrxName());
                    whereClause = "AD_Table_ID=735 AND Record_ID=" + allocationa[0].get_ID() + " AND C_AcctSchema_ID=" + as.getC_AcctSchema_ID() + " ORDER BY Created";
                    int[] nArray = ids = MFactAcct.getAllIDs((String)"Fact_Acct", (String)whereClause, (String)this.getTrxName());
                    int n3 = ids.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        int id = nArray[n4];
                        MFactAcct fa = new MFactAcct(Env.getCtx(), id, this.getTrxName());
                        if (fa.getAccount_ID() == acctPS.getAccount_ID()) {
                            Assertions.assertEquals((Object)fa.getAmtAcctDr().setScale(2, RoundingMode.HALF_UP), (Object)new BigDecimal("102.00").negate());
                            Assertions.assertEquals((Object)fa.getAmtAcctCr().setScale(2, RoundingMode.HALF_UP), (Object)new BigDecimal("0.00"));
                        } else if (fa.getAccount_ID() == acctDEP.getAccount_ID()) {
                            if (fa.getAmtAcctDr().setScale(2, RoundingMode.HALF_UP).compareTo(Env.ZERO) < 0) {
                                Assertions.assertEquals((Object)fa.getAmtAcctDr().setScale(2, RoundingMode.HALF_UP), (Object)new BigDecimal("2.00").negate());
                                Assertions.assertEquals((Object)fa.getAmtAcctCr().setScale(2, RoundingMode.HALF_UP), (Object)new BigDecimal("0.00"));
                            } else {
                                Assertions.assertEquals((Object)fa.getAmtAcctDr().setScale(2, RoundingMode.HALF_UP), (Object)new BigDecimal("0.11"));
                                Assertions.assertEquals((Object)fa.getAmtAcctCr().setScale(2, RoundingMode.HALF_UP), (Object)new BigDecimal("0.00"));
                            }
                        } else if (fa.getAccount_ID() == acctWO.getAccount_ID()) {
                            if (fa.getAmtAcctDr().setScale(2, RoundingMode.HALF_UP).compareTo(Env.ZERO) < 0) {
                                Assertions.assertEquals((Object)fa.getAmtAcctDr().setScale(2, RoundingMode.HALF_UP), (Object)new BigDecimal("2.00").negate());
                                Assertions.assertEquals((Object)fa.getAmtAcctCr().setScale(2, RoundingMode.HALF_UP), (Object)new BigDecimal("0.00"));
                            } else {
                                Assertions.assertEquals((Object)fa.getAmtAcctDr().setScale(2, RoundingMode.HALF_UP), (Object)new BigDecimal("0.11"));
                                Assertions.assertEquals((Object)fa.getAmtAcctCr().setScale(2, RoundingMode.HALF_UP), (Object)new BigDecimal("0.00"));
                            }
                        } else if (fa.getAccount_ID() == acctART.getAccount_ID()) {
                            Assertions.assertEquals((Object)fa.getAmtAcctDr().setScale(2, RoundingMode.HALF_UP), (Object)new BigDecimal("0.00"));
                            Assertions.assertEquals((Object)fa.getAmtAcctCr().setScale(2, RoundingMode.HALF_UP), (Object)new BigDecimal("106.00").negate());
                        } else if (fa.getAccount_ID() == acctTD.getAccount_ID()) {
                            Assertions.assertEquals((Object)fa.getAmtAcctDr().setScale(2, RoundingMode.HALF_UP), (Object)new BigDecimal("0.00"));
                            Assertions.assertEquals((Object)fa.getAmtAcctCr().setScale(2, RoundingMode.HALF_UP), (Object)new BigDecimal("0.11"));
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        finally {
            this.rollback();
        }
    }

    @Test
    public void testPaymentPostingWithWriteOffandDiscountAPInv() {
        MBPartner bpartner = MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.AGRI_TECH.id);
        Timestamp currentDate = Env.getContextAsDate((Properties)Env.getCtx(), (String)"#Date");
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(currentDate.getTime());
        Timestamp date = new Timestamp(cal.getTimeInMillis());
        MCurrency usd = MCurrency.get((int)DictionaryIDs.C_Currency.USD.id);
        try {
            MAcctSchema[] ass;
            Object whereClause = "AD_Org_ID=? AND C_Currency_ID=?";
            MBankAccount ba = (MBankAccount)new Query(Env.getCtx(), "C_BankAccount", (String)whereClause, this.getTrxName()).setParameters(new Object[]{Env.getAD_Org_ID((Properties)Env.getCtx()), usd.getC_Currency_ID()}).setOrderBy("IsDefault DESC").first();
            Assertions.assertTrue((ba != null ? 1 : 0) != 0, (String)"@NoAccountOrgCurrency@");
            int payterm = DictionaryIDs.C_PaymentTerm.IMMEDIATE.id;
            int taxid = DictionaryIDs.C_Tax.CT_SALES.id;
            MInvoice invoice = this.createInvoice(false, false, date, date, bpartner.getC_BPartner_ID(), payterm, taxid, Env.ONEHUNDRED);
            Assertions.assertEquals((Object)invoice.getTotalLines().setScale(2, RoundingMode.HALF_UP), (Object)new BigDecimal("100.00"));
            Assertions.assertEquals((Object)invoice.getGrandTotal().setScale(2, RoundingMode.HALF_UP), (Object)new BigDecimal("106.00"));
            BigDecimal payAmt = new BigDecimal("102");
            BigDecimal discount = new BigDecimal("2");
            BigDecimal writeoff = new BigDecimal("2");
            MPayment payment = new MPayment(Env.getCtx(), 0, this.getTrxName());
            payment.setC_BankAccount_ID(ba.getC_BankAccount_ID());
            payment.setC_DocType_ID(false);
            payment.setDateTrx(date);
            payment.setDateAcct(date);
            payment.setC_BPartner_ID(bpartner.getC_BPartner_ID());
            payment.setC_Invoice_ID(invoice.getC_Invoice_ID());
            payment.setPayAmt(payAmt);
            payment.setDiscountAmt(discount);
            payment.setWriteOffAmt(writeoff);
            payment.setC_Currency_ID(usd.getC_Currency_ID());
            payment.setC_ConversionType_ID(0);
            payment.setTenderType("K");
            payment.setDocStatus("DR");
            payment.setDocAction("CO");
            payment.saveEx();
            this.completeDocument((PO)payment);
            this.postDocument((PO)payment);
            MAllocationHdr[] allocationa = MAllocationHdr.getOfInvoice((Properties)Env.getCtx(), (int)invoice.getC_Invoice_ID(), (String)this.getTrxName());
            MAcctSchema[] mAcctSchemaArray = ass = MAcctSchema.getClientAcctSchema((Properties)Env.getCtx(), (int)Env.getAD_Client_ID((Properties)Env.getCtx()));
            int n = ass.length;
            int n2 = 0;
            while (n2 < n) {
                MAcctSchema as = mAcctSchemaArray[n2];
                if (as.getC_Currency_ID() == usd.getC_Currency_ID()) {
                    int[] ids;
                    Doc doc = DocManager.getDocument((MAcctSchema)as, (int)735, (int)allocationa[0].get_ID(), (String)this.getTrxName());
                    doc.setC_BankAccount_ID(ba.getC_BankAccount_ID());
                    MAccount acctPT = new MAccount(Env.getCtx(), as.getAcctSchemaDefault().getV_Liability_Acct(), this.getTrxName());
                    MAccount acctDRE = new MAccount(Env.getCtx(), as.getAcctSchemaDefault().getPayDiscount_Rev_Acct(), this.getTrxName());
                    MAccount acctWO = new MAccount(Env.getCtx(), as.getAcctSchemaDefault().getWriteOff_Acct(), this.getTrxName());
                    MAccount acctPS = new MAccount(Env.getCtx(), as.getAcctSchemaDefault().getB_PaymentSelect_Acct(), this.getTrxName());
                    MAccount acctTD = new MAccount(Env.getCtx(), as.getAcctSchemaDefault().getT_Credit_Acct(), this.getTrxName());
                    whereClause = "AD_Table_ID=735 AND Record_ID=" + allocationa[0].get_ID() + " AND C_AcctSchema_ID=" + as.getC_AcctSchema_ID() + " ORDER BY Created";
                    int[] nArray = ids = MFactAcct.getAllIDs((String)"Fact_Acct", (String)whereClause, (String)this.getTrxName());
                    int n3 = ids.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        int id = nArray[n4];
                        MFactAcct fa = new MFactAcct(Env.getCtx(), id, this.getTrxName());
                        if (fa.getAccount_ID() == acctPT.getAccount_ID()) {
                            Assertions.assertEquals((Object)fa.getAmtAcctDr().setScale(2, RoundingMode.HALF_UP), (Object)new BigDecimal("106.00"));
                            Assertions.assertEquals((Object)fa.getAmtAcctCr().setScale(2, RoundingMode.HALF_UP), (Object)new BigDecimal("0.00"));
                        } else if (fa.getAccount_ID() == acctDRE.getAccount_ID()) {
                            if (fa.getAmtAcctCr().setScale(2, RoundingMode.HALF_UP).compareTo(Env.ZERO) > 0) {
                                Assertions.assertEquals((Object)fa.getAmtAcctDr().setScale(2, RoundingMode.HALF_UP), (Object)new BigDecimal("0.00"));
                                Assertions.assertEquals((Object)fa.getAmtAcctCr().setScale(2, RoundingMode.HALF_UP), (Object)new BigDecimal("2.00"));
                            } else {
                                Assertions.assertEquals((Object)fa.getAmtAcctDr().setScale(2, RoundingMode.HALF_UP), (Object)new BigDecimal("0.11"));
                                Assertions.assertEquals((Object)fa.getAmtAcctCr().setScale(2, RoundingMode.HALF_UP), (Object)new BigDecimal("0.00"));
                            }
                        } else if (fa.getAccount_ID() == acctWO.getAccount_ID()) {
                            if (fa.getAmtAcctCr().setScale(2, RoundingMode.HALF_UP).compareTo(Env.ZERO) > 0) {
                                Assertions.assertEquals((Object)fa.getAmtAcctDr().setScale(2, RoundingMode.HALF_UP), (Object)new BigDecimal("0.00"));
                                Assertions.assertEquals((Object)fa.getAmtAcctCr().setScale(2, RoundingMode.HALF_UP), (Object)new BigDecimal("2.00"));
                            } else {
                                Assertions.assertEquals((Object)fa.getAmtAcctDr().setScale(2, RoundingMode.HALF_UP), (Object)new BigDecimal("0.11"));
                                Assertions.assertEquals((Object)fa.getAmtAcctCr().setScale(2, RoundingMode.HALF_UP), (Object)new BigDecimal("0.00"));
                            }
                        } else if (fa.getAccount_ID() == acctPS.getAccount_ID()) {
                            Assertions.assertEquals((Object)fa.getAmtAcctDr().setScale(2, RoundingMode.HALF_UP), (Object)new BigDecimal("0.00"));
                            Assertions.assertEquals((Object)fa.getAmtAcctCr().setScale(2, RoundingMode.HALF_UP), (Object)new BigDecimal("102.00"));
                        } else if (fa.getAccount_ID() == acctTD.getAccount_ID()) {
                            Assertions.assertEquals((Object)fa.getAmtAcctDr().setScale(2, RoundingMode.HALF_UP), (Object)new BigDecimal("0.00"));
                            Assertions.assertEquals((Object)fa.getAmtAcctCr().setScale(2, RoundingMode.HALF_UP), (Object)new BigDecimal("0.11"));
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        finally {
            this.rollback();
        }
    }

    @Test
    public void testPaymentPostingWithWriteOffandDiscountAPCrMe() {
        MBPartner bpartner = MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.SEED_FARM.id);
        Timestamp currentDate = Env.getContextAsDate((Properties)Env.getCtx(), (String)"#Date");
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(currentDate.getTime());
        Timestamp date = new Timestamp(cal.getTimeInMillis());
        MCurrency usd = MCurrency.get((int)DictionaryIDs.C_Currency.USD.id);
        try {
            MAcctSchema[] ass;
            Object whereClause = "AD_Org_ID=? AND C_Currency_ID=?";
            MBankAccount ba = (MBankAccount)new Query(Env.getCtx(), "C_BankAccount", (String)whereClause, this.getTrxName()).setParameters(new Object[]{Env.getAD_Org_ID((Properties)Env.getCtx()), usd.getC_Currency_ID()}).setOrderBy("IsDefault DESC").first();
            Assertions.assertTrue((ba != null ? 1 : 0) != 0, (String)"@NoAccountOrgCurrency@");
            int payterm = DictionaryIDs.C_PaymentTerm.IMMEDIATE.id;
            int taxid = DictionaryIDs.C_Tax.CT_SALES.id;
            MInvoice invoice = this.createInvoice(false, true, date, date, bpartner.getC_BPartner_ID(), payterm, taxid, Env.ONEHUNDRED);
            Assertions.assertEquals((Object)invoice.getTotalLines().setScale(2, RoundingMode.HALF_UP), (Object)new BigDecimal("100.00"));
            Assertions.assertEquals((Object)invoice.getGrandTotal().setScale(2, RoundingMode.HALF_UP), (Object)new BigDecimal("106.00"));
            BigDecimal payAmt = new BigDecimal("102").negate();
            BigDecimal discount = new BigDecimal("2").negate();
            BigDecimal writeoff = new BigDecimal("2").negate();
            MPayment payment = new MPayment(Env.getCtx(), 0, this.getTrxName());
            payment.setC_BankAccount_ID(ba.getC_BankAccount_ID());
            payment.setC_DocType_ID(false);
            payment.setDateTrx(date);
            payment.setDateAcct(date);
            payment.setC_BPartner_ID(bpartner.getC_BPartner_ID());
            payment.setC_Invoice_ID(invoice.getC_Invoice_ID());
            payment.setPayAmt(payAmt);
            payment.setDiscountAmt(discount);
            payment.setWriteOffAmt(writeoff);
            payment.setC_Currency_ID(usd.getC_Currency_ID());
            payment.setC_ConversionType_ID(0);
            payment.setTenderType("K");
            payment.setDocStatus("DR");
            payment.setDocAction("CO");
            payment.saveEx();
            this.completeDocument((PO)payment);
            this.postDocument((PO)payment);
            MAllocationHdr[] allocationa = MAllocationHdr.getOfInvoice((Properties)Env.getCtx(), (int)invoice.getC_Invoice_ID(), (String)this.getTrxName());
            MAcctSchema[] mAcctSchemaArray = ass = MAcctSchema.getClientAcctSchema((Properties)Env.getCtx(), (int)Env.getAD_Client_ID((Properties)Env.getCtx()));
            int n = ass.length;
            int n2 = 0;
            while (n2 < n) {
                MAcctSchema as = mAcctSchemaArray[n2];
                if (as.getC_Currency_ID() == usd.getC_Currency_ID()) {
                    int[] ids;
                    Doc doc = DocManager.getDocument((MAcctSchema)as, (int)735, (int)allocationa[0].get_ID(), (String)this.getTrxName());
                    doc.setC_BankAccount_ID(ba.getC_BankAccount_ID());
                    MAccount acctPT = new MAccount(Env.getCtx(), as.getAcctSchemaDefault().getV_Liability_Acct(), this.getTrxName());
                    MAccount acctDRE = new MAccount(Env.getCtx(), as.getAcctSchemaDefault().getPayDiscount_Rev_Acct(), this.getTrxName());
                    MAccount acctWO = new MAccount(Env.getCtx(), as.getAcctSchemaDefault().getWriteOff_Acct(), this.getTrxName());
                    MAccount acctUC = new MAccount(Env.getCtx(), as.getAcctSchemaDefault().getB_UnallocatedCash_Acct(), this.getTrxName());
                    MAccount acctTD = new MAccount(Env.getCtx(), as.getAcctSchemaDefault().getT_Credit_Acct(), this.getTrxName());
                    whereClause = "AD_Table_ID=735 AND Record_ID=" + allocationa[0].get_ID() + " AND C_AcctSchema_ID=" + as.getC_AcctSchema_ID() + " ORDER BY Created";
                    int[] nArray = ids = MFactAcct.getAllIDs((String)"Fact_Acct", (String)whereClause, (String)this.getTrxName());
                    int n3 = ids.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        int id = nArray[n4];
                        MFactAcct fa = new MFactAcct(Env.getCtx(), id, this.getTrxName());
                        if (fa.getAccount_ID() == acctPT.getAccount_ID()) {
                            Assertions.assertEquals((Object)fa.getAmtAcctDr().setScale(2, RoundingMode.HALF_UP), (Object)new BigDecimal("106.00").negate());
                            Assertions.assertEquals((Object)fa.getAmtAcctCr().setScale(2, RoundingMode.HALF_UP), (Object)new BigDecimal("0.00"));
                        } else if (fa.getAccount_ID() == acctDRE.getAccount_ID()) {
                            if (fa.getAmtAcctCr().setScale(2, RoundingMode.HALF_UP).compareTo(Env.ZERO) < 0) {
                                Assertions.assertEquals((Object)fa.getAmtAcctDr().setScale(2, RoundingMode.HALF_UP), (Object)new BigDecimal("0.00"));
                                Assertions.assertEquals((Object)fa.getAmtAcctCr().setScale(2, RoundingMode.HALF_UP), (Object)new BigDecimal("2.00").negate());
                            } else {
                                Assertions.assertEquals((Object)fa.getAmtAcctDr().setScale(2, RoundingMode.HALF_UP), (Object)new BigDecimal("0.00"));
                                Assertions.assertEquals((Object)fa.getAmtAcctCr().setScale(2, RoundingMode.HALF_UP), (Object)new BigDecimal("0.11"));
                            }
                        } else if (fa.getAccount_ID() == acctWO.getAccount_ID()) {
                            if (fa.getAmtAcctCr().setScale(2, RoundingMode.HALF_UP).compareTo(Env.ZERO) < 0) {
                                Assertions.assertEquals((Object)fa.getAmtAcctDr().setScale(2, RoundingMode.HALF_UP), (Object)new BigDecimal("0.00"));
                                Assertions.assertEquals((Object)fa.getAmtAcctCr().setScale(2, RoundingMode.HALF_UP), (Object)new BigDecimal("2.00").negate());
                            } else {
                                Assertions.assertEquals((Object)fa.getAmtAcctDr().setScale(2, RoundingMode.HALF_UP), (Object)new BigDecimal("0.00"));
                                Assertions.assertEquals((Object)fa.getAmtAcctCr().setScale(2, RoundingMode.HALF_UP), (Object)new BigDecimal("0.11"));
                            }
                        } else if (fa.getAccount_ID() == acctUC.getAccount_ID()) {
                            Assertions.assertEquals((Object)fa.getAmtAcctDr().setScale(2, RoundingMode.HALF_UP), (Object)new BigDecimal("0.00"));
                            Assertions.assertEquals((Object)fa.getAmtAcctCr().setScale(2, RoundingMode.HALF_UP), (Object)new BigDecimal("104.00").negate());
                        } else if (fa.getAccount_ID() == acctTD.getAccount_ID()) {
                            Assertions.assertEquals((Object)fa.getAmtAcctDr().setScale(2, RoundingMode.HALF_UP), (Object)new BigDecimal("0.11"));
                            Assertions.assertEquals((Object)fa.getAmtAcctCr().setScale(2, RoundingMode.HALF_UP), (Object)new BigDecimal("0.00"));
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        finally {
            this.rollback();
        }
    }

    @Test
    public void testAllocatePostingWithWriteOffandDiscountARInvARCrMe() {
        MBPartner bpartner = MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.SEED_FARM.id);
        Timestamp currentDate = Env.getContextAsDate((Properties)Env.getCtx(), (String)"#Date");
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(currentDate.getTime());
        Timestamp date = new Timestamp(cal.getTimeInMillis());
        MCurrency usd = MCurrency.get((int)DictionaryIDs.C_Currency.USD.id);
        try {
            MAcctSchema[] ass;
            Object whereClause = "AD_Org_ID=? AND C_Currency_ID=?";
            MBankAccount ba = (MBankAccount)new Query(Env.getCtx(), "C_BankAccount", (String)whereClause, this.getTrxName()).setParameters(new Object[]{Env.getAD_Org_ID((Properties)Env.getCtx()), usd.getC_Currency_ID()}).setOrderBy("IsDefault DESC").first();
            Assertions.assertTrue((ba != null ? 1 : 0) != 0, (String)"@NoAccountOrgCurrency@");
            int payterm = DictionaryIDs.C_PaymentTerm.TWO_PERCENT_10_NET_30.id;
            int taxid = DictionaryIDs.C_Tax.CT_SALES.id;
            MInvoice invoice = this.createInvoice(true, false, date, date, bpartner.getC_BPartner_ID(), payterm, taxid, Env.ONEHUNDRED);
            Assertions.assertEquals((Object)invoice.getTotalLines().setScale(2, RoundingMode.HALF_UP), (Object)new BigDecimal("100.00"));
            Assertions.assertEquals((Object)invoice.getGrandTotal().setScale(2, RoundingMode.HALF_UP), (Object)new BigDecimal("106.00"));
            int paytermcm = DictionaryIDs.C_PaymentTerm.IMMEDIATE.id;
            MInvoice creditmemo = this.createInvoice(true, true, date, date, bpartner.getC_BPartner_ID(), paytermcm, taxid, new BigDecimal("96.23"));
            Assertions.assertEquals((Object)creditmemo.getTotalLines().setScale(2, RoundingMode.HALF_UP), (Object)new BigDecimal("96.23"));
            Assertions.assertEquals((Object)creditmemo.getGrandTotal().setScale(2, RoundingMode.HALF_UP), (Object)new BigDecimal("102.00"));
            MAllocationHdr alloc = new MAllocationHdr(Env.getCtx(), true, date, usd.getC_Currency_ID(), Env.getContext((Properties)Env.getCtx(), (String)"#AD_User_Name"), this.getTrxName());
            alloc.setAD_Org_ID(invoice.getAD_Org_ID());
            int doctypeAlloc = MDocType.getDocType((String)"CMA");
            alloc.setC_DocType_ID(doctypeAlloc);
            alloc.setDescription(alloc.getDescriptionForManualAllocation(invoice.getC_BPartner_ID(), this.getTrxName()));
            alloc.saveEx();
            BigDecimal discount = new BigDecimal("2");
            BigDecimal writeoff = new BigDecimal("2");
            MAllocationLine aLine1 = new MAllocationLine(alloc, invoice.getGrandTotal().subtract(discount.add(writeoff)), discount, writeoff, Env.ZERO);
            aLine1.setDocInfo(invoice.getC_BPartner_ID(), 0, 0);
            aLine1.setPaymentInfo(invoice.getC_Payment_ID(), 0);
            aLine1.setC_Invoice_ID(invoice.getC_Invoice_ID());
            aLine1.saveEx();
            MAllocationLine aLine2 = new MAllocationLine(alloc, creditmemo.getGrandTotal().negate(), Env.ZERO, Env.ZERO, Env.ZERO);
            aLine2.setDocInfo(invoice.getC_BPartner_ID(), 0, 0);
            aLine2.setPaymentInfo(invoice.getC_Payment_ID(), 0);
            aLine2.setC_Invoice_ID(invoice.getC_Invoice_ID());
            aLine2.saveEx();
            this.completeDocument((PO)alloc);
            this.postDocument((PO)alloc);
            MAcctSchema[] mAcctSchemaArray = ass = MAcctSchema.getClientAcctSchema((Properties)Env.getCtx(), (int)Env.getAD_Client_ID((Properties)Env.getCtx()));
            int n = ass.length;
            int n2 = 0;
            while (n2 < n) {
                MAcctSchema as = mAcctSchemaArray[n2];
                if (as.getC_Currency_ID() == usd.getC_Currency_ID()) {
                    int[] ids;
                    Doc doc = DocManager.getDocument((MAcctSchema)as, (int)735, (int)alloc.get_ID(), (String)this.getTrxName());
                    doc.setC_BankAccount_ID(ba.getC_BankAccount_ID());
                    MAccount acctDRE = new MAccount(Env.getCtx(), as.getAcctSchemaDefault().getPayDiscount_Rev_Acct(), this.getTrxName());
                    MAccount acctWO = new MAccount(Env.getCtx(), as.getAcctSchemaDefault().getWriteOff_Acct(), this.getTrxName());
                    MAccount acctART = new MAccount(Env.getCtx(), as.getAcctSchemaDefault().getC_Receivable_Acct(), this.getTrxName());
                    MAccount acctTD = new MAccount(Env.getCtx(), as.getAcctSchemaDefault().getT_Due_Acct(), this.getTrxName());
                    whereClause = "AD_Table_ID=735 AND Record_ID=" + alloc.get_ID() + " AND C_AcctSchema_ID=" + as.getC_AcctSchema_ID() + " ORDER BY Created";
                    int[] nArray = ids = MFactAcct.getAllIDs((String)"Fact_Acct", (String)whereClause, (String)this.getTrxName());
                    int n3 = ids.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        int id = nArray[n4];
                        MFactAcct fa = new MFactAcct(Env.getCtx(), id, this.getTrxName());
                        if (fa.getAccount_ID() == acctDRE.getAccount_ID()) {
                            if (fa.getAmtAcctDr().setScale(2, RoundingMode.HALF_UP).compareTo(Env.ZERO) > 0) {
                                Assertions.assertEquals((Object)fa.getAmtAcctDr().setScale(2, RoundingMode.HALF_UP), (Object)new BigDecimal("2.00"));
                                Assertions.assertEquals((Object)fa.getAmtAcctCr().setScale(2, RoundingMode.HALF_UP), (Object)new BigDecimal("0.00"));
                            } else {
                                Assertions.assertEquals((Object)fa.getAmtAcctDr().setScale(2, RoundingMode.HALF_UP), (Object)new BigDecimal("0.00"));
                                Assertions.assertEquals((Object)fa.getAmtAcctCr().setScale(2, RoundingMode.HALF_UP), (Object)new BigDecimal("0.11"));
                            }
                        } else if (fa.getAccount_ID() == acctWO.getAccount_ID()) {
                            if (fa.getAmtAcctDr().setScale(2, RoundingMode.HALF_UP).compareTo(Env.ZERO) > 0) {
                                Assertions.assertEquals((Object)fa.getAmtAcctDr().setScale(2, RoundingMode.HALF_UP), (Object)new BigDecimal("2.00"));
                                Assertions.assertEquals((Object)fa.getAmtAcctCr().setScale(2, RoundingMode.HALF_UP), (Object)new BigDecimal("0.00"));
                            } else {
                                Assertions.assertEquals((Object)fa.getAmtAcctDr().setScale(2, RoundingMode.HALF_UP), (Object)new BigDecimal("0.00"));
                                Assertions.assertEquals((Object)fa.getAmtAcctCr().setScale(2, RoundingMode.HALF_UP), (Object)new BigDecimal("0.11"));
                            }
                        } else if (fa.getAccount_ID() == acctART.getAccount_ID()) {
                            if (fa.getAmtAcctCr().setScale(2, RoundingMode.HALF_UP).compareTo(Env.ZERO) > 0) {
                                Assertions.assertEquals((Object)fa.getAmtAcctDr().setScale(2, RoundingMode.HALF_UP), (Object)new BigDecimal("0.00"));
                                Assertions.assertEquals((Object)fa.getAmtAcctCr().setScale(2, RoundingMode.HALF_UP), (Object)new BigDecimal("106.00"));
                            } else {
                                Assertions.assertEquals((Object)fa.getAmtAcctDr().setScale(2, RoundingMode.HALF_UP), (Object)new BigDecimal("0.00"));
                                Assertions.assertEquals((Object)fa.getAmtAcctCr().setScale(2, RoundingMode.HALF_UP), (Object)new BigDecimal("-102.00"));
                            }
                        } else if (fa.getAccount_ID() == acctTD.getAccount_ID()) {
                            Assertions.assertEquals((Object)fa.getAmtAcctDr().setScale(2, RoundingMode.HALF_UP), (Object)new BigDecimal("0.11"));
                            Assertions.assertEquals((Object)fa.getAmtAcctCr().setScale(2, RoundingMode.HALF_UP), (Object)new BigDecimal("0.00"));
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        finally {
            this.rollback();
        }
    }

    @Test
    public void testAllocatePostingWithWriteOffandDiscountAPInvAPCrMe() {
        MBPartner bpartner = MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.SEED_FARM.id);
        Timestamp currentDate = Env.getContextAsDate((Properties)Env.getCtx(), (String)"#Date");
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(currentDate.getTime());
        Timestamp date = new Timestamp(cal.getTimeInMillis());
        MCurrency usd = MCurrency.get((int)DictionaryIDs.C_Currency.USD.id);
        try {
            MAcctSchema[] ass;
            Object whereClause = "AD_Org_ID=? AND C_Currency_ID=?";
            MBankAccount ba = (MBankAccount)new Query(Env.getCtx(), "C_BankAccount", (String)whereClause, this.getTrxName()).setParameters(new Object[]{Env.getAD_Org_ID((Properties)Env.getCtx()), usd.getC_Currency_ID()}).setOrderBy("IsDefault DESC").first();
            Assertions.assertTrue((ba != null ? 1 : 0) != 0, (String)"@NoAccountOrgCurrency@");
            int payterm = DictionaryIDs.C_PaymentTerm.IMMEDIATE.id;
            int taxid = DictionaryIDs.C_Tax.CT_SALES.id;
            MInvoice invoice = this.createInvoice(false, false, date, date, bpartner.getC_BPartner_ID(), payterm, taxid, Env.ONEHUNDRED);
            Assertions.assertEquals((Object)invoice.getTotalLines().setScale(2, RoundingMode.HALF_UP), (Object)new BigDecimal("100.00"));
            Assertions.assertEquals((Object)invoice.getGrandTotal().setScale(2, RoundingMode.HALF_UP), (Object)new BigDecimal("106.00"));
            int paytermcm = DictionaryIDs.C_PaymentTerm.IMMEDIATE.id;
            MInvoice creditmemo = this.createInvoice(false, true, date, date, bpartner.getC_BPartner_ID(), paytermcm, taxid, new BigDecimal("96.23"));
            Assertions.assertEquals((Object)creditmemo.getTotalLines().setScale(2, RoundingMode.HALF_UP), (Object)new BigDecimal("96.23"));
            Assertions.assertEquals((Object)creditmemo.getGrandTotal().setScale(2, RoundingMode.HALF_UP), (Object)new BigDecimal("102.00"));
            MAllocationHdr alloc = new MAllocationHdr(Env.getCtx(), true, date, usd.getC_Currency_ID(), Env.getContext((Properties)Env.getCtx(), (String)"#AD_User_Name"), this.getTrxName());
            alloc.setAD_Org_ID(invoice.getAD_Org_ID());
            int doctypeAlloc = MDocType.getDocType((String)"CMA");
            alloc.setC_DocType_ID(doctypeAlloc);
            alloc.setDescription(alloc.getDescriptionForManualAllocation(invoice.getC_BPartner_ID(), this.getTrxName()));
            alloc.saveEx();
            BigDecimal discount = new BigDecimal("2").negate();
            BigDecimal writeoff = new BigDecimal("2").negate();
            BigDecimal amtinv = invoice.getGrandTotal().negate().subtract(discount.add(writeoff));
            MAllocationLine aLine1 = new MAllocationLine(alloc, amtinv, discount, writeoff, Env.ZERO);
            aLine1.setDocInfo(invoice.getC_BPartner_ID(), 0, 0);
            aLine1.setPaymentInfo(invoice.getC_Payment_ID(), 0);
            aLine1.setC_Invoice_ID(invoice.getC_Invoice_ID());
            aLine1.saveEx();
            MAllocationLine aLine2 = new MAllocationLine(alloc, creditmemo.getGrandTotal(), Env.ZERO, Env.ZERO, Env.ZERO);
            aLine2.setDocInfo(invoice.getC_BPartner_ID(), 0, 0);
            aLine2.setPaymentInfo(invoice.getC_Payment_ID(), 0);
            aLine2.setC_Invoice_ID(invoice.getC_Invoice_ID());
            aLine2.saveEx();
            this.completeDocument((PO)alloc);
            this.postDocument((PO)alloc);
            MAcctSchema[] mAcctSchemaArray = ass = MAcctSchema.getClientAcctSchema((Properties)Env.getCtx(), (int)Env.getAD_Client_ID((Properties)Env.getCtx()));
            int n = ass.length;
            int n2 = 0;
            while (n2 < n) {
                MAcctSchema as = mAcctSchemaArray[n2];
                if (as.getC_Currency_ID() == usd.getC_Currency_ID()) {
                    int[] ids;
                    Doc doc = DocManager.getDocument((MAcctSchema)as, (int)735, (int)alloc.get_ID(), (String)this.getTrxName());
                    doc.setC_BankAccount_ID(ba.getC_BankAccount_ID());
                    MAccount acctPT = new MAccount(Env.getCtx(), as.getAcctSchemaDefault().getV_Liability_Acct(), this.getTrxName());
                    MAccount acctDRE = new MAccount(Env.getCtx(), as.getAcctSchemaDefault().getPayDiscount_Rev_Acct(), this.getTrxName());
                    MAccount acctWO = new MAccount(Env.getCtx(), as.getAcctSchemaDefault().getWriteOff_Acct(), this.getTrxName());
                    MAccount acctTD = new MAccount(Env.getCtx(), as.getAcctSchemaDefault().getT_Credit_Acct(), this.getTrxName());
                    whereClause = "AD_Table_ID=735 AND Record_ID=" + alloc.get_ID() + " AND C_AcctSchema_ID=" + as.getC_AcctSchema_ID() + " ORDER BY Created";
                    int[] nArray = ids = MFactAcct.getAllIDs((String)"Fact_Acct", (String)whereClause, (String)this.getTrxName());
                    int n3 = ids.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        int id = nArray[n4];
                        MFactAcct fa = new MFactAcct(Env.getCtx(), id, this.getTrxName());
                        if (fa.getAccount_ID() == acctPT.getAccount_ID()) {
                            if (fa.getAmtAcctDr().setScale(2, RoundingMode.HALF_UP).compareTo(Env.ZERO) > 0) {
                                Assertions.assertEquals((Object)fa.getAmtAcctDr().setScale(2, RoundingMode.HALF_UP), (Object)new BigDecimal("106.00"));
                                Assertions.assertEquals((Object)fa.getAmtAcctCr().setScale(2, RoundingMode.HALF_UP), (Object)new BigDecimal("0.00"));
                            } else {
                                Assertions.assertEquals((Object)fa.getAmtAcctDr().setScale(2, RoundingMode.HALF_UP), (Object)new BigDecimal("-102.00"));
                                Assertions.assertEquals((Object)fa.getAmtAcctCr().setScale(2, RoundingMode.HALF_UP), (Object)new BigDecimal("0.00"));
                            }
                        } else if (fa.getAccount_ID() == acctDRE.getAccount_ID()) {
                            if (fa.getAmtAcctCr().setScale(2, RoundingMode.HALF_UP).compareTo(Env.ZERO) > 0) {
                                Assertions.assertEquals((Object)fa.getAmtAcctDr().setScale(2, RoundingMode.HALF_UP), (Object)new BigDecimal("0.00"));
                                Assertions.assertEquals((Object)fa.getAmtAcctCr().setScale(2, RoundingMode.HALF_UP), (Object)new BigDecimal("2.00"));
                            } else {
                                Assertions.assertEquals((Object)fa.getAmtAcctDr().setScale(2, RoundingMode.HALF_UP), (Object)new BigDecimal("0.11"));
                                Assertions.assertEquals((Object)fa.getAmtAcctCr().setScale(2, RoundingMode.HALF_UP), (Object)new BigDecimal("0.00"));
                            }
                        } else if (fa.getAccount_ID() == acctWO.getAccount_ID()) {
                            if (fa.getAmtAcctCr().setScale(2, RoundingMode.HALF_UP).compareTo(Env.ZERO) > 0) {
                                Assertions.assertEquals((Object)fa.getAmtAcctDr().setScale(2, RoundingMode.HALF_UP), (Object)new BigDecimal("0.00"));
                                Assertions.assertEquals((Object)fa.getAmtAcctCr().setScale(2, RoundingMode.HALF_UP), (Object)new BigDecimal("2.00"));
                            } else {
                                Assertions.assertEquals((Object)fa.getAmtAcctDr().setScale(2, RoundingMode.HALF_UP), (Object)new BigDecimal("0.11"));
                                Assertions.assertEquals((Object)fa.getAmtAcctCr().setScale(2, RoundingMode.HALF_UP), (Object)new BigDecimal("0.00"));
                            }
                        } else if (fa.getAccount_ID() == acctTD.getAccount_ID()) {
                            Assertions.assertEquals((Object)fa.getAmtAcctDr().setScale(2, RoundingMode.HALF_UP), (Object)new BigDecimal("0.00"));
                            Assertions.assertEquals((Object)fa.getAmtAcctCr().setScale(2, RoundingMode.HALF_UP), (Object)new BigDecimal("0.11"));
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        finally {
            this.rollback();
        }
    }

    @Test
    @ResourceLock(value="C_Conversion_Rate")
    public void testAllocatePaymentPostingWithCurrencyBalancing() {
        Timestamp currentDate = Env.getContextAsDate((Properties)Env.getCtx(), (String)"#Date");
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(currentDate.getTime());
        cal.add(5, -2);
        Timestamp date1 = new Timestamp(cal.getTimeInMillis());
        cal.setTimeInMillis(currentDate.getTime());
        cal.add(5, -1);
        Timestamp date2 = new Timestamp(cal.getTimeInMillis());
        Timestamp date3 = currentDate;
        int C_ConversionType_ID = DictionaryIDs.C_ConversionType.COMPANY.id;
        MCurrency usd = MCurrency.get((int)DictionaryIDs.C_Currency.USD.id);
        MCurrency euro = MCurrency.get((int)DictionaryIDs.C_Currency.EUR.id);
        BigDecimal eurToUsd1 = new BigDecimal(32.458922422202);
        MBPartner bp = new MBPartner(Env.getCtx(), DictionaryIDs.C_BPartner.C_AND_W.id, this.getTrxName());
        DB.getDatabase().forUpdate((PO)bp, 0);
        MConversionRate cr1 = this.createConversionRate(euro.getC_Currency_ID(), usd.getC_Currency_ID(), C_ConversionType_ID, date1, eurToUsd1, false);
        BigDecimal eurToUsd2 = new BigDecimal(33.93972535567);
        MConversionRate cr2 = this.createConversionRate(euro.getC_Currency_ID(), usd.getC_Currency_ID(), C_ConversionType_ID, date2, eurToUsd2, false);
        BigDecimal eurToUsd3 = new BigDecimal(33.27812049435);
        MConversionRate cr3 = this.createConversionRate(euro.getC_Currency_ID(), usd.getC_Currency_ID(), C_ConversionType_ID, date3, eurToUsd3, false);
        int M_PriceList_ID = DictionaryIDs.M_PriceList.EXPORT.id;
        try {
            MAcctSchema[] ass;
            Object whereClause = "AD_Org_ID=? AND C_Currency_ID=?";
            MBankAccount ba = (MBankAccount)new Query(Env.getCtx(), "C_BankAccount", (String)whereClause, this.getTrxName()).setParameters(new Object[]{Env.getAD_Org_ID((Properties)Env.getCtx()), usd.getC_Currency_ID()}).setOrderBy("IsDefault DESC").first();
            Assertions.assertTrue((ba != null ? 1 : 0) != 0, (String)"@NoAccountOrgCurrency@");
            MInvoice invoice1 = new MInvoice(Env.getCtx(), 0, this.getTrxName());
            invoice1.setC_BPartner_ID(DictionaryIDs.C_BPartner.C_AND_W.id);
            invoice1.setC_DocTypeTarget_ID("ARI");
            invoice1.setC_DocType_ID(invoice1.getC_DocTypeTarget_ID());
            invoice1.setPaymentRule("P");
            invoice1.setC_PaymentTerm_ID(DictionaryIDs.C_PaymentTerm.IMMEDIATE.id);
            invoice1.setDateInvoiced(date1);
            invoice1.setDateAcct(date1);
            invoice1.setM_PriceList_ID(M_PriceList_ID);
            invoice1.setC_ConversionType_ID(C_ConversionType_ID);
            invoice1.setDocStatus("DR");
            invoice1.setDocAction("CO");
            invoice1.saveEx();
            MInvoiceLine line = new MInvoiceLine(invoice1);
            line.setLine(10);
            line.setC_Charge_ID(DictionaryIDs.C_Charge.FREIGHT.id);
            line.setQty(BigDecimal.ONE);
            BigDecimal invAmt = new BigDecimal(12587.48);
            line.setPrice(invAmt);
            line.setC_Tax_ID(DictionaryIDs.C_Tax.STANDARD.id);
            line.saveEx();
            this.completeDocument((PO)invoice1);
            this.postDocument((PO)invoice1);
            BigDecimal payAmt = new BigDecimal(18549.52);
            MPayment payment = this.createReceiptPayment(DictionaryIDs.C_BPartner.C_AND_W.id, ba.getC_BankAccount_ID(), date2, euro.getC_Currency_ID(), C_ConversionType_ID, payAmt);
            this.completeDocument((PO)payment);
            this.postDocument((PO)payment);
            MAllocationHdr alloc1 = new MAllocationHdr(Env.getCtx(), true, date2, euro.getC_Currency_ID(), Env.getContext((Properties)Env.getCtx(), (String)"#AD_User_Name"), this.getTrxName());
            alloc1.setAD_Org_ID(payment.getAD_Org_ID());
            int doctypeAlloc = MDocType.getDocType((String)"CMA");
            alloc1.setC_DocType_ID(doctypeAlloc);
            alloc1.saveEx();
            BigDecimal allocAmount = new BigDecimal(12587.48);
            MAllocationLine aLine = new MAllocationLine(alloc1, allocAmount, Env.ZERO, Env.ZERO, Env.ZERO);
            aLine.setC_BPartner_ID(invoice1.getC_BPartner_ID());
            aLine.setC_Invoice_ID(invoice1.getC_Invoice_ID());
            aLine.setC_Payment_ID(payment.getC_Payment_ID());
            aLine.saveEx();
            this.completeDocument((PO)alloc1);
            this.postDocument((PO)alloc1);
            MAllocationHdr[] allocations = MAllocationHdr.getOfInvoice((Properties)Env.getCtx(), (int)invoice1.getC_Invoice_ID(), (String)this.getTrxName());
            Assertions.assertTrue((allocations.length == 1 ? 1 : 0) != 0);
            MAllocationHdr allocation = allocations[0];
            this.postDocument((PO)allocation);
            MAcctSchema[] mAcctSchemaArray = ass = MAcctSchema.getClientAcctSchema((Properties)Env.getCtx(), (int)Env.getAD_Client_ID((Properties)Env.getCtx()));
            int n = ass.length;
            int n2 = 0;
            while (n2 < n) {
                MAcctSchema as = mAcctSchemaArray[n2];
                if (as.getC_Currency_ID() == usd.getC_Currency_ID()) {
                    int[] ids;
                    Doc doc = DocManager.getDocument((MAcctSchema)as, (int)735, (int)allocation.get_ID(), (String)this.getTrxName());
                    doc.setC_BankAccount_ID(ba.getC_BankAccount_ID());
                    MAccount acctUC = doc.getAccount(10, as);
                    BigDecimal ucAmtAcctDr = new BigDecimal(370.88).setScale(2, RoundingMode.HALF_UP);
                    whereClause = "AD_Table_ID=735 AND Record_ID=" + allocation.get_ID() + " AND C_AcctSchema_ID=" + as.getC_AcctSchema_ID() + " ORDER BY Created";
                    int[] nArray = ids = MFactAcct.getAllIDs((String)"Fact_Acct", (String)whereClause, (String)this.getTrxName());
                    int n3 = ids.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        int id = nArray[n4];
                        MFactAcct fa = new MFactAcct(Env.getCtx(), id, this.getTrxName());
                        if (acctUC.getAccount_ID() == fa.getAccount_ID() && fa.getAmtAcctDr().signum() > 0) {
                            Assertions.assertTrue((fa.getAmtAcctDr().compareTo(ucAmtAcctDr) == 0 ? 1 : 0) != 0, (String)(fa.getAmtAcctDr().toPlainString() + "!=" + ucAmtAcctDr.toPlainString()));
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
            MInvoice invoice2 = new MInvoice(Env.getCtx(), 0, this.getTrxName());
            invoice2.setC_BPartner_ID(DictionaryIDs.C_BPartner.C_AND_W.id);
            invoice2.setC_DocTypeTarget_ID("ARI");
            invoice2.setC_DocType_ID(invoice2.getC_DocTypeTarget_ID());
            invoice2.setPaymentRule("P");
            invoice2.setC_PaymentTerm_ID(DictionaryIDs.C_PaymentTerm.IMMEDIATE.id);
            invoice2.setDateInvoiced(date3);
            invoice2.setDateAcct(date3);
            invoice2.setM_PriceList_ID(M_PriceList_ID);
            invoice2.setC_ConversionType_ID(C_ConversionType_ID);
            invoice2.setDocStatus("DR");
            invoice2.setDocAction("CO");
            invoice2.saveEx();
            line = new MInvoiceLine(invoice2);
            line.setLine(10);
            line.setC_Charge_ID(DictionaryIDs.C_Charge.FREIGHT.id);
            line.setQty(BigDecimal.ONE);
            invAmt = new BigDecimal(40125);
            line.setPrice(invAmt);
            line.setC_Tax_ID(DictionaryIDs.C_Tax.STANDARD.id);
            line.saveEx();
            this.completeDocument((PO)invoice2);
            this.postDocument((PO)invoice2);
            MAllocationHdr alloc2 = new MAllocationHdr(Env.getCtx(), true, date3, euro.getC_Currency_ID(), Env.getContext((Properties)Env.getCtx(), (String)"#AD_User_Name"), this.getTrxName());
            alloc2.setAD_Org_ID(payment.getAD_Org_ID());
            alloc2.setC_DocType_ID(doctypeAlloc);
            alloc2.saveEx();
            allocAmount = new BigDecimal(5962.04);
            aLine = new MAllocationLine(alloc2, allocAmount, Env.ZERO, Env.ZERO, Env.ZERO);
            aLine.setC_BPartner_ID(invoice2.getC_BPartner_ID());
            aLine.setC_Invoice_ID(invoice2.getC_Invoice_ID());
            aLine.setC_Payment_ID(payment.getC_Payment_ID());
            aLine.saveEx();
            this.completeDocument((PO)alloc2);
            this.postDocument((PO)alloc2);
            allocations = MAllocationHdr.getOfInvoice((Properties)Env.getCtx(), (int)invoice2.getC_Invoice_ID(), (String)this.getTrxName());
            Assertions.assertTrue((allocations.length == 1 ? 1 : 0) != 0);
            allocation = allocations[0];
            this.postDocument((PO)allocation);
            MAcctSchema[] mAcctSchemaArray2 = ass;
            int n5 = ass.length;
            int n6 = 0;
            while (n6 < n5) {
                MAcctSchema as = mAcctSchemaArray2[n6];
                if (as.getC_Currency_ID() == usd.getC_Currency_ID()) {
                    int[] ids;
                    Doc doc = DocManager.getDocument((MAcctSchema)as, (int)735, (int)allocation.get_ID(), (String)this.getTrxName());
                    doc.setC_BankAccount_ID(ba.getC_BankAccount_ID());
                    MAccount acctUC = doc.getAccount(10, as);
                    BigDecimal ucAmtAcctDr = new BigDecimal(175.67).setScale(2, RoundingMode.HALF_UP);
                    BigDecimal ucAmtAcctCr = new BigDecimal(0.01).setScale(2, RoundingMode.HALF_UP);
                    whereClause = "AD_Table_ID=735 AND Record_ID=" + allocation.get_ID() + " AND C_AcctSchema_ID=" + as.getC_AcctSchema_ID() + " ORDER BY Created";
                    int[] nArray = ids = MFactAcct.getAllIDs((String)"Fact_Acct", (String)whereClause, (String)this.getTrxName());
                    int n7 = ids.length;
                    int n8 = 0;
                    while (n8 < n7) {
                        int id = nArray[n8];
                        MFactAcct fa = new MFactAcct(Env.getCtx(), id, this.getTrxName());
                        if (acctUC.getAccount_ID() == fa.getAccount_ID()) {
                            if (fa.getAmtAcctDr().signum() > 0) {
                                Assertions.assertTrue((fa.getAmtAcctDr().compareTo(ucAmtAcctDr) == 0 ? 1 : 0) != 0, (String)(fa.getAmtAcctDr().toPlainString() + "!=" + ucAmtAcctDr.toPlainString()));
                            } else if (fa.getAmtAcctCr().signum() > 0) {
                                Assertions.assertTrue((fa.getAmtAcctCr().compareTo(ucAmtAcctCr) == 0 ? 1 : 0) != 0, (String)(fa.getAmtAcctCr().toPlainString() + "!=" + ucAmtAcctCr.toPlainString()));
                            }
                        }
                        ++n8;
                    }
                }
                ++n6;
            }
        }
        finally {
            this.rollback();
            this.deleteConversionRate(cr1);
            this.deleteConversionRate(cr2);
            this.deleteConversionRate(cr3);
        }
    }

    private MInvoice createInvoice(Boolean isAR, Boolean isCreditMemo, Timestamp dateinvoiced, Timestamp dateacct, Integer bpartnerid, Integer payterm, Integer taxid, BigDecimal totallines) {
        MInvoice invoice = new MInvoice(Env.getCtx(), 0, this.getTrxName());
        if (isAR.booleanValue()) {
            if (isCreditMemo.booleanValue()) {
                invoice.setC_DocType_ID(118);
                invoice.setC_DocTypeTarget_ID("ARC");
            } else {
                invoice.setC_DocType_ID(116);
                invoice.setC_DocTypeTarget_ID("ARI");
            }
        } else if (isCreditMemo.booleanValue()) {
            invoice.setC_DocType_ID(124);
            invoice.setC_DocTypeTarget_ID("APC");
        } else {
            invoice.setC_DocType_ID(123);
            invoice.setC_DocTypeTarget_ID("API");
        }
        invoice.setC_BPartner_ID(bpartnerid.intValue());
        invoice.setDateInvoiced(dateinvoiced);
        invoice.setDateAcct(dateacct);
        invoice.setC_PaymentTerm_ID(payterm.intValue());
        invoice.setDocStatus("DR");
        invoice.setDocAction("CO");
        invoice.saveEx();
        MInvoiceLine line1 = new MInvoiceLine(invoice);
        line1.setLine(10);
        line1.setC_Charge_ID(DictionaryIDs.C_Charge.FREIGHT.id);
        line1.setQty(new BigDecimal("1"));
        line1.setPrice(totallines);
        line1.setC_Tax_ID(taxid.intValue());
        line1.saveEx();
        this.completeDocument((PO)invoice);
        this.postDocument((PO)invoice);
        return invoice;
    }
}

