/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.test.base;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Timestamp;
import java.util.List;
import java.util.Properties;
import org.compiere.acct.Doc;
import org.compiere.acct.DocManager;
import org.compiere.model.MAccount;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MBPartner;
import org.compiere.model.MClient;
import org.compiere.model.MConversionRate;
import org.compiere.model.MCost;
import org.compiere.model.MFactAcct;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutLine;
import org.compiere.model.MInventory;
import org.compiere.model.MInventoryLine;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MMatchInv;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MProduct;
import org.compiere.model.MProductCategory;
import org.compiere.model.MProductCategoryAcct;
import org.compiere.model.MWarehouse;
import org.compiere.model.PO;
import org.compiere.model.ProductCost;
import org.compiere.model.Query;
import org.compiere.process.DocumentEngine;
import org.compiere.process.ProcessInfo;
import org.compiere.util.Env;
import org.compiere.wf.MWorkflow;
import org.idempiere.test.AbstractTestCase;
import org.idempiere.test.DictionaryIDs;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.Isolated;

@Isolated
public class MatchInvTestIsolated
extends AbstractTestCase {
    @Test
    public void testMatchInvStdCost() {
        MProductCategory category = new MProductCategory(Env.getCtx(), 0, null);
        category.setName("Standard Costing");
        category.saveEx();
        String whereClause = "M_Product_Category_ID=?";
        List categoryAccts = new Query(Env.getCtx(), "M_Product_Category_Acct", whereClause, null).setParameters(new Object[]{category.get_ID()}).list();
        for (MProductCategoryAcct categoryAcct : categoryAccts) {
            categoryAcct.setCostingMethod("S");
            categoryAcct.saveEx();
        }
        int mulchId = DictionaryIDs.M_Product.MULCH.id;
        MProduct mulch = new MProduct(Env.getCtx(), mulchId, null);
        int mulchCategoryId = mulch.getM_Product_Category_ID();
        try {
            MMatchInv[] miList;
            mulch.setM_Product_Category_ID(category.get_ID());
            mulch.saveEx();
            int purchaseId = DictionaryIDs.M_PriceList.PURCHASE.id;
            MBPartner bpartner = MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.SEED_FARM.id);
            MAcctSchema as = MClient.get((int)this.getAD_Client_ID()).getAcctSchema();
            BigDecimal mulchCost = MCost.getCurrentCost((MProduct)mulch, (int)0, (String)this.getTrxName()).setScale(as.getCostingPrecision(), RoundingMode.HALF_UP);
            int hqLocator = DictionaryIDs.M_Locator.HQ.id;
            int costAdjustmentDocTypeId = DictionaryIDs.C_DocType.COST_ADJUSTMENT.id;
            MInventory inventory = new MInventory(Env.getCtx(), 0, this.getTrxName());
            inventory.setCostingMethod("S");
            inventory.setC_DocType_ID(costAdjustmentDocTypeId);
            inventory.setM_Warehouse_ID(this.getM_Warehouse_ID());
            inventory.setMovementDate(this.getLoginDate());
            inventory.setDocAction("CO");
            inventory.saveEx();
            BigDecimal endProductCost = new BigDecimal("2.1234").setScale(as.getCostingPrecision(), RoundingMode.HALF_UP);
            MInventoryLine il = new MInventoryLine(Env.getCtx(), 0, this.getTrxName());
            il.setM_Inventory_ID(inventory.get_ID());
            il.setM_Locator_ID(hqLocator);
            il.setM_Product_ID(mulch.getM_Product_ID());
            il.setCurrentCostPrice(mulchCost);
            il.setNewCostPrice(endProductCost);
            il.saveEx();
            ProcessInfo info = MWorkflow.runDocumentActionWorkflow((PO)inventory, (String)"CO");
            inventory.load(this.getTrxName(), new String[0]);
            Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
            Assertions.assertEquals((Object)"CO", (Object)inventory.getDocStatus(), (String)("Cost Adjustment Status=" + inventory.getDocStatus()));
            if (!inventory.isPosted()) {
                String msg = DocumentEngine.postImmediate((Properties)Env.getCtx(), (int)this.getAD_Client_ID(), (int)321, (int)inventory.get_ID(), (boolean)false, (String)this.getTrxName());
                Assertions.assertNull((Object)msg, (String)msg);
            }
            mulchCost = MCost.getCurrentCost((MProduct)mulch, (int)0, (String)this.getTrxName()).setScale(as.getCostingPrecision(), RoundingMode.HALF_UP);
            Assertions.assertEquals((Object)endProductCost, (Object)mulchCost, (String)("Cost not adjusted: " + mulchCost.toPlainString()));
            MAcctSchema[] schemas = MAcctSchema.getClientAcctSchema((Properties)Env.getCtx(), (int)this.getAD_Client_ID());
            int i = 0;
            while (i < schemas.length) {
                BigDecimal expected = MConversionRate.convert((Properties)Env.getCtx(), (BigDecimal)mulchCost, (int)as.getC_Currency_ID(), (int)schemas[i].getC_Currency_ID(), (Timestamp)inventory.getMovementDate(), (int)0, (int)this.getAD_Client_ID(), (int)this.getAD_Org_ID(), (boolean)true);
                BigDecimal mulchCostConv = MCost.getCurrentCost((MProduct)mulch, (int)0, (MAcctSchema)schemas[i], (int)schemas[i].getAD_Org_ID(), (String)"S", (BigDecimal)BigDecimal.ONE, (int)0, (boolean)true, (String)this.getTrxName()).setScale(schemas[i].getCostingPrecision(), RoundingMode.HALF_UP);
                Assertions.assertEquals((Object)expected, (Object)mulchCostConv, (String)("Converted Cost for schema incorrect: " + schemas[i].toString() + " - " + mulchCostConv.toPlainString()));
                ++i;
            }
            MOrder order = new MOrder(Env.getCtx(), 0, this.getTrxName());
            order.setBPartner(bpartner);
            order.setIsSOTrx(false);
            order.setC_DocTypeTarget_ID();
            order.setM_PriceList_ID(purchaseId);
            order.setDocStatus("DR");
            order.setDocAction("CO");
            order.saveEx();
            MOrderLine orderLine = new MOrderLine(order);
            orderLine.setLine(10);
            orderLine.setProduct(mulch);
            orderLine.setQty(BigDecimal.ONE);
            orderLine.saveEx();
            info = MWorkflow.runDocumentActionWorkflow((PO)order, (String)"CO");
            order.load(this.getTrxName(), new String[0]);
            Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
            Assertions.assertEquals((Object)"CO", (Object)order.getDocStatus());
            MInOut receipt = new MInOut(order, 122, order.getDateOrdered());
            receipt.saveEx();
            MInOutLine receiptLine = new MInOutLine(receipt);
            receiptLine.setC_OrderLine_ID(orderLine.get_ID());
            receiptLine.setLine(10);
            receiptLine.setProduct(mulch);
            receiptLine.setQty(BigDecimal.ONE);
            MWarehouse wh = MWarehouse.get((Properties)Env.getCtx(), (int)receipt.getM_Warehouse_ID());
            int M_Locator_ID = wh.getDefaultLocator().getM_Locator_ID();
            receiptLine.setM_Locator_ID(M_Locator_ID);
            receiptLine.saveEx();
            info = MWorkflow.runDocumentActionWorkflow((PO)receipt, (String)"CO");
            receipt.load(this.getTrxName(), new String[0]);
            Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
            Assertions.assertEquals((Object)"CO", (Object)receipt.getDocStatus());
            if (!receipt.isPosted()) {
                String error = DocumentEngine.postImmediate((Properties)Env.getCtx(), (int)receipt.getAD_Client_ID(), (int)319, (int)receipt.get_ID(), (boolean)false, (String)this.getTrxName());
                Assertions.assertTrue((error == null ? 1 : 0) != 0);
            }
            receipt.load(this.getTrxName(), new String[0]);
            Assertions.assertTrue((boolean)receipt.isPosted());
            MInvoice invoice = new MInvoice(receipt, receipt.getMovementDate());
            invoice.setC_DocTypeTarget_ID("API");
            invoice.setDocStatus("DR");
            invoice.setDocAction("CO");
            invoice.saveEx();
            MInvoiceLine invoiceLine = new MInvoiceLine(invoice);
            invoiceLine.setM_InOutLine_ID(receiptLine.get_ID());
            invoiceLine.setLine(10);
            invoiceLine.setProduct(mulch);
            invoiceLine.setQty(BigDecimal.ONE);
            invoiceLine.saveEx();
            info = MWorkflow.runDocumentActionWorkflow((PO)invoice, (String)"CO");
            invoice.load(this.getTrxName(), new String[0]);
            Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
            Assertions.assertEquals((Object)"CO", (Object)invoice.getDocStatus());
            if (!invoice.isPosted()) {
                String error = DocumentEngine.postImmediate((Properties)Env.getCtx(), (int)invoice.getAD_Client_ID(), (int)318, (int)invoice.get_ID(), (boolean)false, (String)this.getTrxName());
                Assertions.assertTrue((error == null ? 1 : 0) != 0);
            }
            invoice.load(this.getTrxName(), new String[0]);
            Assertions.assertTrue((boolean)invoice.isPosted());
            MMatchInv[] mMatchInvArray = miList = MMatchInv.getInvoiceLine((Properties)Env.getCtx(), (int)invoiceLine.get_ID(), (String)this.getTrxName());
            int n = miList.length;
            int n2 = 0;
            while (n2 < n) {
                MMatchInv mi = mMatchInvArray[n2];
                if (!mi.isPosted()) {
                    String error = DocumentEngine.postImmediate((Properties)Env.getCtx(), (int)mi.getAD_Client_ID(), (int)472, (int)mi.get_ID(), (boolean)false, (String)this.getTrxName());
                    Assertions.assertTrue((error == null ? 1 : 0) != 0);
                }
                mi.load(this.getTrxName(), new String[0]);
                Assertions.assertTrue((boolean)mi.isPosted());
                Doc doc = DocManager.getDocument((MAcctSchema)as, (int)472, (int)mi.get_ID(), (String)this.getTrxName());
                doc.setC_BPartner_ID(mi.getC_InvoiceLine().getC_Invoice().getC_BPartner_ID());
                MAccount acctNIR = doc.getAccount(51, as);
                ProductCost pc = new ProductCost(Env.getCtx(), mi.getM_Product_ID(), mi.getM_AttributeSetInstance_ID(), this.getTrxName());
                MAccount acctInvClr = pc.getAccount(10, as);
                MAccount acctIPV = pc.getAccount(6, as);
                int C_AcctSchema_ID = as.getC_AcctSchema_ID();
                String whereClause2 = "AD_Table_ID=472 AND Record_ID=" + mi.get_ID() + " AND C_AcctSchema_ID=" + C_AcctSchema_ID;
                int[] ids = MFactAcct.getAllIDs((String)"Fact_Acct", (String)whereClause2, (String)this.getTrxName());
                BigDecimal invMatchAmt = invoiceLine.getMatchedQty().multiply(invoiceLine.getPriceActual()).setScale(as.getStdPrecision(), RoundingMode.HALF_UP);
                mulchCost = mulchCost.setScale(as.getStdPrecision(), RoundingMode.HALF_UP);
                int[] nArray = ids;
                int n3 = ids.length;
                int n4 = 0;
                while (n4 < n3) {
                    int id = nArray[n4];
                    MFactAcct fa = new MFactAcct(Env.getCtx(), id, this.getTrxName());
                    if (fa.getAccount_ID() == acctNIR.getAccount_ID()) {
                        Assertions.assertEquals((Object)fa.getAmtAcctDr().setScale(2, RoundingMode.HALF_UP), (Object)mulchCost.setScale(2, RoundingMode.HALF_UP), (String)"");
                    } else if (fa.getAccount_ID() == acctInvClr.getAccount_ID()) {
                        Assertions.assertEquals((Object)fa.getAmtAcctCr().setScale(2, RoundingMode.HALF_UP), (Object)invMatchAmt.setScale(2, RoundingMode.HALF_UP), (String)"");
                    } else if (fa.getAccount_ID() == acctIPV.getAccount_ID()) {
                        Assertions.assertEquals((Object)fa.getAmtAcctDr().subtract(fa.getAmtAcctCr()).setScale(2, RoundingMode.HALF_UP), (Object)invMatchAmt.subtract(mulchCost).setScale(2, RoundingMode.HALF_UP), (String)"");
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        finally {
            this.getTrx().rollback();
            mulch.setM_Product_Category_ID(mulchCategoryId);
            mulch.saveEx();
            category.deleteEx(true);
        }
    }
}

