/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.io.IOException;
import org.zkoss.lang.Objects;
import org.zkoss.zk.au.AuRequest;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.event.CheckEvent;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.ext.Disable;
import org.zkoss.zk.ui.sys.ContentRenderer;
import org.zkoss.zul.impl.LabelImageElement;

public class Checkbox
extends LabelImageElement
implements Disable {
    private Object _value;
    private String _name;
    boolean _checked;
    private boolean _disabled;
    private String _autodisable;
    private boolean _indeterminate;

    public Checkbox() {
    }

    public Checkbox(String label) {
        super(label);
    }

    public Checkbox(String label, String image) {
        super(label, image);
    }

    public boolean isIndeterminate() {
        return this._indeterminate;
    }

    public void setIndeterminate(boolean indeterminate) {
        String mold = this.getMold();
        if ("switch".equals(mold) || "toggle".equals(mold)) {
            throw new UiException("Checkbox switch/toggle mold does not support indeterminate yet." + (Object)((Object)this));
        }
        if (this._indeterminate != indeterminate) {
            this._indeterminate = indeterminate;
            this.smartUpdate("indeterminate", this._indeterminate);
        }
    }

    public String getAutodisable() {
        return this._autodisable;
    }

    public void setAutodisable(String autodisable) {
        if (autodisable == null) {
            autodisable = "";
        }
        if (!Objects.equals((Object)this._autodisable, (Object)autodisable)) {
            this._autodisable = autodisable;
            this.smartUpdate("autodisable", this._autodisable);
        }
    }

    public boolean isDisabled() {
        return this._disabled;
    }

    public void setDisabled(boolean disabled) {
        if (this._disabled != disabled) {
            this._disabled = disabled;
            this.smartUpdate("disabled", this._disabled);
        }
    }

    public boolean isChecked() {
        return this._checked;
    }

    public void setChecked(boolean checked) {
        if (this._checked != checked) {
            this._checked = checked;
            this.smartUpdate("checked", this._checked);
            if (this.isInitialized() && this._indeterminate) {
                this.setIndeterminate(false);
            }
        }
    }

    public State getState() {
        if (this.isIndeterminate()) {
            return State.INDETERMINATE;
        }
        return this.isChecked() ? State.CHECKED : State.UNCHECKED;
    }

    public <T> T getValue() {
        return (T)this._value;
    }

    public <T> void setValue(T value) {
        if (!Objects.equals((Object)this._value, value)) {
            this._value = value;
            this.smartUpdate("value", this._value);
        }
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        if (name != null && name.length() == 0) {
            name = null;
        }
        if (!Objects.equals((Object)this._name, (Object)name)) {
            this._name = name;
            this.smartUpdate("name", this._name);
        }
    }

    protected boolean isChildable() {
        return false;
    }

    public void setMold(String mold) {
        if (this._indeterminate && ("switch".equals(mold) || "toggle".equals(mold))) {
            throw new UiException("Checkbox switch/toggle mold does not support indeterminate yet." + (Object)((Object)this));
        }
        super.setMold(mold);
    }

    public String getZclass() {
        return this._zclass == null ? "z-checkbox" : this._zclass;
    }

    @Override
    protected void renderProperties(ContentRenderer renderer) throws IOException {
        super.renderProperties(renderer);
        if (this._value != null) {
            this.render(renderer, "value", this._value);
        }
        if (this._autodisable != null) {
            this.render(renderer, "autodisable", this._autodisable);
        }
        this.render(renderer, "disabled", this._disabled);
        this.render(renderer, "name", this._name);
        this.render(renderer, "indeterminate", this._indeterminate);
        if (this._checked) {
            this.render(renderer, "checked", this._checked);
        }
    }

    public void service(AuRequest request, boolean everError) {
        String cmd = request.getCommand();
        if (cmd.equals("onCheck")) {
            CheckEvent evt = CheckEvent.getCheckEvent((AuRequest)request);
            if ("tristate".equals(this.getMold())) {
                Boolean state = evt.getState();
                this._checked = state != null && state != false;
                this._indeterminate = state == null;
            } else {
                this._checked = evt.isChecked();
                this._indeterminate = false;
            }
            Events.postEvent((Event)evt);
        } else {
            super.service(request, everError);
        }
    }

    protected void updateByClient(String name, Object value) {
        if ("disabled".equals(name)) {
            this.setDisabled(value instanceof Boolean ? ((Boolean)value).booleanValue() : "true".equals(Objects.toString((Object)value)));
        } else {
            super.updateByClient(name, value);
        }
    }

    static {
        Checkbox.addClientEvent(Checkbox.class, (String)"onCheck", (int)16385);
        Checkbox.addClientEvent(Checkbox.class, (String)"onFocus", (int)8192);
        Checkbox.addClientEvent(Checkbox.class, (String)"onBlur", (int)8192);
    }

    public static enum State {
        CHECKED,
        UNCHECKED,
        INDETERMINATE;

    }
}

