/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver.json.binary;

import oracle.jdbc.driver.json.binary.OsonAbstractArray;
import oracle.jdbc.driver.json.binary.OsonAbstractObject;
import oracle.jdbc.driver.json.binary.OsonArrayImpl;
import oracle.jdbc.driver.json.binary.OsonContext;
import oracle.jdbc.driver.json.binary.OsonObjectImpl;
import oracle.jdbc.driver.json.binary.OsonValueFactory;
import oracle.jdbc.driver.json.tree.OracleJsonBinaryImpl;
import oracle.jdbc.driver.json.tree.OracleJsonDateImpl;
import oracle.jdbc.driver.json.tree.OracleJsonDecimalImpl;
import oracle.jdbc.driver.json.tree.OracleJsonDoubleImpl;
import oracle.jdbc.driver.json.tree.OracleJsonFloatImpl;
import oracle.jdbc.driver.json.tree.OracleJsonIntervalDSImpl;
import oracle.jdbc.driver.json.tree.OracleJsonIntervalYMImpl;
import oracle.jdbc.driver.json.tree.OracleJsonStringImpl;
import oracle.jdbc.driver.json.tree.OracleJsonStringNumberImpl;
import oracle.jdbc.driver.json.tree.OracleJsonTimestampImpl;
import oracle.jdbc.driver.json.tree.OracleJsonTimestampTZImpl;
import oracle.sql.json.OracleJsonDecimal;
import oracle.sql.json.OracleJsonValue;

public class OracleOsonValueFactory
extends OsonValueFactory {
    public static OracleOsonValueFactory INSTANCE = new OracleOsonValueFactory();

    @Override
    public OsonAbstractArray createArray(OsonContext osonContext, int n2) {
        return new OsonArrayImpl(osonContext, n2);
    }

    @Override
    public OsonAbstractObject createObject(OsonContext osonContext, int n2) {
        return new OsonObjectImpl(osonContext, n2);
    }

    @Override
    public Object createString(OsonContext osonContext, int n2, int n3) {
        osonContext.b.position(n2);
        return new OracleJsonStringImpl(osonContext.b.readString(n3));
    }

    @Override
    public OracleJsonDecimalImpl createNumber(byte[] byArray, OracleJsonDecimal.TargetType targetType) {
        return new OracleJsonDecimalImpl(byArray, targetType);
    }

    @Override
    public OracleJsonStringNumberImpl createStringNumber(String string) {
        return new OracleJsonStringNumberImpl(string);
    }

    @Override
    public OracleJsonDoubleImpl createDouble(double d2) {
        return new OracleJsonDoubleImpl(d2);
    }

    @Override
    public OracleJsonBinaryImpl createBinary(byte[] byArray, boolean bl) {
        return new OracleJsonBinaryImpl(byArray, bl);
    }

    @Override
    public OracleJsonTimestampImpl createTimestamp(byte[] byArray) {
        return new OracleJsonTimestampImpl(byArray);
    }

    @Override
    public OracleJsonTimestampTZImpl createTimestampTZ(byte[] byArray) {
        return new OracleJsonTimestampTZImpl(byArray);
    }

    @Override
    public OracleJsonFloatImpl createFloat(float f2) {
        return new OracleJsonFloatImpl(f2);
    }

    @Override
    public OracleJsonDateImpl createDate(byte[] byArray) {
        return new OracleJsonDateImpl(byArray);
    }

    @Override
    public OracleJsonIntervalYMImpl createIntervalYM(byte[] byArray) {
        return new OracleJsonIntervalYMImpl(byArray);
    }

    @Override
    public OracleJsonIntervalDSImpl createIntervalDS(byte[] byArray) {
        return new OracleJsonIntervalDSImpl(byArray);
    }

    @Override
    public OracleJsonValue createTrue() {
        return OracleJsonValue.TRUE;
    }

    @Override
    public OracleJsonValue createFalse() {
        return OracleJsonValue.FALSE;
    }

    @Override
    public OracleJsonValue createNull() {
        return OracleJsonValue.NULL;
    }
}

