/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.store.kahadb.scheduler.legacy;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.activemq.store.kahadb.disk.index.BTreeIndex;
import org.apache.activemq.store.kahadb.disk.journal.Location;
import org.apache.activemq.store.kahadb.disk.page.Transaction;
import org.apache.activemq.store.kahadb.disk.util.LongMarshaller;
import org.apache.activemq.store.kahadb.disk.util.VariableMarshaller;
import org.apache.activemq.store.kahadb.scheduler.legacy.LegacyJobImpl;
import org.apache.activemq.store.kahadb.scheduler.legacy.LegacyJobLocation;
import org.apache.activemq.store.kahadb.scheduler.legacy.LegacyJobSchedulerStoreImpl;
import org.apache.activemq.util.ByteSequence;
import org.apache.activemq.util.ServiceStopper;
import org.apache.activemq.util.ServiceSupport;

final class LegacyJobSchedulerImpl
extends ServiceSupport {
    private final LegacyJobSchedulerStoreImpl store;
    private String name;
    private BTreeIndex<Long, List<LegacyJobLocation>> index;

    LegacyJobSchedulerImpl(LegacyJobSchedulerStoreImpl store) {
        this.store = store;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public long getNextScheduleTime() throws IOException {
        Map.Entry<Long, List<LegacyJobLocation>> first = this.index.getFirst(this.store.getPageFile().tx());
        return first != null ? first.getKey() : -1L;
    }

    public List<LegacyJobImpl> getNextScheduleJobs() throws IOException {
        final ArrayList<LegacyJobImpl> result = new ArrayList<LegacyJobImpl>();
        this.store.getPageFile().tx().execute(new Transaction.Closure<IOException>(){

            @Override
            public void execute(Transaction tx) throws IOException {
                Map.Entry first = LegacyJobSchedulerImpl.this.index.getFirst(LegacyJobSchedulerImpl.this.store.getPageFile().tx());
                if (first != null) {
                    for (LegacyJobLocation jl : (List)first.getValue()) {
                        ByteSequence bs = LegacyJobSchedulerImpl.this.getPayload(jl.getLocation());
                        LegacyJobImpl job = new LegacyJobImpl(jl, bs);
                        result.add(job);
                    }
                }
            }
        });
        return result;
    }

    public List<LegacyJobImpl> getAllJobs() throws IOException {
        final ArrayList<LegacyJobImpl> result = new ArrayList<LegacyJobImpl>();
        this.store.getPageFile().tx().execute(new Transaction.Closure<IOException>(){

            @Override
            public void execute(Transaction tx) throws IOException {
                Map.Entry next;
                Iterator iter = LegacyJobSchedulerImpl.this.index.iterator(LegacyJobSchedulerImpl.this.store.getPageFile().tx());
                while (iter.hasNext() && (next = iter.next()) != null) {
                    for (LegacyJobLocation jl : (List)next.getValue()) {
                        ByteSequence bs = LegacyJobSchedulerImpl.this.getPayload(jl.getLocation());
                        LegacyJobImpl job = new LegacyJobImpl(jl, bs);
                        result.add(job);
                    }
                }
            }
        });
        return result;
    }

    public List<LegacyJobImpl> getAllJobs(final long start, final long finish) throws IOException {
        final ArrayList<LegacyJobImpl> result = new ArrayList<LegacyJobImpl>();
        this.store.getPageFile().tx().execute(new Transaction.Closure<IOException>(){

            @Override
            public void execute(Transaction tx) throws IOException {
                Map.Entry next;
                Iterator iter = LegacyJobSchedulerImpl.this.index.iterator(LegacyJobSchedulerImpl.this.store.getPageFile().tx(), start);
                while (iter.hasNext() && (next = iter.next()) != null && next.getKey() <= finish) {
                    for (LegacyJobLocation jl : (List)next.getValue()) {
                        ByteSequence bs = LegacyJobSchedulerImpl.this.getPayload(jl.getLocation());
                        LegacyJobImpl job = new LegacyJobImpl(jl, bs);
                        result.add(job);
                    }
                }
            }
        });
        return result;
    }

    ByteSequence getPayload(Location location) throws IllegalStateException, IOException {
        return this.store.getPayload(location);
    }

    public String toString() {
        return "LegacyJobScheduler: " + this.name;
    }

    protected void doStart() throws Exception {
    }

    protected void doStop(ServiceStopper stopper) throws Exception {
    }

    void createIndexes(Transaction tx) throws IOException {
        this.index = new BTreeIndex(this.store.getPageFile(), tx.allocate().getPageId());
    }

    void load(Transaction tx) throws IOException {
        this.index.setKeyMarshaller(LongMarshaller.INSTANCE);
        this.index.setValueMarshaller(ValueMarshaller.INSTANCE);
        this.index.load(tx);
    }

    void read(DataInput in) throws IOException {
        this.name = in.readUTF();
        this.index = new BTreeIndex(this.store.getPageFile(), in.readLong());
        this.index.setKeyMarshaller(LongMarshaller.INSTANCE);
        this.index.setValueMarshaller(ValueMarshaller.INSTANCE);
    }

    public void write(DataOutput out) throws IOException {
        out.writeUTF(this.name);
        out.writeLong(this.index.getPageId());
    }

    static class ValueMarshaller
    extends VariableMarshaller<List<LegacyJobLocation>> {
        static ValueMarshaller INSTANCE = new ValueMarshaller();

        ValueMarshaller() {
        }

        @Override
        public List<LegacyJobLocation> readPayload(DataInput dataIn) throws IOException {
            ArrayList<LegacyJobLocation> result = new ArrayList<LegacyJobLocation>();
            int size = dataIn.readInt();
            for (int i = 0; i < size; ++i) {
                LegacyJobLocation jobLocation = new LegacyJobLocation();
                jobLocation.readExternal(dataIn);
                result.add(jobLocation);
            }
            return result;
        }

        @Override
        public void writePayload(List<LegacyJobLocation> value, DataOutput dataOut) throws IOException {
            dataOut.writeInt(value.size());
            for (LegacyJobLocation jobLocation : value) {
                jobLocation.writeExternal(dataOut);
            }
        }
    }
}

