/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.zk.pivot;

import com.google.common.net.MediaType;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Iterator;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.print.MPrintFormat;
import org.compiere.print.MPrintFormatItem;
import org.compiere.print.PrintData;
import org.compiere.print.PrintDataElement;
import org.compiere.print.ReportEngine;
import org.compiere.util.CLogger;
import org.compiere.util.DisplayType;
import org.compiere.util.Ini;
import org.compiere.util.Language;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.idempiere.print.renderer.IReportRenderer;
import org.idempiere.zk.pivot.PivotReportRendererConfiguration;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.osgi.service.component.annotations.Component;
import org.zkoss.zk.ui.Executions;

@Component(service={IReportRenderer.class}, immediate=true)
public class PivotReportRenderer
implements IReportRenderer<PivotReportRendererConfiguration> {
    private static final CLogger log = CLogger.getCLogger(PivotReportRenderer.class);

    public String getId() {
        return "Pivot";
    }

    public String getName() {
        return this.getId();
    }

    public String getContentType() {
        return MediaType.HTML_UTF_8.toString();
    }

    public String getFileExtension() {
        return "pivot.html";
    }

    public void renderReport(ReportEngine reportEngine, PivotReportRendererConfiguration configuration) {
        try {
            Language lang = configuration.getLanguage();
            if (lang == null) {
                lang = Language.getLoginLanguage();
            }
            Writer fw = null;
            fw = configuration.getOutputFile() != null ? new OutputStreamWriter((OutputStream)new FileOutputStream(configuration.getOutputFile(), false), Ini.getCharset()) : configuration.getOutputWriter();
            this.createHTML(reportEngine, new BufferedWriter(fw), lang, configuration.isExport());
        }
        catch (FileNotFoundException fnfe) {
            log.log(Level.SEVERE, "(f) - " + fnfe.toString());
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "(f)", (Throwable)e);
            throw new AdempiereException((Throwable)e);
        }
    }

    private void createHTML(ReportEngine reportEngine, BufferedWriter bw, Language lang, boolean export) {
        PrintData printData = reportEngine.getPrintData();
        MPrintFormat printFormat = reportEngine.getPrintFormat();
        PrintWriter w = new PrintWriter(bw);
        try {
            if (lang == null) {
                lang = Language.getLoginLanguage();
            }
            w.println("<!DOCTYPE html>\n<html>\n    <head>\n\t\t<meta charset=\"utf-8\"/> \t\t<link rel=\"stylesheet\" type=\"text/css\" href=\"https://cdnjs.cloudflare.com/ajax/libs/c3/0.4.11/c3.min.css\">\n        <script type=\"text/javascript\" src=\"https://cdnjs.cloudflare.com/ajax/libs/d3/3.5.5/d3.min.js\"></script>\n        <script type=\"text/javascript\" src=\"https://cdnjs.cloudflare.com/ajax/libs/c3/0.4.11/c3.min.js\"></script>\n        <script type=\"text/javascript\" src=\"https://cdnjs.cloudflare.com/ajax/libs/jquery/1.11.2/jquery.min.js\"></script>\n        <script type=\"text/javascript\" src=\"https://cdnjs.cloudflare.com/ajax/libs/jqueryui/1.11.4/jquery-ui.min.js\"></script>\n");
            this.appendStyle(w, export, "~./js/pivot/pivot.css");
            this.appendScript(w, export, "~./js/pivot/pivot.js");
            this.appendScript(w, export, "~./js/pivot/c3_renderers.js");
            w.println("        <style>\n            body {font-family: Verdana;}\n            .c3-line, .c3-focused {stroke-width: 3px !important;}\n            .c3-bar {stroke: white !important; stroke-width: 1;}\n            .c3 text { font-size: 12px; color: grey;}\n            .tick line {stroke: white;}\n            .c3-axis path {stroke: grey;}\n            .c3-circle { opacity: 1 !important; }\n            .c3-xgrid-focus {visibility: hidden !important;}\n        </style>\n        <!-- optional: mobile support with jqueryui-touch-punch -->\n        <script type=\"text/javascript\" src=\"https://cdnjs.cloudflare.com/ajax/libs/jqueryui-touch-punch/0.2.3/jquery.ui.touch-punch.min.js\"></script>\n");
            JSONObject derivedAttributes = new JSONObject();
            JSONArray ja = new JSONArray();
            int row = 0;
            while (row < printData.getRowCount()) {
                JSONObject jo = new JSONObject();
                printData.setRowIndex(row);
                if (!printData.isFunctionRow()) {
                    int col = 0;
                    while (col < printFormat.getItemCount()) {
                        Object obj;
                        String printName;
                        MPrintFormatItem item = printFormat.getItem(col);
                        if (item.isPrinted() && !Util.isEmpty((String)(printName = item.getPrintName(lang))) && (obj = printData.getNodeByPrintFormatItem(item)) instanceof PrintDataElement) {
                            PrintDataElement pde = (PrintDataElement)obj;
                            String value = pde.getValueDisplay(lang);
                            if (pde.isDate()) {
                                this.putPivotAttributes(derivedAttributes, item.getPrintName(lang), lang);
                                value = pde.getValueAsString();
                            }
                            if (DisplayType.isNumeric((int)pde.getDisplayType())) {
                                value = pde.getValueAsString();
                            }
                            jo.append(printName, (Object)value);
                        }
                        ++col;
                    }
                    ja.put((Object)jo);
                }
                ++row;
            }
            w.println();
            w.println("<script type=\"text/javascript\">\n    $(function(){\n\tlet jsonObject = " + ja.toString() + ";\n   let derivers = $.pivotUtilities.derivers;\n");
            if (derivedAttributes.keys().hasNext()) {
                w.println(" let dateFormat = $.pivotUtilities.derivers.dateFormat;\n");
            }
            w.println("        let renderers = $.extend($.pivotUtilities.renderers,\n            $.pivotUtilities.c3_renderers);\n\t\t\t$(\"#output\").pivotUI(jsonObject, {\n");
            if (derivedAttributes.keys().hasNext()) {
                w.println("       derivedAttributes: { \n");
                Iterator keys = derivedAttributes.keys();
                while (keys.hasNext()) {
                    String key = (String)keys.next();
                    String dateFormatString = derivedAttributes.getString(key);
                    w.println(" \"" + key + "\": " + dateFormatString);
                    if (keys.hasNext()) {
                        w.println(", ");
                    }
                    w.println("\n");
                }
                w.println(" }, \n");
            }
            w.println("\t  renderers: renderers,\n\t           cols: [\"\"], rows: [\"\"],\n\t           rendererName: \"Horizontal Stacked Bar Chart\",\n\t           rowOrder: \"value_z_to_a\", colOrder: \"value_z_to_a\",\n\t           rendererOptions: {\n\t                c3: { data: {colors: {\n\t                        Liberal: '#dc3912', Conservative: '#3366cc', NDP: '#ff9900',\n\t                        Green:'#109618', 'Bloc Quebecois': '#990099'\n\t                    }}}\n\t           }\n\t     });\n\t });\n\t</script>\n\t</head>\n    <body>\n        <div id=\"output\" style=\"margin: 30px;\"></div>\n    </body>\n</html>\n");
            w.flush();
            w.close();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "(w)", (Throwable)e);
        }
    }

    private void putPivotAttributes(JSONObject derivedAttributes, String dateName, Language language) {
        try {
            derivedAttributes.put(dateName + "(" + Msg.translate((Language)language, (String)"CalendarYear") + ")", (Object)("dateFormat(\"" + dateName + "\", \"%y\", true)"));
            derivedAttributes.put(dateName + "(" + Msg.translate((Language)language, (String)"Month") + ")", (Object)("dateFormat(\"" + dateName + "\", \"%m-%n\", true)"));
        }
        catch (JSONException e) {
            log.log(Level.SEVERE, "(w)", (Throwable)e);
        }
    }

    public boolean isBinary() {
        return false;
    }

    public Class<PivotReportRendererConfiguration> getConfigurationType() {
        return PivotReportRendererConfiguration.class;
    }

    private void appendStyle(PrintWriter writer, boolean isExport, String csslink) throws IOException, URISyntaxException {
        if (isExport) {
            URL url = this.getClass().getResource(csslink.replace("~./", "/web/"));
            writer.println("<style>");
            writer.println(this.readResource(url).toString());
            writer.println("</style>");
        } else {
            writer.print("<link rel=\"stylesheet\" type=\"text/css\" href=\"");
            writer.print(Executions.encodeURL((String)csslink));
            writer.println("\">");
        }
    }

    private void appendScript(PrintWriter writer, boolean isExport, String scriptlink) throws IOException, URISyntaxException {
        if (isExport) {
            URL url = this.getClass().getResource(scriptlink.replace("~./", "/web/"));
            writer.println("<script language='javascript'>");
            writer.println(this.readResource(url).toString());
            writer.println("</script>");
        } else {
            writer.print("<script type=\"text/javascript\" src=\"");
            writer.print(Executions.encodeURL((String)scriptlink));
            writer.println("\"/>");
        }
    }

    private StringBuilder readResource(URL url) throws IOException {
        String line;
        StringBuilder builder = new StringBuilder();
        InputStream is = url.openStream();
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        while ((line = reader.readLine()) != null) {
            builder.append(line);
        }
        reader.close();
        return builder;
    }
}

