/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.ui.sso.oidc.service;

import com.nimbusds.oauth2.sdk.AuthorizationCode;
import com.nimbusds.oauth2.sdk.AuthorizationCodeGrant;
import com.nimbusds.oauth2.sdk.AuthorizationGrant;
import com.nimbusds.oauth2.sdk.GeneralException;
import com.nimbusds.oauth2.sdk.ResponseType;
import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.oauth2.sdk.TokenErrorResponse;
import com.nimbusds.oauth2.sdk.TokenRequest;
import com.nimbusds.oauth2.sdk.TokenResponse;
import com.nimbusds.oauth2.sdk.auth.ClientAuthentication;
import com.nimbusds.oauth2.sdk.auth.ClientSecretBasic;
import com.nimbusds.oauth2.sdk.auth.Secret;
import com.nimbusds.oauth2.sdk.http.HTTPResponse;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.oauth2.sdk.id.Issuer;
import com.nimbusds.oauth2.sdk.id.State;
import com.nimbusds.oauth2.sdk.token.AccessToken;
import com.nimbusds.oauth2.sdk.token.BearerAccessToken;
import com.nimbusds.openid.connect.sdk.AuthenticationErrorResponse;
import com.nimbusds.openid.connect.sdk.AuthenticationRequest;
import com.nimbusds.openid.connect.sdk.AuthenticationResponse;
import com.nimbusds.openid.connect.sdk.AuthenticationResponseParser;
import com.nimbusds.openid.connect.sdk.AuthenticationSuccessResponse;
import com.nimbusds.openid.connect.sdk.Nonce;
import com.nimbusds.openid.connect.sdk.OIDCTokenResponse;
import com.nimbusds.openid.connect.sdk.OIDCTokenResponseParser;
import com.nimbusds.openid.connect.sdk.Prompt;
import com.nimbusds.openid.connect.sdk.UserInfoRequest;
import com.nimbusds.openid.connect.sdk.UserInfoResponse;
import com.nimbusds.openid.connect.sdk.claims.UserInfo;
import com.nimbusds.openid.connect.sdk.op.OIDCProviderMetadata;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.ParseException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.adempiere.base.sso.ISSOPrincipalService;
import org.compiere.model.I_SSO_PrincipalConfig;
import org.compiere.model.MSysConfig;
import org.compiere.util.Language;
import org.compiere.util.Util;

public class OIDCPrincipalService
implements ISSOPrincipalService {
    private static final String AUTHENTICATION_CODE_PARAMETER = "code";
    private static final String OIDC_STATE = "oidc.state";
    private I_SSO_PrincipalConfig principalConfig;
    private OIDCProviderMetadata metaData = null;

    public OIDCPrincipalService(I_SSO_PrincipalConfig principleConfig) {
        this.principalConfig = principleConfig;
    }

    public String getUserName(Object principalObject) throws ParseException {
        if (principalObject != null && principalObject instanceof UserInfo) {
            boolean isEmailLogin = MSysConfig.getBooleanValue((String)"USE_EMAIL_FOR_LOGIN", (boolean)false);
            UserInfo userInfo = (UserInfo)principalObject;
            if (isEmailLogin) {
                return userInfo.getEmailAddress();
            }
            return userInfo.getName();
        }
        return null;
    }

    public Language getLanguage(Object principalObject) throws ParseException {
        return Language.getBaseLanguage();
    }

    public boolean hasAuthenticationCode(HttpServletRequest request, HttpServletResponse response) {
        String code = request.getParameter(AUTHENTICATION_CODE_PARAMETER);
        return !Util.isEmpty((String)code, (boolean)true);
    }

    public void getAuthenticationToken(HttpServletRequest request, HttpServletResponse response, String redirectMode) throws Throwable {
        Object url = request.getRequestURL().toString();
        String query = request.getQueryString();
        if (query != null) {
            url = (String)url + "?" + query;
        }
        AuthenticationResponse authResponse = AuthenticationResponseParser.parse((URI)new URI((String)url));
        State state = (State)request.getSession().getAttribute(OIDC_STATE);
        if (!state.equals((Object)authResponse.getState())) {
            request.getSession().removeAttribute(OIDC_STATE);
            response.sendRedirect(this.getRedirectURL(this.principalConfig, redirectMode));
            return;
        }
        if (!authResponse.indicatesSuccess()) {
            AuthenticationErrorResponse errorResponse = authResponse.toErrorResponse();
            throw new RuntimeException(errorResponse.toString());
        }
        AuthenticationSuccessResponse successResponse = authResponse.toSuccessResponse();
        AuthorizationCode authorizationCode = successResponse.getAuthorizationCode();
        URI redirectURI = new URI(this.getRedirectURL(this.principalConfig, redirectMode));
        AuthorizationCodeGrant authorizationGrant = new AuthorizationCodeGrant(authorizationCode, redirectURI);
        TokenResponse tokenResponse = this.issueTokenRequest((AuthorizationGrant)authorizationGrant);
        this.processTokenResponse(request, tokenResponse, true);
    }

    private String getRedirectURL(I_SSO_PrincipalConfig principalConfig, String clientType) {
        if ("SSO_MODE_WEBUI".equals(clientType)) {
            return principalConfig.getSSO_ApplicationRedirectURIs();
        }
        if ("SSO_MODE_MONITOR".equals(clientType)) {
            return principalConfig.getSSO_IDempMonitorRedirectURIs();
        }
        if ("SSO_MODE_OSGI".equals(clientType)) {
            return principalConfig.getSSO_OSGIRedirectURIs();
        }
        return null;
    }

    private void processTokenResponse(HttpServletRequest request, TokenResponse tokenResponse, boolean getUserInfo) throws URISyntaxException, IOException, GeneralException {
        if (!tokenResponse.indicatesSuccess()) {
            TokenErrorResponse errorResponse = tokenResponse.toErrorResponse();
            throw new RuntimeException(errorResponse.toJSONObject().toJSONString());
        }
        OIDCTokenResponse oidcTokenResponse = (OIDCTokenResponse)tokenResponse.toSuccessResponse();
        AccessToken accessToken = oidcTokenResponse.getOIDCTokens().getAccessToken();
        if (getUserInfo) {
            BearerAccessToken bearerAccessToken;
            String userInfoURL = this.getMetaData().getUserInfoEndpointURI().toString();
            URI userInfoEndpoint = new URI(userInfoURL);
            HTTPResponse httpResponse = new UserInfoRequest(userInfoEndpoint, (AccessToken)(bearerAccessToken = new BearerAccessToken(accessToken.getValue()))).toHTTPRequest().send();
            UserInfoResponse userInfoResponse = UserInfoResponse.parse((HTTPResponse)httpResponse);
            if (!userInfoResponse.indicatesSuccess()) {
                throw new RuntimeException(userInfoResponse.toErrorResponse().toString());
            }
            UserInfo userInfo = userInfoResponse.toSuccessResponse().getUserInfo();
            this.setAuthenticationResult(request.getSession(), userInfo);
        }
    }

    private OIDCProviderMetadata getMetaData() throws GeneralException, IOException {
        if (this.metaData == null) {
            String discoveryURI = this.principalConfig.getSSO_ApplicationDiscoveryURI();
            Issuer issuer = new Issuer(discoveryURI.substring(0, discoveryURI.indexOf("/.well-known/openid-configuration")));
            this.metaData = OIDCProviderMetadata.resolve((Issuer)issuer);
        }
        return this.metaData;
    }

    private TokenResponse issueTokenRequest(AuthorizationGrant authorizationGrant) throws URISyntaxException, IOException, GeneralException {
        ClientID clientID = new ClientID(this.principalConfig.getSSO_ApplicationClientID());
        Secret clientSecret = new Secret(this.principalConfig.getSSO_ApplicationSecretKey());
        ClientSecretBasic clientAuth = new ClientSecretBasic(clientID, clientSecret);
        String tokenEndpointURL = this.getMetaData().getTokenEndpointURI().toString();
        URI tokenEndpoint = new URI(tokenEndpointURL);
        TokenRequest tokenRequest = new TokenRequest(tokenEndpoint, (ClientAuthentication)clientAuth, authorizationGrant);
        return OIDCTokenResponseParser.parse((HTTPResponse)tokenRequest.toHTTPRequest().send());
    }

    private void setAuthenticationResult(HttpSession session, UserInfo userInfo) {
        session.setAttribute("sso.principal.token", (Object)userInfo);
    }

    public boolean isAuthenticated(HttpServletRequest request, HttpServletResponse response) {
        return request.getSession().getAttribute("sso.principal.token") != null;
    }

    public void redirectForAuthentication(HttpServletRequest request, HttpServletResponse response, String redirectMode) throws IOException {
        AuthenticationRequest authRequest = null;
        try {
            String url = this.getMetaData().getAuthorizationEndpointURI().toString();
            authRequest = new AuthenticationRequest.Builder(new ResponseType(new String[]{AUTHENTICATION_CODE_PARAMETER}), new Scope(new String[]{"openid", "profile", "email"}), new ClientID(this.principalConfig.getSSO_ApplicationClientID()), new URI(this.getRedirectURL(this.principalConfig, redirectMode))).state(new State()).nonce(new Nonce()).prompt(new Prompt(new Prompt.Type[]{Prompt.Type.LOGIN})).endpointURI(new URI(url)).build();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        catch (GeneralException e) {
            throw new RuntimeException(e);
        }
        request.getSession().setAttribute(OIDC_STATE, (Object)authRequest.getState());
        URI redirectURI = authRequest.toURI();
        response.sendRedirect(redirectURI.toURL().toString());
    }

    public void removePrincipalFromSession(HttpServletRequest httpRequest) {
        httpRequest.getSession().removeAttribute("sso.principal.token");
        httpRequest.getSession().removeAttribute(OIDC_STATE);
    }
}

