/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.test.model;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Timestamp;
import java.util.List;
import java.util.Properties;
import org.compiere.model.MAccount;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MBPartner;
import org.compiere.model.MClient;
import org.compiere.model.MCost;
import org.compiere.model.MCostElement;
import org.compiere.model.MFactAcct;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutLine;
import org.compiere.model.MInventory;
import org.compiere.model.MInventoryLine;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MPInstance;
import org.compiere.model.MPInstancePara;
import org.compiere.model.MProcess;
import org.compiere.model.MProduct;
import org.compiere.model.MProductCategory;
import org.compiere.model.MProductCategoryAcct;
import org.compiere.model.MProduction;
import org.compiere.model.MStorageOnHand;
import org.compiere.model.PO;
import org.compiere.model.ProductCost;
import org.compiere.model.Query;
import org.compiere.process.DocumentEngine;
import org.compiere.process.ProcessInfo;
import org.compiere.process.ServerProcessCtl;
import org.compiere.util.Env;
import org.compiere.util.TimeUtil;
import org.compiere.util.Trx;
import org.compiere.wf.MWorkflow;
import org.eevolution.model.MPPProductBOM;
import org.eevolution.model.MPPProductBOMLine;
import org.idempiere.test.AbstractTestCase;
import org.idempiere.test.DictionaryIDs;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.junit.jupiter.api.parallel.Isolated;

@Isolated
@Execution(value=ExecutionMode.SAME_THREAD)
public class ProductionTestIsolated
extends AbstractTestCase {
    @Test
    public void testAverageCostingProduction() {
        int mulchId = 137;
        int hqLocator = 101;
        this.createPOAndMRForProduct(mulchId);
        MProduct mulch = MProduct.get((int)mulchId);
        BigDecimal componentOnHand1 = MStorageOnHand.getQtyOnHand((int)mulchId, (int)this.getM_Warehouse_ID(), (int)0, (String)this.getTrxName());
        BigDecimal componentCost = MCost.getCurrentCost((MProduct)mulch, (int)0, (String)this.getTrxName());
        MProduct mulchX = new MProduct(Env.getCtx(), 0, this.getTrxName());
        mulchX.setName("Mulch X");
        mulchX.setIsBOM(true);
        mulchX.setIsStocked(true);
        mulchX.setC_UOM_ID(mulch.getC_UOM_ID());
        mulchX.setM_Product_Category_ID(mulch.getM_Product_Category_ID());
        mulchX.setProductType(mulch.getProductType());
        mulchX.setM_AttributeSet_ID(mulch.getM_AttributeSet_ID());
        mulchX.setC_TaxCategory_ID(mulch.getC_TaxCategory_ID());
        mulchX.saveEx();
        BigDecimal endProductOnHand1 = MStorageOnHand.getQtyOnHand((int)mulchX.get_ID(), (int)this.getM_Warehouse_ID(), (int)0, (String)this.getTrxName());
        MPPProductBOM bom = new MPPProductBOM(Env.getCtx(), 0, this.getTrxName());
        bom.setM_Product_ID(mulchX.get_ID());
        bom.setBOMType("A");
        bom.setBOMUse("A");
        bom.setName(mulchX.getName());
        bom.saveEx();
        MPPProductBOMLine line = new MPPProductBOMLine(bom);
        line.setM_Product_ID(mulchId);
        line.setQtyBOM(new BigDecimal("1"));
        line.saveEx();
        mulchX.load(this.getTrxName(), new String[0]);
        mulchX.setIsVerified(true);
        mulchX.saveEx();
        MProduction production = new MProduction(Env.getCtx(), 0, this.getTrxName());
        production.setM_Product_ID(mulchX.get_ID());
        production.setM_Locator_ID(hqLocator);
        production.setIsUseProductionPlan(false);
        production.setMovementDate(this.getLoginDate());
        production.setDocAction("CO");
        production.setDocStatus("DR");
        production.setIsComplete(false);
        production.setProductionQty(new BigDecimal("1"));
        production.setPP_Product_BOM_ID(bom.getPP_Product_BOM_ID());
        production.saveEx();
        int productionCreate = 53226;
        MProcess process = MProcess.get((Properties)Env.getCtx(), (int)productionCreate);
        ProcessInfo pi = new ProcessInfo(process.getName(), process.get_ID());
        pi.setAD_Client_ID(this.getAD_Client_ID());
        pi.setAD_User_ID(this.getAD_User_ID());
        pi.setRecord_ID(production.get_ID());
        pi.setTransactionName(this.getTrxName());
        ServerProcessCtl.process((ProcessInfo)pi, (Trx)this.getTrx(), (boolean)false);
        Assertions.assertFalse((boolean)pi.isError(), (String)pi.getSummary());
        production.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((Object)"Y", (Object)production.getIsCreated(), (String)"MProduction.IsCreated != Y");
        Assertions.assertTrue((production.getLines().length > 0 ? 1 : 0) != 0, (String)"No Production Lines");
        ProcessInfo info = MWorkflow.runDocumentActionWorkflow((PO)production, (String)"CO");
        production.load(this.getTrxName(), new String[0]);
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        Assertions.assertEquals((Object)"CO", (Object)production.getDocStatus(), (String)("Production Status=" + production.getDocStatus()));
        BigDecimal componentOnHand2 = MStorageOnHand.getQtyOnHand((int)mulchId, (int)this.getM_Warehouse_ID(), (int)0, (String)this.getTrxName());
        BigDecimal endProductOnHand2 = MStorageOnHand.getQtyOnHand((int)mulchX.get_ID(), (int)this.getM_Warehouse_ID(), (int)0, (String)this.getTrxName());
        BigDecimal componentChange = componentOnHand2.subtract(componentOnHand1).setScale(0);
        BigDecimal endProductChange = endProductOnHand2.subtract(endProductOnHand1).setScale(0);
        Assertions.assertEquals((Object)new BigDecimal("-1"), (Object)componentChange, (String)"On hand of component doesn't reduce as expected");
        Assertions.assertEquals((Object)new BigDecimal("1"), (Object)endProductChange, (String)"On hand of end product doesn't increase as expected");
        if (!production.isPosted()) {
            String msg = DocumentEngine.postImmediate((Properties)Env.getCtx(), (int)this.getAD_Client_ID(), (int)325, (int)production.get_ID(), (boolean)false, (String)this.getTrxName());
            Assertions.assertNull((Object)msg, (String)msg);
        }
        BigDecimal endProductCost = MCost.getCurrentCost((MProduct)mulchX, (int)0, (String)this.getTrxName());
        MAcctSchema as = MClient.get((int)this.getAD_Client_ID()).getAcctSchema();
        componentCost = componentCost.setScale(as.getCostingPrecision(), RoundingMode.HALF_UP);
        endProductCost = endProductCost.setScale(as.getCostingPrecision(), RoundingMode.HALF_UP);
        Assertions.assertEquals((Object)componentCost, (Object)endProductCost, (String)"Cost not roll up correctly");
    }

    @Test
    public void testStandardCostingProduction() {
        MProductCategory category = new MProductCategory(Env.getCtx(), 0, null);
        category.setName("Standard Costing");
        category.saveEx();
        Object whereClause = "M_Product_Category_ID=?";
        List categoryAccts = new Query(Env.getCtx(), "M_Product_Category_Acct", (String)whereClause, null).setParameters(new Object[]{category.get_ID()}).list();
        for (MProductCategoryAcct categoryAcct : categoryAccts) {
            categoryAcct.setCostingMethod("S");
            categoryAcct.saveEx();
        }
        int mulchId = 137;
        MProduct mulch = new MProduct(Env.getCtx(), mulchId, null);
        int categorySaveId = mulch.getM_Product_Category_ID();
        mulch.setM_Product_Category_ID(category.get_ID());
        mulch.saveEx();
        try {
            int hqLocator = 101;
            this.createPOAndMRForProduct(mulchId);
            BigDecimal componentOnHand1 = MStorageOnHand.getQtyOnHand((int)mulchId, (int)this.getM_Warehouse_ID(), (int)0, (String)this.getTrxName());
            BigDecimal componentCost = MCost.getCurrentCost((MProduct)mulch, (int)0, (String)this.getTrxName());
            MProduct mulchX = new MProduct(Env.getCtx(), 0, this.getTrxName());
            mulchX.setName("Mulch X");
            mulchX.setIsBOM(true);
            mulchX.setIsStocked(true);
            mulchX.setC_UOM_ID(mulch.getC_UOM_ID());
            mulchX.setM_Product_Category_ID(category.getM_Product_Category_ID());
            mulchX.setProductType(mulch.getProductType());
            mulchX.setM_AttributeSet_ID(mulch.getM_AttributeSet_ID());
            mulchX.setC_TaxCategory_ID(mulch.getC_TaxCategory_ID());
            mulchX.saveEx();
            BigDecimal endProductOnHand1 = MStorageOnHand.getQtyOnHand((int)mulchX.get_ID(), (int)this.getM_Warehouse_ID(), (int)0, (String)this.getTrxName());
            int costAdjustmentDocTypeId = 200004;
            MInventory inventory = new MInventory(Env.getCtx(), 0, this.getTrxName());
            inventory.setCostingMethod("S");
            inventory.setC_DocType_ID(costAdjustmentDocTypeId);
            inventory.setM_Warehouse_ID(this.getM_Warehouse_ID());
            inventory.setMovementDate(this.getLoginDate());
            inventory.setDocAction("CO");
            inventory.saveEx();
            MAcctSchema as = MClient.get((int)this.getAD_Client_ID()).getAcctSchema();
            BigDecimal endProductCost = new BigDecimal("2.50").setScale(as.getCostingPrecision(), RoundingMode.HALF_UP);
            MInventoryLine il = new MInventoryLine(Env.getCtx(), 0, this.getTrxName());
            il.setM_Inventory_ID(inventory.get_ID());
            il.setM_Locator_ID(hqLocator);
            il.setM_Product_ID(mulchX.getM_Product_ID());
            il.setCurrentCostPrice(new BigDecimal("0"));
            il.setNewCostPrice(endProductCost);
            il.saveEx();
            ProcessInfo info = MWorkflow.runDocumentActionWorkflow((PO)inventory, (String)"CO");
            inventory.load(this.getTrxName(), new String[0]);
            Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
            Assertions.assertEquals((Object)"CO", (Object)inventory.getDocStatus(), (String)("Cost Adjustment Status=" + inventory.getDocStatus()));
            if (!inventory.isPosted()) {
                String msg = DocumentEngine.postImmediate((Properties)Env.getCtx(), (int)this.getAD_Client_ID(), (int)321, (int)inventory.get_ID(), (boolean)false, (String)this.getTrxName());
                Assertions.assertNull((Object)msg, (String)msg);
            }
            BigDecimal adjusted = MCost.getCurrentCost((MProduct)mulchX, (int)0, (String)this.getTrxName()).setScale(as.getCostingPrecision(), RoundingMode.HALF_UP);
            Assertions.assertEquals((Object)endProductCost, (Object)adjusted, (String)("Cost not adjusted: " + adjusted.toPlainString()));
            MPPProductBOM bom = new MPPProductBOM(Env.getCtx(), 0, this.getTrxName());
            bom.setM_Product_ID(mulchX.get_ID());
            bom.setBOMType("A");
            bom.setBOMUse("A");
            bom.setName(mulchX.getName());
            bom.saveEx();
            MPPProductBOMLine line = new MPPProductBOMLine(bom);
            line.setM_Product_ID(mulchId);
            line.setQtyBOM(new BigDecimal("1"));
            line.saveEx();
            mulchX.load(this.getTrxName(), new String[0]);
            mulchX.setIsVerified(true);
            mulchX.saveEx();
            MProduction production = new MProduction(Env.getCtx(), 0, this.getTrxName());
            production.setM_Product_ID(mulchX.get_ID());
            production.setM_Locator_ID(hqLocator);
            production.setIsUseProductionPlan(false);
            production.setMovementDate(this.getLoginDate());
            production.setDocAction("CO");
            production.setDocStatus("DR");
            production.setIsComplete(false);
            production.setProductionQty(new BigDecimal("1"));
            production.setPP_Product_BOM_ID(bom.getPP_Product_BOM_ID());
            production.saveEx();
            int productionCreate = 53226;
            MProcess process = MProcess.get((Properties)Env.getCtx(), (int)productionCreate);
            ProcessInfo pi = new ProcessInfo(process.getName(), process.get_ID());
            pi.setAD_Client_ID(this.getAD_Client_ID());
            pi.setAD_User_ID(this.getAD_User_ID());
            pi.setRecord_ID(production.get_ID());
            pi.setTransactionName(this.getTrxName());
            ServerProcessCtl.process((ProcessInfo)pi, (Trx)this.getTrx(), (boolean)false);
            Assertions.assertFalse((boolean)pi.isError(), (String)pi.getSummary());
            production.load(this.getTrxName(), new String[0]);
            Assertions.assertEquals((Object)"Y", (Object)production.getIsCreated(), (String)"MProduction.IsCreated != Y");
            Assertions.assertTrue((production.getLines().length > 0 ? 1 : 0) != 0, (String)"No Production Lines");
            info = MWorkflow.runDocumentActionWorkflow((PO)production, (String)"CO");
            production.load(this.getTrxName(), new String[0]);
            Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
            Assertions.assertEquals((Object)"CO", (Object)production.getDocStatus(), (String)("Production Status=" + production.getDocStatus()));
            BigDecimal componentOnHand2 = MStorageOnHand.getQtyOnHand((int)mulchId, (int)this.getM_Warehouse_ID(), (int)0, (String)this.getTrxName());
            BigDecimal endProductOnHand2 = MStorageOnHand.getQtyOnHand((int)mulchX.get_ID(), (int)this.getM_Warehouse_ID(), (int)0, (String)this.getTrxName());
            BigDecimal componentChange = componentOnHand2.subtract(componentOnHand1).setScale(0);
            BigDecimal endProductChange = endProductOnHand2.subtract(endProductOnHand1).setScale(0);
            Assertions.assertEquals((Object)componentChange, (Object)new BigDecimal("-1"), (String)"On hand of component doesn't reduce as expected");
            Assertions.assertEquals((Object)endProductChange, (Object)new BigDecimal("1"), (String)"On hand of end product doesn't increase as expected");
            if (!production.isPosted()) {
                String msg = DocumentEngine.postImmediate((Properties)Env.getCtx(), (int)this.getAD_Client_ID(), (int)325, (int)production.get_ID(), (boolean)false, (String)this.getTrxName());
                Assertions.assertNull((Object)msg, (String)msg);
            }
            BigDecimal endProductCost1 = MCost.getCurrentCost((MProduct)mulchX, (int)0, (String)this.getTrxName()).setScale(as.getCostingPrecision(), RoundingMode.HALF_UP);
            Assertions.assertEquals((Object)endProductCost, (Object)endProductCost1, (String)"Standard Cost Changed");
            ProductCost pc = new ProductCost(Env.getCtx(), mulchX.getM_Product_ID(), 0, this.getTrxName());
            MAccount acctVariance = pc.getAccount(14, as);
            whereClause = "AD_Table_ID=325 AND Record_ID=" + production.get_ID() + " AND C_AcctSchema_ID=" + as.getC_AcctSchema_ID() + " AND Account_ID=" + acctVariance.getAccount_ID();
            int[] ids = MFactAcct.getAllIDs((String)"Fact_Acct", (String)whereClause, (String)this.getTrxName());
            BigDecimal variance = BigDecimal.ZERO;
            int[] nArray = ids;
            if (ids.length != 0) {
                int id = nArray[0];
                MFactAcct fa = new MFactAcct(Env.getCtx(), id, this.getTrxName());
                variance = fa.getAmtAcctDr().subtract(fa.getAmtAcctCr());
            }
            BigDecimal varianceExpected = componentCost.subtract(endProductCost).setScale(as.getStdPrecision(), RoundingMode.HALF_UP);
            Assertions.assertEquals((Object)varianceExpected.setScale(2, RoundingMode.HALF_UP), (Object)variance.setScale(2, RoundingMode.HALF_UP), (String)"Variance not posted correctly.");
        }
        finally {
            this.getTrx().rollback();
            mulch.setM_Product_Category_ID(categorySaveId);
            mulch.saveEx();
            category.deleteEx(true);
        }
    }

    @Test
    public void testRollUp() {
        MProductCategory category = new MProductCategory(Env.getCtx(), 0, null);
        category.setName("Standard Costing");
        category.saveEx();
        String whereClause = "M_Product_Category_ID=?";
        List categoryAccts = new Query(Env.getCtx(), "M_Product_Category_Acct", whereClause, null).setParameters(new Object[]{category.get_ID()}).list();
        for (MProductCategoryAcct categoryAcct : categoryAccts) {
            categoryAcct.setCostingMethod("S");
            categoryAcct.saveEx();
        }
        try {
            int rollUpProcessId = 53230;
            int mulchId = 137;
            MProduct mulch = new MProduct(Env.getCtx(), mulchId, this.getTrxName());
            mulch.setM_Product_Category_ID(category.get_ID());
            mulch.saveEx();
            MAcctSchema as = MClient.get((int)this.getAD_Client_ID()).getAcctSchema();
            BigDecimal componentCost = MCost.getCurrentCost((MProduct)mulch, (int)0, (String)this.getTrxName()).setScale(as.getCostingPrecision(), RoundingMode.HALF_UP);
            MProduct mulchX = new MProduct(Env.getCtx(), 0, this.getTrxName());
            mulchX.setName("Mulch X");
            mulchX.setIsBOM(true);
            mulchX.setIsStocked(true);
            mulchX.setC_UOM_ID(mulch.getC_UOM_ID());
            mulchX.setM_Product_Category_ID(category.getM_Product_Category_ID());
            mulchX.setProductType(mulch.getProductType());
            mulchX.setM_AttributeSet_ID(mulch.getM_AttributeSet_ID());
            mulchX.setC_TaxCategory_ID(mulch.getC_TaxCategory_ID());
            mulchX.saveEx();
            MPPProductBOM bom = new MPPProductBOM(Env.getCtx(), 0, this.getTrxName());
            bom.setM_Product_ID(mulchX.get_ID());
            bom.setBOMType("A");
            bom.setBOMUse("A");
            bom.setName(mulchX.getName());
            bom.saveEx();
            MPPProductBOMLine line = new MPPProductBOMLine(bom);
            line.setM_Product_ID(mulchId);
            line.setQtyBOM(new BigDecimal("1"));
            line.saveEx();
            mulchX.load(this.getTrxName(), new String[0]);
            mulchX.setIsVerified(true);
            mulchX.saveEx();
            MPInstance instance = new MPInstance(Env.getCtx(), rollUpProcessId, 0, 0, null);
            instance.saveEx();
            MPInstancePara para = new MPInstancePara(instance, 10);
            para.setParameterName("M_Product_ID");
            para.setP_Number(mulchX.get_ID());
            para.saveEx();
            para = new MPInstancePara(instance, 20);
            para.setParameterName("M_CostElement_ID");
            para.setP_Number(MCostElement.getMaterialCostElement((Properties)Env.getCtx(), (String)"S").get_ID());
            para.saveEx();
            ProcessInfo info = new ProcessInfo(MProcess.get((int)rollUpProcessId).getName(), rollUpProcessId);
            info.setAD_PInstance_ID(instance.getAD_PInstance_ID());
            info.setTransactionName(this.getTrxName());
            ServerProcessCtl.process((ProcessInfo)info, (Trx)this.getTrx(), (boolean)false);
            Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
            BigDecimal endProductCost = MCost.getCurrentCost((MProduct)mulchX, (int)0, (String)this.getTrxName()).setScale(as.getCostingPrecision(), RoundingMode.HALF_UP);
            Assertions.assertEquals((Object)componentCost, (Object)endProductCost, (String)"BOM Cost not roll up.");
        }
        finally {
            this.getTrx().rollback();
            category.deleteEx(true);
        }
    }

    private void createPOAndMRForProduct(int mulchId) {
        MOrder order = new MOrder(Env.getCtx(), 0, this.getTrxName());
        order.setBPartner(MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.PATIO.id));
        order.setC_DocTypeTarget_ID(DictionaryIDs.C_DocType.PURCHASE_ORDER.id);
        order.setIsSOTrx(false);
        order.setSalesRep_ID(DictionaryIDs.AD_User.GARDEN_ADMIN.id);
        order.setDocStatus("DR");
        order.setDocAction("CO");
        Timestamp today = TimeUtil.getDay((long)System.currentTimeMillis());
        order.setDateOrdered(today);
        order.setDatePromised(today);
        order.saveEx();
        MOrderLine line1 = new MOrderLine(order);
        line1.setLine(10);
        line1.setProduct(MProduct.get((Properties)Env.getCtx(), (int)mulchId));
        line1.setQty(new BigDecimal("25"));
        line1.setPrice(new BigDecimal("2.60"));
        line1.setDatePromised(today);
        line1.saveEx();
        ProcessInfo info = MWorkflow.runDocumentActionWorkflow((PO)order, (String)"CO");
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        order.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((Object)"CO", (Object)order.getDocStatus());
        MInOut receipt1 = new MInOut(order, DictionaryIDs.C_DocType.MM_RECEIPT.id, order.getDateOrdered());
        receipt1.setDocStatus("DR");
        receipt1.setDocAction("CO");
        receipt1.saveEx();
        MInOutLine receiptLine1 = new MInOutLine(receipt1);
        receiptLine1.setOrderLine(line1, 0, new BigDecimal("25"));
        receiptLine1.setQty(new BigDecimal("25"));
        receiptLine1.saveEx();
        info = MWorkflow.runDocumentActionWorkflow((PO)receipt1, (String)"CO");
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        receipt1.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((Object)"CO", (Object)receipt1.getDocStatus());
        if (!receipt1.isPosted()) {
            String error = DocumentEngine.postImmediate((Properties)Env.getCtx(), (int)receipt1.getAD_Client_ID(), (int)receipt1.get_Table_ID(), (int)receipt1.get_ID(), (boolean)false, (String)this.getTrxName());
            Assertions.assertNull((Object)error, (String)error);
        }
    }
}

