/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.test.model;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.List;
import java.util.Properties;
import org.compiere.model.MAttributeSetInstance;
import org.compiere.model.MBPartner;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutLine;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MPriceList;
import org.compiere.model.MPriceListVersion;
import org.compiere.model.MProcess;
import org.compiere.model.MProduct;
import org.compiere.model.MProductCategory;
import org.compiere.model.MProductCategoryAcct;
import org.compiere.model.MProductPrice;
import org.compiere.model.MProduction;
import org.compiere.model.MProductionLine;
import org.compiere.model.MStorageOnHand;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.process.DocumentEngine;
import org.compiere.process.ProcessInfo;
import org.compiere.process.ServerProcessCtl;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.TimeUtil;
import org.compiere.util.Trx;
import org.compiere.wf.MWorkflow;
import org.eevolution.model.MPPProductBOM;
import org.eevolution.model.MPPProductBOMLine;
import org.idempiere.test.AbstractTestCase;
import org.idempiere.test.DictionaryIDs;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ProductionTest
extends AbstractTestCase {
    private void createPOAndMRForProduct(int mulchId) {
        MOrder order = new MOrder(Env.getCtx(), 0, this.getTrxName());
        order.setBPartner(MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.PATIO.id));
        order.setC_DocTypeTarget_ID(DictionaryIDs.C_DocType.PURCHASE_ORDER.id);
        order.setIsSOTrx(false);
        order.setSalesRep_ID(DictionaryIDs.AD_User.GARDEN_ADMIN.id);
        order.setDocStatus("DR");
        order.setDocAction("CO");
        Timestamp today = TimeUtil.getDay((long)System.currentTimeMillis());
        order.setDateOrdered(today);
        order.setDatePromised(today);
        order.saveEx();
        MOrderLine line1 = new MOrderLine(order);
        line1.setLine(10);
        line1.setProduct(MProduct.get((Properties)Env.getCtx(), (int)mulchId));
        line1.setQty(new BigDecimal("25"));
        line1.setPrice(new BigDecimal("2.60"));
        line1.setDatePromised(today);
        line1.saveEx();
        ProcessInfo info = MWorkflow.runDocumentActionWorkflow((PO)order, (String)"CO");
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        order.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((Object)"CO", (Object)order.getDocStatus());
        MInOut receipt1 = new MInOut(order, DictionaryIDs.C_DocType.MM_RECEIPT.id, order.getDateOrdered());
        receipt1.setDocStatus("DR");
        receipt1.setDocAction("CO");
        receipt1.saveEx();
        MInOutLine receiptLine1 = new MInOutLine(receipt1);
        receiptLine1.setOrderLine(line1, 0, new BigDecimal("25"));
        receiptLine1.setQty(new BigDecimal("25"));
        receiptLine1.saveEx();
        info = MWorkflow.runDocumentActionWorkflow((PO)receipt1, (String)"CO");
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        receipt1.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((Object)"CO", (Object)receipt1.getDocStatus());
        if (!receipt1.isPosted()) {
            String error = DocumentEngine.postImmediate((Properties)Env.getCtx(), (int)receipt1.getAD_Client_ID(), (int)receipt1.get_Table_ID(), (int)receipt1.get_ID(), (boolean)false, (String)this.getTrxName());
            Assertions.assertNull((Object)error, (String)error);
        }
    }

    @Test
    public void testAutoProduce() {
        MProduct mulch = MProduct.get((int)DictionaryIDs.M_Product.MULCH.id);
        MProduct mulchX = new MProduct(Env.getCtx(), 0, null);
        mulchX.setName("MulchX2");
        mulchX.setIsBOM(true);
        mulchX.setIsStocked(true);
        mulchX.setC_UOM_ID(mulch.getC_UOM_ID());
        mulchX.setM_Product_Category_ID(mulch.getM_Product_Category_ID());
        mulchX.setProductType(mulch.getProductType());
        mulchX.setM_AttributeSet_ID(mulch.getM_AttributeSet_ID());
        mulchX.setC_TaxCategory_ID(mulch.getC_TaxCategory_ID());
        mulchX.setIsAutoProduce(true);
        mulchX.saveEx();
        try {
            this.createPOAndMRForProduct(DictionaryIDs.M_Product.MULCH.id);
            MPPProductBOM bom = new MPPProductBOM(Env.getCtx(), 0, this.getTrxName());
            bom.setM_Product_ID(mulchX.get_ID());
            bom.setBOMType("A");
            bom.setBOMUse("A");
            bom.setName(mulchX.getName());
            bom.saveEx();
            MPPProductBOMLine line = new MPPProductBOMLine(bom);
            line.setM_Product_ID(DictionaryIDs.M_Product.MULCH.id);
            line.setQtyBOM(new BigDecimal("2"));
            line.saveEx();
            mulchX.load(null, new String[0]);
            mulchX.setIsVerified(true);
            mulchX.saveEx();
            MOrder order = new MOrder(Env.getCtx(), 0, this.getTrxName());
            order.setBPartner(MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.JOE_BLOCK.id));
            order.setC_DocTypeTarget_ID("SO");
            order.setDeliveryRule("O");
            order.setDocStatus("DR");
            order.setDocAction("CO");
            Timestamp today = TimeUtil.getDay((long)System.currentTimeMillis());
            order.setDateOrdered(today);
            order.setDatePromised(today);
            order.saveEx();
            MPriceList priceList = MPriceList.get((int)order.getM_PriceList_ID());
            MPriceListVersion priceListVersion = priceList.getPriceListVersion(null);
            MProductPrice productPrice = new MProductPrice(Env.getCtx(), 0, this.getTrxName());
            productPrice.setM_PriceList_Version_ID(priceListVersion.get_ID());
            productPrice.setM_Product_ID(mulchX.get_ID());
            productPrice.setPriceLimit(new BigDecimal("5.00"));
            productPrice.setPriceStd(new BigDecimal("5.00"));
            productPrice.saveEx();
            MOrderLine line1 = new MOrderLine(order);
            line1.setLine(10);
            line1.setProduct(mulchX);
            line1.setQty(new BigDecimal("1"));
            line1.setDatePromised(today);
            line1.saveEx();
            ProcessInfo info = MWorkflow.runDocumentActionWorkflow((PO)order, (String)"CO");
            Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
            order.load(this.getTrxName(), new String[0]);
            Assertions.assertEquals((Object)"CO", (Object)order.getDocStatus());
            line1.load(this.getTrxName(), new String[0]);
            Assertions.assertEquals((int)1, (int)line1.getQtyReserved().intValue());
            MInOut shipment = new MInOut(order, 120, order.getDateOrdered());
            shipment.setDocStatus("DR");
            shipment.setDocAction("CO");
            shipment.saveEx();
            MInOutLine shipmentLine = new MInOutLine(shipment);
            shipmentLine.setOrderLine(line1, 0, new BigDecimal("1"));
            shipmentLine.setQty(new BigDecimal("1"));
            shipmentLine.saveEx();
            info = MWorkflow.runDocumentActionWorkflow((PO)shipment, (String)"CO");
            Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
            shipment.load(this.getTrxName(), new String[0]);
            Assertions.assertEquals((Object)"CO", (Object)shipment.getDocStatus());
            shipmentLine.load(this.getTrxName(), new String[0]);
            Assertions.assertTrue((boolean)shipmentLine.isAutoProduce(), (String)"Shipment Line Auto Produce is False");
            Query query = new Query(Env.getCtx(), "M_Production", "M_InOutLine_ID=?", this.getTrxName());
            MProduction production = (MProduction)query.setParameters(new Object[]{shipmentLine.get_ID()}).first();
            Assertions.assertNotNull((Object)production, (String)"Can't find production for auto produce shipment line");
            Assertions.assertEquals((Object)"CO", (Object)production.getDocStatus());
            MProductionLine[] productionLines = production.getLines();
            Assertions.assertNotNull((Object)productionLines, (String)"Can't find production line for auto produce shipment line");
            Assertions.assertTrue((productionLines.length == 2 ? 1 : 0) != 0, (String)("Number of production line is not 2 as expected (" + productionLines.length + ")"));
            Assertions.assertTrue((productionLines[0].getM_Product_ID() == shipmentLine.getM_Product_ID() ? 1 : 0) != 0, (String)"Production Line Production <> Shipment Line Product");
            Assertions.assertTrue((boolean)productionLines[0].getMovementQty().equals(shipmentLine.getMovementQty()), (String)"Production Line Qty <> Shipment Line Qty");
            Assertions.assertTrue((productionLines[1].getM_Product_ID() == DictionaryIDs.M_Product.MULCH.id ? 1 : 0) != 0, (String)"Production Line 2 Product is not the expected component product");
            Assertions.assertTrue((productionLines[1].getMovementQty().intValue() == -2 ? 1 : 0) != 0, (String)"Production Line 2 Qty is not the expected component qty");
        }
        catch (Throwable throwable) {
            this.rollback();
            DB.executeUpdateEx((String)"delete from m_cost where m_product_id=?", (Object[])new Object[]{mulchX.get_ID()}, null);
            mulchX.deleteEx(true);
            throw throwable;
        }
        this.rollback();
        DB.executeUpdateEx((String)"delete from m_cost where m_product_id=?", (Object[])new Object[]{mulchX.get_ID()}, null);
        mulchX.deleteEx(true);
    }

    @Test
    public void testMultipleASI() {
        DB.executeUpdateEx((String)"UPDATE M_CostElement SET IsActive = 'N' WHERE AD_Client_ID=? AND CostingMethod IS NOT NULL AND CostingMethod != ?", (Object[])new Object[]{this.getAD_Client_ID(), "S"}, (String)this.getTrxName());
        MProductCategory category = new MProductCategory(Env.getCtx(), 0, null);
        category.setName("Standard Costing");
        category.saveEx();
        String whereClause = "M_Product_Category_ID=?";
        List categoryAccts = new Query(Env.getCtx(), "M_Product_Category_Acct", whereClause, null).setParameters(new Object[]{category.get_ID()}).list();
        for (MProductCategoryAcct categoryAcct : categoryAccts) {
            categoryAcct.setCostingMethod("S");
            categoryAcct.saveEx();
        }
        MProduct component = new MProduct(Env.getCtx(), 0, null);
        component.setName("testMultipleASI_Child");
        component.setM_AttributeSet_ID(DictionaryIDs.M_AttributeSet.FERTILIZER_LOT.id);
        component.setIsStocked(true);
        component.setProductType("I");
        component.setC_UOM_ID(DictionaryIDs.C_UOM.EACH.id);
        component.setM_Product_Category_ID(category.get_ID());
        component.setC_TaxCategory_ID(DictionaryIDs.C_TaxCategory.STANDARD.id);
        component.saveEx();
        try {
            Timestamp today = TimeUtil.getDay(null);
            MProduct parent = new MProduct(Env.getCtx(), 0, this.getTrxName());
            parent.setName("testMultipleASI_Parent");
            parent.setIsBOM(true);
            parent.setIsStocked(true);
            parent.setC_UOM_ID(component.getC_UOM_ID());
            parent.setM_Product_Category_ID(component.getM_Product_Category_ID());
            parent.setProductType(component.getProductType());
            parent.setC_TaxCategory_ID(component.getC_TaxCategory_ID());
            parent.saveEx();
            BigDecimal endProductOnHand1 = MStorageOnHand.getQtyOnHand((int)parent.get_ID(), (int)this.getM_Warehouse_ID(), (int)0, (String)this.getTrxName());
            Assertions.assertEquals((int)0, (int)endProductOnHand1.intValue(), (String)"On hand of new product is not zero");
            MPPProductBOM bom = new MPPProductBOM(Env.getCtx(), 0, this.getTrxName());
            bom.setM_Product_ID(parent.get_ID());
            bom.setBOMType("A");
            bom.setBOMUse("A");
            bom.setName(parent.getName());
            bom.saveEx();
            MPPProductBOMLine line = new MPPProductBOMLine(bom);
            line.setM_Product_ID(component.get_ID());
            line.setQtyBOM(new BigDecimal("2"));
            line.saveEx();
            parent.load(this.getTrxName(), new String[0]);
            parent.setIsVerified(true);
            parent.saveEx();
            MAttributeSetInstance asi1 = new MAttributeSetInstance(Env.getCtx(), 0, this.getTrxName());
            asi1.setM_AttributeSet_ID(DictionaryIDs.M_AttributeSet.FERTILIZER_LOT.id);
            asi1.setLot("Lot1");
            asi1.saveEx();
            MStorageOnHand.add((Properties)Env.getCtx(), (int)DictionaryIDs.M_Locator.HQ.id, (int)component.get_ID(), (int)asi1.get_ID(), (BigDecimal)new BigDecimal("1"), (Timestamp)today, (String)this.getTrxName());
            MAttributeSetInstance asi2 = new MAttributeSetInstance(Env.getCtx(), 0, this.getTrxName());
            asi2.setM_AttributeSet_ID(DictionaryIDs.M_AttributeSet.FERTILIZER_LOT.id);
            asi2.setLot("Lot2");
            asi2.saveEx();
            MStorageOnHand.add((Properties)Env.getCtx(), (int)DictionaryIDs.M_Locator.HQ.id, (int)component.get_ID(), (int)asi2.get_ID(), (BigDecimal)new BigDecimal("1"), (Timestamp)today, (String)this.getTrxName());
            MProduction production = new MProduction(Env.getCtx(), 0, this.getTrxName());
            production.setM_Product_ID(parent.get_ID());
            production.setM_Locator_ID(DictionaryIDs.M_Locator.HQ.id);
            production.setIsUseProductionPlan(false);
            production.setMovementDate(this.getLoginDate());
            production.setDocAction("CO");
            production.setDocStatus("DR");
            production.setIsComplete(false);
            production.setProductionQty(new BigDecimal("1"));
            production.setPP_Product_BOM_ID(bom.getPP_Product_BOM_ID());
            production.saveEx();
            int productionCreate = 53226;
            MProcess process = MProcess.get((Properties)Env.getCtx(), (int)productionCreate);
            ProcessInfo pi = new ProcessInfo(process.getName(), process.get_ID());
            pi.setAD_Client_ID(this.getAD_Client_ID());
            pi.setAD_User_ID(this.getAD_User_ID());
            pi.setRecord_ID(production.get_ID());
            pi.setTransactionName(this.getTrxName());
            ServerProcessCtl.process((ProcessInfo)pi, (Trx)this.getTrx(), (boolean)false);
            Assertions.assertFalse((boolean)pi.isError(), (String)pi.getSummary());
            production.load(this.getTrxName(), new String[0]);
            Assertions.assertEquals((Object)"Y", (Object)production.getIsCreated(), (String)"MProduction.IsCreated != Y");
            Assertions.assertTrue((production.getLines().length > 0 ? 1 : 0) != 0, (String)"No Production Lines");
            Assertions.assertEquals((int)2, (int)production.getLines().length, (String)"Unexpected number of production lines");
            ProcessInfo info = MWorkflow.runDocumentActionWorkflow((PO)production, (String)"CO");
            production.load(this.getTrxName(), new String[0]);
            Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
            Assertions.assertEquals((Object)"CO", (Object)production.getDocStatus(), (String)("Production Status=" + production.getDocStatus()));
            BigDecimal endProductOnHand2 = MStorageOnHand.getQtyOnHand((int)parent.get_ID(), (int)this.getM_Warehouse_ID(), (int)0, (String)this.getTrxName());
            Assertions.assertEquals((int)1, (int)endProductOnHand2.intValue(), (String)"On hand of end product doesn't increase as expected");
        }
        finally {
            this.getTrx().rollback();
            component.deleteEx(true);
            category.deleteEx(true);
        }
    }

    @Test
    public void testMultipleDateMPolicy() {
        DB.executeUpdateEx((String)"UPDATE M_CostElement SET IsActive = 'N' WHERE AD_Client_ID=? AND CostingMethod IS NOT NULL AND CostingMethod != ?", (Object[])new Object[]{this.getAD_Client_ID(), "S"}, (String)this.getTrxName());
        MProductCategory category = new MProductCategory(Env.getCtx(), 0, null);
        category.setName("Standard Costing");
        category.saveEx();
        String whereClause = "M_Product_Category_ID=?";
        List categoryAccts = new Query(Env.getCtx(), "M_Product_Category_Acct", whereClause, null).setParameters(new Object[]{category.get_ID()}).list();
        for (MProductCategoryAcct categoryAcct : categoryAccts) {
            categoryAcct.setCostingMethod("S");
            categoryAcct.saveEx();
        }
        MProduct component = new MProduct(Env.getCtx(), 0, null);
        component.setName("testMultipleDateMPolicy_Child");
        component.setM_AttributeSet_ID(DictionaryIDs.M_AttributeSet.FERTILIZER_LOT.id);
        component.setIsStocked(true);
        component.setProductType("I");
        component.setC_UOM_ID(DictionaryIDs.C_UOM.EACH.id);
        component.setM_Product_Category_ID(category.get_ID());
        component.setC_TaxCategory_ID(DictionaryIDs.C_TaxCategory.STANDARD.id);
        component.saveEx();
        try {
            Timestamp today = TimeUtil.getDay(null);
            MProduct parent = new MProduct(Env.getCtx(), 0, this.getTrxName());
            parent.setName("testMultipleDateMPolicy_Parent");
            parent.setIsBOM(true);
            parent.setIsStocked(true);
            parent.setC_UOM_ID(component.getC_UOM_ID());
            parent.setM_Product_Category_ID(component.getM_Product_Category_ID());
            parent.setProductType(component.getProductType());
            parent.setC_TaxCategory_ID(component.getC_TaxCategory_ID());
            parent.saveEx();
            BigDecimal endProductOnHand1 = MStorageOnHand.getQtyOnHand((int)parent.get_ID(), (int)this.getM_Warehouse_ID(), (int)0, (String)this.getTrxName());
            Assertions.assertEquals((int)0, (int)endProductOnHand1.intValue(), (String)"On hand of new product is not zero");
            MPPProductBOM bom = new MPPProductBOM(Env.getCtx(), 0, this.getTrxName());
            bom.setM_Product_ID(parent.get_ID());
            bom.setBOMType("A");
            bom.setBOMUse("A");
            bom.setName(parent.getName());
            bom.saveEx();
            MPPProductBOMLine line = new MPPProductBOMLine(bom);
            line.setM_Product_ID(component.get_ID());
            line.setQtyBOM(new BigDecimal("2"));
            line.saveEx();
            parent.load(this.getTrxName(), new String[0]);
            parent.setIsVerified(true);
            parent.saveEx();
            MAttributeSetInstance asi1 = new MAttributeSetInstance(Env.getCtx(), 0, this.getTrxName());
            asi1.setM_AttributeSet_ID(DictionaryIDs.M_AttributeSet.FERTILIZER_LOT.id);
            asi1.setLot("Lot1");
            asi1.saveEx();
            MStorageOnHand.add((Properties)Env.getCtx(), (int)DictionaryIDs.M_Locator.HQ.id, (int)component.get_ID(), (int)asi1.get_ID(), (BigDecimal)new BigDecimal("1"), (Timestamp)TimeUtil.addDays((Timestamp)today, (int)-1), (String)this.getTrxName());
            MStorageOnHand.add((Properties)Env.getCtx(), (int)DictionaryIDs.M_Locator.HQ.id, (int)component.get_ID(), (int)asi1.get_ID(), (BigDecimal)new BigDecimal("1"), (Timestamp)today, (String)this.getTrxName());
            MProduction production = new MProduction(Env.getCtx(), 0, this.getTrxName());
            production.setM_Product_ID(parent.get_ID());
            production.setM_Locator_ID(DictionaryIDs.M_Locator.HQ.id);
            production.setIsUseProductionPlan(false);
            production.setMovementDate(this.getLoginDate());
            production.setDocAction("CO");
            production.setDocStatus("DR");
            production.setIsComplete(false);
            production.setProductionQty(new BigDecimal("1"));
            production.setPP_Product_BOM_ID(bom.getPP_Product_BOM_ID());
            production.saveEx();
            int productionCreate = 53226;
            MProcess process = MProcess.get((Properties)Env.getCtx(), (int)productionCreate);
            ProcessInfo pi = new ProcessInfo(process.getName(), process.get_ID());
            pi.setAD_Client_ID(this.getAD_Client_ID());
            pi.setAD_User_ID(this.getAD_User_ID());
            pi.setRecord_ID(production.get_ID());
            pi.setTransactionName(this.getTrxName());
            ServerProcessCtl.process((ProcessInfo)pi, (Trx)this.getTrx(), (boolean)false);
            Assertions.assertFalse((boolean)pi.isError(), (String)pi.getSummary());
            production.load(this.getTrxName(), new String[0]);
            Assertions.assertEquals((Object)"Y", (Object)production.getIsCreated(), (String)"MProduction.IsCreated != Y");
            Assertions.assertTrue((production.getLines().length > 0 ? 1 : 0) != 0, (String)"No Production Lines");
            Assertions.assertEquals((int)2, (int)production.getLines().length, (String)"Unexpected number of production lines");
            ProcessInfo info = MWorkflow.runDocumentActionWorkflow((PO)production, (String)"CO");
            production.load(this.getTrxName(), new String[0]);
            Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
            Assertions.assertEquals((Object)"CO", (Object)production.getDocStatus(), (String)("Production Status=" + production.getDocStatus()));
            BigDecimal endProductOnHand2 = MStorageOnHand.getQtyOnHand((int)parent.get_ID(), (int)this.getM_Warehouse_ID(), (int)0, (String)this.getTrxName());
            Assertions.assertEquals((int)1, (int)endProductOnHand2.intValue(), (String)"On hand of end product doesn't increase as expected");
        }
        finally {
            this.getTrx().rollback();
            component.deleteEx(true);
            category.deleteEx(true);
        }
    }

    @Test
    public void testMultipleInProgressProduction() {
        DB.executeUpdateEx((String)"UPDATE M_CostElement SET IsActive = 'N' WHERE AD_Client_ID=? AND CostingMethod IS NOT NULL AND CostingMethod != ?", (Object[])new Object[]{this.getAD_Client_ID(), "S"}, (String)this.getTrxName());
        MProductCategory category = new MProductCategory(Env.getCtx(), 0, null);
        category.setName("Standard Costing");
        category.saveEx();
        String whereClause = "M_Product_Category_ID=?";
        List categoryAccts = new Query(Env.getCtx(), "M_Product_Category_Acct", whereClause, null).setParameters(new Object[]{category.get_ID()}).list();
        for (MProductCategoryAcct categoryAcct : categoryAccts) {
            categoryAcct.setCostingMethod("S");
            categoryAcct.saveEx();
        }
        MProduct component = new MProduct(Env.getCtx(), 0, null);
        component.setName("testMultipleDateMPolicy_Child");
        component.setM_AttributeSet_ID(DictionaryIDs.M_AttributeSet.FERTILIZER_LOT.id);
        component.setIsStocked(true);
        component.setProductType("I");
        component.setC_UOM_ID(DictionaryIDs.C_UOM.EACH.id);
        component.setM_Product_Category_ID(category.get_ID());
        component.setC_TaxCategory_ID(DictionaryIDs.C_TaxCategory.STANDARD.id);
        component.saveEx();
        try {
            Timestamp today = TimeUtil.getDay(null);
            MProduct parent = new MProduct(Env.getCtx(), 0, this.getTrxName());
            parent.setName("testMultipleDateMPolicy_Parent");
            parent.setIsBOM(true);
            parent.setIsStocked(true);
            parent.setC_UOM_ID(component.getC_UOM_ID());
            parent.setM_Product_Category_ID(component.getM_Product_Category_ID());
            parent.setProductType(component.getProductType());
            parent.setC_TaxCategory_ID(component.getC_TaxCategory_ID());
            parent.saveEx();
            BigDecimal endProductOnHand1 = MStorageOnHand.getQtyOnHand((int)parent.get_ID(), (int)this.getM_Warehouse_ID(), (int)0, (String)this.getTrxName());
            Assertions.assertEquals((int)0, (int)endProductOnHand1.intValue(), (String)"On hand of new product is not zero");
            MPPProductBOM bom = new MPPProductBOM(Env.getCtx(), 0, this.getTrxName());
            bom.setM_Product_ID(parent.get_ID());
            bom.setBOMType("A");
            bom.setBOMUse("A");
            bom.setName(parent.getName());
            bom.saveEx();
            MPPProductBOMLine line = new MPPProductBOMLine(bom);
            line.setM_Product_ID(component.get_ID());
            line.setQtyBOM(new BigDecimal("2"));
            line.saveEx();
            parent.load(this.getTrxName(), new String[0]);
            parent.setIsVerified(true);
            parent.saveEx();
            MAttributeSetInstance asi1 = new MAttributeSetInstance(Env.getCtx(), 0, this.getTrxName());
            asi1.setM_AttributeSet_ID(DictionaryIDs.M_AttributeSet.FERTILIZER_LOT.id);
            asi1.setLot("Lot1");
            asi1.saveEx();
            MStorageOnHand.add((Properties)Env.getCtx(), (int)DictionaryIDs.M_Locator.HQ.id, (int)component.get_ID(), (int)asi1.get_ID(), (BigDecimal)new BigDecimal("2"), (Timestamp)today, (String)this.getTrxName());
            MAttributeSetInstance asi2 = new MAttributeSetInstance(Env.getCtx(), 0, this.getTrxName());
            asi2.setM_AttributeSet_ID(DictionaryIDs.M_AttributeSet.FERTILIZER_LOT.id);
            asi2.setLot("Lot2");
            asi2.saveEx();
            MStorageOnHand.add((Properties)Env.getCtx(), (int)DictionaryIDs.M_Locator.HQ.id, (int)component.get_ID(), (int)asi2.get_ID(), (BigDecimal)new BigDecimal("2"), (Timestamp)today, (String)this.getTrxName());
            MProduction production1 = new MProduction(Env.getCtx(), 0, this.getTrxName());
            production1.setM_Product_ID(parent.get_ID());
            production1.setM_Locator_ID(DictionaryIDs.M_Locator.HQ.id);
            production1.setIsUseProductionPlan(false);
            production1.setMovementDate(this.getLoginDate());
            production1.setDocAction("CO");
            production1.setDocStatus("DR");
            production1.setIsComplete(false);
            production1.setProductionQty(new BigDecimal("1"));
            production1.setPP_Product_BOM_ID(bom.getPP_Product_BOM_ID());
            production1.saveEx();
            int productionCreate = 53226;
            MProcess process = MProcess.get((Properties)Env.getCtx(), (int)productionCreate);
            ProcessInfo pi = new ProcessInfo(process.getName(), process.get_ID());
            pi.setAD_Client_ID(this.getAD_Client_ID());
            pi.setAD_User_ID(this.getAD_User_ID());
            pi.setRecord_ID(production1.get_ID());
            pi.setTransactionName(this.getTrxName());
            ServerProcessCtl.process((ProcessInfo)pi, (Trx)this.getTrx(), (boolean)false);
            Assertions.assertFalse((boolean)pi.isError(), (String)pi.getSummary());
            production1.load(this.getTrxName(), new String[0]);
            Assertions.assertEquals((Object)"Y", (Object)production1.getIsCreated(), (String)"MProduction.IsCreated != Y");
            Assertions.assertTrue((production1.getLines().length > 0 ? 1 : 0) != 0, (String)"No Production Lines");
            Assertions.assertEquals((int)2, (int)production1.getLines().length, (String)"Unexpected number of production lines");
            MProduction production2 = new MProduction(Env.getCtx(), 0, this.getTrxName());
            production2.setM_Product_ID(parent.get_ID());
            production2.setM_Locator_ID(DictionaryIDs.M_Locator.HQ.id);
            production2.setIsUseProductionPlan(false);
            production2.setMovementDate(this.getLoginDate());
            production2.setDocAction("CO");
            production2.setDocStatus("DR");
            production2.setIsComplete(false);
            production2.setProductionQty(new BigDecimal("1"));
            production2.setPP_Product_BOM_ID(bom.getPP_Product_BOM_ID());
            production2.saveEx();
            pi = new ProcessInfo(process.getName(), process.get_ID());
            pi.setAD_Client_ID(this.getAD_Client_ID());
            pi.setAD_User_ID(this.getAD_User_ID());
            pi.setRecord_ID(production2.get_ID());
            pi.setTransactionName(this.getTrxName());
            ServerProcessCtl.process((ProcessInfo)pi, (Trx)this.getTrx(), (boolean)false);
            Assertions.assertFalse((boolean)pi.isError(), (String)pi.getSummary());
            production2.load(this.getTrxName(), new String[0]);
            Assertions.assertEquals((Object)"Y", (Object)production2.getIsCreated(), (String)"MProduction.IsCreated != Y");
            Assertions.assertTrue((production2.getLines().length > 0 ? 1 : 0) != 0, (String)"No Production Lines");
            Assertions.assertEquals((int)2, (int)production2.getLines().length, (String)"Unexpected number of production lines");
            ProcessInfo info = MWorkflow.runDocumentActionWorkflow((PO)production1, (String)"CO");
            production1.load(this.getTrxName(), new String[0]);
            Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
            Assertions.assertEquals((Object)"CO", (Object)production1.getDocStatus(), (String)("Production Status=" + production1.getDocStatus()));
            BigDecimal endProductOnHand2 = MStorageOnHand.getQtyOnHand((int)parent.get_ID(), (int)this.getM_Warehouse_ID(), (int)0, (String)this.getTrxName());
            Assertions.assertEquals((int)1, (int)endProductOnHand2.intValue(), (String)"On hand of end product doesn't increase as expected");
            info = MWorkflow.runDocumentActionWorkflow((PO)production2, (String)"CO");
            production2.load(this.getTrxName(), new String[0]);
            Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
            Assertions.assertEquals((Object)"CO", (Object)production2.getDocStatus(), (String)("Production Status=" + production2.getDocStatus()));
            endProductOnHand2 = MStorageOnHand.getQtyOnHand((int)parent.get_ID(), (int)this.getM_Warehouse_ID(), (int)0, (String)this.getTrxName());
            Assertions.assertEquals((int)2, (int)endProductOnHand2.intValue(), (String)"On hand of end product doesn't increase as expected");
        }
        finally {
            this.getTrx().rollback();
            component.deleteEx(true);
            category.deleteEx(true);
        }
    }
}

