/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.test.model;

import java.util.concurrent.atomic.AtomicReference;
import org.compiere.model.MAttribute;
import org.compiere.model.MAttributeSet;
import org.compiere.model.MAttributeSetInstance;
import org.compiere.model.MAttributeUse;
import org.compiere.util.Env;
import org.compiere.util.Trx;
import org.compiere.util.TrxRunnable;
import org.idempiere.test.AbstractTestCase;
import org.idempiere.test.DictionaryIDs;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class MAttributeSetTest
extends AbstractTestCase {
    @Test
    public void testGetMAttributeUse() {
        MAttributeSet as = MAttributeSet.get((int)DictionaryIDs.M_AttributeSet.PATIO_CHAIR.id);
        MAttributeUse[] use = as.getMAttributeUse();
        Assertions.assertNotNull((Object)use);
        Assertions.assertTrue((use.length > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testGetMAttributes() {
        MAttributeSet as = MAttributeSet.get((int)DictionaryIDs.M_AttributeSet.PATIO_CHAIR.id);
        MAttributeUse[] uses = as.getMAttributeUse();
        int instance = 0;
        int nonInstance = 0;
        MAttributeUse[] mAttributeUseArray = uses;
        int n = uses.length;
        int n2 = 0;
        while (n2 < n) {
            MAttributeUse use = mAttributeUseArray[n2];
            if (use.getM_Attribute().isInstanceAttribute()) {
                ++instance;
            } else {
                ++nonInstance;
            }
            ++n2;
        }
        Assertions.assertTrue((instance > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((nonInstance > 0 ? 1 : 0) != 0);
        MAttribute[] attributes = as.getMAttributes(true);
        Assertions.assertNotNull((Object)attributes);
        Assertions.assertEquals((int)instance, (int)attributes.length);
        attributes = as.getMAttributes(false);
        Assertions.assertEquals((int)nonInstance, (int)attributes.length);
    }

    @Test
    public void testMAttributeUseBeforeAfterSave() {
        MAttribute a1 = new MAttribute(Env.getCtx(), 0, this.getTrxName());
        a1.setName("MyTestAttribute1");
        a1.setAttributeValueType("N");
        a1.setIsInstanceAttribute(false);
        a1.setIsMandatory(false);
        a1.saveEx();
        MAttribute a2 = new MAttribute(Env.getCtx(), 0, this.getTrxName());
        a2.setName("MyTestAttribute2");
        a2.setAttributeValueType("N");
        a2.setIsInstanceAttribute(true);
        a2.setIsMandatory(false);
        a2.saveEx();
        MAttributeSet as = new MAttributeSet(Env.getCtx(), 0, this.getTrxName());
        as.setName("MyTestAttributeSet1");
        as.setIsInstanceAttribute(false);
        as.saveEx();
        MAttributeUse use1 = new MAttributeUse(Env.getCtx(), 0, this.getTrxName());
        use1.setM_Attribute_ID(a1.get_ID());
        use1.setM_AttributeSet_ID(as.get_ID());
        use1.saveEx();
        Assertions.assertEquals((int)10, (int)use1.getSeqNo());
        as.load(this.getTrxName(), new String[0]);
        Assertions.assertFalse((boolean)as.isInstanceAttribute());
        MAttributeUse use2 = new MAttributeUse(Env.getCtx(), 0, this.getTrxName());
        use2.setM_Attribute_ID(a2.get_ID());
        use2.setM_AttributeSet_ID(as.get_ID());
        use2.saveEx();
        Assertions.assertEquals((int)20, (int)use2.getSeqNo());
        as.load(this.getTrxName(), new String[0]);
        Assertions.assertTrue((boolean)as.isInstanceAttribute());
    }

    @Test
    public void testGenerateUniqueSerial() {
        MAttributeSet mas = new MAttributeSet(Env.getCtx(), DictionaryIDs.M_AttributeSet.PATIO_CHAIR.id, null);
        mas.setM_SerNoCtl_ID(DictionaryIDs.M_SerNoCtl.SERIAL_NO_EXAMPLE.id);
        try {
            mas.saveEx();
            Trx trx1 = Trx.get((String)Trx.createTrxName(), (boolean)true);
            Trx trx2 = Trx.get((String)Trx.createTrxName(), (boolean)true);
            AtomicReference<Object> atomic1 = new AtomicReference<Object>(null);
            AtomicReference<Object> atomic2 = new AtomicReference<Object>(null);
            try {
                TrxRunnable runnable1 = trxName -> {
                    MAttributeSetInstance asi1 = new MAttributeSetInstance(Env.getCtx(), 0, mas.get_ID(), trxName);
                    String serno1 = asi1.getSerNo(true);
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {}
                    Trx.get((String)trxName, (boolean)false).commit();
                    atomic1.set(serno1);
                };
                TrxRunnable runnable2 = trxName -> {
                    MAttributeSetInstance asi2 = new MAttributeSetInstance(Env.getCtx(), 0, mas.get_ID(), trx2.getTrxName());
                    String serno2 = asi2.getSerNo(true);
                    Trx.get((String)trxName, (boolean)false).commit();
                    atomic2.set(serno2);
                };
                Thread t1 = new Thread(() -> Trx.run((String)trx1.getTrxName(), (TrxRunnable)runnable1));
                Thread t2 = new Thread(() -> Trx.run((String)trx2.getTrxName(), (TrxRunnable)runnable2));
                t1.start();
                t2.start();
                try {
                    t1.join();
                }
                catch (InterruptedException interruptedException) {}
                try {
                    t2.join();
                }
                catch (InterruptedException interruptedException) {}
                Assertions.assertNotNull(atomic1.get(), (String)"Serial number 1 not generated");
                Assertions.assertNotNull(atomic2.get(), (String)"Serial number 2 not generated");
                Assertions.assertNotEquals(atomic1.get(), atomic2.get(), (String)"Duplicate serial number generated");
            }
            finally {
                trx1.close();
                trx2.close();
            }
        }
        finally {
            mas.setM_SerNoCtl_ID(0);
            mas.saveEx();
        }
    }

    @Test
    public void testGenerateLot() {
        MAttributeSet mas = new MAttributeSet(Env.getCtx(), DictionaryIDs.M_AttributeSet.FERTILIZER_LOT.id, null);
        Trx trx1 = Trx.get((String)Trx.createTrxName(), (boolean)true);
        Trx trx2 = Trx.get((String)Trx.createTrxName(), (boolean)true);
        AtomicReference<Object> atomic1 = new AtomicReference<Object>(null);
        AtomicReference<Object> atomic2 = new AtomicReference<Object>(null);
        try {
            TrxRunnable runnable1 = trxName -> {
                MAttributeSetInstance asi1 = new MAttributeSetInstance(Env.getCtx(), 0, mas.get_ID(), trxName);
                String lot1 = asi1.getLot(true, DictionaryIDs.M_Product.FERTILIZER_50.id);
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {}
                Trx.get((String)trxName, (boolean)false).commit();
                atomic1.set(lot1);
            };
            TrxRunnable runnable2 = trxName -> {
                MAttributeSetInstance asi2 = new MAttributeSetInstance(Env.getCtx(), 0, mas.get_ID(), trx2.getTrxName());
                String lot2 = asi2.getLot(true, DictionaryIDs.M_Product.FERTILIZER_50.id);
                Trx.get((String)trxName, (boolean)false).commit();
                atomic2.set(lot2);
            };
            Thread t1 = new Thread(() -> Trx.run((String)trx1.getTrxName(), (TrxRunnable)runnable1));
            Thread t2 = new Thread(() -> Trx.run((String)trx2.getTrxName(), (TrxRunnable)runnable2));
            t1.start();
            t2.start();
            try {
                t1.join();
            }
            catch (InterruptedException interruptedException) {}
            try {
                t2.join();
            }
            catch (InterruptedException interruptedException) {}
            Assertions.assertNotNull(atomic1.get(), (String)"Lot 1 not generated");
            Assertions.assertNotNull(atomic2.get(), (String)"Lot 2 not generated");
            Assertions.assertNotEquals(atomic1.get(), atomic2.get(), (String)"Duplicate lot generated");
        }
        finally {
            trx1.close();
            trx2.close();
        }
    }
}

