/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.test.form;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Properties;
import java.util.Vector;
import org.compiere.apps.form.FactReconcile;
import org.compiere.minigrid.IMiniTable;
import org.compiere.minigrid.MiniTableImpl;
import org.compiere.model.MBankStatement;
import org.compiere.model.MBankStatementLine;
import org.compiere.model.MClientInfo;
import org.compiere.model.MFactAcct;
import org.compiere.model.MPayment;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.process.DocumentEngine;
import org.compiere.process.ProcessInfo;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Util;
import org.compiere.wf.MWorkflow;
import org.idempiere.test.AbstractTestCase;
import org.idempiere.test.DictionaryIDs;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class FactReconcileFormTest
extends AbstractTestCase {
    @Test
    public void testReconcileForm() {
        KeyNamePair knp;
        MPayment payment = new MPayment(Env.getCtx(), 0, this.getTrxName());
        payment.setC_BankAccount_ID(DictionaryIDs.C_BankAccount.ACCOUNT_1234.id);
        payment.setIsReceipt(true);
        payment.setPayAmt(new BigDecimal("9.99"));
        payment.setC_BPartner_ID(DictionaryIDs.C_BPartner.SEED_FARM.id);
        payment.setC_DocType_ID(true);
        payment.setC_Currency_ID(DictionaryIDs.C_Currency.USD.id);
        payment.saveEx();
        ProcessInfo pi = MWorkflow.runDocumentActionWorkflow((PO)payment, (String)"CO");
        Assertions.assertFalse((boolean)pi.isError(), (String)pi.getSummary());
        payment.load(this.getTrxName(), new String[0]);
        if (!payment.isPosted()) {
            String error = DocumentEngine.postImmediate((Properties)Env.getCtx(), (int)payment.getAD_Client_ID(), (int)335, (int)payment.get_ID(), (boolean)true, (String)this.getTrxName());
            Assertions.assertTrue((boolean)Util.isEmpty((String)error, (boolean)true), (String)error);
        }
        Query query = new Query(Env.getCtx(), "Fact_Acct", "AD_Table_ID=? AND Record_ID=? AND Account_ID=? AND C_AcctSchema_ID=?", this.getTrxName());
        MFactAcct paymentFact = (MFactAcct)query.setParameters(new Object[]{335, payment.get_ID(), DictionaryIDs.C_ElementValue.CHECKING_IN_TRANSFER.id, MClientInfo.get((int)this.getAD_Client_ID()).getC_AcctSchema1_ID()}).first();
        Assertions.assertNotNull((Object)paymentFact, (String)"Faild to retrieve MFactAcct checking in transfer record for payment");
        MBankStatement stmt = new MBankStatement(Env.getCtx(), 0, this.getTrxName());
        stmt.setC_BankAccount_ID(DictionaryIDs.C_BankAccount.ACCOUNT_1234.id);
        stmt.setName("testReconcileForm");
        stmt.setDateAcct(payment.getDateAcct());
        stmt.saveEx();
        MBankStatementLine line = new MBankStatementLine(stmt);
        line.setC_Payment_ID(payment.get_ID());
        line.setStmtAmt(payment.getPayAmt());
        line.setTrxAmt(line.getStmtAmt());
        line.setC_Currency_ID(payment.getC_Currency_ID());
        line.saveEx();
        pi = MWorkflow.runDocumentActionWorkflow((PO)stmt, (String)"CO");
        Assertions.assertFalse((boolean)pi.isError(), (String)pi.getSummary());
        stmt.load(this.getTrxName(), new String[0]);
        if (!stmt.isPosted()) {
            String error = DocumentEngine.postImmediate((Properties)Env.getCtx(), (int)stmt.getAD_Client_ID(), (int)392, (int)stmt.get_ID(), (boolean)true, (String)this.getTrxName());
            Assertions.assertTrue((boolean)Util.isEmpty((String)error, (boolean)true), (String)error);
        }
        MFactAcct statementFact = (MFactAcct)query.setParameters(new Object[]{392, stmt.get_ID(), DictionaryIDs.C_ElementValue.CHECKING_IN_TRANSFER.id, MClientInfo.get((int)this.getAD_Client_ID()).getC_AcctSchema1_ID()}).first();
        Assertions.assertNotNull((Object)statementFact, (String)"Faild to retrieve MFactAcct checking in transfer record for bank statement");
        FactReconcileImpl fri = new FactReconcileImpl();
        Vector<KeyNamePair> accounts = fri.getAccount();
        Assertions.assertTrue((accounts.size() > 0 ? 1 : 0) != 0, (String)"Failed to retrieve account elements");
        KeyNamePair checkingInTransfer = null;
        for (KeyNamePair account : accounts) {
            if (account.getKey() != DictionaryIDs.C_ElementValue.CHECKING_IN_TRANSFER.id) continue;
            checkingInTransfer = account;
            break;
        }
        Assertions.assertNotNull(checkingInTransfer, (String)"Can't find Checking In Transfer account element");
        fri.setParameters(payment.getC_BPartner_ID(), payment.getDateAcct(), checkingInTransfer, false);
        fri.loadData();
        Assertions.assertTrue((fri.miniTable.getRowCount() >= 2 ? 1 : 0) != 0, (String)"Failed to load not reconciled fact account records");
        int i = 0;
        while (i < fri.miniTable.getRowCount()) {
            KeyNamePair knp2 = (KeyNamePair)fri.miniTable.getValueAt(i, fri.getIdColumnIndex());
            if (knp2.getKey() == paymentFact.get_ID() || knp2.getKey() == statementFact.get_ID()) {
                fri.miniTable.setValueAt((Object)Boolean.TRUE, i, fri.getSelectedColumnIndex());
            }
            ++i;
        }
        fri.calculateSelection((IMiniTable)fri.miniTable);
        Assertions.assertEquals((int)2, (int)fri.getSelectedCount(), (String)"Failed to locate not reconciled payment and bank statement fact records in mini table");
        ArrayList generated = new ArrayList();
        fri.generate((IMiniTable)fri.miniTable, generated);
        Assertions.assertEquals((int)2, (int)generated.size(), (String)"Failed to generate Fact_Reconciliation records");
        fri.setParameters(payment.getC_BPartner_ID(), payment.getDateAcct(), checkingInTransfer, false);
        fri.loadData();
        int i2 = 0;
        while (i2 < fri.miniTable.getRowCount()) {
            knp = (KeyNamePair)fri.miniTable.getValueAt(i2, fri.getIdColumnIndex());
            if (knp.getKey() == paymentFact.get_ID() || knp.getKey() == statementFact.get_ID()) {
                fri.miniTable.setValueAt((Object)Boolean.TRUE, i2, fri.getSelectedColumnIndex());
            }
            ++i2;
        }
        fri.calculateSelection((IMiniTable)fri.miniTable);
        Assertions.assertEquals((int)0, (int)fri.getSelectedCount(), (String)"Payment and bank statement line not reconcilled");
        fri.setParameters(payment.getC_BPartner_ID(), payment.getDateAcct(), checkingInTransfer, true);
        fri.loadData();
        i2 = 0;
        while (i2 < fri.miniTable.getRowCount()) {
            knp = (KeyNamePair)fri.miniTable.getValueAt(i2, fri.getIdColumnIndex());
            if (knp.getKey() == paymentFact.get_ID() || knp.getKey() == statementFact.get_ID()) {
                fri.miniTable.setValueAt((Object)Boolean.TRUE, i2, fri.getSelectedColumnIndex());
            }
            ++i2;
        }
        fri.calculateSelection((IMiniTable)fri.miniTable);
        Assertions.assertEquals((int)2, (int)fri.getSelectedCount(), (String)"Failed to locate reconcilled payment and statement fact record in mini table");
        ArrayList reseted = new ArrayList();
        fri.reset((IMiniTable)fri.miniTable, reseted);
        Assertions.assertEquals((int)2, (int)reseted.size(), (String)"Failed to reset Fact_Reconciliation records");
        fri.setParameters(payment.getC_BPartner_ID(), payment.getDateAcct(), checkingInTransfer, false);
        fri.loadData();
        Assertions.assertTrue((fri.miniTable.getRowCount() >= 2 ? 1 : 0) != 0, (String)"Failed to load fact account records");
        int i3 = 0;
        while (i3 < fri.miniTable.getRowCount()) {
            KeyNamePair knp3 = (KeyNamePair)fri.miniTable.getValueAt(i3, fri.getIdColumnIndex());
            if (knp3.getKey() == paymentFact.get_ID() || knp3.getKey() == statementFact.get_ID()) {
                fri.miniTable.setValueAt((Object)Boolean.TRUE, i3, fri.getSelectedColumnIndex());
            }
            ++i3;
        }
        fri.calculateSelection((IMiniTable)fri.miniTable);
        Assertions.assertEquals((int)2, (int)fri.getSelectedCount(), (String)"Failed to locate payment and statement fact record in mini table");
    }

    private class FactReconcileImpl
    extends FactReconcile {
        protected MiniTableImpl miniTable = null;

        protected FactReconcileImpl() {
            this.m_trxName = FactReconcileFormTest.this.getTrxName();
            this.m_C_AcctSchema_ID = MClientInfo.get((int)FactReconcileFormTest.this.getAD_Client_ID()).getC_AcctSchema1_ID();
            this.m_AD_Client_ID = Env.getAD_Client_ID((Properties)Env.getCtx());
        }

        public void loadData() {
            this.miniTable = new MiniTableImpl();
            Vector headers = this.getColumnNames();
            for (String header : headers) {
                this.miniTable.addColumn(header);
            }
            this.setColumnClass((IMiniTable)this.miniTable);
            Vector datas = super.getData();
            for (Vector data : datas) {
                int row = this.miniTable.getRowCount();
                this.miniTable.setRowCount(row + 1);
                int column = 0;
                while (column < data.size()) {
                    Object value = data.get(column);
                    this.miniTable.setValueAt(value, row, column);
                    ++column;
                }
            }
        }

        protected void setParameters(int C_BPartner_ID, Timestamp dateAcct, KeyNamePair checkingInTransfer, boolean isReconciled) {
            this.m_C_BPartner_ID = C_BPartner_ID;
            this.m_DateAcct = dateAcct;
            this.m_Account_ID = checkingInTransfer.getKey();
            this.m_isReconciled = isReconciled;
        }

        protected Vector<KeyNamePair> getAccount() {
            return super.getAccount();
        }

        protected int getSelectedCount() {
            return this.m_noSelected;
        }

        protected int getIdColumnIndex() {
            return this.idColIndex;
        }

        protected int getSelectedColumnIndex() {
            return this.selectedColIndex;
        }
    }
}

