/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.test.base;

import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import org.compiere.model.X_C_NonBusinessDay;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Language;
import org.compiere.util.TimeUtil;
import org.idempiere.test.AbstractTestCase;
import org.idempiere.test.DictionaryIDs;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TimeUtilTest
extends AbstractTestCase {
    @Test
    public void testTrunc() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        try {
            GregorianCalendar cal = new GregorianCalendar(Language.getLoginLanguage().getLocale());
            Timestamp source = Timestamp.from(sdf.parse("2022-10-28 11:11:00.000").toInstant());
            Timestamp dayTarget = Timestamp.from(sdf.parse("2022-10-28 00:00:00.000").toInstant());
            Timestamp truncated = TimeUtil.trunc((Timestamp)source, (String)"D");
            Assertions.assertEquals((Object)dayTarget, (Object)truncated, (String)"TRUNC_DAY not working as expected");
            Timestamp weekTarget = null;
            weekTarget = cal.getFirstDayOfWeek() == 1 ? Timestamp.from(sdf.parse("2022-10-23 00:00:00.000").toInstant()) : Timestamp.from(sdf.parse("2022-10-24 00:00:00.000").toInstant());
            truncated = TimeUtil.trunc((Timestamp)source, (String)"W");
            Assertions.assertEquals((Object)weekTarget, (Object)truncated, (String)"TRUNC_WEEK not working as expected");
            Timestamp monthTarget = Timestamp.from(sdf.parse("2022-10-01 00:00:00.000").toInstant());
            truncated = TimeUtil.trunc((Timestamp)source, (String)"MM");
            Assertions.assertEquals((Object)monthTarget, (Object)truncated, (String)"TRUNC_MONTH not working as expected");
            Timestamp yearTarget = Timestamp.from(sdf.parse("2022-01-01 00:00:00.000").toInstant());
            truncated = TimeUtil.trunc((Timestamp)source, (String)"Y");
            Assertions.assertEquals((Object)yearTarget, (Object)truncated, (String)"TRUNC_YEAR not working as expected");
            Timestamp quarter4 = Timestamp.from(sdf.parse("2022-10-01 00:00:00.000").toInstant());
            truncated = TimeUtil.trunc((Timestamp)source, (String)"Q");
            Assertions.assertEquals((Object)quarter4, (Object)truncated, (String)"TRUNC_QUARTER not working as expected for October");
            source = Timestamp.from(sdf.parse("2022-09-28 11:11:00.000").toInstant());
            Timestamp quarter3 = Timestamp.from(sdf.parse("2022-07-01 00:00:00.000").toInstant());
            truncated = TimeUtil.trunc((Timestamp)source, (String)"Q");
            Assertions.assertEquals((Object)quarter3, (Object)truncated, (String)"TRUNC_QUARTER not working as expected for September");
            source = Timestamp.from(sdf.parse("2022-06-28 11:11:00.000").toInstant());
            Timestamp quarter2 = Timestamp.from(sdf.parse("2022-04-01 00:00:00.000").toInstant());
            truncated = TimeUtil.trunc((Timestamp)source, (String)"Q");
            Assertions.assertEquals((Object)quarter2, (Object)truncated, (String)"TRUNC_QUARTER not working as expected for June");
            source = Timestamp.from(sdf.parse("2022-03-28 11:11:00.000").toInstant());
            Timestamp quarter1 = Timestamp.from(sdf.parse("2022-01-01 00:00:00.000").toInstant());
            truncated = TimeUtil.trunc((Timestamp)source, (String)"Q");
            Assertions.assertEquals((Object)quarter1, (Object)truncated, (String)"TRUNC_QUARTER not working as expected for March");
        }
        catch (ParseException e) {
            Assertions.fail((Throwable)e);
        }
    }

    @Test
    public void testGetDay() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        try {
            Timestamp source = Timestamp.from(sdf.parse("2022-10-28 11:11:00.000").toInstant());
            Timestamp dayTarget = Timestamp.from(sdf.parse("2022-10-28 00:00:00.000").toInstant());
            Assertions.assertEquals((Object)dayTarget, (Object)TimeUtil.getDay((Timestamp)source), (String)"getDay not working as expected");
            Timestamp nextDayTarget = Timestamp.from(sdf.parse("2022-10-29 00:00:00.000").toInstant());
            Assertions.assertEquals((Object)nextDayTarget, (Object)TimeUtil.getNextDay((Timestamp)source), (String)"getNextDay not working as expected");
            Timestamp previousDayTarget = Timestamp.from(sdf.parse("2022-10-27 00:00:00.000").toInstant());
            Assertions.assertEquals((Object)previousDayTarget, (Object)TimeUtil.getPreviousDay((Timestamp)source), (String)"getPreviousDay not working as expected");
            Timestamp monthLastDayTarget = Timestamp.from(sdf.parse("2022-10-31 00:00:00.000").toInstant());
            Assertions.assertEquals((Object)monthLastDayTarget, (Object)TimeUtil.getMonthLastDay((Timestamp)source), (String)"getMonthLastDay not working as expected");
            Timestamp monthFirstDayTarget = Timestamp.from(sdf.parse("2022-10-01 00:00:00.000").toInstant());
            Assertions.assertEquals((Object)monthFirstDayTarget, (Object)TimeUtil.getMonthFirstDay((Timestamp)source), (String)"getMonthFirstDay not working as expected");
            Timestamp from = Timestamp.from(sdf.parse("2022-10-01 00:00:00.000").toInstant());
            Timestamp to = source;
            Assertions.assertEquals((int)27, (int)TimeUtil.getDaysBetween((Timestamp)from, (Timestamp)to), (String)"getDaysBetween not working as expected for positive difference");
            Assertions.assertEquals((int)-27, (int)TimeUtil.getDaysBetween((Timestamp)to, (Timestamp)from), (String)"getDaysBetween not working as expected for negative difference");
            from = Timestamp.from(sdf.parse("2021-10-01 00:00:00.000").toInstant());
            Assertions.assertEquals((int)392, (int)TimeUtil.getDaysBetween((Timestamp)from, (Timestamp)source), (String)"getDaysBetween not working as expected for cross year positive difference");
            Assertions.assertEquals((int)-392, (int)TimeUtil.getDaysBetween((Timestamp)source, (Timestamp)from), (String)"getDaysBetween not working as expected for cross year negative difference");
            Assertions.assertEquals((int)12, (int)TimeUtil.getMonthsBetween((Timestamp)from, (Timestamp)source), (String)"getMonthsBetween not working as expected");
            Timestamp datePart = Timestamp.from(sdf.parse("2022-09-28 00:00:00.000").toInstant());
            Timestamp timePart = source;
            Timestamp combine = Timestamp.from(sdf.parse("2022-09-28 11:11:00.000").toInstant());
            Assertions.assertEquals((Object)combine, (Object)TimeUtil.getDayBorder((Timestamp)datePart, (Timestamp)timePart, (boolean)false), (String)"getDayBorder doesn't combine date part and time part as expected");
            Assertions.assertEquals((Object)combine, (Object)TimeUtil.getDayTime((Timestamp)datePart, (Timestamp)timePart), (String)"getDayTime doesn't combine date part and time part as expected");
            Assertions.assertEquals((Object)datePart, (Object)TimeUtil.getDayBorder((Timestamp)combine, null, (boolean)false), (String)"getDayBorder doesn't return start of day date as expected");
            Timestamp endOfDay = Timestamp.from(sdf.parse("2022-09-28 23:59:59.999").toInstant());
            Assertions.assertEquals((Object)endOfDay, (Object)TimeUtil.getDayBorder((Timestamp)combine, null, (boolean)true), (String)"getDayBorder doesn't return end of day date as expected");
        }
        catch (ParseException e) {
            Assertions.fail((Throwable)e);
        }
    }

    @Test
    public void testValidation() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        try {
            Timestamp from1 = Timestamp.from(sdf.parse("2022-10-20 00:00:00.000").toInstant());
            Timestamp to1 = Timestamp.from(sdf.parse("2022-10-25 00:00:00.000").toInstant());
            Timestamp from2 = Timestamp.from(sdf.parse("2022-10-24 00:00:00.000").toInstant());
            Timestamp to2 = Timestamp.from(sdf.parse("2022-10-28 00:00:00.000").toInstant());
            Assertions.assertTrue((boolean)TimeUtil.inRange((Timestamp)from1, (Timestamp)to1, (Timestamp)from2, (Timestamp)to2), (String)"Wrong inRange validation");
            to1 = Timestamp.from(sdf.parse("2022-10-23 00:00:00.000").toInstant());
            Assertions.assertFalse((boolean)TimeUtil.inRange((Timestamp)from1, (Timestamp)to1, (Timestamp)from2, (Timestamp)to2), (String)"Wrong inRange validation");
            from1 = Timestamp.from(sdf.parse("2022-10-26 00:00:00.000").toInstant());
            to1 = Timestamp.from(sdf.parse("2022-10-30 00:00:00.000").toInstant());
            Assertions.assertTrue((boolean)TimeUtil.inRange((Timestamp)from1, (Timestamp)to1, (Timestamp)from2, (Timestamp)to2), (String)"Wrong inRange validation");
            from1 = Timestamp.from(sdf.parse("2022-10-28 00:00:00.000").toInstant());
            Assertions.assertFalse((boolean)TimeUtil.inRange((Timestamp)from1, (Timestamp)to1, (Timestamp)from2, (Timestamp)to2), (String)"Wrong inRange validation");
            from1 = Timestamp.from(sdf.parse("2022-10-20 00:00:00.000").toInstant());
            to1 = Timestamp.from(sdf.parse("2022-10-24 00:00:00.000").toInstant());
            Assertions.assertFalse((boolean)TimeUtil.inRange((Timestamp)from1, (Timestamp)to1, (Timestamp)from2, (Timestamp)to2), (String)"Wrong inRange validation");
            from1 = Timestamp.from(sdf.parse("2022-10-25 00:00:00.000").toInstant());
            to1 = Timestamp.from(sdf.parse("2022-10-27 00:00:00.000").toInstant());
            Assertions.assertTrue((boolean)TimeUtil.inRange((Timestamp)from1, (Timestamp)to1, (Timestamp)from2, (Timestamp)to2), (String)"Wrong inRange validation");
            Calendar cal = TimeUtil.getToday();
            cal.set(7, 2);
            from1 = new Timestamp(cal.getTimeInMillis());
            cal.set(7, 4);
            to1 = new Timestamp(cal.getTimeInMillis());
            Assertions.assertFalse((boolean)TimeUtil.inRange((Timestamp)from1, (Timestamp)to1, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)true, (boolean)true, (boolean)true), (String)"Invalid inRange validation");
            Assertions.assertTrue((boolean)TimeUtil.inRange((Timestamp)from1, (Timestamp)to1, (boolean)false, (boolean)true, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)false), (String)"Invalid inRange validation");
            from1 = Timestamp.from(sdf.parse("2022-10-20 00:00:00.000").toInstant());
            to1 = Timestamp.from(sdf.parse("2022-10-24 00:00:00.000").toInstant());
            Assertions.assertFalse((boolean)TimeUtil.isSameDay((Timestamp)from1, (Timestamp)to1), (String)"Invalid isSameDay validation");
            from1 = Timestamp.from(sdf.parse("2022-10-20 00:00:00.000").toInstant());
            to1 = Timestamp.from(sdf.parse("2022-10-20 00:00:00.000").toInstant());
            Assertions.assertTrue((boolean)TimeUtil.isSameDay((Timestamp)from1, (Timestamp)to1), (String)"Invalid isSameDay validation");
            from1 = Timestamp.from(sdf.parse("2022-10-20 01:00:00.000").toInstant());
            to1 = Timestamp.from(sdf.parse("2022-10-24 01:00:00.000").toInstant());
            Assertions.assertFalse((boolean)TimeUtil.isSameHour((Timestamp)from1, (Timestamp)to1), (String)"Invalid isSameHour validation");
            to1 = Timestamp.from(sdf.parse("2022-10-20 02:00:00.000").toInstant());
            Assertions.assertFalse((boolean)TimeUtil.isSameHour((Timestamp)from1, (Timestamp)to1), (String)"Invalid isSameHour validation");
            to1 = Timestamp.from(sdf.parse("2022-10-20 01:00:00.000").toInstant());
            Assertions.assertTrue((boolean)TimeUtil.isSameHour((Timestamp)from1, (Timestamp)to1), (String)"Invalid isSameHour validation");
            from1 = Timestamp.from(sdf.parse("2022-10-20 00:00:00.000").toInstant());
            to1 = Timestamp.from(sdf.parse("2022-10-20 00:00:00.000").toInstant());
            Assertions.assertFalse((boolean)TimeUtil.isAllDay((Timestamp)from1, (Timestamp)to1), (String)"Invalid isAllDay validation");
            to1 = Timestamp.from(sdf.parse("2022-10-21 00:00:00.000").toInstant());
            Assertions.assertTrue((boolean)TimeUtil.isAllDay((Timestamp)from1, (Timestamp)to1), (String)"Invalid isAllDay validation");
            from1 = TimeUtil.getDay((long)System.currentTimeMillis());
            to1 = TimeUtil.addDays((Timestamp)from1, (int)1);
            Assertions.assertTrue((boolean)TimeUtil.isValid((Timestamp)from1, (Timestamp)to1), (String)"Invalid isValid validation");
            from1 = TimeUtil.addDays((Timestamp)from1, (int)-2);
            to1 = TimeUtil.addDays((Timestamp)from1, (int)1);
            Assertions.assertFalse((boolean)TimeUtil.isValid((Timestamp)from1, (Timestamp)to1), (String)"Invalid isValid validation");
            Timestamp test1 = TimeUtil.addDays((Timestamp)to1, (int)1);
            Assertions.assertFalse((boolean)TimeUtil.isValid((Timestamp)from1, (Timestamp)to1, (Timestamp)test1), (String)"Invalid isValid validation");
            test1 = TimeUtil.addDays((Timestamp)from1, (int)1);
            to1 = TimeUtil.addDays((Timestamp)from1, (int)1);
            Assertions.assertTrue((boolean)TimeUtil.isValid((Timestamp)from1, (Timestamp)to1, (Timestamp)test1), (String)"Invalid isValid validation");
            to1 = TimeUtil.addDays((Timestamp)to1, (int)1);
            Assertions.assertTrue((boolean)TimeUtil.isValid((Timestamp)from1, (Timestamp)to1, (Timestamp)test1), (String)"Invalid isValid validation");
        }
        catch (ParseException e) {
            Assertions.fail((Throwable)e);
        }
    }

    @Test
    public void testNonBusinessDays() {
        Calendar cal = TimeUtil.getToday();
        cal.set(7, 2);
        Timestamp from = new Timestamp(cal.getTimeInMillis());
        cal.set(7, 6);
        Timestamp to = new Timestamp(cal.getTimeInMillis());
        DB.executeUpdateEx((String)"DELETE FROM C_NonBusinessDay WHERE AD_Client_ID=? AND Date1 BETWEEN ? AND ?", (Object[])new Object[]{this.getAD_Client_ID(), from, to}, (String)this.getTrxName());
        cal.set(7, 4);
        Timestamp expected = new Timestamp(cal.getTimeInMillis());
        Assertions.assertEquals((Object)expected, (Object)TimeUtil.addOnlyBusinessDays((Timestamp)from, (int)2, (int)this.getAD_Client_ID(), (String)this.getTrxName()));
        X_C_NonBusinessDay nbd = new X_C_NonBusinessDay(Env.getCtx(), 0, this.getTrxName());
        nbd.setName("testNonBusinessDays1");
        cal.set(7, 3);
        nbd.setDate1(new Timestamp(cal.getTimeInMillis()));
        nbd.setC_Calendar_ID(DictionaryIDs.C_Calendar.GARDENWORLD_CALENDAR.id);
        nbd.saveEx();
        cal.set(7, 5);
        expected = new Timestamp(cal.getTimeInMillis());
        Assertions.assertEquals((Object)expected, (Object)TimeUtil.addOnlyBusinessDays((Timestamp)from, (int)2, (int)this.getAD_Client_ID(), (String)this.getTrxName()));
        to = expected;
        Assertions.assertEquals((int)2, (int)TimeUtil.getBusinessDaysBetween((Timestamp)from, (Timestamp)to, (int)this.getAD_Client_ID(), (String)this.getTrxName()));
        Assertions.assertEquals((int)3, (int)TimeUtil.getBusinessDaysBetween((Timestamp)from, (Timestamp)to, (int)this.getAD_Client_ID(), (boolean)true, (String)this.getTrxName()));
        nbd.deleteEx(true);
        Assertions.assertEquals((int)3, (int)TimeUtil.getBusinessDaysBetween((Timestamp)from, (Timestamp)to, (int)this.getAD_Client_ID(), (String)this.getTrxName()));
        Assertions.assertEquals((int)4, (int)TimeUtil.getBusinessDaysBetween((Timestamp)from, (Timestamp)to, (int)this.getAD_Client_ID(), (boolean)true, (String)this.getTrxName()));
    }
}

