/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.test.base;

import java.io.File;
import java.util.Properties;
import org.compiere.dbPort.Convert;
import org.compiere.model.MTest;
import org.compiere.util.Env;
import org.idempiere.test.AbstractTestCase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.Isolated;

@Isolated
public class JsonFieldTest
extends AbstractTestCase {
    @Test
    public void testSavingJSONValue() {
        MTest testPO = new MTest(Env.getCtx(), this.getClass().getName(), 1, this.getTrxName());
        testPO.setJsonData((Object)"Testing if JSON allows to save regular strings");
        boolean updated = testPO.save();
        Assertions.assertFalse((boolean)updated);
        testPO = new MTest(Env.getCtx(), this.getClass().getName(), 1, this.getTrxName());
        String validJsonString = "{ \"name\": \"iDempiere\", \"id\": 100 }";
        testPO.setJsonData((Object)validJsonString);
        updated = testPO.save();
        Assertions.assertTrue((boolean)updated);
        String validJsonArray = "[ {\"type\": \"mobile\", \"phone\": \"001001\"} , {\"type\": \"fix\", \"phone\": \"002002\"} ]";
        testPO.setJsonData((Object)validJsonArray);
        updated = testPO.save();
        Assertions.assertTrue((boolean)updated);
        testPO.setJsonData(null);
        updated = testPO.save();
        Assertions.assertTrue((boolean)updated);
        Env.getCtx().setProperty("LogMigrationScript", "Y");
        Env.setContext((Properties)Env.getCtx(), (String)"MigrationScriptComment", (String)"IDEMPIERE-02981 JsonFieldTest");
        testPO.setJsonData((Object)validJsonString);
        updated = testPO.save();
        Assertions.assertTrue((boolean)updated);
        testPO.setJsonData((Object)validJsonArray);
        updated = testPO.save();
        Assertions.assertTrue((boolean)updated);
        Env.getCtx().setProperty("LogMigrationScript", "");
        String fileName = Convert.getGeneratedMigrationScriptFileName();
        String folderPg = Convert.getMigrationScriptFolder((String)"postgresql");
        String folderOr = Convert.getMigrationScriptFolder((String)"oracle");
        Convert.closeLogMigrationScript();
        File file = new File(folderPg + fileName);
        Assertions.assertTrue((boolean)file.exists(), (String)("Not found: " + folderPg + fileName));
        file.delete();
        file = new File(folderOr + fileName);
        Assertions.assertTrue((boolean)file.exists(), (String)("Not found: " + folderOr + fileName));
        file.delete();
    }
}

