/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.ui.impl.undo;

import io.keikai.api.CellOperationUtil;
import io.keikai.api.IllegalOpArgumentException;
import io.keikai.api.Range;
import io.keikai.api.Ranges;
import io.keikai.api.model.Sheet;
import io.keikai.ui.impl.undo.AbstractUndoableAction;
import io.keikai.ui.impl.undo.ReserveUtil;
import org.zkoss.lang.Objects;
import org.zkoss.util.resource.Labels;

public class DeleteCellAction
extends AbstractUndoableAction {
    private static final long serialVersionUID = -3233822438103730541L;
    private Range.DeleteShift _shift;
    private ReserveUtil.ReservedResult _reserve = null;
    private boolean _doFlag;

    public DeleteCellAction(String label, Sheet sheet, int row, int column, int lastRow, int lastColumn, Range.DeleteShift shift) {
        super(label, sheet, row, column, lastRow, lastColumn);
        this._shift = shift;
    }

    @Override
    public void doAction() {
        if (this.isSheetProtected()) {
            return;
        }
        this._doFlag = true;
        Range r = Ranges.range(this._sheet, this._row, this._column, this._lastRow, this._lastColumn);
        if (r.isWholeRow() && r.isWholeColumn()) {
            throw new IllegalOpArgumentException("doesn't support to delete all");
        }
        this._reserve = ReserveUtil.reserve(this._sheet.getInternalSheet(), this._row, this._column, this._lastRow, this._lastColumn, 7);
        CellOperationUtil.delete(r, this._shift);
    }

    @Override
    public boolean isUndoable() {
        return this._doFlag && this.isSheetAvailable() && !this.isSheetProtected();
    }

    @Override
    public boolean isRedoable() {
        return !this._doFlag && this.isSheetAvailable() && !this.isSheetProtected();
    }

    @Override
    public void undoAction() {
        if (this.isSheetProtected()) {
            return;
        }
        Range r = Ranges.range(this._sheet, this._row, this._column, this._lastRow, this._lastColumn);
        switch (this._shift) {
            case UP: {
                CellOperationUtil.insert(r, Range.InsertShift.DOWN, Range.InsertCopyOrigin.FORMAT_NONE);
                break;
            }
            case LEFT: {
                CellOperationUtil.insert(r, Range.InsertShift.RIGHT, Range.InsertCopyOrigin.FORMAT_NONE);
                break;
            }
            case DEFAULT: {
                CellOperationUtil.insert(r, Range.InsertShift.DEFAULT, Range.InsertCopyOrigin.FORMAT_NONE);
            }
        }
        this._reserve.restore();
        this._reserve = null;
        this._doFlag = false;
    }

    @Override
    protected boolean isSheetProtected() {
        Range range = Ranges.range(this._sheet);
        return !(!super.isSheetProtected() || Objects.equals((Object)Labels.getLabel((String)"zss.undo.deleteColumn"), (Object)this.getLabel()) && range.getSheetProtection().isDeleteColumnsAllowed() || Objects.equals((Object)Labels.getLabel((String)"zss.undo.deleteRow"), (Object)this.getLabel()) && range.getSheetProtection().isDeleteRowsAllowed());
    }
}

