/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.ui.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class JSONObj
implements Serializable {
    private static final long serialVersionUID = 4074301876831554811L;
    Map _data = new LinkedHashMap();

    public void setData(String name, String value) {
        this.setDataMap(name, value);
    }

    public void setData(String name, Number number) {
        this.setDataMap(name, number);
    }

    public void setData(String name, boolean bool) {
        this.setDataMap(name, bool ? Boolean.TRUE : Boolean.FALSE);
    }

    public void setData(String name, int number) {
        this.setDataMap(name, number);
    }

    public void setData(String name, long number) {
        this.setDataMap(name, number);
    }

    public void setData(String name, float number) {
        this.setDataMap(name, new Float(number));
    }

    public void setData(String name, double number) {
        this.setDataMap(name, new Double(number));
    }

    public void setData(String name, JSONObj jsonobj) {
        this.setDataMap(name, jsonobj);
    }

    public void setData(String name, List list) {
        this.setDataMap(name, list);
    }

    public void setData(String name, Object[] list) {
        ArrayList<Object> al = new ArrayList<Object>();
        for (int i = 0; i < list.length; ++i) {
            al.add(list[i]);
        }
        this.setDataMap(name, al);
    }

    private void setDataMap(String name, Object obj) {
        this._data.put(name, obj);
    }

    private void toFormatedString(StringBuffer sb) {
        sb.append("{");
        boolean first = true;
        for (Map.Entry entry : this._data.entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            if (first) {
                first = false;
            } else {
                sb.append(",");
            }
            sb.append("\"").append(key).append("\":");
            this.appendObj(sb, value);
        }
        sb.append("}");
    }

    private void appendObj(StringBuffer sb, Object obj) {
        if (obj == null) {
            obj = "";
        }
        if (obj instanceof String) {
            String str = (String)obj;
            sb.append("\"");
            char[] chars = str.toCharArray();
            block6: for (int i = 0; i < chars.length; ++i) {
                switch (chars[i]) {
                    case '\"': {
                        sb.append("\\\"");
                        continue block6;
                    }
                    case '\\': {
                        sb.append("\\\\");
                        continue block6;
                    }
                    case '\n': {
                        sb.append("\\n");
                        continue block6;
                    }
                    case '\r': {
                        continue block6;
                    }
                    default: {
                        sb.append(chars[i]);
                    }
                }
            }
            sb.append("\"");
        } else if (obj instanceof Number) {
            sb.append(((Number)obj).toString());
        } else if (obj instanceof Boolean) {
            sb.append((Boolean)obj != false ? "true" : "false");
        } else if (obj instanceof JSONObj) {
            ((JSONObj)obj).toFormatedString(sb);
        } else if (obj instanceof List) {
            sb.append("[");
            boolean first = true;
            for (Object value : (List)obj) {
                if (first) {
                    first = false;
                } else {
                    sb.append(",");
                }
                this.appendObj(sb, value);
            }
            sb.append("]");
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        this.toFormatedString(sb);
        return sb.toString();
    }

    public static void main(String[] args) {
        JSONObj obj1 = new JSONObj();
        JSONObj obj2 = new JSONObj();
        JSONObj obj3 = new JSONObj();
        JSONObj obj4 = new JSONObj();
        obj1.setData("index", 1);
        obj1.setData("txt", "abc");
        obj1.setData("format", "ddd");
        obj2.setData("index", 2);
        obj2.setData("txt", "def");
        obj2.setData("format", "kkk");
        obj3.setData("type", "row");
        obj3.setData("index", 1);
        obj3.setData("cells", new Object[]{obj1, obj2});
        obj4.setData("data", new Object[]{obj3});
        System.out.println(obj4.toString());
    }
}

