/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.ui.au.in;

import io.keikai.model.SSheet;
import io.keikai.ui.Spreadsheet;
import io.keikai.ui.au.in.AbstractCommand;
import io.keikai.ui.au.in.AuDataUtil;
import io.keikai.ui.au.in.Command;
import io.keikai.ui.event.HeaderAction;
import io.keikai.ui.event.HeaderType;
import io.keikai.ui.event.HeaderUpdateEvent;
import io.keikai.ui.sys.SpreadsheetInCtrl;
import java.util.Map;
import org.zkoss.zk.au.AuRequest;
import org.zkoss.zk.mesg.MZk;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.Events;

public class HeaderUpdateCommand
extends AbstractCommand
implements Command {
    @Override
    public void process(AuRequest request) {
        Component comp = request.getComponent();
        if (comp == null) {
            throw new UiException(MZk.ILLEGAL_REQUEST_COMPONENT_REQUIRED, (Object)this);
        }
        Map data = request.getData();
        String type = (String)data.get("type");
        if ("top".equals(type)) {
            this.processTopHeader((Spreadsheet)comp, data);
        } else if ("left".equals(type)) {
            this.processLeftHeader((Spreadsheet)comp, data);
        } else {
            throw new UiException(MZk.ILLEGAL_REQUEST_WRONG_DATA, new Object[]{"Type:" + type, this});
        }
    }

    private void processTopHeader(Spreadsheet spreadsheet, Map data) {
        String sheetId = (String)data.get("sheetId");
        SSheet sheet = spreadsheet.getSelectedSSheet();
        if (!sheet.getId().equals(sheetId)) {
            return;
        }
        String action = (String)data.get("action");
        int index = (Integer)data.get("index");
        if ("resize".equals(action)) {
            int newsize = AuDataUtil.getInt(data, "size");
            int id = (Integer)data.get("id");
            boolean hidden = (Boolean)data.get("hidden");
            ((SpreadsheetInCtrl)spreadsheet.getExtraCtrl()).setColumnSize(sheetId, index, newsize, id, hidden);
            if (Events.isListened((Component)spreadsheet, (String)"onHeaderUpdate", (boolean)true)) {
                HeaderUpdateEvent he = new HeaderUpdateEvent("onHeaderUpdate", (Component)spreadsheet, sheet, HeaderType.COLUMN, HeaderAction.RESIZE, index, newsize, hidden);
                Events.postEvent((Event)he);
            }
        } else {
            throw new UiException(MZk.ILLEGAL_REQUEST_WRONG_DATA, new Object[]{"action:" + action, this});
        }
    }

    private void processLeftHeader(Spreadsheet spreadsheet, Map data) {
        String sheetId = (String)data.get("sheetId");
        SSheet sheet = spreadsheet.getSelectedSSheet();
        if (!sheet.getId().equals(sheetId)) {
            return;
        }
        String action = (String)data.get("action");
        int index = (Integer)data.get("index");
        if ("resize".equals(action)) {
            int newsize = AuDataUtil.getInt(data, "size");
            int id = (Integer)data.get("id");
            boolean hidden = (Boolean)data.get("hidden");
            boolean isCustom = (Boolean)data.get("custom");
            ((SpreadsheetInCtrl)spreadsheet.getExtraCtrl()).setRowSize(sheetId, index, newsize, id, hidden, isCustom);
            if (Events.isListened((Component)spreadsheet, (String)"onHeaderUpdate", (boolean)true)) {
                HeaderUpdateEvent he = new HeaderUpdateEvent("onHeaderUpdate", (Component)spreadsheet, sheet, HeaderType.ROW, HeaderAction.RESIZE, index, newsize, hidden);
                Events.postEvent((Event)he);
            }
        } else {
            throw new UiException(MZk.ILLEGAL_REQUEST_WRONG_DATA, new Object[]{"action:" + action, this});
        }
    }
}

