/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.xssf.model;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlOptions;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.ExternalLinkDocument;
import org.zkoss.poi.POIXMLDocumentPart;
import org.zkoss.poi.openxml4j.opc.PackagePart;
import org.zkoss.poi.openxml4j.opc.PackageRelationship;

public class ExternalLink
extends POIXMLDocumentPart {
    private String _bookName;
    private String _linkIndex;
    public static final int FIRST_CUSTOM_STYLE_ID = 165;
    private ExternalLinkDocument doc;

    public ExternalLink() {
        this.doc = ExternalLinkDocument.Factory.newInstance();
        this.doc.addNewExternalLink();
        this.initialize();
    }

    public ExternalLink(PackagePart part, PackageRelationship rel) throws IOException {
        super(part, rel);
        this.readFrom(part.getInputStream());
    }

    protected void readFrom(InputStream is) throws IOException {
        try {
            this.doc = ExternalLinkDocument.Factory.parse((InputStream)is);
            String rid = this.doc.getExternalLink().getExternalBook().getId();
            PackageRelationship extrel = this.getPackagePart().getRelationship(rid);
            this._bookName = extrel.getTargetURI().toString();
            String srcPath = extrel.getSourceURI().toString();
            int j = srcPath.lastIndexOf("externalLink");
            int k = srcPath.lastIndexOf(".xml");
            this._linkIndex = srcPath.substring(j + 12, k);
        }
        catch (XmlException e) {
            throw new IOException(e.getLocalizedMessage());
        }
    }

    public String getBookName() {
        return this._bookName;
    }

    public void setBookName(String bookname) {
        this._bookName = bookname;
    }

    public String getLinkIndex() {
        return this._linkIndex;
    }

    public void setLinkIndex(String index) {
        this._linkIndex = index;
    }

    public void writeTo(OutputStream out) throws IOException {
        XmlOptions options = new XmlOptions(DEFAULT_XML_OPTIONS);
        this.doc.save(out, options);
    }

    @Override
    protected void commit() throws IOException {
        PackagePart part = this.getPackagePart();
        OutputStream out = part.getOutputStream();
        this.writeTo(out);
        out.close();
    }

    private void initialize() {
    }
}

