/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.ss.format;

import java.util.Formatter;
import java.util.Locale;
import org.zkoss.poi.ss.format.CellFormatter;

public class CellGeneralFormatter
extends CellFormatter {
    public CellGeneralFormatter(Locale locale) {
        super("General", locale);
    }

    @Override
    public void formatValue(StringBuffer toAppendTo, Object value) {
        if (value instanceof Number) {
            String fmt;
            double val = ((Number)value).doubleValue();
            if (val == 0.0) {
                toAppendTo.append('0');
                return;
            }
            double exp = Math.log10(Math.abs(val));
            boolean stripZeros = true;
            if (exp > 10.0 || exp < -9.0) {
                fmt = "%1.5E";
            } else if ((double)((long)val) != val) {
                fmt = "%1.9f";
            } else {
                fmt = "%1.0f";
                stripZeros = false;
            }
            Formatter formatter = new Formatter(toAppendTo, this.locale);
            formatter.format(this.locale, fmt, value);
            if (stripZeros) {
                int removeFrom = fmt.endsWith("E") ? toAppendTo.lastIndexOf("E") - 1 : toAppendTo.length() - 1;
                while (toAppendTo.charAt(removeFrom) == '0') {
                    toAppendTo.deleteCharAt(removeFrom--);
                }
                if (toAppendTo.charAt(removeFrom) == '.') {
                    toAppendTo.deleteCharAt(removeFrom--);
                }
            }
        } else if (value instanceof Boolean) {
            toAppendTo.append(value.toString().toUpperCase());
        } else {
            toAppendTo.append(value.toString());
        }
    }

    @Override
    public void simpleValue(StringBuffer toAppendTo, Object value) {
        this.formatValue(toAppendTo, value);
    }
}

