/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.hwpf;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import org.zkoss.poi.POIDocument;
import org.zkoss.poi.hwpf.model.CHPBinTable;
import org.zkoss.poi.hwpf.model.FileInformationBlock;
import org.zkoss.poi.hwpf.model.FontTable;
import org.zkoss.poi.hwpf.model.ListTables;
import org.zkoss.poi.hwpf.model.PAPBinTable;
import org.zkoss.poi.hwpf.model.SectionTable;
import org.zkoss.poi.hwpf.model.StyleSheet;
import org.zkoss.poi.hwpf.model.TextPieceTable;
import org.zkoss.poi.hwpf.usermodel.ObjectPoolImpl;
import org.zkoss.poi.hwpf.usermodel.ObjectsPool;
import org.zkoss.poi.hwpf.usermodel.Range;
import org.zkoss.poi.poifs.filesystem.DirectoryEntry;
import org.zkoss.poi.poifs.filesystem.DirectoryNode;
import org.zkoss.poi.poifs.filesystem.DocumentEntry;
import org.zkoss.poi.poifs.filesystem.POIFSFileSystem;
import org.zkoss.poi.util.Internal;

public abstract class HWPFDocumentCore
extends POIDocument {
    protected static final String STREAM_OBJECT_POOL = "ObjectPool";
    protected static final String STREAM_WORD_DOCUMENT = "WordDocument";
    protected ObjectPoolImpl _objectPool;
    protected FileInformationBlock _fib;
    protected StyleSheet _ss;
    protected CHPBinTable _cbt;
    protected PAPBinTable _pbt;
    protected SectionTable _st;
    protected FontTable _ft;
    protected ListTables _lt;
    protected byte[] _mainStream;

    protected HWPFDocumentCore() {
        super((DirectoryNode)null);
    }

    public static POIFSFileSystem verifyAndBuildPOIFS(InputStream istream) throws IOException {
        PushbackInputStream pis = new PushbackInputStream(istream, 6);
        byte[] first6 = new byte[6];
        pis.read(first6);
        if (first6[0] == 123 && first6[1] == 92 && first6[2] == 114 && first6[3] == 116 && first6[4] == 102) {
            throw new IllegalArgumentException("The document is really a RTF file");
        }
        pis.unread(first6);
        return new POIFSFileSystem(pis);
    }

    public HWPFDocumentCore(InputStream istream) throws IOException {
        this(HWPFDocumentCore.verifyAndBuildPOIFS(istream));
    }

    public HWPFDocumentCore(POIFSFileSystem pfilesystem) throws IOException {
        this(pfilesystem.getRoot());
    }

    public HWPFDocumentCore(DirectoryNode directory) throws IOException {
        super(directory);
        DirectoryEntry objectPoolEntry;
        DocumentEntry documentProps = (DocumentEntry)directory.getEntry(STREAM_WORD_DOCUMENT);
        this._mainStream = new byte[documentProps.getSize()];
        directory.createDocumentInputStream(STREAM_WORD_DOCUMENT).read(this._mainStream);
        this._fib = new FileInformationBlock(this._mainStream);
        try {
            objectPoolEntry = (DirectoryEntry)directory.getEntry(STREAM_OBJECT_POOL);
        }
        catch (FileNotFoundException exc) {
            objectPoolEntry = null;
        }
        this._objectPool = new ObjectPoolImpl(objectPoolEntry);
    }

    public abstract Range getRange();

    public abstract Range getOverallRange();

    public String getDocumentText() {
        return this.getText().toString();
    }

    @Internal
    public abstract StringBuilder getText();

    public CHPBinTable getCharacterTable() {
        return this._cbt;
    }

    public PAPBinTable getParagraphTable() {
        return this._pbt;
    }

    public SectionTable getSectionTable() {
        return this._st;
    }

    public StyleSheet getStyleSheet() {
        return this._ss;
    }

    public ListTables getListTables() {
        return this._lt;
    }

    public FontTable getFontTable() {
        return this._ft;
    }

    public FileInformationBlock getFileInformationBlock() {
        return this._fib;
    }

    public ObjectsPool getObjectsPool() {
        return this._objectPool;
    }

    public abstract TextPieceTable getTextTable();
}

