/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.hsmf.dev;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintStream;
import org.zkoss.poi.hsmf.datatypes.Chunk;
import org.zkoss.poi.hsmf.datatypes.ChunkGroup;
import org.zkoss.poi.hsmf.datatypes.MAPIProperty;
import org.zkoss.poi.hsmf.datatypes.PropertiesChunk;
import org.zkoss.poi.hsmf.datatypes.PropertyValue;
import org.zkoss.poi.hsmf.parsers.POIFSChunkParser;
import org.zkoss.poi.poifs.filesystem.POIFSFileSystem;

public class HSMFDump {
    private POIFSFileSystem fs;

    public HSMFDump(POIFSFileSystem fs) {
        this.fs = fs;
    }

    public void dump() throws IOException {
        this.dump(System.out);
    }

    public void dump(PrintStream out) throws IOException {
        ChunkGroup[] chunkGroups;
        for (ChunkGroup chunks : chunkGroups = POIFSChunkParser.parse(this.fs)) {
            out.println(chunks.getClass().getSimpleName());
            for (Chunk chunk : chunks.getChunks()) {
                MAPIProperty attr = MAPIProperty.get(chunk.getChunkId());
                if (chunk instanceof PropertiesChunk) {
                    PropertiesChunk props = (PropertiesChunk)chunk;
                    out.println("   Properties - " + props.getProperties().size() + ":");
                    for (MAPIProperty prop : props.getProperties().keySet()) {
                        out.println("       * " + prop);
                        for (PropertyValue v : props.getValues(prop)) {
                            out.println("        = " + v.toString());
                        }
                    }
                    continue;
                }
                String idName = attr.id + " - " + attr.name;
                if (attr == MAPIProperty.UNKNOWN) {
                    idName = chunk.getChunkId() + " - (unknown)";
                }
                out.println("   " + idName + " - " + chunk.getType().getName());
                out.println("       " + chunk.toString());
            }
            out.println();
        }
    }

    public static void main(String[] args) throws Exception {
        for (String file : args) {
            POIFSFileSystem fs = new POIFSFileSystem(new FileInputStream(file));
            HSMFDump dump = new HSMFDump(fs);
            dump.dump();
        }
    }
}

