/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spi.impl;

import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.internal.util.EmptyStatement;
import com.hazelcast.internal.util.UnmodifiableListIterator;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.spi.impl.SpiDataSerializerHook;
import java.io.IOException;
import java.util.AbstractList;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.function.Predicate;

public class UnmodifiableLazyList
extends AbstractList
implements IdentifiedDataSerializable {
    private final transient SerializationService serializationService;
    private List list;

    public UnmodifiableLazyList() {
        this.serializationService = null;
    }

    public UnmodifiableLazyList(List list, SerializationService serializationService) {
        this.list = list;
        this.serializationService = serializationService;
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public boolean add(Object t) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeIf(Predicate filter) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection coll) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object get(int index) {
        Object o = this.list.get(index);
        if (o instanceof Data) {
            Object item = this.serializationService.toObject(o);
            try {
                this.list.set(index, item);
            }
            catch (Exception e) {
                EmptyStatement.ignore(e);
            }
            return item;
        }
        return o;
    }

    @Override
    public Iterator iterator() {
        return this.listIterator(0);
    }

    @Override
    public ListIterator listIterator() {
        return this.listIterator(0);
    }

    @Override
    public ListIterator listIterator(int index) {
        return new UnmodifiableLazyListIterator(this.list.listIterator(index));
    }

    @Override
    public List subList(int fromIndex, int toIndex) {
        return new UnmodifiableLazyList(this.list.subList(fromIndex, toIndex), this.serializationService);
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeInt(this.list.size());
        for (Object o : this) {
            out.writeObject(o);
        }
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        int size = in.readInt();
        this.list = new ArrayList(size);
        for (int i = 0; i < size; ++i) {
            this.list.add(in.readObject());
        }
    }

    @Override
    public int getFactoryId() {
        return SpiDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 18;
    }

    private class UnmodifiableLazyListIterator
    extends UnmodifiableListIterator {
        ListIterator listIterator;

        UnmodifiableLazyListIterator(ListIterator listIterator) {
            this.listIterator = listIterator;
        }

        @Override
        public boolean hasNext() {
            return this.listIterator.hasNext();
        }

        @Override
        public Object next() {
            return this.deserializeAndSet(this.listIterator.next());
        }

        @Override
        public boolean hasPrevious() {
            return this.listIterator.hasPrevious();
        }

        @Override
        public Object previous() {
            return this.deserializeAndSet(this.listIterator.previous());
        }

        @Override
        public int nextIndex() {
            return this.listIterator.nextIndex();
        }

        @Override
        public int previousIndex() {
            return this.listIterator.previousIndex();
        }

        private Object deserializeAndSet(Object o) {
            if (o instanceof Data) {
                Object item = UnmodifiableLazyList.this.serializationService.toObject(o);
                try {
                    this.listIterator.set(item);
                }
                catch (Exception e) {
                    EmptyStatement.ignore(e);
                }
                return item;
            }
            if (o instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)o;
                Object key = UnmodifiableLazyList.this.serializationService.toObject(entry.getKey());
                Object value = UnmodifiableLazyList.this.serializationService.toObject(entry.getValue());
                AbstractMap.SimpleImmutableEntry item = new AbstractMap.SimpleImmutableEntry(key, value);
                try {
                    this.listIterator.set(item);
                }
                catch (Exception e) {
                    EmptyStatement.ignore(e);
                }
                return item;
            }
            return o;
        }
    }
}

